/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audio;

import a.a.a.a.a;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.UUID;
import org.webrtc.Logging;
import org.webrtc.audio.WebRtcAudioUtils;

public class WebRtcAudioEffects {
    public static final boolean DEBUG = false;
    public static final String TAG = "WebRtcAudioEffectsExternal";
    public static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    public static final UUID AOSP_NOISE_SUPPRESSOR = UUID.fromString("c06c8400-8e06-11e0-9cb6-0002a5d5c51b");
    @Nullable
    public static AudioEffect.Descriptor[] cachedEffects;
    @Nullable
    public AcousticEchoCanceler aec;
    @Nullable
    public NoiseSuppressor ns;
    public boolean shouldEnableAec;
    public boolean shouldEnableNs;

    public static boolean isAcousticEchoCancelerSupported() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AEC, AOSP_ACOUSTIC_ECHO_CANCELER);
    }

    public static boolean isNoiseSuppressorSupported() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_NS, AOSP_NOISE_SUPPRESSOR);
    }

    public WebRtcAudioEffects() {
        Logging.d(TAG, a.a("ctor").append(WebRtcAudioUtils.getThreadInfo()).toString());
    }

    private boolean effectTypeIsVoIP(UUID uUID) {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return AudioEffect.EFFECT_TYPE_AEC.equals(uUID) && WebRtcAudioEffects.isAcousticEchoCancelerSupported() || AudioEffect.EFFECT_TYPE_NS.equals(uUID) && WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    public static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    @Nullable
    public static AudioEffect.Descriptor[] getAvailableEffects() {
        AudioEffect.Descriptor[] descriptorArray = cachedEffects;
        if (cachedEffects != null) {
            return descriptorArray;
        }
        cachedEffects = AudioEffect.queryEffects();
        return cachedEffects;
    }

    public static boolean isEffectTypeAvailable(UUID uUID, UUID uUID2) {
        AudioEffect.Descriptor[] descriptorArray = WebRtcAudioEffects.getAvailableEffects();
        if (descriptorArray == null) {
            return false;
        }
        for (AudioEffect.Descriptor descriptor : descriptorArray) {
            if (!descriptor.type.equals(uUID)) continue;
            return descriptor.uuid.equals(uUID2) ^ true;
        }
        return false;
    }

    public boolean setAEC(boolean bl) {
        Logging.d(TAG, "setAEC(" + bl + ")");
        if (!WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            Logging.w(TAG, "Platform AEC is not supported");
            this.shouldEnableAec = false;
            return false;
        }
        if (this.aec != null && bl != this.shouldEnableAec) {
            Logging.e(TAG, "Platform AEC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAec = bl;
        return true;
    }

    public boolean setNS(boolean bl) {
        Logging.d(TAG, "setNS(" + bl + ")");
        if (!WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            Logging.w(TAG, "Platform NS is not supported");
            this.shouldEnableNs = false;
            return false;
        }
        if (this.ns != null && bl != this.shouldEnableNs) {
            Logging.e(TAG, "Platform NS state can't be modified while recording");
            return false;
        }
        this.shouldEnableNs = bl;
        return true;
    }

    public void enable(int n3) {
        StringBuilder stringBuilder;
        CharSequence charSequence;
        Logging.d(TAG, "enable(audioSession=" + n3 + ")");
        WebRtcAudioEffects.assertTrue(((WebRtcAudioEffects)((Object)stringBuilder2)).aec == null);
        WebRtcAudioEffects.assertTrue(((WebRtcAudioEffects)((Object)stringBuilder2)).ns == null);
        if (WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            ((WebRtcAudioEffects)((Object)stringBuilder2)).aec = AcousticEchoCanceler.create((int)n3);
            Object object = ((WebRtcAudioEffects)((Object)stringBuilder2)).aec;
            if (object != null) {
                boolean bl = object.getEnabled();
                boolean bl2 = ((WebRtcAudioEffects)((Object)stringBuilder2)).shouldEnableAec && WebRtcAudioEffects.isAcousticEchoCancelerSupported();
                if (((WebRtcAudioEffects)((Object)stringBuilder2)).aec.setEnabled(bl2) != 0) {
                    Logging.e(TAG, "Failed to set the AcousticEchoCanceler state");
                }
                object = TAG;
                charSequence = a.a("AcousticEchoCanceler: was ");
                String string2 = bl ? "enabled" : "disabled";
                stringBuilder = charSequence.append(string2).append(", enable: ").append(bl2).append(", is now: ");
                charSequence = ((WebRtcAudioEffects)((Object)stringBuilder2)).aec.getEnabled() ? "enabled" : "disabled";
                Logging.d((String)object, stringBuilder.append((String)charSequence).toString());
            } else {
                Logging.e(TAG, "Failed to create the AcousticEchoCanceler instance");
            }
        }
        if (WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            ((WebRtcAudioEffects)((Object)stringBuilder2)).ns = NoiseSuppressor.create((int)n3);
            NoiseSuppressor noiseSuppressor = ((WebRtcAudioEffects)((Object)stringBuilder2)).ns;
            if (noiseSuppressor != null) {
                boolean bl = noiseSuppressor.getEnabled();
                boolean bl3 = ((WebRtcAudioEffects)((Object)stringBuilder2)).shouldEnableNs && WebRtcAudioEffects.isNoiseSuppressorSupported();
                if (((WebRtcAudioEffects)((Object)stringBuilder2)).ns.setEnabled(bl3) != 0) {
                    Logging.e(TAG, "Failed to set the NoiseSuppressor state");
                }
                String string3 = TAG;
                stringBuilder = a.a("NoiseSuppressor: was ");
                charSequence = bl ? "enabled" : "disabled";
                WebRtcAudioEffects webRtcAudioEffects = stringBuilder2;
                StringBuilder stringBuilder2 = stringBuilder.append((String)charSequence).append(", enable: ").append(bl3).append(", is now: ");
                String string4 = webRtcAudioEffects.ns.getEnabled() ? "enabled" : "disabled";
                Logging.d(string3, stringBuilder2.append(string4).toString());
            } else {
                Logging.e(TAG, "Failed to create the NoiseSuppressor instance");
            }
        }
    }

    public void release() {
        Logging.d(TAG, "release");
        AcousticEchoCanceler acousticEchoCanceler = this.aec;
        if (acousticEchoCanceler != null) {
            acousticEchoCanceler.release();
            this.aec = null;
        }
        if ((acousticEchoCanceler = this.ns) != null) {
            acousticEchoCanceler.release();
            this.ns = null;
        }
    }
}

