/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audio;

import a.a.a.a.a;
import android.media.AudioManager;
import android.support.annotation.Nullable;
import java.util.Timer;
import java.util.TimerTask;
import org.webrtc.Logging;
import org.webrtc.audio.WebRtcAudioUtils;

public class VolumeLogger {
    public static final String TAG = "VolumeLogger";
    public static final String THREAD_NAME = "WebRtcVolumeLevelLoggerThread";
    public static final int TIMER_PERIOD_IN_SECONDS = 30;
    public final AudioManager audioManager;
    @Nullable
    public Timer timer;

    public VolumeLogger(AudioManager audioManager) {
        this.audioManager = audioManager;
    }

    public void start() {
        Logging.d(TAG, a.a("start").append(WebRtcAudioUtils.getThreadInfo()).toString());
        if (this.timer != null) {
            return;
        }
        Logging.d(TAG, a.a("audio mode is: ").append(WebRtcAudioUtils.modeToString(this.audioManager.getMode())).toString());
        this.timer = new Timer(THREAD_NAME);
        VolumeLogger volumeLogger = this;
        this.timer.schedule((TimerTask)volumeLogger.new LogVolumeTask(volumeLogger.audioManager.getStreamMaxVolume(2), this.audioManager.getStreamMaxVolume(0)), 0L, 30000L);
    }

    public void stop() {
        Logging.d(TAG, a.a("stop").append(WebRtcAudioUtils.getThreadInfo()).toString());
        Timer timer = this.timer;
        if (timer != null) {
            timer.cancel();
            this.timer = null;
        }
    }

    public class LogVolumeTask
    extends TimerTask {
        public final int maxRingVolume;
        public final int maxVoiceCallVolume;

        public LogVolumeTask(int n3, int n4) {
            this.maxRingVolume = n3;
            this.maxVoiceCallVolume = n4;
        }

        @Override
        public void run() {
            int n3 = VolumeLogger.this.audioManager.getMode();
            if (n3 == 1) {
                Logging.d(VolumeLogger.TAG, a.a("STREAM_RING stream volume: ").append(VolumeLogger.this.audioManager.getStreamVolume(2)).append(" (max=").append(this.maxRingVolume).append(")").toString());
            } else if (n3 == 3) {
                Logging.d(VolumeLogger.TAG, a.a("VOICE_CALL stream volume: ").append(VolumeLogger.this.audioManager.getStreamVolume(0)).append(" (max=").append(this.maxVoiceCallVolume).append(")").toString());
            }
        }
    }
}

