/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audio;

import android.content.Context;
import android.media.AudioManager;
import org.webrtc.JniCommon;
import org.webrtc.Logging;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.WebRtcAudioEffects;
import org.webrtc.audio.WebRtcAudioManager;
import org.webrtc.audio.WebRtcAudioRecord;
import org.webrtc.audio.WebRtcAudioTrack;

public class JavaAudioDeviceModule
implements AudioDeviceModule {
    public static final String TAG = "JavaAudioDeviceModule";
    public final Context context;
    public final AudioManager audioManager;
    public final WebRtcAudioRecord audioInput;
    public final WebRtcAudioTrack audioOutput;
    public final int inputSampleRate;
    public final int outputSampleRate;
    public final boolean useStereoInput;
    public final boolean useStereoOutput;
    public long i;
    public final Object nativeLock = new Object();
    public long nativeAudioDeviceModule;

    public static Builder builder(Context context) {
        return new Builder(context, null);
    }

    public static boolean isBuiltInAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.isAcousticEchoCancelerSupported();
    }

    public static boolean isBuiltInNoiseSuppressorSupported() {
        return WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    public JavaAudioDeviceModule(Context context, AudioManager audioManager, WebRtcAudioRecord webRtcAudioRecord, WebRtcAudioTrack webRtcAudioTrack, int n3, int n4, boolean bl, boolean bl2) {
        this.context = context;
        this.audioManager = audioManager;
        this.audioInput = webRtcAudioRecord;
        this.audioOutput = webRtcAudioTrack;
        this.inputSampleRate = n3;
        this.outputSampleRate = n4;
        this.useStereoInput = bl;
        this.useStereoOutput = bl2;
    }

    public static native long nativeCreateAudioDeviceModule(Context var0, AudioManager var1, WebRtcAudioRecord var2, WebRtcAudioTrack var3, int var4, int var5, boolean var6, boolean var7);

    public /* synthetic */ JavaAudioDeviceModule(Context context, AudioManager audioManager, WebRtcAudioRecord webRtcAudioRecord, WebRtcAudioTrack webRtcAudioTrack, int n3, int n4, boolean bl, boolean bl2, 1 var9_9) {
        this(context, audioManager, webRtcAudioRecord, webRtcAudioTrack, n3, n4, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getNativeAudioDeviceModulePointer() {
        JavaAudioDeviceModule javaAudioDeviceModule = this;
        Object object = javaAudioDeviceModule.nativeLock;
        synchronized (object) {
            if (javaAudioDeviceModule.nativeAudioDeviceModule == 0L) {
                this.nativeAudioDeviceModule = JavaAudioDeviceModule.nativeCreateAudioDeviceModule(this.context, this.audioManager, this.audioInput, this.audioOutput, this.inputSampleRate, this.outputSampleRate, this.useStereoInput, this.useStereoOutput);
            }
            return this.nativeAudioDeviceModule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void release() {
        JavaAudioDeviceModule javaAudioDeviceModule = this;
        Object object = javaAudioDeviceModule.nativeLock;
        synchronized (object) {
            if (javaAudioDeviceModule.nativeAudioDeviceModule != 0L) {
                JniCommon.nativeReleaseRef(this.nativeAudioDeviceModule);
                this.nativeAudioDeviceModule = 0L;
            }
            return;
        }
    }

    @Override
    public void setSpeakerMute(boolean bl) {
        Logging.d(TAG, "setSpeakerMute: " + bl);
        this.audioOutput.setSpeakerMute(bl);
    }

    @Override
    public void setMicrophoneMute(boolean bl) {
        Logging.d(TAG, "setMicrophoneMute: " + bl);
        this.audioInput.setMicrophoneMute(bl);
    }

    public static interface AudioTrackErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(AudioTrackStartErrorCode var1, String var2);

        public void onWebRtcAudioTrackError(String var1);
    }

    public static enum AudioTrackStartErrorCode {
        AUDIO_TRACK_START_EXCEPTION,
        AUDIO_TRACK_START_STATE_MISMATCH;

    }

    public static interface SamplesReadyCallback {
        public void onWebRtcAudioRecordSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        public final int audioFormat;
        public final int channelCount;
        public final int sampleRate;
        public final byte[] data;

        public AudioSamples(int n3, int n4, int n5, byte[] byArray) {
            this.audioFormat = n3;
            this.channelCount = n4;
            this.sampleRate = n5;
            this.data = byArray;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface AudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    public static enum AudioRecordStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }

    public static class Builder {
        public final Context context;
        public final AudioManager audioManager;
        public int inputSampleRate;
        public int outputSampleRate;
        public int audioSource;
        public int audioFormat;
        public AudioTrackErrorCallback audioTrackErrorCallback;
        public AudioRecordErrorCallback audioRecordErrorCallback;
        public SamplesReadyCallback samplesReadyCallback;
        public boolean useHardwareAcousticEchoCanceler;
        public boolean useHardwareNoiseSuppressor;
        public boolean useStereoInput;
        public boolean useStereoOutput;

        public Builder(Context context) {
            Builder builder = this;
            this.audioSource = 7;
            this.audioFormat = 2;
            this.useHardwareAcousticEchoCanceler = JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported();
            this.useHardwareNoiseSuppressor = JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported();
            this.context = context;
            builder.audioManager = (AudioManager)context.getSystemService("audio");
            builder.inputSampleRate = WebRtcAudioManager.getSampleRate(builder.audioManager);
            builder.outputSampleRate = WebRtcAudioManager.getSampleRate(builder.audioManager);
        }

        public /* synthetic */ Builder(Context context, 1 var2_2) {
            this(context);
        }

        public Builder setSampleRate(int n3) {
            Logging.d(JavaAudioDeviceModule.TAG, "Input/Output sample rate overridden to: " + n3);
            this.inputSampleRate = n3;
            this.outputSampleRate = n3;
            return this;
        }

        public Builder setInputSampleRate(int n3) {
            Logging.d(JavaAudioDeviceModule.TAG, "Input sample rate overridden to: " + n3);
            this.inputSampleRate = n3;
            return this;
        }

        public Builder setOutputSampleRate(int n3) {
            Logging.d(JavaAudioDeviceModule.TAG, "Output sample rate overridden to: " + n3);
            this.outputSampleRate = n3;
            return this;
        }

        public Builder setAudioSource(int n3) {
            this.audioSource = n3;
            return this;
        }

        public Builder setAudioFormat(int n3) {
            this.audioFormat = n3;
            return this;
        }

        public Builder setAudioTrackErrorCallback(AudioTrackErrorCallback audioTrackErrorCallback) {
            this.audioTrackErrorCallback = audioTrackErrorCallback;
            return this;
        }

        public Builder setAudioRecordErrorCallback(AudioRecordErrorCallback audioRecordErrorCallback) {
            this.audioRecordErrorCallback = audioRecordErrorCallback;
            return this;
        }

        public Builder setSamplesReadyCallback(SamplesReadyCallback samplesReadyCallback) {
            this.samplesReadyCallback = samplesReadyCallback;
            return this;
        }

        public Builder setUseHardwareNoiseSuppressor(boolean bl) {
            if (bl && !JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported()) {
                Logging.e(JavaAudioDeviceModule.TAG, "HW NS not supported");
                bl = false;
            }
            this.useHardwareNoiseSuppressor = bl;
            return this;
        }

        public Builder setUseHardwareAcousticEchoCanceler(boolean bl) {
            if (bl && !JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported()) {
                Logging.e(JavaAudioDeviceModule.TAG, "HW AEC not supported");
                bl = false;
            }
            this.useHardwareAcousticEchoCanceler = bl;
            return this;
        }

        public Builder setUseStereoInput(boolean bl) {
            this.useStereoInput = bl;
            return this;
        }

        public Builder setUseStereoOutput(boolean bl) {
            this.useStereoOutput = bl;
            return this;
        }

        public AudioDeviceModule createAudioDeviceModule() {
            WebRtcAudioTrack webRtcAudioTrack;
            WebRtcAudioRecord webRtcAudioRecord;
            Logging.d(JavaAudioDeviceModule.TAG, "createAudioDeviceModule");
            if (this.useHardwareNoiseSuppressor) {
                Logging.d(JavaAudioDeviceModule.TAG, "HW NS will be used.");
            } else {
                if (JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported()) {
                    Logging.d(JavaAudioDeviceModule.TAG, "Overriding default behavior; now using WebRTC NS!");
                }
                Logging.d(JavaAudioDeviceModule.TAG, "HW NS will not be used.");
            }
            if (this.useHardwareAcousticEchoCanceler) {
                Logging.d(JavaAudioDeviceModule.TAG, "HW AEC will be used.");
            } else {
                if (JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported()) {
                    Logging.d(JavaAudioDeviceModule.TAG, "Overriding default behavior; now using WebRTC AEC!");
                }
                Logging.d(JavaAudioDeviceModule.TAG, "HW AEC will not be used.");
            }
            WebRtcAudioRecord webRtcAudioRecord2 = webRtcAudioRecord;
            webRtcAudioRecord = new WebRtcAudioRecord(this.context, this.audioManager, this.audioSource, this.audioFormat, this.audioRecordErrorCallback, this.samplesReadyCallback, this.useHardwareAcousticEchoCanceler, this.useHardwareNoiseSuppressor);
            WebRtcAudioTrack webRtcAudioTrack2 = webRtcAudioTrack;
            webRtcAudioTrack = new WebRtcAudioTrack(this.context, this.audioManager, this.audioTrackErrorCallback);
            return new JavaAudioDeviceModule(this.context, this.audioManager, webRtcAudioRecord2, webRtcAudioTrack2, this.inputSampleRate, this.outputSampleRate, this.useStereoInput, this.useStereoOutput, null);
        }
    }
}

