/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.webrtc.GlGenericDrawer;
import org.webrtc.GlShader;
import org.webrtc.GlTextureFrameBuffer;
import org.webrtc.GlUtil;
import org.webrtc.JavaI420Buffer;
import org.webrtc.JniCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoFrameDrawer;

public class YuvConverter {
    public static final String FRAGMENT_SHADER = "uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n";
    public final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    public final GlTextureFrameBuffer i420TextureFrameBuffer = new GlTextureFrameBuffer(6408);
    public final ShaderCallbacks shaderCallbacks = new ShaderCallbacks(null);
    public final GlGenericDrawer drawer = new GlGenericDrawer("uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n", this.shaderCallbacks);
    public final VideoFrameDrawer videoFrameDrawer;

    public YuvConverter() {
        this(new VideoFrameDrawer());
    }

    public YuvConverter(VideoFrameDrawer videoFrameDrawer) {
        this.videoFrameDrawer = videoFrameDrawer;
        this.threadChecker.detachThread();
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer textureBuffer) {
        Matrix matrix;
        YuvConverter yuvConverter = this;
        yuvConverter.threadChecker.checkIsOnValidThread();
        VideoFrame.TextureBuffer textureBuffer2 = textureBuffer;
        textureBuffer = (VideoFrame.TextureBuffer)yuvConverter.videoFrameDrawer.prepareBufferForViewportSize(textureBuffer2, textureBuffer2.getWidth(), textureBuffer.getHeight());
        int n3 = textureBuffer.getWidth();
        int n4 = n3;
        int n5 = textureBuffer.getHeight();
        int n6 = n5;
        int n7 = (n4 + 7) / 8 * 8;
        int n8 = n6;
        int n9 = (n8 + 1) / 2;
        int n10 = n8 + n9;
        ByteBuffer byteBuffer = JniCommon.nativeAllocateByteBuffer(n7 * n10);
        YuvConverter yuvConverter2 = this;
        int n11 = n7 / 4;
        Matrix matrix2 = matrix;
        new Matrix().preTranslate(0.5f, 0.5f);
        matrix2.preScale(1.0f, -1.0f);
        matrix2.preTranslate(-0.5f, -0.5f);
        yuvConverter2.i420TextureFrameBuffer.setSize(n11, n10);
        GLES20.glBindFramebuffer((int)36160, (int)yuvConverter2.i420TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        yuvConverter2.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawTexture(yuvConverter2.drawer, textureBuffer, matrix2, n4, n6, 0, 0, n11, n6);
        yuvConverter2.shaderCallbacks.setPlaneU();
        VideoFrameDrawer.drawTexture(yuvConverter2.drawer, textureBuffer, matrix2, n4, n6, 0, n6, n11 /= 2, n9);
        yuvConverter2.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawTexture(yuvConverter2.drawer, textureBuffer, matrix2, n4, n6, n11, n6, n11, n9);
        n11 = yuvConverter2.i420TextureFrameBuffer.getWidth();
        n4 = yuvConverter2.i420TextureFrameBuffer.getHeight();
        GLES20.glReadPixels((int)0, (int)0, (int)n11, (int)n4, (int)6408, (int)5121, (Buffer)byteBuffer);
        GlUtil.checkNoGLES2Error("YuvConverter.convert");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        n11 = n7 * n6 + 0;
        n4 = n7 / 2;
        n6 = n11 + n4;
        byteBuffer.position(0);
        byteBuffer.limit(n11);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        ByteBuffer byteBuffer3 = byteBuffer;
        int n12 = n11;
        byteBuffer.position(n11);
        n11 = (n9 - 1) * n7 + n4;
        byteBuffer3.limit(n12 + n11);
        ByteBuffer byteBuffer4 = byteBuffer3.slice();
        ByteBuffer byteBuffer5 = byteBuffer;
        byteBuffer.position(n6);
        byteBuffer5.limit(n6 + n11);
        ByteBuffer byteBuffer6 = byteBuffer5.slice();
        textureBuffer.release();
        return JavaI420Buffer.wrap(n3, n5, byteBuffer2, n7, byteBuffer4, n7, byteBuffer6, n7, () -> JniCommon.nativeFreeByteBuffer(byteBuffer));
    }

    public void release() {
        YuvConverter yuvConverter = this;
        yuvConverter.threadChecker.checkIsOnValidThread();
        yuvConverter.drawer.release();
        yuvConverter.i420TextureFrameBuffer.release();
        yuvConverter.videoFrameDrawer.release();
        yuvConverter.threadChecker.detachThread();
    }

    public static class ShaderCallbacks
    implements GlGenericDrawer.ShaderCallbacks {
        public static final float[] yCoeffs = new float[]{0.256788f, 0.504129f, 0.0979059f, 0.0627451f};
        public static final float[] uCoeffs = new float[]{-0.148223f, -0.290993f, 0.439216f, 0.501961f};
        public static final float[] vCoeffs = new float[]{0.439216f, -0.367788f, -0.0714274f, 0.501961f};
        public int xUnitLoc;
        public int coeffsLoc;
        public float[] coeffs;
        public float stepSize;

        public ShaderCallbacks() {
        }

        public /* synthetic */ ShaderCallbacks(1 var1_1) {
            this();
        }

        public void setPlaneY() {
            ShaderCallbacks shaderCallbacks = this;
            shaderCallbacks.coeffs = yCoeffs;
            shaderCallbacks.stepSize = 1.0f;
        }

        public void setPlaneU() {
            ShaderCallbacks shaderCallbacks = this;
            shaderCallbacks.coeffs = uCoeffs;
            shaderCallbacks.stepSize = 2.0f;
        }

        public void setPlaneV() {
            ShaderCallbacks shaderCallbacks = this;
            shaderCallbacks.coeffs = vCoeffs;
            shaderCallbacks.stepSize = 2.0f;
        }

        @Override
        public void onNewShader(GlShader glShader) {
            this.xUnitLoc = glShader.getUniformLocation("xUnit");
            this.coeffsLoc = glShader.getUniformLocation("coeffs");
        }

        @Override
        public void onPrepareShader(GlShader glShader, float[] fArray, int n3, int n4, int n5, int n6) {
            ShaderCallbacks shaderCallbacks = this;
            GLES20.glUniform4fv((int)shaderCallbacks.coeffsLoc, (int)1, (float[])this.coeffs, (int)0);
            float f3 = this.stepSize;
            float f4 = n3;
            GLES20.glUniform2f((int)shaderCallbacks.xUnitLoc, (float)(f3 * fArray[0] / f4), (float)(f3 * fArray[1] / f4));
        }
    }
}

