/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import org.webrtc.CapturerObserver;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

public interface VideoProcessor
extends CapturerObserver {
    @Nullable
    public static VideoFrame applyFrameAdaptationParameters(VideoFrame videoFrame, FrameAdaptationParameters frameAdaptationParameters) {
        if (frameAdaptationParameters.drop) {
            return null;
        }
        VideoFrame.Buffer buffer = videoFrame.getBuffer().cropAndScale(frameAdaptationParameters.cropX, frameAdaptationParameters.cropY, frameAdaptationParameters.cropWidth, frameAdaptationParameters.cropHeight, frameAdaptationParameters.scaleWidth, frameAdaptationParameters.scaleHeight);
        return new VideoFrame(buffer, videoFrame.getRotation(), frameAdaptationParameters.timestampNs);
    }

    default public void onFrameCaptured(VideoFrame videoFrame, FrameAdaptationParameters frameAdaptationParameters) {
        if ((videoFrame = VideoProcessor.applyFrameAdaptationParameters(videoFrame, frameAdaptationParameters)) != null) {
            this.onFrameCaptured(videoFrame);
            videoFrame.release();
        }
    }

    public void setSink(@Nullable VideoSink var1);

    public static class FrameAdaptationParameters {
        public final int cropX;
        public final int cropY;
        public final int cropWidth;
        public final int cropHeight;
        public final int scaleWidth;
        public final int scaleHeight;
        public final long timestampNs;
        public final boolean drop;

        public FrameAdaptationParameters(int n3, int n4, int n5, int n6, int n7, int n8, long l3, boolean bl) {
            this.cropX = n3;
            this.cropY = n4;
            this.cropWidth = n5;
            this.cropHeight = n6;
            this.scaleWidth = n7;
            this.scaleHeight = n8;
            this.timestampNs = l3;
            this.drop = bl;
        }
    }
}

