/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import android.support.annotation.Nullable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.webrtc.GlUtil;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.VideoFrame;
import org.webrtc.YuvHelper;

public class VideoFrameDrawer {
    public static final String TAG = "VideoFrameDrawer";
    public static final float[] srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    public final float[] dstPoints = new float[6];
    public final Point renderSize = new Point();
    public int renderWidth;
    public int renderHeight;
    public final YuvUploader yuvUploader = new YuvUploader(null);
    @Nullable
    public VideoFrame lastI420Frame;
    public final Matrix renderMatrix = new Matrix();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void drawTexture(RendererCommon.GlDrawer glDrawer, VideoFrame.TextureBuffer textureBuffer, Matrix object, int n3, int n4, int n5, int n6, int n7, int n8) {
        void var8_9;
        void var7_8;
        void var6_7;
        void var5_6;
        void var4_5;
        void var3_4;
        Matrix matrix = new Matrix(textureBuffer.getTransformMatrix());
        matrix.preConcat(object);
        float[] fArray = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(matrix);
        int n9 = textureBuffer.getType().ordinal();
        if (n9 != 0) {
            if (n9 != 1) throw new RuntimeException("Unknown texture type.");
            glDrawer.drawRgb(textureBuffer.getTextureId(), fArray, (int)var3_4, (int)var4_5, (int)var5_6, (int)var6_7, (int)var7_8, (int)var8_9);
            return;
        } else {
            glDrawer.drawOes(textureBuffer.getTextureId(), fArray, (int)var3_4, (int)var4_5, (int)var5_6, (int)var6_7, (int)var7_8, (int)var8_9);
        }
    }

    public static int distance(float f3, float f4, float f5, float f6) {
        return (int)Math.round(Math.hypot(f5 - f3, f6 - f4));
    }

    private void calculateTransformedRenderSize(int n3, int n4, @Nullable Matrix matrix) {
        if (matrix == null) {
            ((VideoFrameDrawer)object).renderWidth = n3;
            ((VideoFrameDrawer)object).renderHeight = n4;
            return;
        }
        matrix.mapPoints(((VideoFrameDrawer)object).dstPoints, srcPoints);
        for (int i3 = 0; i3 < 3; ++i3) {
            float[] fArray = ((VideoFrameDrawer)object).dstPoints;
            float[] fArray2 = fArray;
            int n5 = i3 * 2;
            int n6 = n5 + 0;
            fArray[n6] = fArray2[n6] * (float)n3;
            int n7 = n5 + 1;
            ((VideoFrameDrawer)object).dstPoints[n7] = fArray2[n7] * (float)n4;
        }
        VideoFrameDrawer videoFrameDrawer = object;
        Object object = videoFrameDrawer.dstPoints;
        videoFrameDrawer.renderWidth = VideoFrameDrawer.distance(videoFrameDrawer.dstPoints[0], (float)object[1], (float)object[2], (float)object[3]);
        object = videoFrameDrawer.dstPoints;
        videoFrameDrawer.renderHeight = VideoFrameDrawer.distance(videoFrameDrawer.dstPoints[0], (float)object[1], (float)object[4], (float)object[5]);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer) {
        this.drawFrame(videoFrame, glDrawer, null);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer, Matrix matrix) {
        VideoFrame videoFrame2 = videoFrame;
        int n3 = videoFrame2.getRotatedWidth();
        int n4 = videoFrame2.getRotatedHeight();
        this.drawFrame(videoFrame, glDrawer, matrix, 0, 0, n3, n4);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer, @Nullable Matrix matrix, int n3, int n4, int n5, int n6) {
        VideoFrameDrawer videoFrameDrawer = this;
        videoFrameDrawer.calculateTransformedRenderSize(videoFrame.getRotatedWidth(), videoFrame.getRotatedHeight(), matrix);
        if (videoFrameDrawer.renderWidth > 0 && this.renderHeight > 0) {
            boolean bl = videoFrame.getBuffer() instanceof VideoFrame.TextureBuffer;
            VideoFrameDrawer videoFrameDrawer2 = this;
            videoFrameDrawer2.renderMatrix.reset();
            videoFrameDrawer2.renderMatrix.preTranslate(0.5f, 0.5f);
            if (!bl) {
                this.renderMatrix.preScale(1.0f, -1.0f);
            }
            VideoFrameDrawer videoFrameDrawer3 = this;
            videoFrameDrawer3.renderMatrix.preRotate((float)videoFrame.getRotation());
            videoFrameDrawer3.renderMatrix.preTranslate(-0.5f, -0.5f);
            if (matrix != null) {
                this.renderMatrix.preConcat(matrix);
            }
            if (bl) {
                this.lastI420Frame = null;
                VideoFrameDrawer.drawTexture(glDrawer, (VideoFrame.TextureBuffer)videoFrame.getBuffer(), this.renderMatrix, this.renderWidth, this.renderHeight, n3, n4, n5, n6);
            } else {
                if (videoFrame != this.lastI420Frame) {
                    this.lastI420Frame = videoFrame;
                    VideoFrame.I420Buffer i420Buffer = videoFrame.getBuffer().toI420();
                    this.yuvUploader.uploadFromBuffer(i420Buffer);
                    i420Buffer.release();
                }
                glDrawer.drawYuv(this.yuvUploader.getYuvTextures(), RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, n3, n4, n5, n6);
            }
            return;
        }
        Logging.w(TAG, a.a("Illegal frame size: ").append(this.renderWidth).append("x").append(this.renderHeight).toString());
    }

    public VideoFrame.Buffer prepareBufferForViewportSize(VideoFrame.Buffer buffer, int n3, int n4) {
        VideoFrame.Buffer buffer2 = buffer;
        buffer2.retain();
        return buffer2;
    }

    public void release() {
        this.yuvUploader.release();
        this.lastI420Frame = null;
    }

    public static class YuvUploader {
        @Nullable
        public ByteBuffer copyBuffer;
        @Nullable
        public int[] yuvTextures;

        public YuvUploader() {
        }

        public /* synthetic */ YuvUploader(1 var1_1) {
            this();
        }

        @Nullable
        public int[] uploadYuvData(int n3, int n4, int[] nArray, ByteBuffer[] byteBufferArray) {
            ByteBuffer byteBuffer;
            int[] nArray2 = new int[3];
            int[] nArray3 = nArray2;
            nArray3[0] = n3;
            nArray2[1] = n3 /= 2;
            nArray2[2] = n3;
            int[] nArray4 = new int[3];
            int[] nArray5 = nArray4;
            nArray5[0] = n4;
            nArray4[1] = n4 /= 2;
            nArray4[2] = n4;
            n4 = 0;
            for (int i3 = 0; i3 < 3; ++i3) {
                if (nArray[i3] <= nArray3[i3]) continue;
                n4 = Math.max(n4, nArray3[i3] * nArray5[i3]);
            }
            if (n4 > 0 && ((byteBuffer = this.copyBuffer) == null || byteBuffer.capacity() < n4)) {
                this.copyBuffer = ByteBuffer.allocateDirect(n4);
            }
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (n4 = 0; n4 < 3; ++n4) {
                    this.yuvTextures[n4] = GlUtil.generateTexture(3553);
                }
            }
            for (n4 = 0; n4 < 3; ++n4) {
                ByteBuffer byteBuffer2;
                GLES20.glActiveTexture((int)(n4 + 33984));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[n4]);
                if (nArray[n4] == nArray3[n4]) {
                    byteBuffer2 = byteBufferArray[n4];
                } else {
                    YuvHelper.copyPlane(byteBufferArray[n4], nArray[n4], this.copyBuffer, nArray3[n4], nArray3[n4], nArray5[n4]);
                    byteBuffer2 = this.copyBuffer;
                }
                int n5 = nArray3[n4];
                int n6 = nArray5[n4];
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)n5, (int)n6, (int)0, (int)6409, (int)5121, (Buffer)byteBuffer2);
            }
            return this.yuvTextures;
        }

        @Nullable
        public int[] uploadFromBuffer(VideoFrame.I420Buffer i420Buffer) {
            YuvUploader yuvUploader = object;
            int[] nArray = new int[3];
            Object object = nArray;
            object[0] = i420Buffer.getStrideY();
            object[1] = i420Buffer.getStrideU();
            nArray[2] = i420Buffer.getStrideV();
            ByteBuffer[] byteBufferArray = new ByteBuffer[3];
            ByteBuffer[] byteBufferArray2 = byteBufferArray;
            byteBufferArray2[0] = i420Buffer.getDataY();
            byteBufferArray2[1] = i420Buffer.getDataU();
            byteBufferArray[2] = i420Buffer.getDataV();
            return yuvUploader.uploadYuvData(i420Buffer.getWidth(), i420Buffer.getHeight(), (int[])object, byteBufferArray2);
        }

        @Nullable
        public int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public void release() {
            YuvUploader yuvUploader = this;
            yuvUploader.copyBuffer = null;
            int[] nArray = yuvUploader.yuvTextures;
            if (yuvUploader.yuvTextures != null) {
                GLES20.glDeleteTextures((int)3, (int[])nArray, (int)0);
                this.yuvTextures = null;
            }
        }
    }
}

