/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.os.Handler;
import android.os.HandlerThread;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import org.webrtc.EglBase;
import org.webrtc.Logging;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.YuvConverter;
import org.webrtc.YuvHelper;

public class VideoFileRenderer
implements VideoSink {
    public static final String TAG = "VideoFileRenderer";
    public final HandlerThread renderThread;
    public final Handler renderThreadHandler;
    public final HandlerThread fileThread;
    public final Handler fileThreadHandler;
    public final FileOutputStream videoOutFile;
    public final String outputFileName;
    public final int outputFileWidth;
    public final int outputFileHeight;
    public final int outputFrameSize;
    public final ByteBuffer outputFrameBuffer;
    public EglBase eglBase;
    public YuvConverter yuvConverter;
    public int frameCount;

    public VideoFileRenderer(String string2, int n3, int n4, final EglBase.Context context) {
        if (n3 % 2 != 1 && n4 % 2 != 1) {
            VideoFileRenderer videoFileRenderer = this;
            this.outputFileName = string2;
            this.outputFileWidth = n3;
            this.outputFileHeight = n4;
            videoFileRenderer.outputFrameSize = n3 * n4 * 3 / 2;
            videoFileRenderer.outputFrameBuffer = ByteBuffer.allocateDirect(videoFileRenderer.outputFrameSize);
            videoFileRenderer.videoOutFile = new FileOutputStream(string2);
            videoFileRenderer.videoOutFile.write(("YUV4MPEG2 C420 W" + n3 + " H" + n4 + " Ip F30:1 A1:1\n").getBytes(Charset.forName("US-ASCII")));
            videoFileRenderer.renderThread = new HandlerThread("VideoFileRendererRenderThread");
            videoFileRenderer.renderThread.start();
            videoFileRenderer.renderThreadHandler = new Handler(this.renderThread.getLooper());
            videoFileRenderer.fileThread = new HandlerThread("VideoFileRendererFileThread");
            videoFileRenderer.fileThread.start();
            videoFileRenderer.fileThreadHandler = new Handler(this.fileThread.getLooper());
            ThreadUtils.invokeAtFrontUninterruptibly(videoFileRenderer.renderThreadHandler, new Runnable(){

                @Override
                public void run() {
                    1 v02 = this;
                    VideoFileRenderer.access$002(v02.VideoFileRenderer.this, EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER));
                    v02.VideoFileRenderer.this.eglBase.createDummyPbufferSurface();
                    v02.VideoFileRenderer.this.eglBase.makeCurrent();
                    VideoFileRenderer.access$102(v02.VideoFileRenderer.this, new YuvConverter());
                }
            });
            return;
        }
        throw new IllegalArgumentException("Does not support uneven width or height");
    }

    private void renderFrameOnRenderThread(VideoFrame videoFrame) {
        float f3;
        VideoFrame videoFrame2 = videoFrame;
        VideoFrame.Buffer buffer = videoFrame2.getBuffer();
        int n3 = videoFrame2.getRotation() % 180 == 0 ? this.outputFileWidth : this.outputFileHeight;
        int n4 = videoFrame.getRotation() % 180 == 0 ? this.outputFileHeight : this.outputFileWidth;
        float f4 = (float)buffer.getWidth() / (float)buffer.getHeight();
        float f5 = (float)n3 / (float)n4;
        VideoFrame.Buffer buffer2 = buffer;
        int n5 = buffer2.getWidth();
        int n6 = buffer2.getHeight();
        if (f3 > f4) {
            float f6 = f4;
            f4 = n6;
            n6 = (int)(f6 / f5 * f4);
        } else {
            float f7 = f4;
            f4 = n5;
            n5 = (int)(f5 / f7 * f4);
        }
        VideoFrame.Buffer buffer3 = buffer;
        VideoFrame.Buffer buffer4 = buffer3.cropAndScale((buffer3.getWidth() - n5) / 2, (buffer.getHeight() - n6) / 2, n5, n6, n3, n4);
        videoFrame.release();
        buffer = buffer4.toI420();
        buffer4.release();
        this.fileThreadHandler.post(() -> this.a((VideoFrame.I420Buffer)buffer, videoFrame));
    }

    private /* synthetic */ void a(VideoFrame.I420Buffer i420Buffer, VideoFrame videoFrame) {
        FileOutputStream fileOutputStream;
        VideoFileRenderer videoFileRenderer = this;
        VideoFrame.I420Buffer i420Buffer2 = i420Buffer;
        YuvHelper.I420Rotate(i420Buffer2.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), this.outputFrameBuffer, i420Buffer.getWidth(), i420Buffer.getHeight(), videoFrame.getRotation());
        i420Buffer2.release();
        try {
            fileOutputStream = videoFileRenderer.videoOutFile;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error writing video to disk", iOException);
        }
        fileOutputStream.write("FRAME\n".getBytes(Charset.forName("US-ASCII")));
        videoFileRenderer.videoOutFile.write(this.outputFrameBuffer.array(), this.outputFrameBuffer.arrayOffset(), this.outputFrameSize);
        ++videoFileRenderer.frameCount;
    }

    public static /* synthetic */ EglBase access$002(VideoFileRenderer videoFileRenderer, EglBase eglBase) {
        videoFileRenderer.eglBase = eglBase;
        return eglBase;
    }

    public static /* synthetic */ YuvConverter access$102(VideoFileRenderer videoFileRenderer, YuvConverter yuvConverter) {
        videoFileRenderer.yuvConverter = yuvConverter;
        return yuvConverter;
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        videoFrame.retain();
        this.renderThreadHandler.post(() -> this.renderFrameOnRenderThread(videoFrame));
    }

    public void release() {
        CountDownLatch countDownLatch;
        VideoFileRenderer videoFileRenderer = this;
        CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch2(1);
        this.renderThreadHandler.post(() -> {
            VideoFileRenderer videoFileRenderer = this;
            videoFileRenderer.yuvConverter.release();
            videoFileRenderer.eglBase.release();
            videoFileRenderer.renderThread.quit();
            countDownLatch2.countDown();
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        videoFileRenderer.fileThreadHandler.post(() -> {
            VideoFileRenderer videoFileRenderer;
            try {
                VideoFileRenderer videoFileRenderer2 = this;
                videoFileRenderer = videoFileRenderer2;
                videoFileRenderer2.videoOutFile.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error closing output file", iOException);
            }
            Logging.d(TAG, "Video written to disk as " + this.outputFileName + ". The number of frames is " + this.frameCount + " and the dimensions of the frames are " + this.outputFileWidth + "x" + this.outputFileHeight + ".");
            videoFileRenderer.fileThread.quit();
        });
        try {
            videoFileRenderer.fileThread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            Logging.e(TAG, "Interrupted while waiting for the write to disk to complete.", interruptedException);
        }
    }
}

