/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.support.annotation.Nullable;
import org.webrtc.CalledByNative;
import org.webrtc.EncodedImage;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoFrame;

public interface VideoEncoder {
    @CalledByNative
    default public long createNativeVideoEncoder() {
        return 0L;
    }

    @CalledByNative
    default public boolean isHardwareEncoder() {
        return true;
    }

    @CalledByNative
    public VideoCodecStatus initEncode(Settings var1, Callback var2);

    @CalledByNative
    public VideoCodecStatus release();

    @CalledByNative
    public VideoCodecStatus encode(VideoFrame var1, EncodeInfo var2);

    @CalledByNative
    public VideoCodecStatus setRateAllocation(BitrateAllocation var1, int var2);

    @CalledByNative
    public ScalingSettings getScalingSettings();

    @CalledByNative
    default public ResolutionBitrateLimits[] getResolutionBitrateLimits() {
        return new ResolutionBitrateLimits[0];
    }

    @CalledByNative
    public String getImplementationName();

    public static interface Callback {
        public void onEncodedFrame(EncodedImage var1, CodecSpecificInfo var2);
    }

    public static class ResolutionBitrateLimits {
        public final int frameSizePixels;
        public final int minStartBitrateBps;
        public final int minBitrateBps;
        public final int maxBitrateBps;

        public ResolutionBitrateLimits(int n3, int n4, int n5, int n6) {
            this.frameSizePixels = n3;
            this.minStartBitrateBps = n4;
            this.minBitrateBps = n5;
            this.maxBitrateBps = n6;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getFrameSizePixels() {
            return this.frameSizePixels;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getMinStartBitrateBps() {
            return this.minStartBitrateBps;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getMinBitrateBps() {
            return this.minBitrateBps;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getMaxBitrateBps() {
            return this.maxBitrateBps;
        }
    }

    public static class ScalingSettings {
        public static final ScalingSettings OFF = new ScalingSettings();
        public final boolean on;
        @Nullable
        public final Integer low;
        @Nullable
        public final Integer high;

        public ScalingSettings(int n3, int n4) {
            this.on = true;
            this.low = n3;
            this.high = n4;
        }

        public ScalingSettings() {
            this.on = false;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean bl) {
            ScalingSettings scalingSettings = this;
            scalingSettings.on = bl;
            scalingSettings.low = null;
            scalingSettings.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean bl, int n3, int n4) {
            this.on = bl;
            this.low = n3;
            this.high = n4;
        }

        public String toString() {
            return this.on ? a.a("[ ").append(this.low).append(", ").append(this.high).append(" ]").toString() : "OFF";
        }
    }

    public static class BitrateAllocation {
        public final int[][] bitratesBbs;

        @CalledByNative(value="BitrateAllocation")
        public BitrateAllocation(int[][] nArray) {
            this.bitratesBbs = nArray;
        }

        public int getSum() {
            int n3 = 0;
            int[][] nArray = this.bitratesBbs;
            int n4 = this.bitratesBbs.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                int[] nArray2 = nArray[i3];
                int n5 = nArray2.length;
                for (int i4 = 0; i4 < n5; ++i4) {
                    n3 += nArray2[i4];
                }
            }
            return n3;
        }
    }

    public static class CodecSpecificInfoH264
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP9
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP8
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfo {
    }

    public static class EncodeInfo {
        public final EncodedImage.FrameType[] frameTypes;

        @CalledByNative(value="EncodeInfo")
        public EncodeInfo(EncodedImage.FrameType[] frameTypeArray) {
            this.frameTypes = frameTypeArray;
        }
    }

    public static class Capabilities {
        public final boolean lossNotification;

        @CalledByNative(value="Capabilities")
        public Capabilities(boolean bl) {
            this.lossNotification = bl;
        }
    }

    public static class Settings {
        public final int numberOfCores;
        public final int width;
        public final int height;
        public final int startBitrate;
        public final int maxFramerate;
        public final int numberOfSimulcastStreams;
        public final boolean automaticResizeOn;
        public final Capabilities capabilities;

        @Deprecated
        public Settings(int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
            this(n3, n4, n5, n6, n7, n8, bl, new Capabilities(false));
        }

        @CalledByNative(value="Settings")
        public Settings(int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, Capabilities capabilities) {
            this.numberOfCores = n3;
            this.width = n4;
            this.height = n5;
            this.startBitrate = n6;
            this.maxFramerate = n7;
            this.numberOfSimulcastStreams = n8;
            this.automaticResizeOn = bl;
            this.capabilities = capabilities;
        }
    }
}

