/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    public static void checkIsOnMainThread() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            return;
        }
        throw new IllegalStateException("Not on main thread!");
    }

    public static void executeUninterruptibly(BlockingOperation blockingOperation) {
        boolean bl = false;
        while (true) {
            try {
                blockingOperation.run();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
            return;
        }
    }

    public static boolean joinUninterruptibly(Thread thread, long l3) {
        boolean bl;
        long l4 = SystemClock.elapsedRealtime();
        boolean bl2 = bl = false;
        long l5 = l3;
        while (l5 > 0L) {
            try {
                thread.join(l5);
                break;
            }
            catch (InterruptedException interruptedException) {
                boolean bl3 = true;
                long l6 = l3 - (SystemClock.elapsedRealtime() - l4);
                bl2 = bl3;
                l5 = l6;
            }
        }
        if (bl2) {
            Thread.currentThread().interrupt();
        }
        return thread.isAlive() ^ true;
    }

    public static void joinUninterruptibly(final Thread thread) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() {
                thread.join();
            }
        });
    }

    public static void awaitUninterruptibly(final CountDownLatch countDownLatch) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() {
                countDownLatch.await();
            }
        });
    }

    public static boolean awaitUninterruptibly(CountDownLatch countDownLatch, long l3) {
        long l4 = SystemClock.elapsedRealtime();
        boolean bl = false;
        boolean bl2 = false;
        long l5 = l3;
        while (true) {
            try {
                bl2 = countDownLatch.await(l5, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                if ((l5 = l3 - (SystemClock.elapsedRealtime() - l4)) > 0L) continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return bl2;
    }

    public static <V> V invokeAtFrontUninterruptibly(Handler object, Callable<V> object2) {
        RuntimeException runtimeException;
        CountDownLatch countDownLatch;
        CaughtException caughtException;
        Result result;
        if (object.getLooper().getThread() == Thread.currentThread()) {
            try {
                return object2.call();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        final Result result2 = result;
        public class Result {
            public V value;
        }
        result = new Result();
        CaughtException caughtException2 = caughtException;
        public class CaughtException {
            public Exception e;
        }
        caughtException = new CaughtException();
        CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch2(1);
        object.post(new Runnable((Callable)object2, caughtException2, countDownLatch2){
            public final /* synthetic */ Callable val$callable;
            public final /* synthetic */ CaughtException val$caughtException;
            public final /* synthetic */ CountDownLatch val$barrier;
            {
                this.val$callable = callable;
                this.val$caughtException = caughtException;
                this.val$barrier = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    result2.value = this.val$callable.call();
                }
                catch (Exception exception) {
                    this.val$caughtException.e = exception;
                }
                this.val$barrier.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        object = caughtException.e;
        if (object == null) {
            return result2.value;
        }
        object2 = runtimeException;
        ((RuntimeException)object2)((Throwable)object);
        runtimeException.setStackTrace(ThreadUtils.concatStackTraces(caughtException2.e.getStackTrace(), ((Throwable)object2).getStackTrace()));
        throw runtimeException;
    }

    public static void invokeAtFrontUninterruptibly(Handler handler, final Runnable runnable) {
        ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Void>(){

            @Override
            public Void call() {
                runnable.run();
                return null;
            }
        });
    }

    public static StackTraceElement[] concatStackTraces(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        StackTraceElement[] stackTraceElementArray3 = new StackTraceElement[stackTraceElementArray.length + stackTraceElementArray2.length];
        int n3 = stackTraceElementArray.length;
        System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray3, 0, n3);
        n3 = stackTraceElementArray.length;
        int n4 = stackTraceElementArray2.length;
        System.arraycopy(stackTraceElementArray2, 0, stackTraceElementArray3, n3, n4);
        return stackTraceElementArray3;
    }

    public static interface BlockingOperation {
        public void run();
    }

    public static class ThreadChecker {
        @Nullable
        public Thread thread = Thread.currentThread();

        public void checkIsOnValidThread() {
            if (this.thread == null) {
                this.thread = Thread.currentThread();
            }
            if (Thread.currentThread() == this.thread) {
                return;
            }
            throw new IllegalStateException("Wrong thread");
        }

        public void detachThread() {
            this.thread = null;
        }
    }
}

