/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import android.os.Handler;
import android.support.annotation.Nullable;
import org.webrtc.RefCountDelegate;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.YuvConverter;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    public final int unscaledWidth;
    public final int unscaledHeight;
    public final int width;
    public final int height;
    public final VideoFrame.TextureBuffer.Type type;
    public final int id;
    public final Matrix transformMatrix;
    public final Handler toI420Handler;
    public final YuvConverter yuvConverter;
    public final RefCountDelegate refCountDelegate;

    public TextureBufferImpl(int n3, int n4, VideoFrame.TextureBuffer.Type type, int n5, Matrix matrix, Handler handler, YuvConverter yuvConverter, @Nullable Runnable runnable) {
        TextureBufferImpl textureBufferImpl = this;
        this.unscaledWidth = n3;
        this.unscaledHeight = n4;
        this.width = n3;
        this.height = n4;
        this.type = type;
        this.id = n5;
        this.transformMatrix = matrix;
        this.toI420Handler = handler;
        textureBufferImpl.yuvConverter = yuvConverter;
        textureBufferImpl.refCountDelegate = new RefCountDelegate(runnable);
    }

    public TextureBufferImpl(int n3, int n4, int n5, int n6, VideoFrame.TextureBuffer.Type type, int n7, Matrix matrix, Handler handler, YuvConverter yuvConverter, @Nullable Runnable runnable) {
        TextureBufferImpl textureBufferImpl = this;
        this.unscaledWidth = n3;
        this.unscaledHeight = n4;
        this.width = n5;
        this.height = n6;
        this.type = type;
        this.id = n7;
        this.transformMatrix = matrix;
        this.toI420Handler = handler;
        textureBufferImpl.yuvConverter = yuvConverter;
        textureBufferImpl.refCountDelegate = new RefCountDelegate(runnable);
    }

    private TextureBufferImpl applyTransformMatrix(Matrix matrix, int n3, int n4, int n5, int n6) {
        Matrix matrix2;
        Matrix matrix3 = matrix2;
        matrix3(this.transformMatrix);
        matrix2.preConcat(matrix);
        this.retain();
        return new TextureBufferImpl(n3, n4, n5, n6, this.type, this.id, matrix3, this.toI420Handler, this.yuvConverter, this::release);
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, () -> this.yuvConverter.convert(this));
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n3, int n4, int n5, int n6, int n7, int n8) {
        Matrix matrix;
        Matrix matrix2 = matrix;
        int n9 = n3;
        matrix2();
        n3 = this.height;
        n4 = n3 - (n4 + n6);
        matrix2.preTranslate((float)n9 / (float)this.width, (float)n4 / (float)n3);
        matrix2.preScale((float)n5 / (float)this.width, (float)n6 / (float)this.height);
        return this.applyTransformMatrix(matrix, Math.round((float)(this.unscaledWidth * n5) / (float)this.width), Math.round((float)(this.unscaledHeight * n6) / (float)this.height), n7, n8);
    }

    public int getUnscaledWidth() {
        return this.unscaledWidth;
    }

    public int getUnscaledHeight() {
        return this.unscaledHeight;
    }

    public Handler getToI420Handler() {
        return this.toI420Handler;
    }

    public YuvConverter getYuvConverter() {
        return this.yuvConverter;
    }

    public TextureBufferImpl applyTransformMatrix(Matrix matrix, int n3, int n4) {
        return this.applyTransformMatrix(matrix, n3, n4, n3, n4);
    }
}

