/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.GlRectDrawer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceEglRenderer;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

public class SurfaceViewRenderer
extends SurfaceView
implements SurfaceHolder.Callback,
VideoSink,
RendererCommon.RendererEvents {
    public static final String TAG = "SurfaceViewRenderer";
    public final String resourceName;
    public final RendererCommon.VideoLayoutMeasure videoLayoutMeasure;
    public final SurfaceEglRenderer eglRenderer;
    public RendererCommon.RendererEvents rendererEvents;
    public int rotatedFrameWidth;
    public int rotatedFrameHeight;
    public boolean enableFixedSize;
    public int surfaceWidth;
    public int surfaceHeight;

    public SurfaceViewRenderer(Context context) {
        SurfaceViewRenderer surfaceViewRenderer = this;
        super(context);
        surfaceViewRenderer.videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
        surfaceViewRenderer.resourceName = surfaceViewRenderer.getResourceName();
        surfaceViewRenderer.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        surfaceViewRenderer.getHolder().addCallback((SurfaceHolder.Callback)this);
        surfaceViewRenderer.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    public SurfaceViewRenderer(Context context, AttributeSet attributeSet) {
        SurfaceViewRenderer surfaceViewRenderer = this;
        super(context, attributeSet);
        surfaceViewRenderer.videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
        surfaceViewRenderer.resourceName = surfaceViewRenderer.getResourceName();
        surfaceViewRenderer.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        surfaceViewRenderer.getHolder().addCallback((SurfaceHolder.Callback)this);
        surfaceViewRenderer.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
            int n3;
            int n4;
            SurfaceViewRenderer surfaceViewRenderer = this;
            float f3 = (float)surfaceViewRenderer.getWidth() / (float)this.getHeight();
            int n5 = surfaceViewRenderer.rotatedFrameWidth;
            int n6 = this.rotatedFrameHeight;
            if ((float)n4 / (float)n3 > f3) {
                n5 = (int)((float)n6 * f3);
            } else {
                n6 = (int)((float)n5 / f3);
            }
            int n7 = Math.min(this.getWidth(), n5);
            SurfaceViewRenderer surfaceViewRenderer2 = this;
            n5 = Math.min(surfaceViewRenderer2.getHeight(), n6);
            surfaceViewRenderer2.logD(a.a("updateSurfaceSize. Layout size: ").append(this.getWidth()).append("x").append(this.getHeight()).append(", frame size: ").append(this.rotatedFrameWidth).append("x").append(this.rotatedFrameHeight).append(", requested surface size: ").append(n7).append("x").append(n5).append(", old surface size: ").append(this.surfaceWidth).append("x").append(this.surfaceHeight).toString());
            if (n7 != surfaceViewRenderer2.surfaceWidth || n5 != this.surfaceHeight) {
                this.surfaceWidth = n7;
                this.surfaceHeight = n5;
                this.getHolder().setFixedSize(n7, n5);
            }
        } else {
            this.surfaceHeight = 0;
            this.surfaceWidth = 0;
            this.getHolder().setSizeFromLayout();
        }
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId());
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    private void postOrRun(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.post(runnable);
        }
    }

    private void logD(String string2) {
        Logging.d(TAG, this.resourceName + ": " + string2);
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents) {
        this.init(context, rendererEvents, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init(context, this, nArray, glDrawer);
    }

    public void release() {
        this.eglRenderer.release();
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f3, RendererCommon.GlDrawer glDrawer) {
        this.eglRenderer.addFrameListener(frameListener, f3, glDrawer);
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f3) {
        this.eglRenderer.addFrameListener(frameListener, f3);
    }

    public void removeFrameListener(EglRenderer.FrameListener frameListener) {
        this.eglRenderer.removeFrameListener(frameListener);
    }

    public void setEnableHardwareScaler(boolean bl) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = bl;
        this.updateSurfaceSize();
    }

    public void setMirror(boolean bl) {
        this.eglRenderer.setMirror(bl);
    }

    public void setScalingType(RendererCommon.ScalingType scalingType) {
        SurfaceViewRenderer surfaceViewRenderer = this;
        ThreadUtils.checkIsOnMainThread();
        surfaceViewRenderer.videoLayoutMeasure.setScalingType(scalingType);
        surfaceViewRenderer.requestLayout();
    }

    public void setScalingType(RendererCommon.ScalingType scalingType, RendererCommon.ScalingType scalingType2) {
        SurfaceViewRenderer surfaceViewRenderer = this;
        ThreadUtils.checkIsOnMainThread();
        surfaceViewRenderer.videoLayoutMeasure.setScalingType(scalingType, scalingType2);
        surfaceViewRenderer.requestLayout();
    }

    public void setFpsReduction(float f3) {
        this.eglRenderer.setFpsReduction(f3);
    }

    public void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        this.eglRenderer.onFrame(videoFrame);
    }

    public void onMeasure(int n3, int n4) {
        SurfaceViewRenderer surfaceViewRenderer = surfaceViewRenderer2;
        ThreadUtils.checkIsOnMainThread();
        SurfaceViewRenderer surfaceViewRenderer2 = surfaceViewRenderer.videoLayoutMeasure.measure(n3, n4, surfaceViewRenderer2.rotatedFrameWidth, surfaceViewRenderer2.rotatedFrameHeight);
        surfaceViewRenderer.setMeasuredDimension(((Point)surfaceViewRenderer2).x, ((Point)surfaceViewRenderer2).y);
        surfaceViewRenderer.logD(a.a("onMeasure(). New size: ").append(((Point)surfaceViewRenderer2).x).append("x").append(((Point)surfaceViewRenderer2).y).toString());
    }

    public void onLayout(boolean bl, int n3, int n4, int n5, int n6) {
        SurfaceViewRenderer surfaceViewRenderer = this;
        ThreadUtils.checkIsOnMainThread();
        surfaceViewRenderer.eglRenderer.setLayoutAspectRatio((float)(n5 - n3) / (float)(n6 - n4));
        surfaceViewRenderer.updateSurfaceSize();
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
        this.updateSurfaceSize();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n3, int n4, int n5) {
    }

    public void clearImage() {
        this.eglRenderer.clearImage();
    }

    @Override
    public void onFirstFrameRendered() {
        RendererCommon.RendererEvents rendererEvents = ((SurfaceViewRenderer)rendererEvents).rendererEvents;
        if (rendererEvents != null) {
            rendererEvents.onFirstFrameRendered();
        }
    }

    @Override
    public void onFrameResolutionChanged(int n3, int n4, int n5) {
        RendererCommon.RendererEvents rendererEvents = this.rendererEvents;
        if (rendererEvents != null) {
            rendererEvents.onFrameResolutionChanged(n3, n4, n5);
        }
        int n6 = n5 != 0 && n5 != 180 ? n4 : n3;
        if (n5 != 0 && n5 != 180) {
            n4 = n3;
        }
        SurfaceViewRenderer surfaceViewRenderer = this;
        surfaceViewRenderer.postOrRun(() -> {
            SurfaceViewRenderer surfaceViewRenderer = this;
            this.rotatedFrameWidth = n6;
            surfaceViewRenderer.rotatedFrameHeight = n4;
            surfaceViewRenderer.updateSurfaceSize();
            surfaceViewRenderer.requestLayout();
        });
    }
}

