/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.Nullable;
import java.util.concurrent.Callable;
import org.webrtc.EglBase;
import org.webrtc.GlUtil;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.TextureBufferImpl;
import org.webrtc.ThreadUtils;
import org.webrtc.TimestampAligner;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.YuvConverter;

public class SurfaceTextureHelper {
    public static final String TAG = "SurfaceTextureHelper";
    public final Handler handler;
    public final EglBase eglBase;
    public final SurfaceTexture surfaceTexture;
    public final int oesTextureId;
    public final YuvConverter yuvConverter;
    @Nullable
    public final TimestampAligner timestampAligner;
    @Nullable
    public VideoSink listener;
    public boolean hasPendingTexture;
    public volatile boolean isTextureInUse;
    public boolean isQuitting;
    public int frameRotation;
    public int textureWidth;
    public int textureHeight;
    @Nullable
    public VideoSink pendingListener;
    public final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            2 v02 = this;
            Logging.d(SurfaceTextureHelper.TAG, a.a("Setting listener to ").append(SurfaceTextureHelper.this.pendingListener).toString());
            SurfaceTextureHelper surfaceTextureHelper = v02.SurfaceTextureHelper.this;
            SurfaceTextureHelper.access$202(surfaceTextureHelper, surfaceTextureHelper.pendingListener);
            SurfaceTextureHelper.access$102(v02.SurfaceTextureHelper.this, null);
            if (v02.SurfaceTextureHelper.this.hasPendingTexture) {
                2 v22 = this;
                v22.SurfaceTextureHelper.this.updateTexImage();
                SurfaceTextureHelper.access$302(v22.SurfaceTextureHelper.this, false);
            }
        }
    };

    public static SurfaceTextureHelper create(final String string2, final EglBase.Context context, final boolean bl, final YuvConverter yuvConverter) {
        Handler handler;
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread(string2).start();
        final Handler handler2 = handler;
        return ThreadUtils.invokeAtFrontUninterruptibly(new Handler(handlerThread2.getLooper()), new Callable<SurfaceTextureHelper>(){

            @Override
            @Nullable
            public SurfaceTextureHelper call() {
                try {
                    return new SurfaceTextureHelper(context, handler2, bl, yuvConverter, null);
                }
                catch (RuntimeException runtimeException) {
                    Logging.e(SurfaceTextureHelper.TAG, string2 + " create failure", runtimeException);
                    return null;
                }
            }
        });
    }

    public static SurfaceTextureHelper create(String object, EglBase.Context context) {
        YuvConverter yuvConverter;
        String string2 = object;
        object = yuvConverter;
        yuvConverter = new YuvConverter();
        return SurfaceTextureHelper.create(string2, context, false, (YuvConverter)object);
    }

    public static SurfaceTextureHelper create(String string2, EglBase.Context context, boolean bl) {
        return SurfaceTextureHelper.create(string2, context, bl, new YuvConverter());
    }

    public SurfaceTextureHelper(EglBase.Context context, Handler handler, boolean bl, YuvConverter yuvConverter) {
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            TimestampAligner timestampAligner;
            this.handler = handler;
            if (bl) {
                TimestampAligner timestampAligner2;
                timestampAligner = timestampAligner2;
                timestampAligner2 = new TimestampAligner();
            } else {
                timestampAligner = null;
            }
            SurfaceTextureHelper surfaceTextureHelper = this;
            this.timestampAligner = timestampAligner;
            this.yuvConverter = yuvConverter;
            surfaceTextureHelper.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
            try {
                surfaceTextureHelper.eglBase.createDummyPbufferSurface();
                surfaceTextureHelper.eglBase.makeCurrent();
            }
            catch (RuntimeException runtimeException) {
                this.eglBase.release();
                handler.getLooper().quit();
                throw runtimeException;
            }
            surfaceTextureHelper.oesTextureId = GlUtil.generateTexture(36197);
            surfaceTextureHelper.surfaceTexture = new SurfaceTexture(this.oesTextureId);
            SurfaceTextureHelper.setOnFrameAvailableListener(surfaceTextureHelper.surfaceTexture, surfaceTexture -> {
                this.hasPendingTexture = true;
                this.tryDeliverTextureFrame();
            }, handler);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
    }

    @TargetApi(value=21)
    public static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener onFrameAvailableListener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(onFrameAvailableListener);
        }
    }

    private void returnTextureFrame() {
        this.handler.post(() -> {
            this.isTextureInUse = false;
            if (this.isQuitting) {
                this.release();
            } else {
                this.tryDeliverTextureFrame();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        Object object = EglBase.lock;
        synchronized (object) {
            this.surfaceTexture.updateTexImage();
            return;
        }
    }

    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            if (!this.isQuitting && this.hasPendingTexture && !this.isTextureInUse && this.listener != null) {
                if (this.textureWidth != 0 && this.textureHeight != 0) {
                    VideoFrame videoFrame;
                    TextureBufferImpl textureBufferImpl;
                    SurfaceTextureHelper surfaceTextureHelper = this;
                    surfaceTextureHelper.isTextureInUse = true;
                    surfaceTextureHelper.hasPendingTexture = false;
                    surfaceTextureHelper.updateTexImage();
                    Object object = new float[16];
                    surfaceTextureHelper.surfaceTexture.getTransformMatrix(object);
                    long l3 = surfaceTextureHelper.surfaceTexture.getTimestamp();
                    Object object2 = surfaceTextureHelper.timestampAligner;
                    if (object2 != null) {
                        l3 = ((TimestampAligner)object2).translateTimestamp(l3);
                    }
                    object2 = textureBufferImpl;
                    textureBufferImpl = new TextureBufferImpl(this.textureWidth, this.textureHeight, VideoFrame.TextureBuffer.Type.OES, this.oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(object), this.handler, this.yuvConverter, this::returnTextureFrame);
                    object = videoFrame;
                    object((VideoFrame.Buffer)object2, this.frameRotation, l3);
                    this.listener.onFrame((VideoFrame)object);
                    videoFrame.release();
                    return;
                }
                Logging.w(TAG, "Texture size has not been set.");
                return;
            }
            return;
        }
        throw new IllegalStateException("Wrong thread.");
    }

    private void release() {
        if (((SurfaceTextureHelper)((Object)timestampAligner)).handler.getLooper().getThread() == Thread.currentThread()) {
            if (!((SurfaceTextureHelper)((Object)timestampAligner)).isTextureInUse && ((SurfaceTextureHelper)((Object)timestampAligner)).isQuitting) {
                SurfaceTextureHelper surfaceTextureHelper = timestampAligner;
                surfaceTextureHelper.yuvConverter.release();
                int[] nArray = new int[1];
                int[] nArray2 = nArray;
                nArray[0] = ((SurfaceTextureHelper)((Object)timestampAligner)).oesTextureId;
                GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
                surfaceTextureHelper.surfaceTexture.release();
                surfaceTextureHelper.eglBase.release();
                surfaceTextureHelper.handler.getLooper().quit();
                TimestampAligner timestampAligner = surfaceTextureHelper.timestampAligner;
                if (timestampAligner != null) {
                    timestampAligner.dispose();
                }
                return;
            }
            throw new IllegalStateException("Unexpected release.");
        }
        throw new IllegalStateException("Wrong thread.");
    }

    public /* synthetic */ SurfaceTextureHelper(EglBase.Context context, Handler handler, boolean bl, YuvConverter yuvConverter, 1 var5_5) {
        this(context, handler, bl, yuvConverter);
    }

    public static /* synthetic */ VideoSink access$202(SurfaceTextureHelper surfaceTextureHelper, VideoSink videoSink) {
        surfaceTextureHelper.listener = videoSink;
        return videoSink;
    }

    public static /* synthetic */ VideoSink access$102(SurfaceTextureHelper surfaceTextureHelper, VideoSink videoSink) {
        surfaceTextureHelper.pendingListener = videoSink;
        return videoSink;
    }

    public static /* synthetic */ boolean access$302(SurfaceTextureHelper surfaceTextureHelper, boolean bl) {
        surfaceTextureHelper.hasPendingTexture = bl;
        return bl;
    }

    public void startListening(VideoSink videoSink) {
        if (this.listener == null && this.pendingListener == null) {
            this.pendingListener = videoSink;
            this.handler.post(this.setListenerRunnable);
            return;
        }
        throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
    }

    public void stopListening() {
        SurfaceTextureHelper surfaceTextureHelper = this;
        Logging.d(TAG, "stopListening()");
        surfaceTextureHelper.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(surfaceTextureHelper.handler, () -> {
            SurfaceTextureHelper surfaceTextureHelper = this;
            surfaceTextureHelper.listener = null;
            surfaceTextureHelper.pendingListener = null;
        });
    }

    public void setTextureSize(int n3, int n4) {
        if (n3 > 0) {
            if (n4 > 0) {
                SurfaceTextureHelper surfaceTextureHelper = this;
                surfaceTextureHelper.surfaceTexture.setDefaultBufferSize(n3, n4);
                surfaceTextureHelper.handler.post(() -> {
                    this.textureWidth = n3;
                    this.textureHeight = n4;
                    this.tryDeliverTextureFrame();
                });
                return;
            }
            throw new IllegalArgumentException("Texture height must be positive, but was " + n4);
        }
        throw new IllegalArgumentException("Texture width must be positive, but was " + n3);
    }

    public void setFrameRotation(int n3) {
        this.handler.post(() -> {
            this.frameRotation = n3;
        });
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    public void dispose() {
        Logging.d(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, () -> {
            this.isQuitting = true;
            if (!this.isTextureInUse) {
                this.release();
            }
        });
    }

    @Deprecated
    public VideoFrame.I420Buffer textureToYuv(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.toI420();
    }
}

