/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.view.SurfaceHolder;
import java.util.concurrent.CountDownLatch;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;

public class SurfaceEglRenderer
extends EglRenderer
implements SurfaceHolder.Callback {
    public static final String TAG = "SurfaceEglRenderer";
    public RendererCommon.RendererEvents rendererEvents;
    public final Object layoutLock = new Object();
    public boolean isRenderingPaused;
    public boolean isFirstFrameRendered;
    public int rotatedFrameWidth;
    public int rotatedFrameHeight;
    public int frameRotation;

    public SurfaceEglRenderer(String string2) {
        super(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFrameDimensionsAndReportEvents(VideoFrame videoFrame) {
        SurfaceEglRenderer surfaceEglRenderer = this;
        Object object = surfaceEglRenderer.layoutLock;
        synchronized (object) {
            if (surfaceEglRenderer.isRenderingPaused) {
                return;
            }
            if (!this.isFirstFrameRendered) {
                SurfaceEglRenderer surfaceEglRenderer2 = this;
                surfaceEglRenderer2.isFirstFrameRendered = true;
                surfaceEglRenderer2.logD("Reporting first rendered frame.");
                if (surfaceEglRenderer2.rendererEvents != null) {
                    this.rendererEvents.onFirstFrameRendered();
                }
            }
            if (this.rotatedFrameWidth != videoFrame.getRotatedWidth() || this.rotatedFrameHeight != videoFrame.getRotatedHeight() || this.frameRotation != videoFrame.getRotation()) {
                SurfaceEglRenderer surfaceEglRenderer3 = this;
                surfaceEglRenderer3.logD("Reporting frame resolution changed to " + videoFrame.getBuffer().getWidth() + "x" + videoFrame.getBuffer().getHeight() + " with rotation " + videoFrame.getRotation());
                if (surfaceEglRenderer3.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(videoFrame.getBuffer().getWidth(), videoFrame.getBuffer().getHeight(), videoFrame.getRotation());
                }
                this.rotatedFrameWidth = videoFrame.getRotatedWidth();
                this.rotatedFrameHeight = videoFrame.getRotatedHeight();
                this.frameRotation = videoFrame.getRotation();
            }
            return;
        }
    }

    private void logD(String string2) {
        Logging.d(TAG, this.name + ": " + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBase.Context object, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        EglBase.Context context = object;
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        object = this.layoutLock;
        SurfaceEglRenderer surfaceEglRenderer = this;
        synchronized (object) {
            surfaceEglRenderer.isFirstFrameRendered = false;
            surfaceEglRenderer.rotatedFrameWidth = 0;
            surfaceEglRenderer.rotatedFrameHeight = 0;
            surfaceEglRenderer.frameRotation = 0;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
            super.init(context, nArray, glDrawer);
            return;
        }
    }

    @Override
    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.init(context, null, nArray, glDrawer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFpsReduction(float f3) {
        Object object = this.layoutLock;
        synchronized (object) {
            boolean bl = f3 == 0.0f;
            this.isRenderingPaused = bl;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            super.setFpsReduction(f3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableFpsReduction() {
        SurfaceEglRenderer surfaceEglRenderer = this;
        Object object = surfaceEglRenderer.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = false;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
            super.disableFpsReduction();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseVideo() {
        SurfaceEglRenderer surfaceEglRenderer = this;
        Object object = surfaceEglRenderer.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = true;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
            super.pauseVideo();
            return;
        }
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        this.updateFrameDimensionsAndReportEvents(videoFrame);
        super.onFrame(videoFrame);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        this.createEglSurface(surfaceHolder.getSurface());
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        countDownLatch.getClass();
        this.releaseEglSurface(countDownLatch::countDown);
        ThreadUtils.awaitUninterruptibly(countDownLatch);
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n3, int n4, int n5) {
        ThreadUtils.checkIsOnMainThread();
        this.logD("surfaceChanged: format: " + n3 + " size: " + n4 + "x" + n5);
    }
}

