/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.support.annotation.Nullable;
import android.view.Surface;
import org.webrtc.CapturerObserver;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

@TargetApi(value=21)
public class ScreenCapturerAndroid
implements VideoCapturer,
VideoSink {
    public static final int DISPLAY_FLAGS = 3;
    public static final int VIRTUAL_DISPLAY_DPI = 400;
    public final Intent mediaProjectionPermissionResultData;
    public final MediaProjection.Callback mediaProjectionCallback;
    public int width;
    public int height;
    @Nullable
    public VirtualDisplay virtualDisplay;
    @Nullable
    public SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    public CapturerObserver capturerObserver;
    public long numCapturedFrames;
    @Nullable
    public MediaProjection mediaProjection;
    public boolean isDisposed;
    @Nullable
    public MediaProjectionManager mediaProjectionManager;

    public ScreenCapturerAndroid(Intent intent, MediaProjection.Callback callback) {
        this.mediaProjectionPermissionResultData = intent;
        this.mediaProjectionCallback = callback;
    }

    private void checkNotDisposed() {
        if (!this.isDisposed) {
            return;
        }
        throw new RuntimeException("capturer is disposed.");
    }

    private void createVirtualDisplay() {
        Surface surface;
        ScreenCapturerAndroid screenCapturerAndroid = this;
        screenCapturerAndroid.surfaceTextureHelper.setTextureSize(this.width, this.height);
        ScreenCapturerAndroid screenCapturerAndroid2 = this;
        int n3 = screenCapturerAndroid2.width;
        int n4 = screenCapturerAndroid2.height;
        Surface surface2 = surface;
        surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
        screenCapturerAndroid.virtualDisplay = screenCapturerAndroid.mediaProjection.createVirtualDisplay("WebRTC_ScreenCapture", n3, n4, 400, 3, surface2, null, null);
    }

    public static /* synthetic */ VirtualDisplay access$202(ScreenCapturerAndroid screenCapturerAndroid, VirtualDisplay virtualDisplay) {
        screenCapturerAndroid.virtualDisplay = virtualDisplay;
        return virtualDisplay;
    }

    public static /* synthetic */ MediaProjection access$302(ScreenCapturerAndroid screenCapturerAndroid, MediaProjection mediaProjection) {
        screenCapturerAndroid.mediaProjection = mediaProjection;
        return mediaProjection;
    }

    @Override
    public synchronized void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, CapturerObserver capturerObserver) {
        this.checkNotDisposed();
        if (capturerObserver != null) {
            this.capturerObserver = capturerObserver;
            if (surfaceTextureHelper != null) {
                this.surfaceTextureHelper = surfaceTextureHelper;
                this.mediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
                return;
            }
            throw new RuntimeException("surfaceTextureHelper not set.");
        }
        throw new RuntimeException("capturerObserver not set.");
    }

    @Override
    public synchronized void startCapture(int n3, int n4, int n5) {
        ScreenCapturerAndroid screenCapturerAndroid = this;
        this.checkNotDisposed();
        this.width = n3;
        screenCapturerAndroid.height = n4;
        screenCapturerAndroid.mediaProjection = screenCapturerAndroid.mediaProjectionManager.getMediaProjection(-1, this.mediaProjectionPermissionResultData);
        screenCapturerAndroid.mediaProjection.registerCallback(this.mediaProjectionCallback, this.surfaceTextureHelper.getHandler());
        screenCapturerAndroid.createVirtualDisplay();
        screenCapturerAndroid.capturerObserver.onCapturerStarted(true);
        screenCapturerAndroid.surfaceTextureHelper.startListening(this);
    }

    @Override
    public synchronized void stopCapture() {
        ScreenCapturerAndroid screenCapturerAndroid = this;
        screenCapturerAndroid.checkNotDisposed();
        ThreadUtils.invokeAtFrontUninterruptibly(screenCapturerAndroid.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                1 v02 = this;
                v02.ScreenCapturerAndroid.this.surfaceTextureHelper.stopListening();
                v02.ScreenCapturerAndroid.this.capturerObserver.onCapturerStopped();
                if (v02.ScreenCapturerAndroid.this.virtualDisplay != null) {
                    1 v12 = this;
                    v12.ScreenCapturerAndroid.this.virtualDisplay.release();
                    ScreenCapturerAndroid.access$202(v12.ScreenCapturerAndroid.this, null);
                }
                if (ScreenCapturerAndroid.this.mediaProjection != null) {
                    1 v22 = this;
                    v22.ScreenCapturerAndroid.this.mediaProjection.unregisterCallback(ScreenCapturerAndroid.this.mediaProjectionCallback);
                    v22.ScreenCapturerAndroid.this.mediaProjection.stop();
                    ScreenCapturerAndroid.access$302(v22.ScreenCapturerAndroid.this, null);
                }
            }
        });
    }

    @Override
    public synchronized void dispose() {
        this.isDisposed = true;
    }

    @Override
    public synchronized void changeCaptureFormat(int n3, int n4, int n5) {
        this.checkNotDisposed();
        this.width = n3;
        this.height = n4;
        if (this.virtualDisplay == null) {
            return;
        }
        ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(){

            @Override
            public void run() {
                2 v02 = this;
                v02.ScreenCapturerAndroid.this.virtualDisplay.release();
                v02.ScreenCapturerAndroid.this.createVirtualDisplay();
            }
        });
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        ScreenCapturerAndroid screenCapturerAndroid = this;
        ++screenCapturerAndroid.numCapturedFrames;
        screenCapturerAndroid.capturerObserver.onFrameCaptured(videoFrame);
    }

    @Override
    public boolean isScreencast() {
        return true;
    }

    public long getNumCapturedFrames() {
        return this.numCapturedFrames;
    }
}

