/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RtpParameters;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;

public class RtpTransceiver {
    public long nativeRtpTransceiver;
    public RtpSender cachedSender;
    public RtpReceiver cachedReceiver;

    @CalledByNative
    public RtpTransceiver(long l3) {
        this.nativeRtpTransceiver = l3;
        this.cachedSender = RtpTransceiver.nativeGetSender(l3);
        this.cachedReceiver = RtpTransceiver.nativeGetReceiver(l3);
    }

    private void checkRtpTransceiverExists() {
        if (this.nativeRtpTransceiver != 0L) {
            return;
        }
        throw new IllegalStateException("RtpTransceiver has been disposed.");
    }

    public static native MediaStreamTrack.MediaType nativeGetMediaType(long var0);

    public static native String nativeGetMid(long var0);

    public static native RtpSender nativeGetSender(long var0);

    public static native RtpReceiver nativeGetReceiver(long var0);

    public static native boolean nativeStopped(long var0);

    public static native RtpTransceiverDirection nativeDirection(long var0);

    public static native RtpTransceiverDirection nativeCurrentDirection(long var0);

    public static native void nativeStop(long var0);

    public static native void nativeSetDirection(long var0, RtpTransceiverDirection var2);

    public MediaStreamTrack.MediaType getMediaType() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        return RtpTransceiver.nativeGetMediaType(rtpTransceiver.nativeRtpTransceiver);
    }

    public String getMid() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        return RtpTransceiver.nativeGetMid(rtpTransceiver.nativeRtpTransceiver);
    }

    public RtpSender getSender() {
        return this.cachedSender;
    }

    public RtpReceiver getReceiver() {
        return this.cachedReceiver;
    }

    public boolean isStopped() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        return RtpTransceiver.nativeStopped(rtpTransceiver.nativeRtpTransceiver);
    }

    public RtpTransceiverDirection getDirection() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        return RtpTransceiver.nativeDirection(rtpTransceiver.nativeRtpTransceiver);
    }

    public RtpTransceiverDirection getCurrentDirection() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        return RtpTransceiver.nativeCurrentDirection(rtpTransceiver.nativeRtpTransceiver);
    }

    public void setDirection(RtpTransceiverDirection rtpTransceiverDirection) {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        RtpTransceiver.nativeSetDirection(rtpTransceiver.nativeRtpTransceiver, rtpTransceiverDirection);
    }

    public void stop() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        RtpTransceiver.nativeStop(rtpTransceiver.nativeRtpTransceiver);
    }

    @CalledByNative
    public void dispose() {
        RtpTransceiver rtpTransceiver = this;
        rtpTransceiver.checkRtpTransceiverExists();
        rtpTransceiver.cachedSender.dispose();
        rtpTransceiver.cachedReceiver.dispose();
        JniCommon.nativeReleaseRef(rtpTransceiver.nativeRtpTransceiver);
        rtpTransceiver.nativeRtpTransceiver = 0L;
    }

    public static final class RtpTransceiverInit {
        public final RtpTransceiverDirection direction;
        public final List<String> streamIds;
        public final List<RtpParameters.Encoding> sendEncodings;

        public RtpTransceiverInit() {
            this(RtpTransceiverDirection.SEND_RECV);
        }

        public RtpTransceiverInit(RtpTransceiverDirection rtpTransceiverDirection) {
            this(rtpTransceiverDirection, Collections.emptyList(), Collections.emptyList());
        }

        public RtpTransceiverInit(RtpTransceiverDirection rtpTransceiverDirection, List<String> list) {
            this(rtpTransceiverDirection, list, Collections.emptyList());
        }

        public RtpTransceiverInit(RtpTransceiverDirection rtpTransceiverDirection, List<String> list, List<RtpParameters.Encoding> list2) {
            RtpTransceiverInit rtpTransceiverInit = this;
            rtpTransceiverInit.direction = rtpTransceiverDirection;
            rtpTransceiverInit.streamIds = new ArrayList<String>(list);
            rtpTransceiverInit.sendEncodings = new ArrayList<RtpParameters.Encoding>(list2);
        }

        @CalledByNative(value="RtpTransceiverInit")
        public int getDirectionNativeIndex() {
            return this.direction.getNativeIndex();
        }

        @CalledByNative(value="RtpTransceiverInit")
        public List<String> getStreamIds() {
            return new ArrayList<String>(this.streamIds);
        }

        @CalledByNative(value="RtpTransceiverInit")
        public List<RtpParameters.Encoding> getSendEncodings() {
            return new ArrayList<RtpParameters.Encoding>(this.sendEncodings);
        }
    }

    public static enum RtpTransceiverDirection {
        SEND_RECV(0),
        SEND_ONLY(1),
        RECV_ONLY(2),
        INACTIVE(3);

        public final int nativeIndex;

        public RtpTransceiverDirection(int n4) {
            this.nativeIndex = n4;
        }

        @CalledByNative(value="RtpTransceiverDirection")
        public static RtpTransceiverDirection fromNativeIndex(int n3) {
            for (RtpTransceiverDirection rtpTransceiverDirection : RtpTransceiverDirection.values()) {
                if (rtpTransceiverDirection.getNativeIndex() != n3) continue;
                return rtpTransceiverDirection;
            }
            throw new IllegalArgumentException("Uknown native RtpTransceiverDirection type" + n3);
        }

        @CalledByNative(value="RtpTransceiverDirection")
        public int getNativeIndex() {
            return this.nativeIndex;
        }
    }
}

