/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import org.webrtc.CalledByNative;
import org.webrtc.DtmfSender;
import org.webrtc.FrameEncryptor;
import org.webrtc.JniCommon;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RtpParameters;

public class RtpSender {
    public long nativeRtpSender;
    @Nullable
    public MediaStreamTrack cachedTrack;
    public boolean ownsTrack = true;
    @Nullable
    public final DtmfSender dtmfSender;

    @CalledByNative
    public RtpSender(long l3) {
        DtmfSender dtmfSender;
        this.nativeRtpSender = l3;
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(RtpSender.nativeGetTrack(l3));
        l3 = RtpSender.nativeGetDtmfSender(l3);
        if (l3 != 0L) {
            DtmfSender dtmfSender2;
            dtmfSender = dtmfSender2;
            dtmfSender2 = new DtmfSender(l3);
        } else {
            dtmfSender = null;
        }
        this.dtmfSender = dtmfSender;
    }

    private void checkRtpSenderExists() {
        if (this.nativeRtpSender != 0L) {
            return;
        }
        throw new IllegalStateException("RtpSender has been disposed.");
    }

    public static native boolean nativeSetTrack(long var0, long var2);

    public static native long nativeGetTrack(long var0);

    public static native long nativeGetDtmfSender(long var0);

    public static native boolean nativeSetParameters(long var0, RtpParameters var2);

    public static native RtpParameters nativeGetParameters(long var0);

    public static native String nativeGetId(long var0);

    public static native void nativeSetFrameEncryptor(long var0, long var2);

    public boolean setTrack(@Nullable MediaStreamTrack mediaStreamTrack, boolean bl) {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        long l3 = rtpSender.nativeRtpSender;
        long l4 = mediaStreamTrack == null ? 0L : mediaStreamTrack.getNativeMediaStreamTrack();
        if (!RtpSender.nativeSetTrack(l3, l4)) {
            return false;
        }
        MediaStreamTrack mediaStreamTrack2 = this.cachedTrack;
        if (mediaStreamTrack2 != null && this.ownsTrack) {
            mediaStreamTrack2.dispose();
        }
        this.cachedTrack = mediaStreamTrack;
        this.ownsTrack = bl;
        return true;
    }

    @Nullable
    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public boolean setParameters(RtpParameters rtpParameters) {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        return RtpSender.nativeSetParameters(rtpSender.nativeRtpSender, rtpParameters);
    }

    public RtpParameters getParameters() {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        return RtpSender.nativeGetParameters(rtpSender.nativeRtpSender);
    }

    public String id() {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        return RtpSender.nativeGetId(rtpSender.nativeRtpSender);
    }

    @Nullable
    public DtmfSender dtmf() {
        return this.dtmfSender;
    }

    public void setFrameEncryptor(FrameEncryptor frameEncryptor) {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        RtpSender.nativeSetFrameEncryptor(rtpSender.nativeRtpSender, frameEncryptor.getNativeFrameEncryptor());
    }

    public void dispose() {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        Object object = rtpSender.dtmfSender;
        if (object != null) {
            ((DtmfSender)object).dispose();
        }
        if ((object = this.cachedTrack) != null && this.ownsTrack) {
            ((MediaStreamTrack)object).dispose();
        }
        JniCommon.nativeReleaseRef(this.nativeRtpSender);
        this.nativeRtpSender = 0L;
    }

    public long getNativeRtpSender() {
        RtpSender rtpSender = this;
        rtpSender.checkRtpSenderExists();
        return rtpSender.nativeRtpSender;
    }
}

