/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import org.webrtc.CalledByNative;
import org.webrtc.FrameDecryptor;
import org.webrtc.JniCommon;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RtpParameters;

public class RtpReceiver {
    public long nativeRtpReceiver;
    public long nativeObserver;
    @Nullable
    public MediaStreamTrack cachedTrack;

    @CalledByNative
    public RtpReceiver(long l3) {
        this.nativeRtpReceiver = l3;
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(RtpReceiver.nativeGetTrack(l3));
    }

    private void checkRtpReceiverExists() {
        if (this.nativeRtpReceiver != 0L) {
            return;
        }
        throw new IllegalStateException("RtpReceiver has been disposed.");
    }

    public static native long nativeGetTrack(long var0);

    public static native boolean nativeSetParameters(long var0, RtpParameters var2);

    public static native RtpParameters nativeGetParameters(long var0);

    public static native String nativeGetId(long var0);

    public static native long nativeSetObserver(long var0, Observer var2);

    public static native void nativeUnsetObserver(long var0, long var2);

    public static native void nativeSetFrameDecryptor(long var0, long var2);

    @Nullable
    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public boolean setParameters(@Nullable RtpParameters rtpParameters) {
        this.checkRtpReceiverExists();
        return rtpParameters == null ? false : RtpReceiver.nativeSetParameters(this.nativeRtpReceiver, rtpParameters);
    }

    public RtpParameters getParameters() {
        RtpReceiver rtpReceiver = this;
        rtpReceiver.checkRtpReceiverExists();
        return RtpReceiver.nativeGetParameters(rtpReceiver.nativeRtpReceiver);
    }

    public String id() {
        RtpReceiver rtpReceiver = this;
        rtpReceiver.checkRtpReceiverExists();
        return RtpReceiver.nativeGetId(rtpReceiver.nativeRtpReceiver);
    }

    @CalledByNative
    public void dispose() {
        RtpReceiver rtpReceiver = this;
        rtpReceiver.checkRtpReceiverExists();
        rtpReceiver.cachedTrack.dispose();
        long l3 = rtpReceiver.nativeObserver;
        if (l3 != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, l3);
            this.nativeObserver = 0L;
        }
        JniCommon.nativeReleaseRef(this.nativeRtpReceiver);
        this.nativeRtpReceiver = 0L;
    }

    public void SetObserver(Observer observer) {
        RtpReceiver rtpReceiver = this;
        rtpReceiver.checkRtpReceiverExists();
        long l3 = rtpReceiver.nativeObserver;
        if (l3 != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, l3);
        }
        this.nativeObserver = RtpReceiver.nativeSetObserver(this.nativeRtpReceiver, observer);
    }

    public void setFrameDecryptor(FrameDecryptor frameDecryptor) {
        RtpReceiver rtpReceiver = this;
        rtpReceiver.checkRtpReceiverExists();
        RtpReceiver.nativeSetFrameDecryptor(rtpReceiver.nativeRtpReceiver, frameDecryptor.getNativeFrameDecryptor());
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onFirstPacketReceived(MediaStreamTrack.MediaType var1);
    }
}

