/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import java.util.List;
import java.util.Map;
import org.webrtc.CalledByNative;
import org.webrtc.MediaStreamTrack;

public class RtpParameters {
    public final String transactionId;
    public final Rtcp rtcp;
    public final List<HeaderExtension> headerExtensions;
    public final List<Encoding> encodings;
    public final List<Codec> codecs;

    @CalledByNative
    public RtpParameters(String string2, Rtcp rtcp, List<HeaderExtension> list, List<Encoding> list2, List<Codec> list3) {
        this.transactionId = string2;
        this.rtcp = rtcp;
        this.headerExtensions = list;
        this.encodings = list2;
        this.codecs = list3;
    }

    @CalledByNative
    public String getTransactionId() {
        return this.transactionId;
    }

    @CalledByNative
    public Rtcp getRtcp() {
        return this.rtcp;
    }

    @CalledByNative
    public List<HeaderExtension> getHeaderExtensions() {
        return this.headerExtensions;
    }

    @CalledByNative
    public List<Encoding> getEncodings() {
        return this.encodings;
    }

    @CalledByNative
    public List<Codec> getCodecs() {
        return this.codecs;
    }

    public static class HeaderExtension {
        public final String uri;
        public final int id;
        public final boolean encrypted;

        @CalledByNative(value="HeaderExtension")
        public HeaderExtension(String string2, int n3, boolean bl) {
            this.uri = string2;
            this.id = n3;
            this.encrypted = bl;
        }

        @CalledByNative(value="HeaderExtension")
        public String getUri() {
            return this.uri;
        }

        @CalledByNative(value="HeaderExtension")
        public int getId() {
            return this.id;
        }

        @CalledByNative(value="HeaderExtension")
        public boolean getEncrypted() {
            return this.encrypted;
        }
    }

    public static class Rtcp {
        public final String cname;
        public final boolean reducedSize;

        @CalledByNative(value="Rtcp")
        public Rtcp(String string2, boolean bl) {
            this.cname = string2;
            this.reducedSize = bl;
        }

        @CalledByNative(value="Rtcp")
        public String getCname() {
            return this.cname;
        }

        @CalledByNative(value="Rtcp")
        public boolean getReducedSize() {
            return this.reducedSize;
        }
    }

    public static class Codec {
        public int payloadType;
        public String name;
        public MediaStreamTrack.MediaType kind;
        public Integer clockRate;
        public Integer numChannels;
        public Map<String, String> parameters;

        @CalledByNative(value="Codec")
        public Codec(int n3, String string2, MediaStreamTrack.MediaType mediaType, Integer n4, Integer n5, Map<String, String> map) {
            this.payloadType = n3;
            this.name = string2;
            this.kind = mediaType;
            this.clockRate = n4;
            this.numChannels = n5;
            this.parameters = map;
        }

        @CalledByNative(value="Codec")
        public int getPayloadType() {
            return this.payloadType;
        }

        @CalledByNative(value="Codec")
        public String getName() {
            return this.name;
        }

        @CalledByNative(value="Codec")
        public MediaStreamTrack.MediaType getKind() {
            return this.kind;
        }

        @CalledByNative(value="Codec")
        public Integer getClockRate() {
            return this.clockRate;
        }

        @CalledByNative(value="Codec")
        public Integer getNumChannels() {
            return this.numChannels;
        }

        @CalledByNative(value="Codec")
        public Map getParameters() {
            return this.parameters;
        }
    }

    public static class Encoding {
        @Nullable
        public String rid;
        public boolean active = true;
        @Nullable
        public Integer maxBitrateBps;
        @Nullable
        public Integer minBitrateBps;
        @Nullable
        public Integer maxFramerate;
        @Nullable
        public Integer numTemporalLayers;
        @Nullable
        public Double scaleResolutionDownBy;
        public Long ssrc;

        public Encoding(String string2, boolean bl, Double d3) {
            this.rid = string2;
            this.active = bl;
            this.scaleResolutionDownBy = d3;
        }

        @CalledByNative(value="Encoding")
        public Encoding(String string2, boolean bl, Integer n3, Integer n4, Integer n5, Integer n6, Double d3, Long l3) {
            this.rid = string2;
            this.active = bl;
            this.maxBitrateBps = n3;
            this.minBitrateBps = n4;
            this.maxFramerate = n5;
            this.numTemporalLayers = n6;
            this.scaleResolutionDownBy = d3;
            this.ssrc = l3;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        public String getRid() {
            return this.rid;
        }

        @CalledByNative(value="Encoding")
        public boolean getActive() {
            return this.active;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        public Integer getMaxBitrateBps() {
            return this.maxBitrateBps;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        public Integer getMinBitrateBps() {
            return this.minBitrateBps;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        public Integer getMaxFramerate() {
            return this.maxFramerate;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        public Integer getNumTemporalLayers() {
            return this.numTemporalLayers;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        public Double getScaleResolutionDownBy() {
            return this.scaleResolutionDownBy;
        }

        @CalledByNative(value="Encoding")
        public Long getSsrc() {
            return this.ssrc;
        }
    }
}

