/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.PeerConnection;

public class RtcCertificatePem {
    public static final long DEFAULT_EXPIRY = 2592000L;
    public final String privateKey;
    public final String certificate;

    @CalledByNative
    public RtcCertificatePem(String string2, String string3) {
        this.privateKey = string2;
        this.certificate = string3;
    }

    public static RtcCertificatePem generateCertificate() {
        return RtcCertificatePem.nativeGenerateCertificate(PeerConnection.KeyType.ECDSA, 2592000L);
    }

    public static RtcCertificatePem generateCertificate(PeerConnection.KeyType keyType) {
        return RtcCertificatePem.nativeGenerateCertificate(keyType, 2592000L);
    }

    public static RtcCertificatePem generateCertificate(long l3) {
        return RtcCertificatePem.nativeGenerateCertificate(PeerConnection.KeyType.ECDSA, l3);
    }

    public static RtcCertificatePem generateCertificate(PeerConnection.KeyType keyType, long l3) {
        return RtcCertificatePem.nativeGenerateCertificate(keyType, l3);
    }

    public static native RtcCertificatePem nativeGenerateCertificate(PeerConnection.KeyType var0, long var1);

    @CalledByNative
    public String getPrivateKey() {
        return this.privateKey;
    }

    @CalledByNative
    public String getCertificate() {
        return this.certificate;
    }
}

