/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Point;
import android.opengl.Matrix;
import android.view.View;

public class RendererCommon {
    public static float BALANCED_VISIBLE_FRACTION = 0.5625f;

    public static float[] getLayoutMatrix(boolean bl, float f3, float f4) {
        float f5 = 1.0f;
        float f6 = 1.0f;
        if (f4 > f3) {
            f6 = f3 / f4;
        } else {
            f5 = f4 / f3;
        }
        if (bl) {
            f5 *= -1.0f;
        }
        float[] fArray = new float[16];
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.scaleM((float[])fArray, (int)0, (float)f5, (float)f6, (float)1.0f);
        RendererCommon.adjustOrigin(fArray);
        return fArray;
    }

    public static android.graphics.Matrix convertMatrixToAndroidGraphicsMatrix(float[] fArray) {
        float[] fArray2 = new float[9];
        float[] fArray3 = fArray2;
        fArray3[0] = fArray[0];
        fArray3[1] = fArray[4];
        fArray3[2] = fArray[12];
        fArray3[3] = fArray[1];
        fArray3[4] = fArray[5];
        fArray3[5] = fArray[13];
        fArray3[6] = fArray[3];
        fArray3[7] = fArray[7];
        fArray2[8] = fArray[15];
        android.graphics.Matrix matrix = new android.graphics.Matrix();
        matrix.setValues(fArray3);
        return matrix;
    }

    public static float[] convertMatrixFromAndroidGraphicsMatrix(android.graphics.Matrix object) {
        float[] fArray;
        android.graphics.Matrix matrix = object;
        float[] fArray2 = new float[9];
        object = fArray2;
        matrix.getValues(fArray2);
        float[] fArray3 = new float[16];
        float[] fArray4 = fArray = fArray3;
        fArray[0] = (float)object[0];
        fArray[1] = (float)object[3];
        fArray[2] = 0.0f;
        fArray[3] = (float)object[6];
        fArray[4] = (float)object[1];
        fArray[5] = (float)object[4];
        fArray[6] = 0.0f;
        fArray4[7] = (float)object[7];
        fArray4[8] = 0.0f;
        fArray4[9] = 0.0f;
        fArray4[10] = 1.0f;
        fArray[11] = 0.0f;
        fArray[12] = (float)object[2];
        fArray[13] = (float)object[5];
        fArray[14] = 0.0f;
        fArray3[15] = (float)object[8];
        return fArray3;
    }

    public static Point getDisplaySize(ScalingType scalingType, float f3, int n3, int n4) {
        return RendererCommon.getDisplaySize(RendererCommon.convertScalingTypeToVisibleFraction(scalingType), f3, n3, n4);
    }

    public static void adjustOrigin(float[] fArray) {
        float[] fArray2 = fArray;
        fArray2[12] = fArray[12] - (fArray[0] + fArray[4]) * 0.5f;
        fArray2[13] = fArray[13] - (fArray[1] + fArray[5]) * 0.5f;
        fArray2[12] = fArray[12] + 0.5f;
        fArray2[13] = fArray[13] + 0.5f;
    }

    public static float convertScalingTypeToVisibleFraction(ScalingType scalingType) {
        int n3 = scalingType.ordinal();
        if (n3 != 0) {
            if (n3 != 1) {
                if (n3 == 2) {
                    return BALANCED_VISIBLE_FRACTION;
                }
                throw new IllegalArgumentException();
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public static Point getDisplaySize(float f3, float f4, int n3, int n4) {
        if (f3 != 0.0f && f4 != 0.0f) {
            int n5 = n3;
            n3 = Math.min(n5, Math.round((float)n4 / f3 * f4));
            int n6 = Math.min(n4, Math.round((float)n5 / f3 / f4));
            return new Point(n3, n6);
        }
        return new Point(n3, n4);
    }

    public static enum ScalingType {
        SCALE_ASPECT_FIT,
        SCALE_ASPECT_FILL,
        SCALE_ASPECT_BALANCED;

    }

    public static class VideoLayoutMeasure {
        public ScalingType scalingTypeMatchOrientation;
        public ScalingType scalingTypeMismatchOrientation;

        public VideoLayoutMeasure() {
            this.scalingTypeMismatchOrientation = this.scalingTypeMatchOrientation = ScalingType.SCALE_ASPECT_BALANCED;
        }

        public void setScalingType(ScalingType scalingType) {
            this.scalingTypeMatchOrientation = scalingType;
            this.scalingTypeMismatchOrientation = scalingType;
        }

        public void setScalingType(ScalingType scalingType, ScalingType scalingType2) {
            this.scalingTypeMatchOrientation = scalingType;
            this.scalingTypeMismatchOrientation = scalingType2;
        }

        public Point measure(int n3, int n4, int n5, int n6) {
            int n7 = View.getDefaultSize((int)Integer.MAX_VALUE, (int)n3);
            int n8 = View.getDefaultSize((int)Integer.MAX_VALUE, (int)n4);
            if (n5 != 0 && n6 != 0 && n7 != 0 && n8 != 0) {
                float f3;
                float f4 = (float)n5 / (float)n6;
                float f5 = (float)n7 / (float)n8;
                boolean bl = f3 > 1.0f;
                boolean bl2 = f5 > 1.0f;
                VideoLayoutMeasure videoLayoutMeasure = RendererCommon.getDisplaySize(bl == bl2 ? videoLayoutMeasure.scalingTypeMatchOrientation : videoLayoutMeasure.scalingTypeMismatchOrientation, f4, n7, n8);
                if (View.MeasureSpec.getMode((int)n3) == 0x40000000) {
                    ((Point)videoLayoutMeasure).x = n7;
                }
                if (View.MeasureSpec.getMode((int)n4) == 0x40000000) {
                    ((Point)videoLayoutMeasure).y = n8;
                }
                return videoLayoutMeasure;
            }
            return new Point(n7, n8);
        }
    }

    public static interface GlDrawer {
        public void drawOes(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawRgb(int var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void drawYuv(int[] var1, float[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

        public void release();
    }

    public static interface RendererEvents {
        public void onFirstFrameRendered();

        public void onFrameResolutionChanged(int var1, int var2, int var3);
    }
}

