/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import java.util.concurrent.atomic.AtomicInteger;
import org.webrtc.RefCounted;

public class RefCountDelegate
implements RefCounted {
    public final AtomicInteger refCount = new AtomicInteger(1);
    @Nullable
    public final Runnable releaseCallback;

    public RefCountDelegate(@Nullable Runnable runnable) {
        this.releaseCallback = runnable;
    }

    @Override
    public void retain() {
        if (this.refCount.incrementAndGet() >= 2) {
            return;
        }
        throw new IllegalStateException("retain() called on an object with refcount < 1");
    }

    @Override
    public void release() {
        int n3 = ((RefCountDelegate)this).refCount.decrementAndGet();
        if (n3 >= 0) {
            if (n3 == 0 && (this = ((RefCountDelegate)this).releaseCallback) != null) {
                this.run();
            }
            return;
        }
        throw new IllegalStateException("release() called on an object with refcount < 1");
    }
}

