/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.os.Process;
import android.support.annotation.Nullable;
import java.util.List;
import org.webrtc.AudioDecoderFactoryFactory;
import org.webrtc.AudioEncoderFactoryFactory;
import org.webrtc.AudioProcessingFactory;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.BuiltinAudioDecoderFactoryFactory;
import org.webrtc.BuiltinAudioEncoderFactoryFactory;
import org.webrtc.CalledByNative;
import org.webrtc.ContextUtils;
import org.webrtc.FecControllerFactoryFactoryInterface;
import org.webrtc.JNILogging;
import org.webrtc.Loggable;
import org.webrtc.Logging;
import org.webrtc.MediaCodecVideoDecoder;
import org.webrtc.MediaCodecVideoEncoder;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaTransportFactoryFactory;
import org.webrtc.NativeLibrary;
import org.webrtc.NativeLibraryLoader;
import org.webrtc.NetworkControllerFactoryFactory;
import org.webrtc.NetworkStatePredictorFactoryFactory;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionDependencies;
import org.webrtc.SSLCertificateVerifier;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;

public class PeerConnectionFactory {
    public static final String TRIAL_ENABLED = "Enabled";
    @Deprecated
    public static final String VIDEO_FRAME_EMIT_TRIAL = "VideoFrameEmit";
    public static final String TAG = "PeerConnectionFactory";
    public static final String VIDEO_CAPTURER_THREAD_NAME = "VideoCapturerThread";
    public static volatile boolean internalTracerInitialized;
    @Nullable
    public static ThreadInfo staticNetworkThread;
    @Nullable
    public static ThreadInfo staticWorkerThread;
    @Nullable
    public static ThreadInfo staticSignalingThread;
    public long nativeFactory;
    @Nullable
    public volatile ThreadInfo networkThread;
    @Nullable
    public volatile ThreadInfo workerThread;
    @Nullable
    public volatile ThreadInfo signalingThread;

    public static Builder builder() {
        return new Builder(null);
    }

    public static void initialize(InitializationOptions initializationOptions) {
        Loggable loggable;
        InitializationOptions initializationOptions2 = initializationOptions;
        ContextUtils.initialize(initializationOptions2.applicationContext);
        NativeLibrary.initialize(initializationOptions2.nativeLibraryLoader, initializationOptions.nativeLibraryName);
        PeerConnectionFactory.nativeInitializeAndroidGlobals();
        PeerConnectionFactory.nativeInitializeFieldTrials(initializationOptions2.fieldTrials);
        if (initializationOptions2.enableInternalTracer && !internalTracerInitialized) {
            PeerConnectionFactory.initializeInternalTracer();
        }
        if ((loggable = initializationOptions.loggable) != null) {
            Logging.injectLoggable(loggable, initializationOptions.loggableSeverity);
            PeerConnectionFactory.nativeInjectLoggable(new JNILogging(initializationOptions.loggable), initializationOptions.loggableSeverity.ordinal());
        } else {
            Logging.d(TAG, "PeerConnectionFactory was initialized without an injected Loggable. Any existing Loggable will be deleted.");
            Logging.deleteInjectedLoggable();
            PeerConnectionFactory.nativeDeleteLoggable();
        }
    }

    public static void checkInitializeHasBeenCalled() {
        if (NativeLibrary.isLoaded() && ContextUtils.getApplicationContext() != null) {
            return;
        }
        throw new IllegalStateException("PeerConnectionFactory.initialize was not called before creating a PeerConnectionFactory.");
    }

    public static void initializeInternalTracer() {
        internalTracerInitialized = true;
        PeerConnectionFactory.nativeInitializeInternalTracer();
    }

    public static void shutdownInternalTracer() {
        internalTracerInitialized = false;
        PeerConnectionFactory.nativeShutdownInternalTracer();
    }

    @Deprecated
    public static void initializeFieldTrials(String string2) {
        PeerConnectionFactory.nativeInitializeFieldTrials(string2);
    }

    public static String fieldTrialsFindFullName(String string2) {
        return NativeLibrary.isLoaded() ? PeerConnectionFactory.nativeFindFieldTrialsFullName(string2) : "";
    }

    public static boolean startInternalTracingCapture(String string2) {
        return PeerConnectionFactory.nativeStartInternalTracingCapture(string2);
    }

    public static void stopInternalTracingCapture() {
        PeerConnectionFactory.nativeStopInternalTracingCapture();
    }

    @CalledByNative
    public PeerConnectionFactory(long l3) {
        PeerConnectionFactory.checkInitializeHasBeenCalled();
        if (l3 != 0L) {
            this.nativeFactory = l3;
            return;
        }
        throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
    }

    public static void enableSendRtcp(boolean bl) {
        PeerConnectionFactory.nativeEnableSendRtcp(bl);
    }

    public static void enableSelfVoiceAec(boolean bl) {
        PeerConnectionFactory.nativeEnableSelfVoiceAec(bl);
    }

    private void checkPeerConnectionFactoryExists() {
        if (this.nativeFactory != 0L) {
            return;
        }
        throw new IllegalStateException("PeerConnectionFactory has been disposed.");
    }

    public static void printStackTrace(@Nullable ThreadInfo threadInfo, boolean bl) {
        if (threadInfo == null) {
            return;
        }
        ThreadInfo threadInfo2 = threadInfo;
        String string2 = threadInfo2.thread.getName();
        StackTraceElement[] stackTraceElementArray = threadInfo2.thread.getStackTrace();
        if (stackTraceElementArray.length > 0) {
            Logging.w(TAG, string2 + " stacktrace:");
            int n3 = stackTraceElementArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Logging.w(TAG, stackTraceElementArray[i3].toString());
            }
        }
        if (bl) {
            Logging.w(TAG, "*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***");
            Logging.w(TAG, "pid: " + Process.myPid() + ", tid: " + threadInfo.tid + ", name: " + string2 + "  >>> WebRTC <<<");
            PeerConnectionFactory.nativePrintStackTrace(threadInfo.tid);
        }
    }

    @Deprecated
    public static void printStackTraces() {
        PeerConnectionFactory.printStackTrace(staticNetworkThread, false);
        PeerConnectionFactory.printStackTrace(staticWorkerThread, false);
        PeerConnectionFactory.printStackTrace(staticSignalingThread, false);
    }

    @CalledByNative
    private void onNetworkThreadReady() {
        staticNetworkThread = this.networkThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onNetworkThreadReady");
    }

    @CalledByNative
    private void onWorkerThreadReady() {
        staticWorkerThread = this.workerThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onWorkerThreadReady");
    }

    @CalledByNative
    private void onSignalingThreadReady() {
        staticSignalingThread = this.signalingThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onSignalingThreadReady");
    }

    public static native void nativeInitializeAndroidGlobals();

    public static native void nativeInitializeFieldTrials(String var0);

    public static native String nativeFindFieldTrialsFullName(String var0);

    public static native void nativeInitializeInternalTracer();

    public static native void nativeShutdownInternalTracer();

    public static native boolean nativeStartInternalTracingCapture(String var0);

    public static native void nativeStopInternalTracingCapture();

    public static native PeerConnectionFactory nativeCreatePeerConnectionFactory(Context var0, Options var1, long var2, long var4, long var6, VideoEncoderFactory var8, VideoDecoderFactory var9, long var10, long var12, long var14, long var16, long var18);

    public static native long nativeCreatePeerConnection(long var0, PeerConnection.RTCConfiguration var2, MediaConstraints var3, long var4, SSLCertificateVerifier var6);

    public static native long nativeCreateLocalMediaStream(long var0, String var2);

    public static native long nativeCreateVideoSource(long var0, boolean var2, boolean var3);

    public static native long nativeCreateVideoTrack(long var0, String var2, long var3);

    public static native long nativeCreateAudioSource(long var0, MediaConstraints var2);

    public static native long nativeCreateAudioTrack(long var0, String var2, long var3);

    public static native boolean nativeStartAecDump(long var0, int var2, int var3);

    public static native void nativeStopAecDump(long var0);

    public static native void nativeFreeFactory(long var0);

    public static native long nativeGetNativePeerConnectionFactory(long var0);

    public static native void nativeInjectLoggable(JNILogging var0, int var1);

    public static native void nativeDeleteLoggable();

    public static native void nativePrintStackTrace(int var0);

    public static native void nativePrintStackTracesOfRegisteredThreads();

    public static native void nativeEnableSendRtcp(boolean var0);

    public static native void nativeEnableSelfVoiceAec(boolean var0);

    public static native void nativeSetVoiceRecordCallback(VoiceRecordCallback var0);

    public static void SetVoiceRecordCallback(VoiceRecordCallback voiceRecordCallback) {
        PeerConnectionFactory.nativeSetVoiceRecordCallback(voiceRecordCallback);
    }

    @Nullable
    public PeerConnection createPeerConnectionInternal(PeerConnection.RTCConfiguration rTCConfiguration, MediaConstraints mediaConstraints, PeerConnection.Observer observer, SSLCertificateVerifier sSLCertificateVerifier) {
        this.checkPeerConnectionFactoryExists();
        long l3 = PeerConnection.createNativePeerConnectionObserver(observer);
        if (l3 == 0L) {
            return null;
        }
        long l4 = PeerConnectionFactory.nativeCreatePeerConnection(this.nativeFactory, rTCConfiguration, mediaConstraints, l3, sSLCertificateVerifier);
        if (l4 == 0L) {
            return null;
        }
        return new PeerConnection(l4);
    }

    @Deprecated
    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        return this.createPeerConnectionInternal(rTCConfiguration, mediaConstraints, observer, null);
    }

    @Deprecated
    @Nullable
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> list, MediaConstraints mediaConstraints, PeerConnection.Observer observer) {
        PeerConnection.RTCConfiguration rTCConfiguration;
        PeerConnectionFactory peerConnectionFactory = rTCConfiguration2;
        PeerConnection.RTCConfiguration rTCConfiguration2 = rTCConfiguration;
        rTCConfiguration2(list);
        return peerConnectionFactory.createPeerConnection(rTCConfiguration, mediaConstraints, observer);
    }

    @Nullable
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> list, PeerConnection.Observer observer) {
        return this.createPeerConnection(new PeerConnection.RTCConfiguration(list), observer);
    }

    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rTCConfiguration, PeerConnection.Observer observer) {
        return this.createPeerConnection(rTCConfiguration, null, observer);
    }

    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration object, PeerConnectionDependencies peerConnectionDependencies) {
        PeerConnectionFactory peerConnectionFactory = observer;
        PeerConnection.RTCConfiguration rTCConfiguration = object;
        PeerConnectionDependencies peerConnectionDependencies2 = peerConnectionDependencies;
        PeerConnection.Observer observer = peerConnectionDependencies2.getObserver();
        object = peerConnectionDependencies2.getSSLCertificateVerifier();
        return peerConnectionFactory.createPeerConnectionInternal(rTCConfiguration, null, observer, (SSLCertificateVerifier)object);
    }

    public MediaStream createLocalMediaStream(String string2) {
        this.checkPeerConnectionFactoryExists();
        return new MediaStream(PeerConnectionFactory.nativeCreateLocalMediaStream(this.nativeFactory, string2));
    }

    public VideoSource createVideoSource(boolean bl, boolean bl2) {
        this.checkPeerConnectionFactoryExists();
        return new VideoSource(PeerConnectionFactory.nativeCreateVideoSource(this.nativeFactory, bl, bl2));
    }

    public VideoSource createVideoSource(boolean bl) {
        return this.createVideoSource(bl, true);
    }

    public VideoTrack createVideoTrack(String string2, VideoSource videoSource) {
        this.checkPeerConnectionFactoryExists();
        return new VideoTrack(PeerConnectionFactory.nativeCreateVideoTrack(this.nativeFactory, string2, videoSource.getNativeVideoTrackSource()));
    }

    public AudioSource createAudioSource(MediaConstraints mediaConstraints) {
        this.checkPeerConnectionFactoryExists();
        return new AudioSource(PeerConnectionFactory.nativeCreateAudioSource(this.nativeFactory, mediaConstraints));
    }

    public AudioTrack createAudioTrack(String string2, AudioSource audioSource) {
        this.checkPeerConnectionFactoryExists();
        return new AudioTrack(PeerConnectionFactory.nativeCreateAudioTrack(this.nativeFactory, string2, audioSource.getNativeAudioSource()));
    }

    public boolean startAecDump(int n3, int n4) {
        PeerConnectionFactory peerConnectionFactory = this;
        peerConnectionFactory.checkPeerConnectionFactoryExists();
        return PeerConnectionFactory.nativeStartAecDump(peerConnectionFactory.nativeFactory, n3, n4);
    }

    public void stopAecDump() {
        PeerConnectionFactory peerConnectionFactory = this;
        peerConnectionFactory.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeStopAecDump(peerConnectionFactory.nativeFactory);
    }

    public void dispose() {
        PeerConnectionFactory peerConnectionFactory = this;
        peerConnectionFactory.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeFreeFactory(peerConnectionFactory.nativeFactory);
        peerConnectionFactory.networkThread = null;
        peerConnectionFactory.workerThread = null;
        peerConnectionFactory.signalingThread = null;
        MediaCodecVideoEncoder.disposeEglContext();
        MediaCodecVideoDecoder.disposeEglContext();
        peerConnectionFactory.nativeFactory = 0L;
    }

    public long getNativePeerConnectionFactory() {
        PeerConnectionFactory peerConnectionFactory = this;
        peerConnectionFactory.checkPeerConnectionFactoryExists();
        return PeerConnectionFactory.nativeGetNativePeerConnectionFactory(peerConnectionFactory.nativeFactory);
    }

    public long getNativeOwnedFactoryAndThreads() {
        PeerConnectionFactory peerConnectionFactory = this;
        peerConnectionFactory.checkPeerConnectionFactoryExists();
        return peerConnectionFactory.nativeFactory;
    }

    public void printInternalStackTraces(boolean bl) {
        PeerConnectionFactory peerConnectionFactory = this;
        PeerConnectionFactory.printStackTrace(peerConnectionFactory.signalingThread, bl);
        PeerConnectionFactory.printStackTrace(peerConnectionFactory.workerThread, bl);
        PeerConnectionFactory.printStackTrace(peerConnectionFactory.networkThread, bl);
        if (bl) {
            PeerConnectionFactory.nativePrintStackTracesOfRegisteredThreads();
        }
    }

    public static interface VoiceRecordCallback {
        public void onRecordVoice(int var1, byte[] var2, int var3, int var4);
    }

    public static class Builder {
        @Nullable
        public Options options;
        @Nullable
        public AudioDeviceModule audioDeviceModule;
        public AudioEncoderFactoryFactory audioEncoderFactoryFactory = new BuiltinAudioEncoderFactoryFactory();
        public AudioDecoderFactoryFactory audioDecoderFactoryFactory = new BuiltinAudioDecoderFactoryFactory();
        @Nullable
        public VideoEncoderFactory videoEncoderFactory;
        @Nullable
        public VideoDecoderFactory videoDecoderFactory;
        @Nullable
        public AudioProcessingFactory audioProcessingFactory;
        @Nullable
        public FecControllerFactoryFactoryInterface fecControllerFactoryFactory;
        @Nullable
        public NetworkControllerFactoryFactory networkControllerFactoryFactory;
        @Nullable
        public NetworkStatePredictorFactoryFactory networkStatePredictorFactoryFactory;
        @Nullable
        public MediaTransportFactoryFactory mediaTransportFactoryFactory;

        public Builder() {
        }

        public /* synthetic */ Builder(1 var1_1) {
            this();
        }

        public Builder setOptions(Options options) {
            this.options = options;
            return this;
        }

        public Builder setAudioDeviceModule(AudioDeviceModule audioDeviceModule) {
            this.audioDeviceModule = audioDeviceModule;
            return this;
        }

        public Builder setAudioEncoderFactoryFactory(AudioEncoderFactoryFactory audioEncoderFactoryFactory) {
            if (audioEncoderFactoryFactory != null) {
                this.audioEncoderFactoryFactory = audioEncoderFactoryFactory;
                return this;
            }
            throw new IllegalArgumentException("PeerConnectionFactory.Builder does not accept a null AudioEncoderFactoryFactory.");
        }

        public Builder setAudioDecoderFactoryFactory(AudioDecoderFactoryFactory audioDecoderFactoryFactory) {
            if (audioDecoderFactoryFactory != null) {
                this.audioDecoderFactoryFactory = audioDecoderFactoryFactory;
                return this;
            }
            throw new IllegalArgumentException("PeerConnectionFactory.Builder does not accept a null AudioDecoderFactoryFactory.");
        }

        public Builder setVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
            this.videoEncoderFactory = videoEncoderFactory;
            return this;
        }

        public Builder setVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
            this.videoDecoderFactory = videoDecoderFactory;
            return this;
        }

        public Builder setAudioProcessingFactory(AudioProcessingFactory audioProcessingFactory) {
            if (audioProcessingFactory != null) {
                this.audioProcessingFactory = audioProcessingFactory;
                return this;
            }
            throw new NullPointerException("PeerConnectionFactory builder does not accept a null AudioProcessingFactory.");
        }

        public Builder setFecControllerFactoryFactoryInterface(FecControllerFactoryFactoryInterface fecControllerFactoryFactoryInterface) {
            this.fecControllerFactoryFactory = fecControllerFactoryFactoryInterface;
            return this;
        }

        public Builder setNetworkControllerFactoryFactory(NetworkControllerFactoryFactory networkControllerFactoryFactory) {
            this.networkControllerFactoryFactory = networkControllerFactoryFactory;
            return this;
        }

        public Builder setNetworkStatePredictorFactoryFactory(NetworkStatePredictorFactoryFactory networkStatePredictorFactoryFactory) {
            this.networkStatePredictorFactoryFactory = networkStatePredictorFactoryFactory;
            return this;
        }

        public Builder setMediaTransportFactoryFactory(MediaTransportFactoryFactory mediaTransportFactoryFactory) {
            this.mediaTransportFactoryFactory = mediaTransportFactoryFactory;
            return this;
        }

        public PeerConnectionFactory createPeerConnectionFactory() {
            PeerConnectionFactory.checkInitializeHasBeenCalled();
            if (((Builder)((Object)mediaTransportFactoryFactory)).audioDeviceModule == null) {
                ((Builder)((Object)mediaTransportFactoryFactory)).audioDeviceModule = JavaAudioDeviceModule.builder(ContextUtils.getApplicationContext()).createAudioDeviceModule();
            }
            Builder builder = mediaTransportFactoryFactory;
            Context context = ContextUtils.getApplicationContext();
            Options options = builder.options;
            long l3 = builder.audioDeviceModule.getNativeAudioDeviceModulePointer();
            long l4 = builder.audioEncoderFactoryFactory.createNativeAudioEncoderFactory();
            long l5 = builder.audioDecoderFactoryFactory.createNativeAudioDecoderFactory();
            VideoEncoderFactory videoEncoderFactory = builder.videoEncoderFactory;
            VideoDecoderFactory videoDecoderFactory = builder.videoDecoderFactory;
            AudioProcessingFactory audioProcessingFactory = builder.audioProcessingFactory;
            long l6 = audioProcessingFactory == null ? 0L : audioProcessingFactory.createNative();
            FecControllerFactoryFactoryInterface fecControllerFactoryFactoryInterface = ((Builder)((Object)mediaTransportFactoryFactory)).fecControllerFactoryFactory;
            long l7 = fecControllerFactoryFactoryInterface == null ? 0L : fecControllerFactoryFactoryInterface.createNative();
            NetworkControllerFactoryFactory networkControllerFactoryFactory = ((Builder)((Object)mediaTransportFactoryFactory)).networkControllerFactoryFactory;
            long l8 = networkControllerFactoryFactory == null ? 0L : networkControllerFactoryFactory.createNativeNetworkControllerFactory();
            NetworkStatePredictorFactoryFactory networkStatePredictorFactoryFactory = ((Builder)((Object)mediaTransportFactoryFactory)).networkStatePredictorFactoryFactory;
            long l9 = networkStatePredictorFactoryFactory == null ? 0L : networkStatePredictorFactoryFactory.createNativeNetworkStatePredictorFactory();
            MediaTransportFactoryFactory mediaTransportFactoryFactory = ((Builder)((Object)mediaTransportFactoryFactory)).mediaTransportFactoryFactory;
            long l10 = mediaTransportFactoryFactory == null ? 0L : mediaTransportFactoryFactory.createNativeMediaTransportFactory();
            return PeerConnectionFactory.nativeCreatePeerConnectionFactory(context, options, l3, l4, l5, videoEncoderFactory, videoDecoderFactory, l6, l7, l8, l9, l10);
        }
    }

    public static class Options {
        public static final int ADAPTER_TYPE_UNKNOWN = 0;
        public static final int ADAPTER_TYPE_ETHERNET = 1;
        public static final int ADAPTER_TYPE_WIFI = 2;
        public static final int ADAPTER_TYPE_CELLULAR = 4;
        public static final int ADAPTER_TYPE_VPN = 8;
        public static final int ADAPTER_TYPE_LOOPBACK = 16;
        public static final int ADAPTER_TYPE_ANY = 32;
        public int networkIgnoreMask;
        public boolean disableEncryption;
        public boolean disableNetworkMonitor;

        @CalledByNative(value="Options")
        public int getNetworkIgnoreMask() {
            return this.networkIgnoreMask;
        }

        @CalledByNative(value="Options")
        public boolean getDisableEncryption() {
            return this.disableEncryption;
        }

        @CalledByNative(value="Options")
        public boolean getDisableNetworkMonitor() {
            return this.disableNetworkMonitor;
        }
    }

    public static class InitializationOptions {
        public final Context applicationContext;
        public final String fieldTrials;
        public final boolean enableInternalTracer;
        public final NativeLibraryLoader nativeLibraryLoader;
        public final String nativeLibraryName;
        @Nullable
        public Loggable loggable;
        @Nullable
        public Logging.Severity loggableSeverity;

        public InitializationOptions(Context context, String string2, boolean bl, NativeLibraryLoader nativeLibraryLoader, String string3, @Nullable Loggable loggable, @Nullable Logging.Severity severity) {
            this.applicationContext = context;
            this.fieldTrials = string2;
            this.enableInternalTracer = bl;
            this.nativeLibraryLoader = nativeLibraryLoader;
            this.nativeLibraryName = string3;
            this.loggable = loggable;
            this.loggableSeverity = severity;
        }

        public static Builder builder(Context context) {
            return new Builder(context);
        }

        public /* synthetic */ InitializationOptions(Context context, String string2, boolean bl, NativeLibraryLoader nativeLibraryLoader, String string3, Loggable loggable, Logging.Severity severity, 1 var8_8) {
            this(context, string2, bl, nativeLibraryLoader, string3, loggable, severity);
        }

        public static class Builder {
            public final Context applicationContext;
            public String fieldTrials = "";
            public boolean enableInternalTracer;
            public NativeLibraryLoader nativeLibraryLoader = new NativeLibrary.DefaultLoader();
            public String nativeLibraryName = "jingle_peerconnection_so";
            @Nullable
            public Loggable loggable;
            @Nullable
            public Logging.Severity loggableSeverity;

            public Builder(Context context) {
                this.applicationContext = context;
            }

            public Builder setFieldTrials(String string2) {
                this.fieldTrials = string2;
                return this;
            }

            public Builder setEnableInternalTracer(boolean bl) {
                this.enableInternalTracer = bl;
                return this;
            }

            public Builder setNativeLibraryLoader(NativeLibraryLoader nativeLibraryLoader) {
                this.nativeLibraryLoader = nativeLibraryLoader;
                return this;
            }

            public Builder setNativeLibraryName(String string2) {
                this.nativeLibraryName = string2;
                return this;
            }

            public Builder setInjectableLogger(Loggable loggable, Logging.Severity severity) {
                this.loggable = loggable;
                this.loggableSeverity = severity;
                return this;
            }

            public InitializationOptions createInitializationOptions() {
                return new InitializationOptions(this.applicationContext, this.fieldTrials, this.enableInternalTracer, this.nativeLibraryLoader, this.nativeLibraryName, this.loggable, this.loggableSeverity, null);
            }
        }
    }

    public static class ThreadInfo {
        public final Thread thread;
        public final int tid;

        public static ThreadInfo getCurrent() {
            return new ThreadInfo(Thread.currentThread(), Process.myTid());
        }

        public ThreadInfo(Thread thread, int n3) {
            this.thread = thread;
            this.tid = n3;
        }
    }
}

