/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.webrtc.CalledByNative;
import org.webrtc.CryptoOptions;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.NativePeerConnectionFactory;
import org.webrtc.RTCStatsCollectorCallback;
import org.webrtc.RtcCertificatePem;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.RtpTransceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.StatsObserver;
import org.webrtc.TurnCustomizer;

public class PeerConnection {
    public final List<MediaStream> localStreams = new ArrayList<MediaStream>();
    public final long nativePeerConnection;
    public List<RtpSender> senders = new ArrayList<RtpSender>();
    public List<RtpReceiver> receivers = new ArrayList<RtpReceiver>();
    public List<RtpTransceiver> transceivers = new ArrayList<RtpTransceiver>();

    public PeerConnection(NativePeerConnectionFactory nativePeerConnectionFactory) {
        this(nativePeerConnectionFactory.createNativePeerConnection());
    }

    public PeerConnection(long l3) {
        this.nativePeerConnection = l3;
    }

    public static long createNativePeerConnectionObserver(Observer observer) {
        return PeerConnection.nativeCreatePeerConnectionObserver(observer);
    }

    private native long nativeGetNativePeerConnection();

    private native SessionDescription nativeGetLocalDescription();

    private native SessionDescription nativeGetRemoteDescription();

    private native RtcCertificatePem nativeGetCertificate();

    private native DataChannel nativeCreateDataChannel(String var1, DataChannel.Init var2);

    private native void nativeCreateOffer(SdpObserver var1, MediaConstraints var2);

    private native void nativeCreateAnswer(SdpObserver var1, MediaConstraints var2);

    private native void nativeSetLocalDescription(SdpObserver var1, SessionDescription var2);

    private native void nativeSetRemoteDescription(SdpObserver var1, SessionDescription var2);

    private native void nativeSetAudioPlayout(boolean var1);

    private native void nativeSetAudioRecording(boolean var1);

    private native boolean nativeSetBitrate(Integer var1, Integer var2, Integer var3);

    private native SignalingState nativeSignalingState();

    private native IceConnectionState nativeIceConnectionState();

    private native PeerConnectionState nativeConnectionState();

    private native IceGatheringState nativeIceGatheringState();

    private native void nativeClose();

    public static native long nativeCreatePeerConnectionObserver(Observer var0);

    public static native void nativeFreeOwnedPeerConnection(long var0);

    private native boolean nativeSetConfiguration(RTCConfiguration var1);

    private native boolean nativeAddIceCandidate(String var1, int var2, String var3);

    private native boolean nativeRemoveIceCandidates(IceCandidate[] var1);

    private native boolean nativeAddLocalStream(long var1);

    private native void nativeRemoveLocalStream(long var1);

    private native boolean nativeOldGetStats(StatsObserver var1, long var2);

    private native void nativeNewGetStats(RTCStatsCollectorCallback var1);

    private native RtpSender nativeCreateSender(String var1, String var2);

    private native List<RtpSender> nativeGetSenders();

    private native List<RtpReceiver> nativeGetReceivers();

    private native List<RtpTransceiver> nativeGetTransceivers();

    private native RtpSender nativeAddTrack(long var1, List<String> var3);

    private native boolean nativeRemoveTrack(long var1);

    private native RtpTransceiver nativeAddTransceiverWithTrack(long var1, RtpTransceiver.RtpTransceiverInit var3);

    private native RtpTransceiver nativeAddTransceiverOfType(MediaStreamTrack.MediaType var1, RtpTransceiver.RtpTransceiverInit var2);

    private native boolean nativeStartRtcEventLog(int var1, int var2);

    private native void nativeStopRtcEventLog();

    public SessionDescription getLocalDescription() {
        return this.nativeGetLocalDescription();
    }

    public SessionDescription getRemoteDescription() {
        return this.nativeGetRemoteDescription();
    }

    public RtcCertificatePem getCertificate() {
        return this.nativeGetCertificate();
    }

    public DataChannel createDataChannel(String string2, DataChannel.Init init) {
        return this.nativeCreateDataChannel(string2, init);
    }

    public void createOffer(SdpObserver sdpObserver, MediaConstraints mediaConstraints) {
        this.nativeCreateOffer(sdpObserver, mediaConstraints);
    }

    public void createAnswer(SdpObserver sdpObserver, MediaConstraints mediaConstraints) {
        this.nativeCreateAnswer(sdpObserver, mediaConstraints);
    }

    public void setLocalDescription(SdpObserver sdpObserver, SessionDescription sessionDescription) {
        this.nativeSetLocalDescription(sdpObserver, sessionDescription);
    }

    public void setRemoteDescription(SdpObserver sdpObserver, SessionDescription sessionDescription) {
        this.nativeSetRemoteDescription(sdpObserver, sessionDescription);
    }

    public void setAudioPlayout(boolean bl) {
        this.nativeSetAudioPlayout(bl);
    }

    public void setAudioRecording(boolean bl) {
        this.nativeSetAudioRecording(bl);
    }

    public boolean setConfiguration(RTCConfiguration rTCConfiguration) {
        return this.nativeSetConfiguration(rTCConfiguration);
    }

    public boolean addIceCandidate(IceCandidate iceCandidate) {
        return this.nativeAddIceCandidate(iceCandidate.sdpMid, iceCandidate.sdpMLineIndex, iceCandidate.sdp);
    }

    public boolean removeIceCandidates(IceCandidate[] iceCandidateArray) {
        return this.nativeRemoveIceCandidates(iceCandidateArray);
    }

    public boolean addStream(MediaStream mediaStream) {
        if (!this.nativeAddLocalStream(mediaStream.getNativeMediaStream())) {
            return false;
        }
        this.localStreams.add(mediaStream);
        return true;
    }

    public void removeStream(MediaStream mediaStream) {
        PeerConnection peerConnection = this;
        peerConnection.nativeRemoveLocalStream(mediaStream.getNativeMediaStream());
        peerConnection.localStreams.remove(mediaStream);
    }

    public RtpSender createSender(String object, String string2) {
        if ((object = this.nativeCreateSender((String)object, string2)) != null) {
            this.senders.add((RtpSender)object);
        }
        return object;
    }

    public List<RtpSender> getSenders() {
        Iterator<RtpSender> iterator = this.senders.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        PeerConnection peerConnection = this;
        peerConnection.senders = peerConnection.nativeGetSenders();
        return Collections.unmodifiableList(peerConnection.senders);
    }

    public List<RtpReceiver> getReceivers() {
        Iterator<RtpReceiver> iterator = this.receivers.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        PeerConnection peerConnection = this;
        peerConnection.receivers = peerConnection.nativeGetReceivers();
        return Collections.unmodifiableList(peerConnection.receivers);
    }

    public List<RtpTransceiver> getTransceivers() {
        Iterator<RtpTransceiver> iterator = this.transceivers.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        PeerConnection peerConnection = this;
        peerConnection.transceivers = peerConnection.nativeGetTransceivers();
        return Collections.unmodifiableList(peerConnection.transceivers);
    }

    public RtpSender addTrack(MediaStreamTrack mediaStreamTrack) {
        return this.addTrack(mediaStreamTrack, Collections.emptyList());
    }

    public RtpSender addTrack(MediaStreamTrack object, List<String> list) {
        if (object != null && list != null) {
            if ((object = this.nativeAddTrack(((MediaStreamTrack)object).getNativeMediaStreamTrack(), list)) != null) {
                this.senders.add((RtpSender)object);
                return object;
            }
            throw new IllegalStateException("C++ addTrack failed.");
        }
        throw new NullPointerException("No MediaStreamTrack specified in addTrack.");
    }

    public boolean removeTrack(RtpSender rtpSender) {
        if (rtpSender != null) {
            return this.nativeRemoveTrack(rtpSender.getNativeRtpSender());
        }
        throw new NullPointerException("No RtpSender specified for removeTrack.");
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack mediaStreamTrack) {
        return this.addTransceiver(mediaStreamTrack, new RtpTransceiver.RtpTransceiverInit());
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack object, @Nullable RtpTransceiver.RtpTransceiverInit rtpTransceiverInit) {
        if (object != null) {
            if (rtpTransceiverInit == null) {
                RtpTransceiver.RtpTransceiverInit rtpTransceiverInit2;
                rtpTransceiverInit = rtpTransceiverInit2;
                rtpTransceiverInit2 = new RtpTransceiver.RtpTransceiverInit();
            }
            if ((object = this.nativeAddTransceiverWithTrack(((MediaStreamTrack)object).getNativeMediaStreamTrack(), rtpTransceiverInit)) != null) {
                this.transceivers.add((RtpTransceiver)object);
                return object;
            }
            throw new IllegalStateException("C++ addTransceiver failed.");
        }
        throw new NullPointerException("No MediaStreamTrack specified for addTransceiver.");
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack.MediaType mediaType) {
        return this.addTransceiver(mediaType, new RtpTransceiver.RtpTransceiverInit());
    }

    public RtpTransceiver addTransceiver(MediaStreamTrack.MediaType object, @Nullable RtpTransceiver.RtpTransceiverInit rtpTransceiverInit) {
        if (object != null) {
            if (rtpTransceiverInit == null) {
                RtpTransceiver.RtpTransceiverInit rtpTransceiverInit2;
                rtpTransceiverInit = rtpTransceiverInit2;
                rtpTransceiverInit2 = new RtpTransceiver.RtpTransceiverInit();
            }
            if ((object = this.nativeAddTransceiverOfType((MediaStreamTrack.MediaType)((Object)object), rtpTransceiverInit)) != null) {
                this.transceivers.add((RtpTransceiver)object);
                return object;
            }
            throw new IllegalStateException("C++ addTransceiver failed.");
        }
        throw new NullPointerException("No MediaType specified for addTransceiver.");
    }

    @Deprecated
    public boolean getStats(StatsObserver statsObserver, @Nullable MediaStreamTrack mediaStreamTrack) {
        long l3 = mediaStreamTrack == null ? 0L : mediaStreamTrack.getNativeMediaStreamTrack();
        return this.nativeOldGetStats(statsObserver, l3);
    }

    public void getStats(RTCStatsCollectorCallback rTCStatsCollectorCallback) {
        this.nativeNewGetStats(rTCStatsCollectorCallback);
    }

    public boolean setBitrate(Integer n3, Integer n4, Integer n5) {
        return this.nativeSetBitrate(n3, n4, n5);
    }

    public boolean startRtcEventLog(int n3, int n4) {
        return this.nativeStartRtcEventLog(n3, n4);
    }

    public void stopRtcEventLog() {
        this.nativeStopRtcEventLog();
    }

    public SignalingState signalingState() {
        return this.nativeSignalingState();
    }

    public IceConnectionState iceConnectionState() {
        return this.nativeIceConnectionState();
    }

    public PeerConnectionState connectionState() {
        return this.nativeConnectionState();
    }

    public IceGatheringState iceGatheringState() {
        return this.nativeIceGatheringState();
    }

    public void close() {
        this.nativeClose();
    }

    public void dispose() {
        PeerConnection peerConnection = this;
        peerConnection.close();
        for (MediaStream mediaStream : peerConnection.localStreams) {
            this.nativeRemoveLocalStream(mediaStream.getNativeMediaStream());
            mediaStream.dispose();
        }
        PeerConnection peerConnection2 = this;
        peerConnection2.localStreams.clear();
        Iterator<Object> iterator = peerConnection2.senders.iterator();
        while (iterator.hasNext()) {
            ((RtpSender)iterator.next()).dispose();
        }
        PeerConnection peerConnection3 = this;
        peerConnection3.senders.clear();
        iterator = peerConnection3.receivers.iterator();
        while (iterator.hasNext()) {
            ((RtpReceiver)iterator.next()).dispose();
        }
        iterator = this.transceivers.iterator();
        while (iterator.hasNext()) {
            ((RtpTransceiver)iterator.next()).dispose();
        }
        PeerConnection peerConnection4 = this;
        peerConnection4.transceivers.clear();
        peerConnection4.receivers.clear();
        PeerConnection.nativeFreeOwnedPeerConnection(peerConnection4.nativePeerConnection);
    }

    public long getNativePeerConnection() {
        return this.nativeGetNativePeerConnection();
    }

    @CalledByNative
    public long getNativeOwnedPeerConnection() {
        return this.nativePeerConnection;
    }

    public static class RTCConfiguration {
        public IceTransportsType iceTransportsType;
        public List<IceServer> iceServers;
        public BundlePolicy bundlePolicy;
        @Nullable
        public RtcCertificatePem certificate;
        public RtcpMuxPolicy rtcpMuxPolicy;
        public TcpCandidatePolicy tcpCandidatePolicy;
        public CandidateNetworkPolicy candidateNetworkPolicy;
        public int audioJitterBufferMaxPackets;
        public boolean audioJitterBufferFastAccelerate;
        public int iceConnectionReceivingTimeout;
        public int iceBackupCandidatePairPingInterval;
        public KeyType keyType;
        public ContinualGatheringPolicy continualGatheringPolicy;
        public int iceCandidatePoolSize;
        public boolean pruneTurnPorts;
        public boolean presumeWritableWhenFullyRelayed;
        public boolean surfaceIceCandidatesOnIceTransportTypeChanged;
        @Nullable
        public Integer iceCheckIntervalStrongConnectivityMs;
        @Nullable
        public Integer iceCheckIntervalWeakConnectivityMs;
        @Nullable
        public Integer iceCheckMinInterval;
        @Nullable
        public Integer iceUnwritableTimeMs;
        @Nullable
        public Integer iceUnwritableMinChecks;
        @Nullable
        public Integer stunCandidateKeepaliveIntervalMs;
        public boolean disableIPv6OnWifi;
        public int maxIPv6Networks;
        @Nullable
        public IntervalRange iceRegatherIntervalRange;
        public boolean disableIpv6;
        public boolean enableDscp;
        public boolean enableCpuOveruseDetection;
        public boolean enableRtpDataChannel;
        public boolean suspendBelowMinBitrate;
        @Nullable
        public Integer screencastMinBitrate;
        @Nullable
        public Boolean combinedAudioVideoBwe;
        @Nullable
        public Boolean enableDtlsSrtp;
        public AdapterType networkPreference;
        public SdpSemantics sdpSemantics;
        @Nullable
        public TurnCustomizer turnCustomizer;
        public boolean activeResetSrtpParams;
        public boolean useMediaTransport;
        public boolean useMediaTransportForDataChannels;
        @Nullable
        public CryptoOptions cryptoOptions;

        public RTCConfiguration(List<IceServer> list) {
            RTCConfiguration rTCConfiguration = this;
            this.iceTransportsType = IceTransportsType.ALL;
            this.bundlePolicy = BundlePolicy.BALANCED;
            this.rtcpMuxPolicy = RtcpMuxPolicy.REQUIRE;
            this.tcpCandidatePolicy = TcpCandidatePolicy.ENABLED;
            this.candidateNetworkPolicy = CandidateNetworkPolicy.ALL;
            rTCConfiguration.iceServers = list;
            rTCConfiguration.audioJitterBufferMaxPackets = 50;
            rTCConfiguration.audioJitterBufferFastAccelerate = false;
            rTCConfiguration.iceConnectionReceivingTimeout = -1;
            rTCConfiguration.iceBackupCandidatePairPingInterval = -1;
            rTCConfiguration.keyType = KeyType.ECDSA;
            rTCConfiguration.continualGatheringPolicy = ContinualGatheringPolicy.GATHER_ONCE;
            rTCConfiguration.iceCandidatePoolSize = 0;
            rTCConfiguration.pruneTurnPorts = false;
            rTCConfiguration.presumeWritableWhenFullyRelayed = false;
            rTCConfiguration.surfaceIceCandidatesOnIceTransportTypeChanged = false;
            rTCConfiguration.iceCheckIntervalStrongConnectivityMs = null;
            rTCConfiguration.iceCheckIntervalWeakConnectivityMs = null;
            rTCConfiguration.iceCheckMinInterval = null;
            rTCConfiguration.iceUnwritableTimeMs = null;
            rTCConfiguration.iceUnwritableMinChecks = null;
            rTCConfiguration.stunCandidateKeepaliveIntervalMs = null;
            rTCConfiguration.disableIPv6OnWifi = false;
            rTCConfiguration.maxIPv6Networks = 5;
            rTCConfiguration.iceRegatherIntervalRange = null;
            rTCConfiguration.disableIpv6 = false;
            rTCConfiguration.enableDscp = false;
            rTCConfiguration.enableCpuOveruseDetection = true;
            rTCConfiguration.enableRtpDataChannel = false;
            rTCConfiguration.suspendBelowMinBitrate = false;
            rTCConfiguration.screencastMinBitrate = null;
            rTCConfiguration.combinedAudioVideoBwe = null;
            rTCConfiguration.enableDtlsSrtp = null;
            rTCConfiguration.networkPreference = AdapterType.UNKNOWN;
            rTCConfiguration.sdpSemantics = SdpSemantics.PLAN_B;
            rTCConfiguration.activeResetSrtpParams = false;
            rTCConfiguration.useMediaTransport = false;
            rTCConfiguration.useMediaTransportForDataChannels = false;
            rTCConfiguration.cryptoOptions = null;
        }

        @CalledByNative(value="RTCConfiguration")
        public IceTransportsType getIceTransportsType() {
            return this.iceTransportsType;
        }

        @CalledByNative(value="RTCConfiguration")
        public List<IceServer> getIceServers() {
            return this.iceServers;
        }

        @CalledByNative(value="RTCConfiguration")
        public BundlePolicy getBundlePolicy() {
            return this.bundlePolicy;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public RtcCertificatePem getCertificate() {
            return this.certificate;
        }

        @CalledByNative(value="RTCConfiguration")
        public RtcpMuxPolicy getRtcpMuxPolicy() {
            return this.rtcpMuxPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        public TcpCandidatePolicy getTcpCandidatePolicy() {
            return this.tcpCandidatePolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        public CandidateNetworkPolicy getCandidateNetworkPolicy() {
            return this.candidateNetworkPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        public int getAudioJitterBufferMaxPackets() {
            return this.audioJitterBufferMaxPackets;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getAudioJitterBufferFastAccelerate() {
            return this.audioJitterBufferFastAccelerate;
        }

        @CalledByNative(value="RTCConfiguration")
        public int getIceConnectionReceivingTimeout() {
            return this.iceConnectionReceivingTimeout;
        }

        @CalledByNative(value="RTCConfiguration")
        public int getIceBackupCandidatePairPingInterval() {
            return this.iceBackupCandidatePairPingInterval;
        }

        @CalledByNative(value="RTCConfiguration")
        public KeyType getKeyType() {
            return this.keyType;
        }

        @CalledByNative(value="RTCConfiguration")
        public ContinualGatheringPolicy getContinualGatheringPolicy() {
            return this.continualGatheringPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        public int getIceCandidatePoolSize() {
            return this.iceCandidatePoolSize;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getPruneTurnPorts() {
            return this.pruneTurnPorts;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getPresumeWritableWhenFullyRelayed() {
            return this.presumeWritableWhenFullyRelayed;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getSurfaceIceCandidatesOnIceTransportTypeChanged() {
            return this.surfaceIceCandidatesOnIceTransportTypeChanged;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public Integer getIceCheckIntervalStrongConnectivity() {
            return this.iceCheckIntervalStrongConnectivityMs;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public Integer getIceCheckIntervalWeakConnectivity() {
            return this.iceCheckIntervalWeakConnectivityMs;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public Integer getIceCheckMinInterval() {
            return this.iceCheckMinInterval;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public Integer getIceUnwritableTimeout() {
            return this.iceUnwritableTimeMs;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public Integer getIceUnwritableMinChecks() {
            return this.iceUnwritableMinChecks;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public Integer getStunCandidateKeepaliveInterval() {
            return this.stunCandidateKeepaliveIntervalMs;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getDisableIPv6OnWifi() {
            return this.disableIPv6OnWifi;
        }

        @CalledByNative(value="RTCConfiguration")
        public int getMaxIPv6Networks() {
            return this.maxIPv6Networks;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public IntervalRange getIceRegatherIntervalRange() {
            return this.iceRegatherIntervalRange;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public TurnCustomizer getTurnCustomizer() {
            return this.turnCustomizer;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getDisableIpv6() {
            return this.disableIpv6;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getEnableDscp() {
            return this.enableDscp;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getEnableCpuOveruseDetection() {
            return this.enableCpuOveruseDetection;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getEnableRtpDataChannel() {
            return this.enableRtpDataChannel;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getSuspendBelowMinBitrate() {
            return this.suspendBelowMinBitrate;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public Integer getScreencastMinBitrate() {
            return this.screencastMinBitrate;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public Boolean getCombinedAudioVideoBwe() {
            return this.combinedAudioVideoBwe;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public Boolean getEnableDtlsSrtp() {
            return this.enableDtlsSrtp;
        }

        @CalledByNative(value="RTCConfiguration")
        public AdapterType getNetworkPreference() {
            return this.networkPreference;
        }

        @CalledByNative(value="RTCConfiguration")
        public SdpSemantics getSdpSemantics() {
            return this.sdpSemantics;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getActiveResetSrtpParams() {
            return this.activeResetSrtpParams;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getUseMediaTransport() {
            return this.useMediaTransport;
        }

        @CalledByNative(value="RTCConfiguration")
        public boolean getUseMediaTransportForDataChannels() {
            return this.useMediaTransportForDataChannels;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        public CryptoOptions getCryptoOptions() {
            return this.cryptoOptions;
        }
    }

    public static enum SdpSemantics {
        PLAN_B,
        UNIFIED_PLAN;

    }

    public static class IntervalRange {
        public final int min;
        public final int max;

        public IntervalRange(int n3, int n4) {
            this.min = n3;
            this.max = n4;
        }

        @CalledByNative(value="IntervalRange")
        public int getMin() {
            return this.min;
        }

        @CalledByNative(value="IntervalRange")
        public int getMax() {
            return this.max;
        }
    }

    public static enum ContinualGatheringPolicy {
        GATHER_ONCE,
        GATHER_CONTINUALLY;

    }

    public static enum KeyType {
        RSA,
        ECDSA;

    }

    public static enum AdapterType {
        UNKNOWN,
        ETHERNET,
        WIFI,
        CELLULAR,
        VPN,
        LOOPBACK;

    }

    public static enum CandidateNetworkPolicy {
        ALL,
        LOW_COST;

    }

    public static enum TcpCandidatePolicy {
        ENABLED,
        DISABLED;

    }

    public static enum RtcpMuxPolicy {
        NEGOTIATE,
        REQUIRE;

    }

    public static enum BundlePolicy {
        BALANCED,
        MAXBUNDLE,
        MAXCOMPAT;

    }

    public static enum IceTransportsType {
        NONE,
        RELAY,
        NOHOST,
        ALL;

    }

    public static class IceServer {
        @Deprecated
        public final String uri;
        public final List<String> urls;
        public final String username;
        public final String password;
        public final TlsCertPolicy tlsCertPolicy;
        public final String hostname;
        public final List<String> tlsAlpnProtocols;
        public final List<String> tlsEllipticCurves;

        @Deprecated
        public IceServer(String string2) {
            this(string2, "", "");
        }

        @Deprecated
        public IceServer(String string2, String string3, String string4) {
            this(string2, string3, string4, TlsCertPolicy.TLS_CERT_POLICY_SECURE);
        }

        @Deprecated
        public IceServer(String string2, String string3, String string4, TlsCertPolicy tlsCertPolicy) {
            this(string2, string3, string4, tlsCertPolicy, "");
        }

        @Deprecated
        public IceServer(String string2, String string3, String string4, TlsCertPolicy tlsCertPolicy, String string5) {
            String string6 = string2;
            this(string6, Collections.singletonList(string6), string3, string4, tlsCertPolicy, string5, null, null);
        }

        public IceServer(String string2, List<String> list, String string3, String string4, TlsCertPolicy tlsCertPolicy, String string5, List<String> list2, List<String> list3) {
            if (string2 != null && list != null && !list.isEmpty()) {
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != null) continue;
                    throw new IllegalArgumentException("urls element is null: " + list);
                }
                if (string3 != null) {
                    if (string4 != null) {
                        if (string5 != null) {
                            this.uri = string2;
                            this.urls = list;
                            this.username = string3;
                            this.password = string4;
                            this.tlsCertPolicy = tlsCertPolicy;
                            this.hostname = string5;
                            this.tlsAlpnProtocols = list2;
                            this.tlsEllipticCurves = list3;
                            return;
                        }
                        throw new IllegalArgumentException("hostname == null");
                    }
                    throw new IllegalArgumentException("password == null");
                }
                throw new IllegalArgumentException("username == null");
            }
            throw new IllegalArgumentException("uri == null || urls == null || urls.isEmpty()");
        }

        public static Builder builder(String string2) {
            return new Builder(Collections.singletonList(string2), null);
        }

        public static Builder builder(List<String> list) {
            return new Builder(list, null);
        }

        public /* synthetic */ IceServer(String string2, List list, String string3, String string4, TlsCertPolicy tlsCertPolicy, String string5, List list2, List list3, 1 var9_9) {
            this(string2, list, string3, string4, tlsCertPolicy, string5, list2, list3);
        }

        public String toString() {
            return this.urls + " [" + this.username + ":" + this.password + "] [" + (Object)((Object)this.tlsCertPolicy) + "] [" + this.hostname + "] [" + this.tlsAlpnProtocols + "] [" + this.tlsEllipticCurves + "]";
        }

        public boolean equals(@Nullable Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof IceServer)) {
                return false;
            }
            object = (IceServer)object;
            return this.uri.equals(((IceServer)object).uri) && this.urls.equals(((IceServer)object).urls) && this.username.equals(((IceServer)object).username) && this.password.equals(((IceServer)object).password) && this.tlsCertPolicy.equals((Object)((IceServer)object).tlsCertPolicy) && this.hostname.equals(((IceServer)object).hostname) && this.tlsAlpnProtocols.equals(((IceServer)object).tlsAlpnProtocols) && this.tlsEllipticCurves.equals(((IceServer)object).tlsEllipticCurves);
        }

        public int hashCode() {
            Object[] objectArray = new Object[8];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.uri;
            objectArray2[1] = this.urls;
            objectArray2[2] = this.username;
            objectArray2[3] = this.password;
            objectArray2[4] = this.tlsCertPolicy;
            objectArray2[5] = this.hostname;
            objectArray2[6] = this.tlsAlpnProtocols;
            objectArray[7] = this.tlsEllipticCurves;
            return Arrays.hashCode(objectArray);
        }

        @Nullable
        @CalledByNative(value="IceServer")
        public List<String> getUrls() {
            return this.urls;
        }

        @Nullable
        @CalledByNative(value="IceServer")
        public String getUsername() {
            return this.username;
        }

        @Nullable
        @CalledByNative(value="IceServer")
        public String getPassword() {
            return this.password;
        }

        @CalledByNative(value="IceServer")
        public TlsCertPolicy getTlsCertPolicy() {
            return this.tlsCertPolicy;
        }

        @Nullable
        @CalledByNative(value="IceServer")
        public String getHostname() {
            return this.hostname;
        }

        @CalledByNative(value="IceServer")
        public List<String> getTlsAlpnProtocols() {
            return this.tlsAlpnProtocols;
        }

        @CalledByNative(value="IceServer")
        public List<String> getTlsEllipticCurves() {
            return this.tlsEllipticCurves;
        }

        public static class Builder {
            @Nullable
            public final List<String> urls;
            public String username = "";
            public String password = "";
            public TlsCertPolicy tlsCertPolicy = TlsCertPolicy.TLS_CERT_POLICY_SECURE;
            public String hostname = "";
            public List<String> tlsAlpnProtocols;
            public List<String> tlsEllipticCurves;

            public Builder(List<String> list) {
                if (list != null && !list.isEmpty()) {
                    this.urls = list;
                    return;
                }
                throw new IllegalArgumentException("urls == null || urls.isEmpty(): " + list);
            }

            public /* synthetic */ Builder(List list, 1 var2_2) {
                this(list);
            }

            public Builder setUsername(String string2) {
                this.username = string2;
                return this;
            }

            public Builder setPassword(String string2) {
                this.password = string2;
                return this;
            }

            public Builder setTlsCertPolicy(TlsCertPolicy tlsCertPolicy) {
                this.tlsCertPolicy = tlsCertPolicy;
                return this;
            }

            public Builder setHostname(String string2) {
                this.hostname = string2;
                return this;
            }

            public Builder setTlsAlpnProtocols(List<String> list) {
                this.tlsAlpnProtocols = list;
                return this;
            }

            public Builder setTlsEllipticCurves(List<String> list) {
                this.tlsEllipticCurves = list;
                return this;
            }

            public IceServer createIceServer() {
                return new IceServer(this.urls.get(0), this.urls, this.username, this.password, this.tlsCertPolicy, this.hostname, this.tlsAlpnProtocols, this.tlsEllipticCurves, null);
            }
        }
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onSignalingChange(SignalingState var1);

        @CalledByNative(value="Observer")
        public void onIceConnectionChange(IceConnectionState var1);

        @CalledByNative(value="Observer")
        default public void onStandardizedIceConnectionChange(IceConnectionState iceConnectionState) {
        }

        @CalledByNative(value="Observer")
        default public void onConnectionChange(PeerConnectionState peerConnectionState) {
        }

        @CalledByNative(value="Observer")
        public void onIceConnectionReceivingChange(boolean var1);

        @CalledByNative(value="Observer")
        public void onIceGatheringChange(IceGatheringState var1);

        @CalledByNative(value="Observer")
        public void onIceCandidate(IceCandidate var1);

        @CalledByNative(value="Observer")
        public void onIceCandidatesRemoved(IceCandidate[] var1);

        @CalledByNative(value="Observer")
        public void onAddStream(MediaStream var1);

        @CalledByNative(value="Observer")
        public void onRemoveStream(MediaStream var1);

        @CalledByNative(value="Observer")
        public void onDataChannel(DataChannel var1);

        @CalledByNative(value="Observer")
        public void onRenegotiationNeeded();

        @CalledByNative(value="Observer")
        public void onAddTrack(RtpReceiver var1, MediaStream[] var2);

        @CalledByNative(value="Observer")
        default public void onTrack(RtpTransceiver rtpTransceiver) {
        }
    }

    public static enum SignalingState {
        STABLE,
        HAVE_LOCAL_OFFER,
        HAVE_LOCAL_PRANSWER,
        HAVE_REMOTE_OFFER,
        HAVE_REMOTE_PRANSWER,
        CLOSED;


        @CalledByNative(value="SignalingState")
        public static SignalingState fromNativeIndex(int n3) {
            return SignalingState.values()[n3];
        }
    }

    public static enum TlsCertPolicy {
        TLS_CERT_POLICY_SECURE,
        TLS_CERT_POLICY_INSECURE_NO_CHECK;

    }

    public static enum PeerConnectionState {
        NEW,
        CONNECTING,
        CONNECTED,
        DISCONNECTED,
        FAILED,
        CLOSED;


        @CalledByNative(value="PeerConnectionState")
        public static PeerConnectionState fromNativeIndex(int n3) {
            return PeerConnectionState.values()[n3];
        }
    }

    public static enum IceConnectionState {
        NEW,
        CHECKING,
        CONNECTED,
        COMPLETED,
        FAILED,
        DISCONNECTED,
        CLOSED;


        @CalledByNative(value="IceConnectionState")
        public static IceConnectionState fromNativeIndex(int n3) {
            return IceConnectionState.values()[n3];
        }
    }

    public static enum IceGatheringState {
        NEW,
        GATHERING,
        COMPLETE;


        @CalledByNative(value="IceGatheringState")
        public static IceGatheringState fromNativeIndex(int n3) {
            return IceGatheringState.values()[n3];
        }
    }
}

