/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiInfo;
import android.net.wifi.p2p.WifiP2pGroup;
import android.os.Build;
import android.support.annotation.Nullable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.webrtc.CalledByNative;
import org.webrtc.Logging;
import org.webrtc.PeerConnectionFactory;

public class NetworkMonitorAutoDetect
extends BroadcastReceiver {
    public static final long INVALID_NET_ID = -1L;
    public static final String TAG = "NetworkMonitorAutoDetect";
    public final Observer observer;
    public final IntentFilter intentFilter;
    public final Context context;
    @Nullable
    public final ConnectivityManager.NetworkCallback mobileNetworkCallback;
    @Nullable
    public final ConnectivityManager.NetworkCallback allNetworkCallback;
    public ConnectivityManagerDelegate connectivityManagerDelegate;
    public WifiManagerDelegate wifiManagerDelegate;
    public WifiDirectManagerDelegate wifiDirectManagerDelegate;
    public boolean isRegistered;
    public ConnectionType connectionType;
    public String wifiSSID;

    @SuppressLint(value={"NewApi"})
    public NetworkMonitorAutoDetect(Observer observer, Context context) {
        NetworkMonitorAutoDetect networkMonitorAutoDetect = this;
        this.observer = observer;
        networkMonitorAutoDetect.context = context;
        networkMonitorAutoDetect.connectivityManagerDelegate = new ConnectivityManagerDelegate(context);
        networkMonitorAutoDetect.wifiManagerDelegate = new WifiManagerDelegate(context);
        NetworkState networkState = networkMonitorAutoDetect.connectivityManagerDelegate.getNetworkState();
        this.connectionType = NetworkMonitorAutoDetect.getConnectionType(networkState);
        networkMonitorAutoDetect.wifiSSID = networkMonitorAutoDetect.getWifiSSID(networkState);
        networkMonitorAutoDetect.intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        if (PeerConnectionFactory.fieldTrialsFindFullName("IncludeWifiDirect").equals("Enabled")) {
            this.wifiDirectManagerDelegate = new WifiDirectManagerDelegate(observer, context);
        }
        NetworkMonitorAutoDetect networkMonitorAutoDetect2 = this;
        networkMonitorAutoDetect2.registerReceiver();
        if (networkMonitorAutoDetect2.connectivityManagerDelegate.supportNetworkCallback()) {
            ConnectivityManager.NetworkCallback networkCallback;
            observer = networkCallback;
            networkCallback = new ConnectivityManager.NetworkCallback();
            try {
                this.connectivityManagerDelegate.requestMobileNetwork((ConnectivityManager.NetworkCallback)observer);
            }
            catch (SecurityException securityException) {
                Logging.w(TAG, "Unable to obtain permission to request a cellular network.");
                observer = null;
            }
            this.mobileNetworkCallback = observer;
            this.allNetworkCallback = new SimpleNetworkCallback(null);
            this.connectivityManagerDelegate.registerNetworkCallback(this.allNetworkCallback);
        } else {
            NetworkMonitorAutoDetect networkMonitorAutoDetect3 = this;
            networkMonitorAutoDetect3.mobileNetworkCallback = null;
            networkMonitorAutoDetect3.allNetworkCallback = null;
        }
    }

    private void registerReceiver() {
        if (this.isRegistered) {
            return;
        }
        this.isRegistered = true;
        NetworkMonitorAutoDetect networkMonitorAutoDetect = this;
        this.context.registerReceiver((BroadcastReceiver)networkMonitorAutoDetect, networkMonitorAutoDetect.intentFilter);
    }

    private void unregisterReceiver() {
        if (!this.isRegistered) {
            return;
        }
        this.isRegistered = false;
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    public static ConnectionType getConnectionType(boolean bl, int n3, int n4) {
        if (!bl) {
            return ConnectionType.CONNECTION_NONE;
        }
        if (n3 != 0) {
            if (n3 != 1) {
                if (n3 != 6) {
                    if (n3 != 7) {
                        if (n3 != 9) {
                            if (n3 != 17) {
                                return ConnectionType.CONNECTION_UNKNOWN;
                            }
                            return ConnectionType.CONNECTION_VPN;
                        }
                        return ConnectionType.CONNECTION_ETHERNET;
                    }
                    return ConnectionType.CONNECTION_BLUETOOTH;
                }
                return ConnectionType.CONNECTION_4G;
            }
            return ConnectionType.CONNECTION_WIFI;
        }
        switch (n4) {
            default: {
                return ConnectionType.CONNECTION_UNKNOWN_CELLULAR;
            }
            case 13: {
                return ConnectionType.CONNECTION_4G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return ConnectionType.CONNECTION_3G;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
        }
        return ConnectionType.CONNECTION_2G;
    }

    public static ConnectionType getConnectionType(NetworkState networkState) {
        return NetworkMonitorAutoDetect.getConnectionType(networkState.isConnected(), networkState.getNetworkType(), networkState.getNetworkSubType());
    }

    public static ConnectionType getUnderlyingConnectionTypeForVpn(NetworkState networkState) {
        if (networkState.getNetworkType() != 17) {
            return ConnectionType.CONNECTION_NONE;
        }
        return NetworkMonitorAutoDetect.getConnectionType(networkState.isConnected(), networkState.getUnderlyingNetworkTypeForVpn(), networkState.getUnderlyingNetworkSubtypeForVpn());
    }

    private String getWifiSSID(NetworkState networkState) {
        if (NetworkMonitorAutoDetect.getConnectionType(networkState) != ConnectionType.CONNECTION_WIFI) {
            return "";
        }
        return this.wifiManagerDelegate.getWifiSSID();
    }

    private void connectionTypeChanged(NetworkState object) {
        ConnectionType connectionType = NetworkMonitorAutoDetect.getConnectionType((NetworkState)object);
        NetworkMonitorAutoDetect networkMonitorAutoDetect = this;
        object = networkMonitorAutoDetect.getWifiSSID((NetworkState)object);
        if (connectionType == networkMonitorAutoDetect.connectionType && ((String)object).equals(this.wifiSSID)) {
            return;
        }
        this.connectionType = connectionType;
        this.wifiSSID = object;
        Logging.d(TAG, a.a("Network connectivity changed, type is: ").append((Object)this.connectionType).toString());
        this.observer.onConnectionTypeChanged(connectionType);
    }

    @SuppressLint(value={"NewApi"})
    public static long networkToNetId(Network network) {
        if (Build.VERSION.SDK_INT >= 23) {
            return network.getNetworkHandle();
        }
        return Integer.parseInt(network.toString());
    }

    public boolean supportNetworkCallback() {
        return this.connectivityManagerDelegate.supportNetworkCallback();
    }

    public void setConnectivityManagerDelegateForTests(ConnectivityManagerDelegate connectivityManagerDelegate) {
        this.connectivityManagerDelegate = connectivityManagerDelegate;
    }

    public void setWifiManagerDelegateForTests(WifiManagerDelegate wifiManagerDelegate) {
        this.wifiManagerDelegate = wifiManagerDelegate;
    }

    public boolean isReceiverRegisteredForTesting() {
        return this.isRegistered;
    }

    @Nullable
    public List<NetworkInformation> getActiveNetworkList() {
        ArrayList<NetworkInformation> arrayList;
        Object object = ((NetworkMonitorAutoDetect)((Object)arrayList2)).connectivityManagerDelegate.getActiveNetworkList();
        if (object == null) {
            return null;
        }
        NetworkMonitorAutoDetect networkMonitorAutoDetect = arrayList2;
        ArrayList<NetworkInformation> arrayList2 = arrayList;
        arrayList = new ArrayList<NetworkInformation>((Collection<NetworkInformation>)object);
        object = networkMonitorAutoDetect.wifiDirectManagerDelegate;
        if (object != null) {
            arrayList2.addAll(((WifiDirectManagerDelegate)((Object)object)).getActiveNetworkList());
        }
        return arrayList2;
    }

    public void destroy() {
        Object object = this.allNetworkCallback;
        if (object != null) {
            this.connectivityManagerDelegate.releaseCallback((ConnectivityManager.NetworkCallback)object);
        }
        if ((object = this.mobileNetworkCallback) != null) {
            this.connectivityManagerDelegate.releaseCallback((ConnectivityManager.NetworkCallback)object);
        }
        if ((object = this.wifiDirectManagerDelegate) != null) {
            ((WifiDirectManagerDelegate)((Object)object)).release();
        }
        this.unregisterReceiver();
    }

    public NetworkState getCurrentNetworkState() {
        return this.connectivityManagerDelegate.getNetworkState();
    }

    public long getDefaultNetId() {
        return this.connectivityManagerDelegate.getDefaultNetId();
    }

    public void onReceive(Context object, Intent intent) {
        object = this.getCurrentNetworkState();
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            this.connectionTypeChanged((NetworkState)object);
        }
    }

    public static interface Observer {
        public void onConnectionTypeChanged(ConnectionType var1);

        public void onNetworkConnect(NetworkInformation var1);

        public void onNetworkDisconnect(long var1);
    }

    public static class WifiDirectManagerDelegate
    extends BroadcastReceiver {
        public static final int WIFI_P2P_NETWORK_HANDLE = 0;
        public final Context context;
        public final Observer observer;
        @Nullable
        public NetworkInformation wifiP2pNetworkInfo;

        public WifiDirectManagerDelegate(Observer observer, Context context) {
            this.context = context;
            this.observer = observer;
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.wifi.p2p.STATE_CHANGED");
            intentFilter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
            context.registerReceiver((BroadcastReceiver)this, intentFilter);
        }

        private void onWifiP2pGroupChange(@Nullable WifiP2pGroup wifiP2pGroup) {
            if (wifiP2pGroup != null && wifiP2pGroup.getInterface() != null) {
                ArrayList<InetAddress> arrayList;
                try {
                    arrayList = Collections.list(NetworkInterface.getByName(wifiP2pGroup.getInterface()).getInetAddresses());
                }
                catch (SocketException socketException) {
                    Logging.e(NetworkMonitorAutoDetect.TAG, "Unable to get WifiP2p network interface", socketException);
                    return;
                }
                IPAddress[] iPAddressArray = new IPAddress[arrayList.size()];
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    iPAddressArray[i3] = new IPAddress(((InetAddress)arrayList.get(i3)).getAddress());
                }
                this.wifiP2pNetworkInfo = new NetworkInformation(wifiP2pGroup.getInterface(), ConnectionType.CONNECTION_WIFI, ConnectionType.CONNECTION_NONE, 0L, iPAddressArray);
                this.observer.onNetworkConnect(this.wifiP2pNetworkInfo);
                return;
            }
        }

        private void onWifiP2pStateChange(int n3) {
            if (n3 == 1) {
                this.wifiP2pNetworkInfo = null;
                this.observer.onNetworkDisconnect(0L);
            }
        }

        @SuppressLint(value={"InlinedApi"})
        public void onReceive(Context context, Intent intent) {
            if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(intent.getAction())) {
                this.onWifiP2pGroupChange((WifiP2pGroup)intent.getParcelableExtra("p2pGroupInfo"));
            } else if ("android.net.wifi.p2p.STATE_CHANGED".equals(intent.getAction())) {
                this.onWifiP2pStateChange(intent.getIntExtra("wifi_p2p_state", 0));
            }
        }

        public void release() {
            this.context.unregisterReceiver((BroadcastReceiver)this);
        }

        public List<NetworkInformation> getActiveNetworkList() {
            Object object = object.wifiP2pNetworkInfo;
            if (object != null) {
                return Collections.singletonList(object);
            }
            return Collections.emptyList();
        }
    }

    public static class WifiManagerDelegate {
        @Nullable
        public final Context context;

        public WifiManagerDelegate(Context context) {
            this.context = context;
        }

        public WifiManagerDelegate() {
            this.context = null;
        }

        public String getWifiSSID() {
            IntentFilter intentFilter;
            Object object = intentFilter;
            intentFilter = new IntentFilter("android.net.wifi.STATE_CHANGE");
            if ((object = ((WifiManagerDelegate)object).context.registerReceiver(null, (IntentFilter)object)) != null && (object = (WifiInfo)object.getParcelableExtra("wifiInfo")) != null && (object = object.getSSID()) != null) {
                return object;
            }
            return "";
        }
    }

    public static class ConnectivityManagerDelegate {
        @Nullable
        public final ConnectivityManager connectivityManager;

        public ConnectivityManagerDelegate(Context context) {
            this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        public ConnectivityManagerDelegate() {
            this.connectivityManager = null;
        }

        private NetworkState getNetworkState(@Nullable NetworkInfo networkInfo) {
            if (networkInfo != null && networkInfo.isConnected()) {
                NetworkInfo networkInfo2 = networkInfo;
                int n3 = networkInfo2.getType();
                int n4 = networkInfo2.getSubtype();
                return new NetworkState(true, n3, n4, -1, -1);
            }
            return new NetworkState(false, -1, -1, -1, -1);
        }

        @SuppressLint(value={"NewApi"})
        @Nullable
        private NetworkInformation networkToInfo(@Nullable Network network) {
            ConnectivityManager connectivityManager;
            if (network != null && (connectivityManager = this.connectivityManager) != null) {
                if ((connectivityManager = connectivityManager.getLinkProperties(network)) == null) {
                    Logging.w(NetworkMonitorAutoDetect.TAG, a.a("Detected unknown network: ").append(network.toString()).toString());
                    return null;
                }
                if (connectivityManager.getInterfaceName() == null) {
                    Logging.w(NetworkMonitorAutoDetect.TAG, a.a("Null interface name for network ").append(network.toString()).toString());
                    return null;
                }
                Object object = this.getNetworkState(network);
                ConnectionType connectionType = NetworkMonitorAutoDetect.getConnectionType((NetworkState)object);
                if (connectionType == ConnectionType.CONNECTION_NONE) {
                    Logging.d(NetworkMonitorAutoDetect.TAG, a.a("Network ").append(network.toString()).append(" is disconnected").toString());
                    return null;
                }
                if (connectionType == ConnectionType.CONNECTION_UNKNOWN || connectionType == ConnectionType.CONNECTION_UNKNOWN_CELLULAR) {
                    Logging.d(NetworkMonitorAutoDetect.TAG, a.a("Network ").append(network.toString()).append(" connection type is ").append((Object)connectionType).append(" because it has type ").append(((NetworkState)object).getNetworkType()).append(" and subtype ").append(((NetworkState)object).getNetworkSubType()).toString());
                }
                object = NetworkMonitorAutoDetect.getUnderlyingConnectionTypeForVpn((NetworkState)object);
                return new NetworkInformation(connectivityManager.getInterfaceName(), connectionType, (ConnectionType)((Object)object), NetworkMonitorAutoDetect.networkToNetId(network), this.getIPAddresses((LinkProperties)connectivityManager));
            }
            return null;
        }

        public NetworkState getNetworkState() {
            ConnectivityManager connectivityManager = this.connectivityManager;
            if (connectivityManager == null) {
                return new NetworkState(false, -1, -1, -1, -1);
            }
            return this.getNetworkState(connectivityManager.getActiveNetworkInfo());
        }

        @SuppressLint(value={"NewApi"})
        public NetworkState getNetworkState(@Nullable Network network) {
            ConnectivityManager connectivityManager;
            if (network != null && (connectivityManager = this.connectivityManager) != null) {
                if ((connectivityManager = connectivityManager.getNetworkInfo(network)) == null) {
                    Logging.w(NetworkMonitorAutoDetect.TAG, a.a("Couldn't retrieve information from network ").append(network.toString()).toString());
                    return new NetworkState(false, -1, -1, -1, -1);
                }
                if (connectivityManager.getType() != 17) {
                    if ((network = this.connectivityManager.getNetworkCapabilities(network)) != null && network.hasTransport(4)) {
                        ConnectivityManager connectivityManager2 = connectivityManager;
                        int n3 = connectivityManager2.getType();
                        int n4 = connectivityManager2.getSubtype();
                        return new NetworkState(connectivityManager.isConnected(), 17, -1, n3, n4);
                    }
                    return this.getNetworkState((NetworkInfo)connectivityManager);
                }
                if (connectivityManager.getType() == 17) {
                    if (Build.VERSION.SDK_INT >= 23 && network.equals((Object)this.connectivityManager.getActiveNetwork()) && (this = this.connectivityManager.getActiveNetworkInfo()) != null && this.getType() != 17) {
                        ConnectivityManagerDelegate connectivityManagerDelegate = this;
                        int n5 = connectivityManagerDelegate.getType();
                        int n6 = connectivityManagerDelegate.getSubtype();
                        return new NetworkState(connectivityManager.isConnected(), 17, -1, n5, n6);
                    }
                    return new NetworkState(connectivityManager.isConnected(), 17, -1, -1, -1);
                }
                return this.getNetworkState((NetworkInfo)connectivityManager);
            }
            return new NetworkState(false, -1, -1, -1, -1);
        }

        @SuppressLint(value={"NewApi"})
        public Network[] getAllNetworks() {
            ConnectivityManagerDelegate connectivityManagerDelegate = connectivityManagerDelegate.connectivityManager;
            if (connectivityManagerDelegate == null) {
                return new Network[0];
            }
            return connectivityManagerDelegate.getAllNetworks();
        }

        @Nullable
        public List<NetworkInformation> getActiveNetworkList() {
            ArrayList<NetworkInformation> arrayList;
            if (!this.supportNetworkCallback()) {
                return null;
            }
            ArrayList<NetworkInformation> arrayList2 = arrayList;
            arrayList = new ArrayList<NetworkInformation>();
            Network[] networkArray = this.getAllNetworks();
            int n3 = networkArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                NetworkInformation networkInformation = this.networkToInfo(networkArray[i3]);
                if (networkInformation == null) continue;
                arrayList2.add(networkInformation);
            }
            return arrayList2;
        }

        @SuppressLint(value={"NewApi"})
        public long getDefaultNetId() {
            if (!this.supportNetworkCallback()) {
                return -1L;
            }
            NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return -1L;
            }
            Network[] networkArray = this.getAllNetworks();
            long l3 = -1L;
            for (Network network : networkArray) {
                NetworkInfo networkInfo2;
                if (!this.hasInternetCapability(network) || (networkInfo2 = this.connectivityManager.getNetworkInfo(network)) == null || networkInfo2.getType() != networkInfo.getType()) continue;
                if (l3 == -1L) {
                    l3 = NetworkMonitorAutoDetect.networkToNetId(network);
                    continue;
                }
                throw new RuntimeException("Multiple connected networks of same type are not supported.");
            }
            return l3;
        }

        @SuppressLint(value={"NewApi"})
        public boolean hasInternetCapability(Network network) {
            ConnectivityManagerDelegate connectivityManagerDelegate = connectivityManagerDelegate.connectivityManager;
            if (connectivityManagerDelegate == null) {
                return false;
            }
            return (connectivityManagerDelegate = connectivityManagerDelegate.getNetworkCapabilities(network)) != null && connectivityManagerDelegate.hasCapability(12);
        }

        @SuppressLint(value={"NewApi"})
        public void registerNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
            this.connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().addCapability(12).build(), networkCallback);
        }

        @SuppressLint(value={"NewApi"})
        public void requestMobileNetwork(ConnectivityManager.NetworkCallback networkCallback) {
            NetworkRequest.Builder builder;
            ConnectivityManagerDelegate connectivityManagerDelegate = connectivityManagerDelegate2;
            ConnectivityManagerDelegate connectivityManagerDelegate2 = builder;
            new NetworkRequest.Builder().addCapability(12).addTransportType(0);
            connectivityManagerDelegate.connectivityManager.requestNetwork(connectivityManagerDelegate2.build(), networkCallback);
        }

        @SuppressLint(value={"NewApi"})
        public IPAddress[] getIPAddresses(LinkProperties linkProperties) {
            LinkProperties linkProperties2 = linkProperties;
            IPAddress[] iPAddressArray = new IPAddress[linkProperties2.getLinkAddresses().size()];
            int n3 = 0;
            for (LinkAddress linkAddress : linkProperties2.getLinkAddresses()) {
                iPAddressArray[n3] = new IPAddress(linkAddress.getAddress().getAddress());
                ++n3;
            }
            return iPAddressArray;
        }

        @SuppressLint(value={"NewApi"})
        public void releaseCallback(ConnectivityManager.NetworkCallback networkCallback) {
            if (this.supportNetworkCallback()) {
                Logging.d(NetworkMonitorAutoDetect.TAG, "Unregister network callback");
                this.connectivityManager.unregisterNetworkCallback(networkCallback);
            }
        }

        public boolean supportNetworkCallback() {
            return Build.VERSION.SDK_INT >= 21 && this.connectivityManager != null;
        }
    }

    @SuppressLint(value={"NewApi"})
    public class SimpleNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        public SimpleNetworkCallback() {
        }

        private void onNetworkChanged(Network object) {
            object = NetworkMonitorAutoDetect.this.connectivityManagerDelegate.networkToInfo(object);
            if (object != null) {
                NetworkMonitorAutoDetect.this.observer.onNetworkConnect((NetworkInformation)object);
            }
        }

        public /* synthetic */ SimpleNetworkCallback(1 var2_2) {
            this();
        }

        public void onAvailable(Network network) {
            Logging.d(NetworkMonitorAutoDetect.TAG, a.a("Network becomes available: ").append(network.toString()).toString());
            this.onNetworkChanged(network);
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            Logging.d(NetworkMonitorAutoDetect.TAG, a.a("capabilities changed: ").append(networkCapabilities.toString()).toString());
            this.onNetworkChanged(network);
        }

        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            Logging.d(NetworkMonitorAutoDetect.TAG, a.a("link properties changed: ").append(linkProperties.toString()).toString());
            this.onNetworkChanged(network);
        }

        public void onLosing(Network network, int n3) {
            Logging.d(NetworkMonitorAutoDetect.TAG, a.a("Network ").append(network.toString()).append(" is about to lose in ").append(n3).append("ms").toString());
        }

        public void onLost(Network network) {
            Logging.d(NetworkMonitorAutoDetect.TAG, a.a("Network ").append(network.toString()).append(" is disconnected").toString());
            NetworkMonitorAutoDetect.this.observer.onNetworkDisconnect(NetworkMonitorAutoDetect.networkToNetId(network));
        }
    }

    public static class NetworkState {
        public final boolean connected;
        public final int type;
        public final int subtype;
        public final int underlyingNetworkTypeForVpn;
        public final int underlyingNetworkSubtypeForVpn;

        public NetworkState(boolean bl, int n3, int n4, int n5, int n6) {
            this.connected = bl;
            this.type = n3;
            this.subtype = n4;
            this.underlyingNetworkTypeForVpn = n5;
            this.underlyingNetworkSubtypeForVpn = n6;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public int getNetworkType() {
            return this.type;
        }

        public int getNetworkSubType() {
            return this.subtype;
        }

        public int getUnderlyingNetworkTypeForVpn() {
            return this.underlyingNetworkTypeForVpn;
        }

        public int getUnderlyingNetworkSubtypeForVpn() {
            return this.underlyingNetworkSubtypeForVpn;
        }
    }

    public static class NetworkInformation {
        public final String name;
        public final ConnectionType type;
        public final ConnectionType underlyingTypeForVpn;
        public final long handle;
        public final IPAddress[] ipAddresses;

        public NetworkInformation(String string2, ConnectionType connectionType, ConnectionType connectionType2, long l3, IPAddress[] iPAddressArray) {
            this.name = string2;
            this.type = connectionType;
            this.underlyingTypeForVpn = connectionType2;
            this.handle = l3;
            this.ipAddresses = iPAddressArray;
        }

        @CalledByNative(value="NetworkInformation")
        private IPAddress[] getIpAddresses() {
            return this.ipAddresses;
        }

        @CalledByNative(value="NetworkInformation")
        private ConnectionType getConnectionType() {
            return this.type;
        }

        @CalledByNative(value="NetworkInformation")
        private ConnectionType getUnderlyingConnectionTypeForVpn() {
            return this.underlyingTypeForVpn;
        }

        @CalledByNative(value="NetworkInformation")
        private long getHandle() {
            return this.handle;
        }

        @CalledByNative(value="NetworkInformation")
        private String getName() {
            return this.name;
        }
    }

    public static class IPAddress {
        public final byte[] address;

        public IPAddress(byte[] byArray) {
            this.address = byArray;
        }

        @CalledByNative(value="IPAddress")
        private byte[] getAddress() {
            return this.address;
        }
    }

    public static enum ConnectionType {
        CONNECTION_UNKNOWN,
        CONNECTION_ETHERNET,
        CONNECTION_WIFI,
        CONNECTION_4G,
        CONNECTION_3G,
        CONNECTION_2G,
        CONNECTION_UNKNOWN_CELLULAR,
        CONNECTION_BLUETOOTH,
        CONNECTION_VPN,
        CONNECTION_NONE;

    }
}

