/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.webrtc.CalledByNative;
import org.webrtc.ContextUtils;
import org.webrtc.Logging;
import org.webrtc.NetworkMonitorAutoDetect;

public class NetworkMonitor {
    public static final String TAG = "NetworkMonitor";
    public final ArrayList<Long> nativeNetworkObservers;
    public final ArrayList<NetworkObserver> networkObservers;
    public final Object autoDetectLock = new Object();
    @Nullable
    public NetworkMonitorAutoDetect autoDetect;
    public int numObservers = 0;
    public volatile NetworkMonitorAutoDetect.ConnectionType currentConnectionType;

    public NetworkMonitor() {
        this.nativeNetworkObservers = new ArrayList();
        this.networkObservers = new ArrayList();
        this.currentConnectionType = NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN;
    }

    @Deprecated
    public static void init(Context context) {
    }

    @CalledByNative
    public static NetworkMonitor getInstance() {
        return InstanceHolder.instance;
    }

    public static void assertIsTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected to be true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void startMonitoring(@Nullable Context object, long l3) {
        Logging.d(TAG, "Start monitoring with native observer " + l3);
        if (object == null) {
            object = ContextUtils.getApplicationContext();
        }
        NetworkMonitor networkMonitor = this;
        NetworkMonitor networkMonitor2 = this;
        networkMonitor2.startMonitoring((Context)object);
        object = networkMonitor2.nativeNetworkObservers;
        synchronized (object) {
            this.nativeNetworkObservers.add(l3);
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1 /* !! */ 
            networkMonitor.updateObserverActiveNetworkList(l3);
            networkMonitor.notifyObserversOfConnectionTypeChange(networkMonitor.currentConnectionType);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void stopMonitoring(long l3) {
        NetworkMonitor networkMonitor = this;
        Logging.d(TAG, "Stop monitoring with native observer " + l3);
        networkMonitor.stopMonitoring();
        ArrayList<Long> arrayList = networkMonitor.nativeNetworkObservers;
        synchronized (arrayList) {
            this.nativeNetworkObservers.remove(l3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean networkBindingSupported() {
        NetworkMonitor networkMonitor = this;
        Object object = networkMonitor.autoDetectLock;
        synchronized (object) {
            boolean bl;
            block6: {
                block5: {
                    if (networkMonitor.autoDetect == null) break block5;
                    if (!this.autoDetect.supportNetworkCallback()) break block5;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            return bl;
        }
    }

    @CalledByNative
    public static int androidSdkInt() {
        return Build.VERSION.SDK_INT;
    }

    private NetworkMonitorAutoDetect.ConnectionType getCurrentConnectionType() {
        return this.currentConnectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentDefaultNetId() {
        NetworkMonitor networkMonitor = this;
        Object object = networkMonitor.autoDetectLock;
        synchronized (object) {
            long l3;
            block6: {
                block5: {
                    if (networkMonitor.autoDetect != null) break block5;
                    l3 = -1L;
                    break block6;
                }
                l3 = this.autoDetect.getDefaultNetId();
            }
            return l3;
        }
    }

    private NetworkMonitorAutoDetect createAutoDetect(Context context) {
        return new NetworkMonitorAutoDetect(new NetworkMonitorAutoDetect.Observer(){

            @Override
            public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType connectionType) {
                NetworkMonitor.this.updateCurrentConnectionType(connectionType);
            }

            @Override
            public void onNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
                NetworkMonitor.this.notifyObserversOfNetworkConnect(networkInformation);
            }

            @Override
            public void onNetworkDisconnect(long l3) {
                NetworkMonitor.this.notifyObserversOfNetworkDisconnect(l3);
            }
        }, context);
    }

    private void updateCurrentConnectionType(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        this.currentConnectionType = connectionType;
        this.notifyObserversOfConnectionTypeChange(connectionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyObserversOfConnectionTypeChange(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        Iterator iterator;
        Object object = ((NetworkMonitor)((Object)iterator)).getNativeNetworkObserversSync().iterator();
        while (object.hasNext()) {
            ((NetworkMonitor)((Object)iterator)).nativeNotifyConnectionTypeChanged(object.next());
        }
        object = ((NetworkMonitor)((Object)iterator)).networkObservers;
        synchronized (object) {
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : object
            iterator = new ArrayList<NetworkObserver>(((NetworkMonitor)((Object)iterator)).networkObservers).iterator();
        }
        while (iterator.hasNext()) {
            ((NetworkObserver)iterator.next()).onConnectionTypeChanged(connectionType);
        }
        return;
    }

    private void notifyObserversOfNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
        Iterator<Long> iterator = this.getNativeNetworkObserversSync().iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkConnect(iterator.next(), networkInformation);
        }
    }

    private void notifyObserversOfNetworkDisconnect(long l3) {
        Iterator<Long> iterator = this.getNativeNetworkObserversSync().iterator();
        while (iterator.hasNext()) {
            this.nativeNotifyOfNetworkDisconnect(iterator.next(), l3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObserverActiveNetworkList(long l3) {
        NetworkMonitor networkMonitor = this;
        Object object = networkMonitor.autoDetectLock;
        synchronized (object) {
            List<NetworkMonitorAutoDetect.NetworkInformation> list;
            block7: {
                block6: {
                    if (networkMonitor.autoDetect != null) break block6;
                    list = null;
                    break block7;
                }
                list = this.autoDetect.getActiveNetworkList();
            }
            // MONITOREXIT @DISABLED, blocks:[2, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var3_2
            if (list != null && list.size() != 0) {
                List<NetworkMonitorAutoDetect.NetworkInformation> list2 = list;
                this.nativeNotifyOfActiveNetworkList(l3, list2.toArray(new NetworkMonitorAutoDetect.NetworkInformation[list2.size()]));
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getNativeNetworkObserversSync() {
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            return new ArrayList<Long>(this.nativeNetworkObservers);
        }
    }

    @Deprecated
    public static void addNetworkObserver(NetworkObserver networkObserver) {
        NetworkMonitor.getInstance().addObserver(networkObserver);
    }

    @Deprecated
    public static void removeNetworkObserver(NetworkObserver networkObserver) {
        NetworkMonitor.getInstance().removeObserver(networkObserver);
    }

    public static boolean isOnline() {
        return NetworkMonitor.getInstance().getCurrentConnectionType() != NetworkMonitorAutoDetect.ConnectionType.CONNECTION_NONE;
    }

    private native void nativeNotifyConnectionTypeChanged(long var1);

    private native void nativeNotifyOfNetworkConnect(long var1, NetworkMonitorAutoDetect.NetworkInformation var3);

    private native void nativeNotifyOfNetworkDisconnect(long var1, long var3);

    private native void nativeNotifyOfActiveNetworkList(long var1, NetworkMonitorAutoDetect.NetworkInformation[] var3);

    public static NetworkMonitorAutoDetect createAndSetAutoDetectForTest(Context context) {
        NetworkMonitor networkMonitor = NetworkMonitor.getInstance();
        networkMonitor.autoDetect = networkMonitor.createAutoDetect(context);
        return networkMonitor.autoDetect;
    }

    public /* synthetic */ NetworkMonitor(1 var1_1) {
        this();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startMonitoring(Context context) {
        NetworkMonitor networkMonitor = this;
        Object object = networkMonitor.autoDetectLock;
        synchronized (object) {
            ++networkMonitor.numObservers;
            if (networkMonitor.autoDetect == null) {
                this.autoDetect = this.createAutoDetect(context);
            }
            this.currentConnectionType = NetworkMonitorAutoDetect.getConnectionType(this.autoDetect.getCurrentNetworkState());
            return;
        }
    }

    @Deprecated
    public void startMonitoring() {
        this.startMonitoring(ContextUtils.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopMonitoring() {
        NetworkMonitor networkMonitor = this;
        Object object = networkMonitor.autoDetectLock;
        synchronized (object) {
            int n3 = networkMonitor.numObservers - 1;
            {
                this.numObservers = n3;
                if (n3 == 0) {
                    this.autoDetect.destroy();
                    this.autoDetect = null;
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(NetworkObserver networkObserver) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            this.networkObservers.add(networkObserver);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(NetworkObserver networkObserver) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            this.networkObservers.remove(networkObserver);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NetworkMonitorAutoDetect getNetworkMonitorAutoDetect() {
        NetworkMonitor networkMonitor = object;
        Object object = networkMonitor.autoDetectLock;
        synchronized (object) {
            return networkMonitor.autoDetect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumObservers() {
        NetworkMonitor networkMonitor = object;
        Object object = networkMonitor.autoDetectLock;
        synchronized (object) {
            return networkMonitor.numObservers;
        }
    }

    public static class InstanceHolder {
        public static final NetworkMonitor instance = new NetworkMonitor(null);
    }

    public static interface NetworkObserver {
        public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType var1);
    }
}

