/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.webrtc.JavaI420Buffer;
import org.webrtc.RefCountDelegate;
import org.webrtc.VideoFrame;

public class NV21Buffer
implements VideoFrame.Buffer {
    public final byte[] data;
    public final int width;
    public final int height;
    public final RefCountDelegate refCountDelegate;

    public NV21Buffer(byte[] byArray, int n3, int n4, @Nullable Runnable runnable) {
        NV21Buffer nV21Buffer = this;
        this.data = byArray;
        this.width = n3;
        nV21Buffer.height = n4;
        nV21Buffer.refCountDelegate = new RefCountDelegate(runnable);
    }

    public static native void nativeCropAndScale(int var0, int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, ByteBuffer var9, int var10, ByteBuffer var11, int var12, ByteBuffer var13, int var14);

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        NV21Buffer nV21Buffer = this;
        int n3 = nV21Buffer.width;
        int n4 = nV21Buffer.height;
        return (VideoFrame.I420Buffer)nV21Buffer.cropAndScale(0, 0, n3, n4, n3, n4);
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n3, int n4, int n5, int n6, int n7, int n8) {
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n7, n8);
        NV21Buffer.nativeCropAndScale(n3, n4, n5, n6, n7, n8, this.data, this.width, this.height, javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV());
        return javaI420Buffer;
    }
}

