/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import org.webrtc.AudioTrack;
import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;
import org.webrtc.VideoTrack;

public class MediaStreamTrack {
    public static final String AUDIO_TRACK_KIND = "audio";
    public static final String VIDEO_TRACK_KIND = "video";
    public long nativeTrack;

    @Nullable
    public static MediaStreamTrack createMediaStreamTrack(long l3) {
        if (l3 == 0L) {
            return null;
        }
        String string2 = MediaStreamTrack.nativeGetKind(l3);
        if (string2.equals(AUDIO_TRACK_KIND)) {
            return new AudioTrack(l3);
        }
        if (string2.equals(VIDEO_TRACK_KIND)) {
            return new VideoTrack(l3);
        }
        return null;
    }

    public MediaStreamTrack(long l3) {
        if (l3 != 0L) {
            this.nativeTrack = l3;
            return;
        }
        throw new IllegalArgumentException("nativeTrack may not be null");
    }

    private void checkMediaStreamTrackExists() {
        if (this.nativeTrack != 0L) {
            return;
        }
        throw new IllegalStateException("MediaStreamTrack has been disposed.");
    }

    public static native String nativeGetId(long var0);

    public static native String nativeGetKind(long var0);

    public static native boolean nativeGetEnabled(long var0);

    public static native boolean nativeSetEnabled(long var0, boolean var2);

    public static native State nativeGetState(long var0);

    public String id() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetId(mediaStreamTrack.nativeTrack);
    }

    public String kind() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetKind(mediaStreamTrack.nativeTrack);
    }

    public boolean enabled() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetEnabled(mediaStreamTrack.nativeTrack);
    }

    public boolean setEnabled(boolean bl) {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeSetEnabled(mediaStreamTrack.nativeTrack, bl);
    }

    public State state() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return MediaStreamTrack.nativeGetState(mediaStreamTrack.nativeTrack);
    }

    public void dispose() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        JniCommon.nativeReleaseRef(mediaStreamTrack.nativeTrack);
        mediaStreamTrack.nativeTrack = 0L;
    }

    public long getNativeMediaStreamTrack() {
        MediaStreamTrack mediaStreamTrack = this;
        mediaStreamTrack.checkMediaStreamTrackExists();
        return mediaStreamTrack.nativeTrack;
    }

    public static enum MediaType {
        MEDIA_TYPE_AUDIO(0),
        MEDIA_TYPE_VIDEO(1);

        public final int nativeIndex;

        public MediaType(int n4) {
            this.nativeIndex = n4;
        }

        @CalledByNative(value="MediaType")
        public static MediaType fromNativeIndex(int n3) {
            for (MediaType mediaType : MediaType.values()) {
                if (mediaType.getNative() != n3) continue;
                return mediaType;
            }
            throw new IllegalArgumentException("Unknown native media type: " + n3);
        }

        @CalledByNative(value="MediaType")
        public int getNative() {
            return this.nativeIndex;
        }
    }

    public static enum State {
        LIVE,
        ENDED;


        @CalledByNative(value="State")
        public static State fromNativeIndex(int n3) {
            return State.values()[n3];
        }
    }
}

