/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import java.util.ArrayList;
import java.util.List;
import org.webrtc.AudioTrack;
import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;
import org.webrtc.Logging;
import org.webrtc.MediaStreamTrack;
import org.webrtc.VideoTrack;

public class MediaStream {
    public static final String TAG = "MediaStream";
    public final List<AudioTrack> audioTracks = new ArrayList<AudioTrack>();
    public final List<VideoTrack> videoTracks = new ArrayList<VideoTrack>();
    public final List<VideoTrack> preservedVideoTracks = new ArrayList<VideoTrack>();
    public long nativeStream;

    @CalledByNative
    public MediaStream(long l3) {
        this.nativeStream = l3;
    }

    private void checkMediaStreamExists() {
        if (this.nativeStream != 0L) {
            return;
        }
        throw new IllegalStateException("MediaStream has been disposed.");
    }

    public static void removeMediaStreamTrack(List<? extends MediaStreamTrack> object, long l3) {
        object = object.iterator();
        while (object.hasNext()) {
            MediaStreamTrack mediaStreamTrack = (MediaStreamTrack)object.next();
            if (mediaStreamTrack.getNativeMediaStreamTrack() != l3) continue;
            mediaStreamTrack.dispose();
            object.remove();
            return;
        }
        Logging.e(TAG, "Couldn't not find track");
    }

    public static native boolean nativeAddAudioTrackToNativeStream(long var0, long var2);

    public static native boolean nativeAddVideoTrackToNativeStream(long var0, long var2);

    public static native boolean nativeRemoveAudioTrack(long var0, long var2);

    public static native boolean nativeRemoveVideoTrack(long var0, long var2);

    public static native String nativeGetId(long var0);

    public boolean addTrack(AudioTrack audioTrack) {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        if (MediaStream.nativeAddAudioTrackToNativeStream(mediaStream.nativeStream, audioTrack.getNativeAudioTrack())) {
            this.audioTracks.add(audioTrack);
            return true;
        }
        return false;
    }

    public boolean addTrack(VideoTrack videoTrack) {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        if (MediaStream.nativeAddVideoTrackToNativeStream(mediaStream.nativeStream, videoTrack.getNativeVideoTrack())) {
            this.videoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    public boolean addPreservedTrack(VideoTrack videoTrack) {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        if (MediaStream.nativeAddVideoTrackToNativeStream(mediaStream.nativeStream, videoTrack.getNativeVideoTrack())) {
            this.preservedVideoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    public boolean removeTrack(AudioTrack audioTrack) {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        mediaStream.audioTracks.remove(audioTrack);
        return MediaStream.nativeRemoveAudioTrack(mediaStream.nativeStream, audioTrack.getNativeAudioTrack());
    }

    public boolean removeTrack(VideoTrack videoTrack) {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        mediaStream.videoTracks.remove(videoTrack);
        mediaStream.preservedVideoTracks.remove(videoTrack);
        return MediaStream.nativeRemoveVideoTrack(mediaStream.nativeStream, videoTrack.getNativeVideoTrack());
    }

    @CalledByNative
    public void dispose() {
        this.checkMediaStreamExists();
        while (!this.audioTracks.isEmpty()) {
            AudioTrack audioTrack = this.audioTracks.get(0);
            this.removeTrack(audioTrack);
            audioTrack.dispose();
        }
        while (!this.videoTracks.isEmpty()) {
            VideoTrack videoTrack = this.videoTracks.get(0);
            this.removeTrack(videoTrack);
            videoTrack.dispose();
        }
        while (!this.preservedVideoTracks.isEmpty()) {
            MediaStream mediaStream = this;
            mediaStream.removeTrack(mediaStream.preservedVideoTracks.get(0));
        }
        JniCommon.nativeReleaseRef(this.nativeStream);
        this.nativeStream = 0L;
    }

    public String getId() {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        return MediaStream.nativeGetId(mediaStream.nativeStream);
    }

    public String toString() {
        return a.a("[").append(this.getId()).append(":A=").append(this.audioTracks.size()).append(":V=").append(this.videoTracks.size()).append("]").toString();
    }

    @CalledByNative
    public void addNativeAudioTrack(long l3) {
        this.audioTracks.add(new AudioTrack(l3));
    }

    @CalledByNative
    public void addNativeVideoTrack(long l3) {
        this.videoTracks.add(new VideoTrack(l3));
    }

    @CalledByNative
    public void removeAudioTrack(long l3) {
        MediaStream.removeMediaStreamTrack(this.audioTracks, l3);
    }

    @CalledByNative
    public void removeVideoTrack(long l3) {
        MediaStream.removeMediaStreamTrack(this.videoTracks, l3);
    }

    public long getNativeMediaStream() {
        MediaStream mediaStream = this;
        mediaStream.checkMediaStreamExists();
        return mediaStream.nativeStream;
    }
}

