/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;

public class MediaSource {
    public long nativeSource;

    public MediaSource(long l3) {
        this.nativeSource = l3;
    }

    private void checkMediaSourceExists() {
        if (this.nativeSource != 0L) {
            return;
        }
        throw new IllegalStateException("MediaSource has been disposed.");
    }

    public static native State nativeGetState(long var0);

    public State state() {
        MediaSource mediaSource = this;
        mediaSource.checkMediaSourceExists();
        return MediaSource.nativeGetState(mediaSource.nativeSource);
    }

    public void dispose() {
        MediaSource mediaSource = this;
        mediaSource.checkMediaSourceExists();
        JniCommon.nativeReleaseRef(mediaSource.nativeSource);
        mediaSource.nativeSource = 0L;
    }

    public long getNativeMediaSource() {
        MediaSource mediaSource = this;
        mediaSource.checkMediaSourceExists();
        return mediaSource.nativeSource;
    }

    public static enum State {
        INITIALIZING,
        LIVE,
        ENDED,
        MUTED;


        @CalledByNative(value="State")
        public static State fromNativeIndex(int n3) {
            return State.values()[n3];
        }
    }
}

