/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.webrtc.CalledByNative;
import org.webrtc.CalledByNativeUnchecked;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.EglBase14;
import org.webrtc.GlRectDrawer;
import org.webrtc.H264Utils;
import org.webrtc.Logging;
import org.webrtc.MediaCodecVideoDecoder;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoFrame;
import org.webrtc.VideoFrameDrawer;
import org.webrtc.WrappedNativeVideoEncoder;

@Deprecated
@TargetApi(value=19)
public class MediaCodecVideoEncoder {
    public static final String TAG = "MediaCodecVideoEncoder";
    public static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    public static final int DEQUEUE_TIMEOUT = 0;
    public static final int BITRATE_ADJUSTMENT_FPS = 30;
    public static final int MAXIMUM_INITIAL_FPS = 30;
    public static final double BITRATE_CORRECTION_SEC = 3.0;
    public static final double BITRATE_CORRECTION_MAX_SCALE = 4.0;
    public static final int BITRATE_CORRECTION_STEPS = 20;
    public static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000L;
    public static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000L;
    public static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000L;
    @Nullable
    public static MediaCodecVideoEncoder runningInstance;
    @Nullable
    public static MediaCodecVideoEncoderErrorCallback errorCallback;
    public static int codecErrors;
    public static Set<String> hwEncoderDisabledTypes;
    @Nullable
    public static EglBase staticEglBase;
    public static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    public static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    public static final String H264_MIME_TYPE = "video/avc";
    public static final int VIDEO_AVCProfileHigh = 8;
    public static final int VIDEO_AVCLevel3 = 256;
    public static final MediaCodecProperties qcomVp8HwProperties;
    public static final MediaCodecProperties exynosVp8HwProperties;
    public static final MediaCodecProperties intelVp8HwProperties;
    public static final MediaCodecProperties qcomVp9HwProperties;
    public static final MediaCodecProperties exynosVp9HwProperties;
    public static final MediaCodecProperties[] vp9HwList;
    public static final MediaCodecProperties qcomH264HwProperties;
    public static final MediaCodecProperties exynosH264HwProperties;
    public static final MediaCodecProperties mediatekH264HwProperties;
    public static final MediaCodecProperties hisiH264HwProperties;
    public static final MediaCodecProperties exynosH264HighProfileHwProperties;
    public static final MediaCodecProperties[] h264HighProfileHwList;
    public static final String[] H264_HW_EXCEPTION_MODELS;
    public static final int VIDEO_ControlRateConstant = 2;
    public static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    public static final int[] supportedColorList;
    public static final int[] supportedSurfaceColorList;
    @Nullable
    public Thread mediaCodecThread;
    @Nullable
    public MediaCodec mediaCodec;
    public ByteBuffer[] outputBuffers;
    @Nullable
    public EglBase14 eglBase;
    public int profile;
    public int width;
    public int height;
    @Nullable
    public Surface inputSurface;
    @Nullable
    public GlRectDrawer drawer;
    public VideoCodecType type;
    public int colorFormat;
    public BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
    public double bitrateAccumulator;
    public double bitrateAccumulatorMax;
    public double bitrateObservationTimeMs;
    public int bitrateAdjustmentScaleExp;
    public int targetBitrateBps;
    public int targetFps;
    public long forcedKeyFrameMs;
    public long lastKeyFrameMs;
    @Nullable
    public ByteBuffer configData;

    public static VideoEncoderFactory createFactory() {
        return new DefaultVideoEncoderFactory(new HwEncoderFactory());
    }

    public static void setEglContext(EglBase.Context context) {
        if (staticEglBase != null) {
            Logging.w(TAG, "Egl context already set.");
            staticEglBase.release();
        }
        staticEglBase = EglBase.create(context);
    }

    public static void disposeEglContext() {
        EglBase eglBase = staticEglBase;
        if (eglBase != null) {
            eglBase.release();
            staticEglBase = null;
        }
    }

    @Nullable
    public static EglBase.Context getEglContext() {
        EglBase eglBase = staticEglBase;
        return eglBase == null ? null : eglBase.getEglBaseContext();
    }

    public static MediaCodecProperties[] vp8HwList() {
        ArrayList<MediaCodecProperties> arrayList;
        ArrayList<MediaCodecProperties> arrayList2 = arrayList;
        new ArrayList<MediaCodecProperties>().add(qcomVp8HwProperties);
        arrayList2.add(exynosVp8HwProperties);
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-IntelVP8").equals("Enabled")) {
            arrayList2.add(intelVp8HwProperties);
        }
        ArrayList<MediaCodecProperties> arrayList3 = arrayList2;
        return arrayList3.toArray(new MediaCodecProperties[arrayList3.size()]);
    }

    public static final MediaCodecProperties[] h264HwList() {
        ArrayList<MediaCodecProperties> arrayList = new ArrayList<MediaCodecProperties>();
        arrayList.add(qcomH264HwProperties);
        arrayList.add(exynosH264HwProperties);
        arrayList.add(mediatekH264HwProperties);
        arrayList.add(hisiH264HwProperties);
        Logging.e(TAG, "\u5df2\u6dfb\u52a0\u5bf9\u6d77\u601dH264\u3001MTK \u7f16\u7801\u5668\u7684\u652f\u6301");
        return arrayList.toArray(new MediaCodecProperties[arrayList.size()]);
    }

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback mediaCodecVideoEncoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoEncoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVp8HwSupported() {
        if (hwEncoderDisabledTypes.contains(VP8_MIME_TYPE)) return false;
        int[] nArray = supportedColorList;
        if (MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), nArray) == null) return false;
        return true;
    }

    @Nullable
    public static EncoderProperties vp8HwEncoderProperties() {
        if (hwEncoderDisabledTypes.contains(VP8_MIME_TYPE)) {
            return null;
        }
        int[] nArray = supportedColorList;
        return MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), nArray);
    }

    public static boolean isVp9HwSupported() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, nArray = supportedColorList) != null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isH264HwSupported() {
        if (MediaCodecVideoEncoder.hwEncoderDisabledTypes.contains("video/avc")) ** GOTO lbl-1000
        var0 = MediaCodecVideoEncoder.supportedColorList;
        if (MediaCodecVideoEncoder.findHwEncoder("video/avc", MediaCodecVideoEncoder.h264HwList(), var0) != null) {
            var0_1 = true;
        } else lbl-1000:
        // 2 sources

        {
            var0_1 = false;
        }
        Logging.e("MediaCodecVideoEncoder", "isH264HwSupported:" + var0_1);
        return true;
    }

    public static boolean isH264HighProfileHwSupported() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HighProfileHwList, nArray = supportedColorList) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVp8HwSupportedUsingTextures() {
        if (hwEncoderDisabledTypes.contains(VP8_MIME_TYPE)) return false;
        int[] nArray = supportedSurfaceColorList;
        if (MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), nArray) == null) return false;
        return true;
    }

    public static boolean isVp9HwSupportedUsingTextures() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, nArray = supportedSurfaceColorList) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isH264HwSupportedUsingTextures() {
        if (hwEncoderDisabledTypes.contains(H264_MIME_TYPE)) return false;
        int[] nArray = supportedSurfaceColorList;
        if (MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, MediaCodecVideoEncoder.h264HwList(), nArray) == null) return false;
        return true;
    }

    @Nullable
    public static EncoderProperties findHwEncoder(String string2, MediaCodecProperties[] mediaCodecPropertiesArray, int[] nArray) {
        Logging.e(TAG, "findHwEncoder: " + string2);
        if (Build.VERSION.SDK_INT < 19) {
            Logging.e(TAG, a.a("\u7cfb\u7edf\u7248\u672c\u8fc7\u4f4e\uff0c\u65e0\u6cd5\u6253\u5f00\u786c\u4ef6\u7f16\u7801\u5668: ").append(Build.VERSION.SDK_INT).toString());
            return null;
        }
        if (string2.equals(H264_MIME_TYPE) && Arrays.asList(H264_HW_EXCEPTION_MODELS).contains(Build.MODEL)) {
            Logging.e(TAG, a.a("Model: ").append(Build.MODEL).append(" has black listed H.264 encoder.").toString());
            return null;
        }
        for (int i3 = 0; i3 < MediaCodecList.getCodecCount(); ++i3) {
            Object object;
            int n32;
            int n4;
            int n5;
            Object object2;
            String string3;
            MediaCodecInfo mediaCodecInfo;
            block16: {
                mediaCodecInfo = null;
                try {
                    mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logging.e(TAG, "Cannot retrieve encoder codec info", illegalArgumentException);
                }
                if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder()) continue;
                string3 = null;
                object2 = mediaCodecInfo.getSupportedTypes();
                n5 = ((String[])object2).length;
                for (n4 = 0; n4 < n5; ++n4) {
                    if (!object2[n4].equals(string2)) continue;
                    string3 = mediaCodecInfo.getName();
                    break;
                }
                if (string3 == null) continue;
                Logging.v(TAG, "Found candidate encoder " + string3);
                int n6 = 0;
                BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
                n4 = mediaCodecPropertiesArray.length;
                for (n32 = 0; n32 < n4; ++n32) {
                    object = mediaCodecPropertiesArray[n32];
                    if (!string3.startsWith(((MediaCodecProperties)object).codecPrefix)) continue;
                    if (Build.VERSION.SDK_INT < ((MediaCodecProperties)object).minSdk) {
                        Logging.w(TAG, "Codec " + string3 + " is disabled due to SDK version " + Build.VERSION.SDK_INT);
                        continue;
                    }
                    object2 = ((MediaCodecProperties)object).bitrateAdjustmentType;
                    if (object2 != BitrateAdjustmentType.NO_ADJUSTMENT) {
                        Logging.w(TAG, "Codec " + string3 + " requires bitrate adjustment: " + object2);
                    } else {
                        object2 = bitrateAdjustmentType;
                    }
                    n5 = 1;
                    break block16;
                }
                object2 = bitrateAdjustmentType;
                n5 = n6;
            }
            if (n5 == 0 && string2.equals(H264_MIME_TYPE)) {
                if (Build.VERSION.SDK_INT < 19) continue;
                object2 = BitrateAdjustmentType.FRAMERATE_ADJUSTMENT;
                n5 = 1;
                Logging.e(TAG, "\u5f3a\u5236\u6253\u5f00\u7f16\u7801\u5668: " + string3 + " requires bitrate adjustment: " + object2);
            }
            if (n5 == 0) continue;
            try {
                mediaCodecInfo = mediaCodecInfo.getCapabilitiesForType(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder capabilities", illegalArgumentException);
            }
            int[] nArray2 = mediaCodecInfo.colorFormats;
            n4 = mediaCodecInfo.colorFormats.length;
            for (n32 = 0; n32 < n4; ++n32) {
                Logging.v(TAG, a.a("   Color: 0x").append(Integer.toHexString(nArray2[n32])).toString());
            }
            for (int n32 : nArray) {
                object = mediaCodecInfo.colorFormats;
                int n7 = mediaCodecInfo.colorFormats.length;
                for (int i4 = 0; i4 < n7; ++i4) {
                    Object object3 = object[i4];
                    if (object3 != n32) continue;
                    Logging.d(TAG, "Found target encoder for mime " + string2 + " : " + string3 + ". Color: 0x" + Integer.toHexString((int)object3) + ". Bitrate adjustment: " + object2);
                    return new EncoderProperties(string3, (int)object3, (BitrateAdjustmentType)((Object)object2));
                }
            }
            continue;
        }
        Logging.e(TAG, "\u83b7\u53d6\u786c\u4ef6\u7f16\u7801\u5668\u5931\u8d25: " + string2);
        return null;
    }

    @CalledByNative
    public MediaCodecVideoEncoder() {
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() == Thread.currentThread().getId()) {
            return;
        }
        throw new RuntimeException(a.a("MediaCodecVideoEncoder previously operated on ").append(this.mediaCodecThread).append(" but is now called on ").append(Thread.currentThread()).toString());
    }

    public static void printStackTrace() {
        Object object = runningInstance;
        if (object != null && (object = object.mediaCodecThread) != null && ((StackTraceElement[])(object = object.getStackTrace())).length > 0) {
            Logging.d(TAG, "MediaCodecVideoEncoder stacks trace:");
            int n3 = ((StackTraceElement[])object).length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Logging.d(TAG, object[i3].toString());
            }
        }
    }

    @Nullable
    public static MediaCodec createByCodecName(String string2) {
        Logging.e(TAG, "createByCodecName:" + string2);
        try {
            return MediaCodec.createByCodecName((String)string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @CalledByNativeUnchecked
    private boolean setRates(int n3, int n4) {
        Bundle bundle;
        MediaCodecVideoEncoder mediaCodecVideoEncoder;
        mediaCodecVideoEncoder2.checkOnMediaCodecThread();
        int n5 = n3 * 1000;
        if (mediaCodecVideoEncoder2.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            double d3 = n5;
            mediaCodecVideoEncoder2.bitrateAccumulatorMax = d3 / 8.0;
            int n6 = mediaCodecVideoEncoder2.targetBitrateBps;
            if (n6 > 0 && n5 < n6) {
                mediaCodecVideoEncoder2.bitrateAccumulator = mediaCodecVideoEncoder2.bitrateAccumulator * d3 / (double)n6;
            }
        }
        mediaCodecVideoEncoder2.targetBitrateBps = n5;
        mediaCodecVideoEncoder2.targetFps = n4;
        if (mediaCodecVideoEncoder2.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT && (n4 = mediaCodecVideoEncoder2.targetFps) > 0) {
            n5 = mediaCodecVideoEncoder2.targetBitrateBps * 30 / n4;
            Logging.v(TAG, "setRates: " + n3 + " -> " + n5 / 1000 + " kbps. Fps: " + mediaCodecVideoEncoder2.targetFps);
        } else if (mediaCodecVideoEncoder2.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            Logging.v(TAG, "setRates: " + n3 + " kbps. Fps: " + mediaCodecVideoEncoder2.targetFps + ". ExpScale: " + mediaCodecVideoEncoder2.bitrateAdjustmentScaleExp);
            n3 = mediaCodecVideoEncoder2.bitrateAdjustmentScaleExp;
            if (n3 != 0) {
                n5 = (int)((double)n5 * mediaCodecVideoEncoder2.getBitrateScale(n3));
            }
        } else {
            Logging.v(TAG, "setRates: " + n3 + " kbps. Fps: " + mediaCodecVideoEncoder2.targetFps);
        }
        try {
            mediaCodecVideoEncoder = mediaCodecVideoEncoder2;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "setRates failed", illegalStateException);
            return false;
        }
        MediaCodecVideoEncoder mediaCodecVideoEncoder2 = bundle;
        new Bundle().putInt("video-bitrate", n5);
        mediaCodecVideoEncoder.mediaCodec.setParameters((Bundle)mediaCodecVideoEncoder2);
        return true;
    }

    private double getBitrateScale(int n3) {
        double d3 = (double)n3 / 20.0;
        return Math.pow(4.0, d3);
    }

    private void reportEncodedFrame(int n3) {
        int n4 = this.targetFps;
        if (n4 != 0 && this.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
            MediaCodecVideoEncoder mediaCodecVideoEncoder2 = this;
            double d3 = (double)mediaCodecVideoEncoder2.targetBitrateBps / ((double)n4 * 8.0);
            double d4 = mediaCodecVideoEncoder2.bitrateAccumulator;
            this.bitrateAccumulator = (double)n3 - d3 + d4;
            d3 = this.bitrateObservationTimeMs;
            d4 = n4;
            mediaCodecVideoEncoder.bitrateObservationTimeMs = 1000.0 / d4 + d3;
            d3 = mediaCodecVideoEncoder.bitrateAccumulatorMax * 3.0;
            mediaCodecVideoEncoder.bitrateAccumulator = Math.min(mediaCodecVideoEncoder.bitrateAccumulator, d3);
            mediaCodecVideoEncoder.bitrateAccumulator = Math.max(mediaCodecVideoEncoder.bitrateAccumulator, -d3);
            if (mediaCodecVideoEncoder.bitrateObservationTimeMs > 3000.0) {
                double d5;
                double d6;
                Logging.d(TAG, a.a("Acc: ").append((int)this.bitrateAccumulator).append(". Max: ").append((int)this.bitrateAccumulatorMax).append(". ExpScale: ").append(this.bitrateAdjustmentScaleExp).toString());
                n3 = 0;
                d3 = this.bitrateAccumulator;
                d4 = this.bitrateAccumulatorMax;
                if (d6 > d5) {
                    n3 = (int)(d3 / d4 + 0.5);
                    this.bitrateAdjustmentScaleExp -= n3;
                    this.bitrateAccumulator = d4;
                    n3 = 1;
                } else if (d3 < -d4) {
                    n3 = (int)(-d3 / d4 + 0.5);
                    this.bitrateAdjustmentScaleExp += n3;
                    this.bitrateAccumulator = -d4;
                    n3 = 1;
                }
                if (n3 != 0) {
                    MediaCodecVideoEncoder mediaCodecVideoEncoder3 = this;
                    mediaCodecVideoEncoder3.bitrateAdjustmentScaleExp = Math.min(mediaCodecVideoEncoder3.bitrateAdjustmentScaleExp, 20);
                    mediaCodecVideoEncoder3.bitrateAdjustmentScaleExp = Math.max(mediaCodecVideoEncoder3.bitrateAdjustmentScaleExp, -20);
                    MediaCodecVideoEncoder mediaCodecVideoEncoder4 = this;
                    Logging.d(TAG, a.a("Adjusting bitrate scale to ").append(this.bitrateAdjustmentScaleExp).append(". Value: ").append(mediaCodecVideoEncoder4.getBitrateScale(mediaCodecVideoEncoder4.bitrateAdjustmentScaleExp)).toString());
                    mediaCodecVideoEncoder3.setRates(mediaCodecVideoEncoder3.targetBitrateBps / 1000, this.targetFps);
                }
                this.bitrateObservationTimeMs = 0.0;
            }
            return;
        }
    }

    @CalledByNative
    public static boolean isTextureBuffer(VideoFrame.Buffer buffer) {
        return buffer instanceof VideoFrame.TextureBuffer;
    }

    public static native void nativeFillInputBuffer(long var0, int var2, ByteBuffer var3, int var4, ByteBuffer var5, int var6, ByteBuffer var7, int var8);

    public static native long nativeCreateEncoder(VideoCodecInfo var0, boolean var1);

    static {
        hwEncoderDisabledTypes = new HashSet<String>();
        BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
        qcomVp8HwProperties = new MediaCodecProperties("OMX.qcom.", 19, bitrateAdjustmentType);
        bitrateAdjustmentType = BitrateAdjustmentType.DYNAMIC_ADJUSTMENT;
        exynosVp8HwProperties = new MediaCodecProperties("OMX.Exynos.", 23, bitrateAdjustmentType);
        bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
        intelVp8HwProperties = new MediaCodecProperties("OMX.Intel.", 21, bitrateAdjustmentType);
        bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
        qcomVp9HwProperties = new MediaCodecProperties("OMX.qcom.", 24, bitrateAdjustmentType);
        bitrateAdjustmentType = BitrateAdjustmentType.FRAMERATE_ADJUSTMENT;
        exynosVp9HwProperties = new MediaCodecProperties("OMX.Exynos.", 24, bitrateAdjustmentType);
        vp9HwList = new MediaCodecProperties[]{qcomVp9HwProperties, exynosVp9HwProperties};
        bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
        qcomH264HwProperties = new MediaCodecProperties("OMX.qcom.", 19, bitrateAdjustmentType);
        bitrateAdjustmentType = BitrateAdjustmentType.FRAMERATE_ADJUSTMENT;
        exynosH264HwProperties = new MediaCodecProperties("OMX.Exynos.", 21, bitrateAdjustmentType);
        bitrateAdjustmentType = BitrateAdjustmentType.FRAMERATE_ADJUSTMENT;
        mediatekH264HwProperties = new MediaCodecProperties("OMX.MTK.", 27, bitrateAdjustmentType);
        bitrateAdjustmentType = BitrateAdjustmentType.FRAMERATE_ADJUSTMENT;
        hisiH264HwProperties = new MediaCodecProperties("OMX.hisi.", 19, bitrateAdjustmentType);
        bitrateAdjustmentType = BitrateAdjustmentType.FRAMERATE_ADJUSTMENT;
        exynosH264HighProfileHwProperties = new MediaCodecProperties("OMX.Exynos.", 23, bitrateAdjustmentType);
        h264HighProfileHwList = new MediaCodecProperties[]{exynosH264HighProfileHwProperties};
        H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4"};
        supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
        supportedSurfaceColorList = new int[]{2130708361};
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNativeUnchecked
    public boolean initEncode(VideoCodecType videoCodecType, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8;
        Object object;
        Object object2;
        boolean bl2;
        block26: {
            block27: {
                Logging.d(TAG, "Java initEncode: " + (Object)((Object)videoCodecType) + ". Profile: " + n3 + " : " + n4 + " x " + n5 + ". @ " + n6 + " kbps. Fps: " + n7 + ". Encode from texture : " + bl);
                this.profile = n3;
                this.width = n4;
                this.height = n5;
                if (this.mediaCodecThread != null) {
                    throw new RuntimeException("Forgot to release()?");
                }
                bl2 = false;
                if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP8) {
                    void var11_22;
                    String string2 = VP8_MIME_TYPE;
                    object2 = VP8_MIME_TYPE;
                    MediaCodecProperties[] mediaCodecPropertiesArray = MediaCodecVideoEncoder.vp8HwList();
                    if (bl) {
                        int[] nArray = supportedSurfaceColorList;
                    } else {
                        int[] nArray = supportedColorList;
                    }
                    object2 = MediaCodecVideoEncoder.findHwEncoder((String)object2, mediaCodecPropertiesArray, (int[])var11_22);
                    int n9 = 100;
                    Object object3 = object2;
                    int n10 = n9;
                    object2 = string2;
                    object = object3;
                } else if (videoCodecType == VideoCodecType.VIDEO_CODEC_VP9) {
                    void var11_26;
                    String string3 = VP9_MIME_TYPE;
                    object2 = VP9_MIME_TYPE;
                    MediaCodecProperties[] mediaCodecPropertiesArray = vp9HwList;
                    if (bl) {
                        int[] nArray = supportedSurfaceColorList;
                    } else {
                        int[] nArray = supportedColorList;
                    }
                    object2 = MediaCodecVideoEncoder.findHwEncoder((String)object2, mediaCodecPropertiesArray, (int[])var11_26);
                    int n11 = 100;
                    Object object4 = object2;
                    int n12 = n11;
                    object2 = string3;
                    object = object4;
                } else {
                    void var12_35;
                    if (videoCodecType != VideoCodecType.VIDEO_CODEC_H264) {
                        throw new RuntimeException("initEncode: Non-supported codec " + (Object)((Object)videoCodecType));
                    }
                    object2 = H264_MIME_TYPE;
                    object = H264_MIME_TYPE;
                    MediaCodecProperties[] mediaCodecPropertiesArray = MediaCodecVideoEncoder.h264HwList();
                    if (bl) {
                        int[] nArray = supportedSurfaceColorList;
                    } else {
                        int[] nArray = supportedColorList;
                    }
                    object = MediaCodecVideoEncoder.findHwEncoder((String)object, mediaCodecPropertiesArray, (int[])var12_35);
                    if (n3 == H264Profile.CONSTRAINED_HIGH.getValue()) {
                        String string4 = H264_MIME_TYPE;
                        MediaCodecProperties[] mediaCodecPropertiesArray2 = h264HighProfileHwList;
                        int[] nArray = bl ? supportedSurfaceColorList : supportedColorList;
                        if (MediaCodecVideoEncoder.findHwEncoder(string4, mediaCodecPropertiesArray2, nArray) != null) {
                            Logging.d(TAG, "High profile H.264 encoder supported.");
                            bl2 = true;
                        } else {
                            Logging.d(TAG, "High profile H.264 encoder requested, but not supported. Use baseline.");
                        }
                    }
                    int n13 = 20;
                    Logging.e(TAG, "\u521d\u59cb\u5316\u7f16\u7801\u5668:" + (String)object2 + " " + n13 + " " + n3);
                }
                if (object == null) {
                    throw new RuntimeException("Can not find HW encoder for " + (Object)((Object)videoCodecType));
                }
                runningInstance = this;
                this.colorFormat = ((EncoderProperties)object).colorFormat;
                this.bitrateAdjustmentType = ((EncoderProperties)object).bitrateAdjustmentType;
                n8 = this.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT ? 30 : Math.min(n7, 30);
                MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
                mediaCodecVideoEncoder.forcedKeyFrameMs = 0L;
                mediaCodecVideoEncoder.lastKeyFrameMs = -1L;
                if (videoCodecType != VideoCodecType.VIDEO_CODEC_VP8 || !((EncoderProperties)object).codecName.startsWith(MediaCodecVideoEncoder.qcomVp8HwProperties.codecPrefix)) break block26;
                n7 = Build.VERSION.SDK_INT;
                if (n7 == 21 || n7 == 22) break block27;
                if (n7 == 23) {
                    this.forcedKeyFrameMs = 20000L;
                    break block26;
                } else if (n7 > 23) {
                    this.forcedKeyFrameMs = 15000L;
                }
                break block26;
            }
            this.forcedKeyFrameMs = 15000L;
        }
        Logging.d(TAG, a.a("Color format: ").append(this.colorFormat).append(". Bitrate adjustment: ").append((Object)this.bitrateAdjustmentType).append(". Key frame interval: ").append(this.forcedKeyFrameMs).append(" . Initial fps: ").append(n8).toString());
        this.targetBitrateBps = n6 * 1000;
        this.targetFps = n8;
        this.bitrateAccumulatorMax = (double)this.targetBitrateBps / 8.0;
        this.bitrateAccumulator = 0.0;
        this.bitrateObservationTimeMs = 0.0;
        this.bitrateAdjustmentScaleExp = 0;
        this.mediaCodecThread = Thread.currentThread();
        try {
            void var11_32;
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)object2, (int)n4, (int)n5);
            Logging.e(TAG, "\u9009\u62e9\u7f16\u7801\u5668:" + (String)object2);
            mediaFormat.setInteger("bitrate", this.targetBitrateBps);
            mediaFormat.setInteger("bitrate-mode", 2);
            mediaFormat.setInteger("color-format", ((EncoderProperties)object).colorFormat);
            mediaFormat.setInteger("frame-rate", this.targetFps);
            mediaFormat.setInteger("i-frame-interval", (int)var11_32);
            if (bl2) {
                MediaFormat mediaFormat2 = mediaFormat;
                mediaFormat2.setInteger("profile", 8);
                mediaFormat2.setInteger("level", 256);
            }
            Logging.d(TAG, "  Format: " + mediaFormat);
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(((EncoderProperties)object).codecName);
            this.type = videoCodecType;
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media encoder");
                this.release();
                return false;
            }
            this.mediaCodec.configure(mediaFormat, null, null, 1);
            if (bl) {
                MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
                mediaCodecVideoEncoder.eglBase = EglBase.createEgl14((EglBase14.Context)MediaCodecVideoEncoder.getEglContext(), EglBase.CONFIG_RECORDABLE);
                mediaCodecVideoEncoder.inputSurface = mediaCodecVideoEncoder.mediaCodec.createInputSurface();
                mediaCodecVideoEncoder.eglBase.createSurface(this.inputSurface);
                mediaCodecVideoEncoder.drawer = new GlRectDrawer();
            }
            MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
            mediaCodecVideoEncoder.mediaCodec.start();
            mediaCodecVideoEncoder.outputBuffers = mediaCodecVideoEncoder.mediaCodec.getOutputBuffers();
            Logging.d(TAG, "Output buffers: " + this.outputBuffers.length);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initEncode failed", illegalStateException);
            this.release();
            return false;
        }
    }

    @CalledByNativeUnchecked
    public ByteBuffer[] getInputBuffers() {
        ByteBuffer[] byteBufferArray = this.mediaCodec.getInputBuffers();
        Logging.d(TAG, a.a("Input buffers: ").append(byteBufferArray.length).toString());
        return byteBufferArray;
    }

    public void checkKeyFrameRequired(boolean bl, long l3) {
        long l4;
        l3 = (l3 + 500L) / 1000L;
        if (mediaCodecVideoEncoder3.lastKeyFrameMs < 0L) {
            mediaCodecVideoEncoder3.lastKeyFrameMs = l3;
        }
        boolean bl2 = false;
        if (!bl && (l4 = mediaCodecVideoEncoder3.forcedKeyFrameMs) > 0L && l3 > mediaCodecVideoEncoder3.lastKeyFrameMs + l4) {
            bl2 = true;
        }
        if (bl || bl2) {
            Bundle bundle;
            if (bl) {
                Logging.d(TAG, "Sync frame request");
            } else {
                Logging.d(TAG, "Sync frame forced");
            }
            MediaCodecVideoEncoder mediaCodecVideoEncoder = mediaCodecVideoEncoder3;
            MediaCodecVideoEncoder mediaCodecVideoEncoder2 = mediaCodecVideoEncoder3;
            MediaCodecVideoEncoder mediaCodecVideoEncoder3 = bundle;
            new Bundle().putInt("request-sync", 0);
            mediaCodecVideoEncoder2.mediaCodec.setParameters((Bundle)mediaCodecVideoEncoder3);
            mediaCodecVideoEncoder.lastKeyFrameMs = l3;
        }
    }

    @CalledByNativeUnchecked
    public boolean encodeBuffer(boolean bl, int n3, int n4, long l3) {
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        this.checkOnMediaCodecThread();
        try {
            mediaCodecVideoEncoder.checkKeyFrameRequired(bl, l3);
            mediaCodecVideoEncoder.mediaCodec.queueInputBuffer(n3, 0, n4, l3, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "encodeBuffer failed", illegalStateException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNativeUnchecked
    public boolean encodeFrame(long l3, boolean bl, VideoFrame videoFrame, int n3, long l4) {
        VideoFrame.Buffer buffer;
        this.checkOnMediaCodecThread();
        try {
            this.checkKeyFrameRequired(bl, l4);
            buffer = videoFrame.getBuffer();
            if (buffer instanceof VideoFrame.TextureBuffer) {
                MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
                VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)buffer;
                mediaCodecVideoEncoder.eglBase.makeCurrent();
                GLES20.glClear((int)16384);
                VideoFrameDrawer.drawTexture(mediaCodecVideoEncoder.drawer, textureBuffer, new Matrix(), this.width, this.height, 0, 0, this.width, this.height);
                mediaCodecVideoEncoder.eglBase.swapBuffers(TimeUnit.MICROSECONDS.toNanos(l4));
                return true;
            }
            buffer = buffer.toI420();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "encodeFrame failed", runtimeException);
            return false;
        }
        int n4 = (this.height + 1) / 2;
        ByteBuffer byteBuffer = buffer.getDataY();
        ByteBuffer byteBuffer2 = buffer.getDataU();
        ByteBuffer byteBuffer3 = buffer.getDataV();
        int n5 = buffer.getStrideY();
        int n6 = buffer.getStrideU();
        int n7 = buffer.getStrideV();
        if (byteBuffer.capacity() < n5 * this.height) throw new RuntimeException("Y-plane buffer size too small.");
        if (byteBuffer2.capacity() < n6 * n4) throw new RuntimeException("U-plane buffer size too small.");
        if (byteBuffer3.capacity() < n7 * n4) throw new RuntimeException("V-plane buffer size too small.");
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        MediaCodecVideoEncoder mediaCodecVideoEncoder2 = mediaCodecVideoEncoder;
        MediaCodecVideoEncoder.nativeFillInputBuffer(l3, n3, byteBuffer, n5, byteBuffer2, n6, byteBuffer3, n7);
        buffer.release();
        int n8 = mediaCodecVideoEncoder.width * this.height;
        int n9 = n8 * 3 / 2;
        mediaCodecVideoEncoder2.mediaCodec.queueInputBuffer(n3, 0, n9, l4, 0);
        return true;
    }

    @CalledByNativeUnchecked
    public void release() {
        RuntimeException runtimeException;
        Object object;
        CaughtException caughtException;
        MediaCodecVideoEncoder mediaCodecVideoEncoder = exception;
        Logging.d(TAG, "Java releaseEncoder");
        mediaCodecVideoEncoder.checkOnMediaCodecThread();
        final CaughtException caughtException2 = caughtException;
        public class CaughtException {
            public Exception e;
        }
        caughtException = (MediaCodecVideoEncoder)((Object)exception).new CaughtException();
        boolean bl = false;
        if (mediaCodecVideoEncoder.mediaCodec != null) {
            Runnable runnable;
            CountDownLatch countDownLatch;
            object = countDownLatch;
            countDownLatch = new CountDownLatch(1);
            Runnable runnable2 = runnable;
            runnable = new Runnable((CountDownLatch)object){
                public final /* synthetic */ CountDownLatch val$releaseDone;
                {
                    this.val$releaseDone = countDownLatch;
                }

                @Override
                public void run() {
                    Logging.d(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread");
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.stop();
                    }
                    catch (Exception exception) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder stop failed", exception);
                    }
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.release();
                    }
                    catch (Exception exception) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder release failed", exception);
                        caughtException2.e = exception;
                    }
                    Logging.d(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread done");
                    this.val$releaseDone.countDown();
                }
            };
            new Thread(runnable2).start();
            if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                bl = true;
            }
            ((MediaCodecVideoEncoder)((Object)exception)).mediaCodec = null;
        }
        ((MediaCodecVideoEncoder)((Object)exception)).mediaCodecThread = null;
        object = ((MediaCodecVideoEncoder)((Object)exception)).drawer;
        if (object != null) {
            ((GlRectDrawer)object).release();
            ((MediaCodecVideoEncoder)((Object)exception)).drawer = null;
        }
        if ((object = ((MediaCodecVideoEncoder)((Object)exception)).eglBase) != null) {
            object.release();
            ((MediaCodecVideoEncoder)((Object)exception)).eglBase = null;
        }
        if ((object = ((MediaCodecVideoEncoder)((Object)exception)).inputSurface) != null) {
            object.release();
            ((MediaCodecVideoEncoder)((Object)exception)).inputSurface = null;
        }
        runningInstance = null;
        if (bl) {
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, a.a("Invoke codec error callback. Errors: ").append(codecErrors).toString());
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
            throw new RuntimeException("Media encoder release timeout.");
        }
        Exception exception = caughtException2.e;
        if (exception == null) {
            Logging.d(TAG, "Java releaseEncoder done");
            return;
        }
        RuntimeException runtimeException2 = runtimeException;
        runtimeException2(exception);
        runtimeException.setStackTrace(ThreadUtils.concatStackTraces(caughtException2.e.getStackTrace(), runtimeException2.getStackTrace()));
        throw runtimeException;
    }

    @CalledByNativeUnchecked
    public int dequeueInputBuffer() {
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        mediaCodecVideoEncoder.checkOnMediaCodecThread();
        try {
            return mediaCodecVideoEncoder.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    @CalledByNativeUnchecked
    public OutputBufferInfo dequeueOutputBuffer() {
        boolean bl;
        Object object;
        int n3;
        MediaCodec.BufferInfo bufferInfo;
        block36: {
            MediaCodec.BufferInfo bufferInfo2;
            MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
            mediaCodecVideoEncoder.checkOnMediaCodecThread();
            bufferInfo = bufferInfo2;
            bufferInfo2 = new MediaCodec.BufferInfo();
            n3 = mediaCodecVideoEncoder.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            if (n3 < 0) break block36;
            if (!((bufferInfo.flags & 2) != 0)) break block36;
            MediaCodecVideoEncoder mediaCodecVideoEncoder2 = this;
            Logging.d(TAG, "Config frame generated. Offset: " + bufferInfo.offset + ". Size: " + bufferInfo.size);
            mediaCodecVideoEncoder2.configData = ByteBuffer.allocateDirect(bufferInfo.size);
            mediaCodecVideoEncoder2.outputBuffers[n3].position(bufferInfo.offset);
            ByteBuffer byteBuffer = mediaCodecVideoEncoder2.outputBuffers[n3];
            int n4 = bufferInfo.offset + bufferInfo.size;
            byteBuffer.limit(n4);
            mediaCodecVideoEncoder2.configData.put(this.outputBuffers[n3]);
            object = "";
            bl = false;
            while (true) {
                boolean bl2;
                block38: {
                    block37: {
                        if (bufferInfo.size >= 8) break block37;
                        bl2 = bufferInfo.size;
                        break block38;
                    }
                    bl2 = 8 != 0;
                }
                if (bl >= bl2) break;
                StringBuilder stringBuilder = new StringBuilder().append((String)object);
                byte by = this.configData.get(bl ? 1 : 0);
                object = stringBuilder.append(Integer.toHexString(by & 0xFF)).append(" ").toString();
                bl += 1;
                continue;
                break;
            }
            try {
                MediaCodecVideoEncoder mediaCodecVideoEncoder3 = this;
                Logging.d(TAG, (String)object);
                mediaCodecVideoEncoder3.mediaCodec.releaseOutputBuffer(n3, false);
                n3 = mediaCodecVideoEncoder3.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "dequeueOutputBuffer failed", illegalStateException);
                return new OutputBufferInfo(-1, null, false, -1L);
            }
        }
        if (n3 >= 0) {
            block39: {
                MediaCodec.BufferInfo bufferInfo3 = bufferInfo;
                MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
                MediaCodec.BufferInfo bufferInfo4 = bufferInfo;
                object = this.outputBuffers[n3].duplicate();
                MediaCodec.BufferInfo bufferInfo5 = bufferInfo;
                ((ByteBuffer)object).position(bufferInfo.offset);
                int n5 = bufferInfo5.offset + bufferInfo.size;
                ((ByteBuffer)object).limit(n5);
                mediaCodecVideoEncoder.reportEncodedFrame(bufferInfo4.size);
                bl = (bufferInfo3.flags & 1) != 0;
                if (!bl) break block39;
                Logging.d(TAG, "Sync frame generated");
            }
            if (!bl) return new OutputBufferInfo(n3, ((ByteBuffer)object).slice(), bl, bufferInfo.presentationTimeUs);
            if (this.type != VideoCodecType.VIDEO_CODEC_H264) return new OutputBufferInfo(n3, ((ByteBuffer)object).slice(), bl, bufferInfo.presentationTimeUs);
            Logging.d(TAG, "Appending config frame of size " + this.configData.capacity() + " to output buffer with offset " + bufferInfo.offset + ", size " + bufferInfo.size);
            int n6 = this.configData.capacity() + bufferInfo.size;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n6);
            Object object2 = object;
            ByteBuffer byteBuffer2 = byteBuffer;
            MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
            MediaCodecVideoEncoder mediaCodecVideoEncoder4 = mediaCodecVideoEncoder;
            mediaCodecVideoEncoder.configData.rewind();
            byteBuffer2.put(mediaCodecVideoEncoder4.configData);
            byteBuffer.put((ByteBuffer)object2);
            byteBuffer.position(0);
            return new OutputBufferInfo(n3, byteBuffer, bl, bufferInfo.presentationTimeUs);
        }
        if (n3 == -3) {
            MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
            mediaCodecVideoEncoder.outputBuffers = mediaCodecVideoEncoder.mediaCodec.getOutputBuffers();
            return mediaCodecVideoEncoder.dequeueOutputBuffer();
        }
        if (n3 == -2) {
            return this.dequeueOutputBuffer();
        }
        if (n3 == -1) {
            return null;
        }
        throw new RuntimeException("dequeueOutputBuffer: " + n3);
    }

    @CalledByNativeUnchecked
    public boolean releaseOutputBuffer(int n3) {
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        mediaCodecVideoEncoder.checkOnMediaCodecThread();
        try {
            mediaCodecVideoEncoder.mediaCodec.releaseOutputBuffer(n3, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "releaseOutputBuffer failed", illegalStateException);
            return false;
        }
    }

    @CalledByNative
    public int getColorFormat() {
        return this.colorFormat;
    }

    public static class OutputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int n3, ByteBuffer byteBuffer, boolean bl, long l3) {
            this.index = n3;
            this.buffer = byteBuffer;
            this.isKeyFrame = bl;
            this.presentationTimestampUs = l3;
        }

        @CalledByNative(value="OutputBufferInfo")
        public int getIndex() {
            return this.index;
        }

        @CalledByNative(value="OutputBufferInfo")
        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        @CalledByNative(value="OutputBufferInfo")
        public boolean isKeyFrame() {
            return this.isKeyFrame;
        }

        @CalledByNative(value="OutputBufferInfo")
        public long getPresentationTimestampUs() {
            return this.presentationTimestampUs;
        }
    }

    public static class EncoderProperties {
        public final String codecName;
        public final int colorFormat;
        public final BitrateAdjustmentType bitrateAdjustmentType;

        public EncoderProperties(String string2, int n3, BitrateAdjustmentType bitrateAdjustmentType) {
            this.codecName = string2;
            this.colorFormat = n3;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    public static class MediaCodecProperties {
        public final String codecPrefix;
        public final int minSdk;
        public final BitrateAdjustmentType bitrateAdjustmentType;

        public MediaCodecProperties(String string2, int n3, BitrateAdjustmentType bitrateAdjustmentType) {
            this.codecPrefix = string2;
            this.minSdk = n3;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
        }
    }

    public static enum H264Profile {
        CONSTRAINED_BASELINE(0),
        BASELINE(1),
        MAIN(2),
        CONSTRAINED_HIGH(3),
        HIGH(4);

        public final int value;

        public H264Profile(int n4) {
            this.value = n4;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum BitrateAdjustmentType {
        NO_ADJUSTMENT,
        FRAMERATE_ADJUSTMENT,
        DYNAMIC_ADJUSTMENT;

    }

    public static enum VideoCodecType {
        VIDEO_CODEC_UNKNOWN,
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;


        @CalledByNative(value="VideoCodecType")
        public static VideoCodecType fromNativeIndex(int n3) {
            return VideoCodecType.values()[n3];
        }
    }

    public static class HwEncoderFactory
    implements VideoEncoderFactory {
        public final VideoCodecInfo[] supportedHardwareCodecs = HwEncoderFactory.getSupportedHardwareCodecs();

        public static boolean isSameCodec(VideoCodecInfo videoCodecInfo, VideoCodecInfo videoCodecInfo2) {
            if (!videoCodecInfo.name.equalsIgnoreCase(videoCodecInfo2.name)) {
                return false;
            }
            return videoCodecInfo.name.equalsIgnoreCase("H264") ? H264Utils.isSameH264Profile(videoCodecInfo.params, videoCodecInfo2.params) : true;
        }

        public static boolean isCodecSupported(VideoCodecInfo[] videoCodecInfoArray, VideoCodecInfo videoCodecInfo) {
            int n3 = videoCodecInfoArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!HwEncoderFactory.isSameCodec(videoCodecInfoArray[i3], videoCodecInfo)) continue;
                return true;
            }
            return false;
        }

        public static VideoCodecInfo[] getSupportedHardwareCodecs() {
            HashMap<String, String> hashMap;
            ArrayList<VideoCodecInfo> arrayList;
            ArrayList<VideoCodecInfo> arrayList2 = arrayList;
            arrayList = new ArrayList<VideoCodecInfo>();
            if (MediaCodecVideoEncoder.isVp8HwSupported()) {
                HashMap<String, String> hashMap2;
                Logging.d(MediaCodecVideoEncoder.TAG, "VP8 HW Encoder supported.");
                hashMap = hashMap2;
                hashMap2 = new HashMap<String, String>();
                arrayList2.add(new VideoCodecInfo("VP8", hashMap));
            }
            if (MediaCodecVideoEncoder.isVp9HwSupported()) {
                HashMap<String, String> hashMap3;
                Logging.d(MediaCodecVideoEncoder.TAG, "VP9 HW Encoder supported.");
                hashMap = hashMap3;
                hashMap3 = new HashMap<String, String>();
                arrayList2.add(new VideoCodecInfo("VP9", hashMap));
            }
            if (MediaCodecVideoDecoder.isH264HighProfileHwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "H.264 High Profile HW Encoder supported.");
                arrayList2.add(H264Utils.DEFAULT_H264_HIGH_PROFILE_CODEC);
            }
            if (MediaCodecVideoEncoder.isH264HwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "H.264 HW Encoder supported.");
                arrayList2.add(H264Utils.DEFAULT_H264_BASELINE_PROFILE_CODEC);
            }
            ArrayList<VideoCodecInfo> arrayList3 = arrayList2;
            return arrayList3.toArray(new VideoCodecInfo[arrayList3.size()]);
        }

        @Override
        public VideoCodecInfo[] getSupportedCodecs() {
            return this.supportedHardwareCodecs;
        }

        @Override
        @Nullable
        public VideoEncoder createEncoder(final VideoCodecInfo videoCodecInfo) {
            if (!HwEncoderFactory.isCodecSupported(this.supportedHardwareCodecs, videoCodecInfo)) {
                Logging.d(MediaCodecVideoEncoder.TAG, a.a("No HW video encoder for codec ").append(videoCodecInfo.name).toString());
                return null;
            }
            Logging.d(MediaCodecVideoEncoder.TAG, a.a("Create HW video encoder for ").append(videoCodecInfo.name).toString());
            return new WrappedNativeVideoEncoder(){

                @Override
                public long createNativeVideoEncoder() {
                    return MediaCodecVideoEncoder.nativeCreateEncoder(videoCodecInfo, staticEglBase instanceof EglBase14);
                }

                @Override
                public boolean isHardwareEncoder() {
                    return true;
                }
            };
        }
    }
}

