/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import org.webrtc.AndroidVideoDecoder;
import org.webrtc.EglBase;
import org.webrtc.Logging;
import org.webrtc.MediaCodecUtils;
import org.webrtc.MediaCodecWrapperFactoryImpl;
import org.webrtc.Predicate;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoDecoderFactory;

public class MediaCodecVideoDecoderFactory
implements VideoDecoderFactory {
    public static final String TAG = "MediaCodecVideoDecoderFactory";
    @Nullable
    public final EglBase.Context sharedContext;
    @Nullable
    public final Predicate<MediaCodecInfo> codecAllowedPredicate;

    public MediaCodecVideoDecoderFactory(@Nullable EglBase.Context context, @Nullable Predicate<MediaCodecInfo> predicate) {
        this.sharedContext = context;
        this.codecAllowedPredicate = predicate;
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecType videoCodecType) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i3 = 0; i3 < MediaCodecList.getCodecCount(); ++i3) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder() || !this.isSupportedCodec(mediaCodecInfo, videoCodecType)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        mediaCodecInfo.getName();
        if (!MediaCodecUtils.codecSupportsType(mediaCodecInfo, videoCodecType)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType())) == null) {
            return false;
        }
        return this.isCodecAllowed(mediaCodecInfo);
    }

    private boolean isCodecAllowed(MediaCodecInfo mediaCodecInfo) {
        Logging.e(TAG, a.a("isCodecAllowed: ").append(mediaCodecInfo.getName()).toString());
        return true;
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo mediaCodecInfo) {
        String string2 = mediaCodecInfo.getName();
        if (Build.VERSION.SDK_INT >= 21 && string2.startsWith("OMX.qcom.")) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && string2.startsWith("OMX.Exynos.");
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo object) {
        MediaCodecInfo mediaCodecInfo = this.findCodecForType((VideoCodecType)((Object)(object = VideoCodecType.valueOf(((VideoCodecInfo)object).getName()))));
        if (mediaCodecInfo == null) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(((VideoCodecType)((Object)object)).mimeType());
        return new AndroidVideoDecoder(new MediaCodecWrapperFactoryImpl(), mediaCodecInfo.getName(), (VideoCodecType)((Object)object), MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, codecCapabilities), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> arrayList;
        ArrayList<VideoCodecInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<VideoCodecInfo>();
        VideoCodecType[] videoCodecTypeArray = new VideoCodecType[3];
        VideoCodecType[] videoCodecTypeArray2 = videoCodecTypeArray;
        videoCodecTypeArray[0] = VideoCodecType.VP8;
        videoCodecTypeArray[1] = VideoCodecType.VP9;
        videoCodecTypeArray[2] = VideoCodecType.H264;
        int n3 = videoCodecTypeArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            VideoCodecType videoCodecType = videoCodecTypeArray2[i3];
            MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
            if (mediaCodecInfo == null) continue;
            VideoCodecType videoCodecType2 = videoCodecType;
            String string2 = videoCodecType2.name();
            if (videoCodecType2 == VideoCodecType.H264 && this.isH264HighProfileSupported(mediaCodecInfo)) {
                arrayList2.add(new VideoCodecInfo(string2, MediaCodecUtils.getCodecProperties(videoCodecType, true)));
            }
            arrayList2.add(new VideoCodecInfo(string2, MediaCodecUtils.getCodecProperties(videoCodecType, false)));
        }
        ArrayList<VideoCodecInfo> arrayList3 = arrayList2;
        return arrayList3.toArray(new VideoCodecInfo[arrayList3.size()]);
    }
}

