/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.webrtc.CalledByNative;
import org.webrtc.CalledByNativeUnchecked;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.EglBase;
import org.webrtc.H264Utils;
import org.webrtc.Logging;
import org.webrtc.MediaCodecVideoEncoder;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.WrappedNativeVideoDecoder;

@Deprecated
public class MediaCodecVideoDecoder {
    public static final String TAG = "MediaCodecVideoDecoder";
    public static final long MAX_DECODE_TIME_MS = 200L;
    public static final String FORMAT_KEY_STRIDE = "stride";
    public static final String FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    public static final String FORMAT_KEY_CROP_LEFT = "crop-left";
    public static final String FORMAT_KEY_CROP_RIGHT = "crop-right";
    public static final String FORMAT_KEY_CROP_TOP = "crop-top";
    public static final String FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    public static final int DEQUEUE_INPUT_TIMEOUT = 500000;
    public static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    public static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    @Nullable
    public static MediaCodecVideoDecoder runningInstance;
    @Nullable
    public static MediaCodecVideoDecoderErrorCallback errorCallback;
    public static int codecErrors;
    public static Set<String> hwDecoderDisabledTypes;
    @Nullable
    public static EglBase eglBase;
    public static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    public static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    public static final String H264_MIME_TYPE = "video/avc";
    public static final String[] supportedVp9HwCodecPrefixes;
    public static final String supportedQcomH264HighProfileHwCodecPrefix = "OMX.qcom.";
    public static final String supportedExynosH264HighProfileHwCodecPrefix = "OMX.Exynos.";
    public static final String supportedMediaTekH264HighProfileHwCodecPrefix = "OMX.MTK.";
    public static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    public static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    public static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    public static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    public static final List<Integer> supportedColorList;
    @Nullable
    public Thread mediaCodecThread;
    @Nullable
    public MediaCodec mediaCodec;
    public ByteBuffer[] inputBuffers;
    public ByteBuffer[] outputBuffers;
    public int colorFormat;
    public int width;
    public int height;
    public int stride;
    public int sliceHeight;
    public boolean hasDecodedFirstFrame;
    public final Queue<TimeStamps> decodeStartTimeMs = new ArrayDeque<TimeStamps>();
    @Nullable
    public TextureListener textureListener;
    public int droppedFrames;
    @Nullable
    public Surface surface;
    public final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers = new ArrayDeque<DecodedOutputBuffer>();

    public static VideoDecoderFactory createFactory() {
        return new DefaultVideoDecoderFactory(new HwDecoderFactory());
    }

    public static final String[] supportedVp8HwCodecPrefixes() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        new ArrayList<String>().add(supportedQcomH264HighProfileHwCodecPrefix);
        arrayList2.add("OMX.Nvidia.");
        arrayList2.add(supportedExynosH264HighProfileHwCodecPrefix);
        arrayList2.add("OMX.Intel.");
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekVP8").equals("Enabled") && Build.VERSION.SDK_INT >= 24) {
            arrayList2.add(supportedMediaTekH264HighProfileHwCodecPrefix);
        }
        ArrayList<String> arrayList3 = arrayList2;
        return arrayList3.toArray(new String[arrayList3.size()]);
    }

    public static final String[] supportedH264HwCodecPrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(supportedQcomH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.Intel.");
        arrayList.add(supportedExynosH264HighProfileHwCodecPrefix);
        arrayList.add(supportedMediaTekH264HighProfileHwCodecPrefix);
        arrayList.add("OMX.hisi.");
        Logging.e(TAG, "\u5df2\u6dfb\u52a0\u5bf9\u6d77\u601d\u3001MTK H264\u89e3\u7801\u5668\u7684\u652f\u6301");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void setEglContext(EglBase.Context context) {
        if (eglBase != null) {
            Logging.w(TAG, "Egl context already set.");
            eglBase.release();
        }
        eglBase = EglBase.create(context);
    }

    public static void disposeEglContext() {
        EglBase eglBase = MediaCodecVideoDecoder.eglBase;
        if (eglBase != null) {
            eglBase.release();
            MediaCodecVideoDecoder.eglBase = null;
        }
    }

    public static boolean useSurface() {
        return eglBase != null;
    }

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes()) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwDecoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes) != null;
    }

    public static boolean isH264HwSupported() {
        boolean bl = !hwDecoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, MediaCodecVideoDecoder.supportedH264HwCodecPrefixes()) != null;
        Logging.e(TAG, "isH264HwSupported:" + bl);
        return bl;
    }

    public static boolean isH264HighProfileHwSupported() {
        String[] stringArray;
        if (hwDecoderDisabledTypes.contains(H264_MIME_TYPE)) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = supportedQcomH264HighProfileHwCodecPrefix;
            if (MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, stringArray) != null) {
                return true;
            }
        }
        if (Build.VERSION.SDK_INT >= 23) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = supportedExynosH264HighProfileHwCodecPrefix;
            if (MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, stringArray) != null) {
                return true;
            }
        }
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-MediaTekH264").equals("Enabled") && Build.VERSION.SDK_INT >= 27) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = supportedMediaTekH264HighProfileHwCodecPrefix;
            if (MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, stringArray) != null) {
                return true;
            }
        }
        return false;
    }

    public static void printStackTrace() {
        Object object = runningInstance;
        if (object != null && (object = object.mediaCodecThread) != null && ((StackTraceElement[])(object = object.getStackTrace())).length > 0) {
            Logging.d(TAG, "MediaCodecVideoDecoder stacks trace:");
            int n3 = ((StackTraceElement[])object).length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Logging.d(TAG, object[i3].toString());
            }
        }
    }

    @Nullable
    public static DecoderProperties findDecoder(String string2, String[] stringArray) {
        Logging.e(TAG, "findDecoder: " + string2);
        if (Build.VERSION.SDK_INT < 19) {
            Logging.e(TAG, a.a("\u7cfb\u7edf\u7248\u672c\u8fc7\u4f4e\uff0c\u65e0\u6cd5\u6253\u5f00\u786c\u4ef6\u89e3\u7801\u5668: ").append(Build.VERSION.SDK_INT).toString());
            return null;
        }
        Logging.d(TAG, "Trying to find HW decoder for mime " + string2);
        for (int i3 = 0; i3 < MediaCodecList.getCodecCount(); ++i3) {
            int n3;
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || mediaCodecInfo.isEncoder()) continue;
            String string3 = null;
            String[] stringArray2 = mediaCodecInfo.getSupportedTypes();
            int n4 = stringArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (!stringArray2[n3].equals(string2)) continue;
                string3 = mediaCodecInfo.getName();
                break;
            }
            if (string3 == null) continue;
            Logging.d(TAG, "Found candidate decoder " + string3);
            boolean bl = false;
            n4 = stringArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (!string3.startsWith(stringArray[n3])) continue;
                bl = true;
                break;
            }
            if (string2.equals(H264_MIME_TYPE)) {
                Logging.e(TAG, "\u5f3a\u5236\u6253\u5f00\u89e3\u7801\u5668: " + string2);
            } else if (!bl) continue;
            try {
                mediaCodecInfo = mediaCodecInfo.getCapabilitiesForType(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve decoder capabilities", illegalArgumentException);
            }
            Object object = mediaCodecInfo.colorFormats;
            n4 = mediaCodecInfo.colorFormats.length;
            for (n3 = 0; n3 < n4; ++n3) {
                Logging.v(TAG, a.a("   Color: 0x").append(Integer.toHexString(object[n3])).toString());
            }
            object = supportedColorList.iterator();
            while (object.hasNext()) {
                n4 = (Integer)object.next();
                int[] nArray = mediaCodecInfo.colorFormats;
                int n5 = mediaCodecInfo.colorFormats.length;
                for (int i4 = 0; i4 < n5; ++i4) {
                    int n6 = nArray[i4];
                    if (n6 != n4) continue;
                    Logging.d(TAG, "Found target decoder " + string3 + ". Color: 0x" + Integer.toHexString(n6));
                    return new DecoderProperties(string3, n6);
                }
            }
            continue;
        }
        Logging.d(TAG, "No HW decoder found for mime " + string2);
        return null;
    }

    @CalledByNative
    public MediaCodecVideoDecoder() {
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() == Thread.currentThread().getId()) {
            return;
        }
        throw new IllegalStateException(a.a("MediaCodecVideoDecoder previously operated on ").append(this.mediaCodecThread).append(" but is now called on ").append(Thread.currentThread()).toString());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNativeUnchecked
    private boolean initDecode(VideoCodecType object, int n3, int n4) {
        void var5_9;
        String string2;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("initDecode: Forgot to release()?");
        }
        if (object == VideoCodecType.VIDEO_CODEC_VP8) {
            string2 = VP8_MIME_TYPE;
            String[] stringArray = MediaCodecVideoDecoder.supportedVp8HwCodecPrefixes();
        } else if (object == VideoCodecType.VIDEO_CODEC_VP9) {
            string2 = VP9_MIME_TYPE;
            String[] stringArray = supportedVp9HwCodecPrefixes;
        } else {
            if (object != VideoCodecType.VIDEO_CODEC_H264) {
                throw new RuntimeException("initDecode: Non-supported codec " + object);
            }
            string2 = H264_MIME_TYPE;
            String[] stringArray = MediaCodecVideoDecoder.supportedH264HwCodecPrefixes();
        }
        DecoderProperties decoderProperties = MediaCodecVideoDecoder.findDecoder(string2, (String[])var5_9);
        if (decoderProperties == null) {
            throw new RuntimeException("Cannot find HW decoder for " + object);
        }
        Logging.d(TAG, "Java initDecode: " + object + " : " + n3 + " x " + n4 + ". Color: 0x" + Integer.toHexString(decoderProperties.colorFormat) + ". Use Surface: " + MediaCodecVideoDecoder.useSurface());
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        try {
            this.width = n3;
            this.height = n4;
            this.stride = n3;
            this.sliceHeight = n4;
            if (MediaCodecVideoDecoder.useSurface() && (object = SurfaceTextureHelper.create("Decoder SurfaceTextureHelper", eglBase.getEglBaseContext())) != null) {
                this.textureListener = new TextureListener((SurfaceTextureHelper)object);
                this.textureListener.setSize(n3, n4);
                this.surface = new Surface(((SurfaceTextureHelper)object).getSurfaceTexture());
            }
            object = MediaFormat.createVideoFormat((String)string2, (int)n3, (int)n4);
            if (!MediaCodecVideoDecoder.useSurface()) {
                object.setInteger("color-format", decoderProperties.colorFormat);
            }
            Logging.d(TAG, "  Format: " + object);
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(decoderProperties.codecName);
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media decoder");
                return false;
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            MediaCodecVideoDecoder mediaCodecVideoDecoder2 = this;
            mediaCodecVideoDecoder2.mediaCodec.configure((MediaFormat)object, this.surface, null, 0);
            mediaCodecVideoDecoder2.mediaCodec.start();
            mediaCodecVideoDecoder.colorFormat = decoderProperties.colorFormat;
            mediaCodecVideoDecoder.outputBuffers = mediaCodecVideoDecoder.mediaCodec.getOutputBuffers();
            mediaCodecVideoDecoder.inputBuffers = mediaCodecVideoDecoder.mediaCodec.getInputBuffers();
            mediaCodecVideoDecoder.decodeStartTimeMs.clear();
            mediaCodecVideoDecoder.hasDecodedFirstFrame = false;
            mediaCodecVideoDecoder.dequeuedSurfaceOutputBuffers.clear();
            mediaCodecVideoDecoder.droppedFrames = 0;
            Logging.d(TAG, "Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            return false;
        }
    }

    @CalledByNativeUnchecked
    private void reset(int n3, int n4) {
        if (this.mediaCodecThread != null && this.mediaCodec != null) {
            Logging.d(TAG, "Java reset: " + n3 + " x " + n4);
            this.mediaCodec.flush();
            this.width = n3;
            this.height = n4;
            TextureListener textureListener = this.textureListener;
            if (textureListener != null) {
                textureListener.setSize(n3, n4);
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            mediaCodecVideoDecoder.decodeStartTimeMs.clear();
            mediaCodecVideoDecoder.dequeuedSurfaceOutputBuffers.clear();
            mediaCodecVideoDecoder.hasDecodedFirstFrame = false;
            mediaCodecVideoDecoder.droppedFrames = 0;
            return;
        }
        throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
    }

    @CalledByNativeUnchecked
    private void release() {
        Runnable runnable;
        CountDownLatch countDownLatch;
        Logging.d(TAG, a.a("Java releaseDecoder. Total number of dropped frames: ").append(this.droppedFrames).toString());
        this.checkOnMediaCodecThread();
        final CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch = new CountDownLatch(1);
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    1 v02 = this;
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread");
                    v02.MediaCodecVideoDecoder.this.mediaCodec.stop();
                    v02.MediaCodecVideoDecoder.this.mediaCodec.release();
                    Logging.d(MediaCodecVideoDecoder.TAG, "Java releaseDecoder on release thread done");
                }
                catch (Exception exception) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Media decoder release failed", exception);
                }
                countDownLatch2.countDown();
            }
        };
        new Thread(runnable2).start();
        if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
            Logging.e(TAG, "Media decoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, a.a("Invoke codec error callback. Errors: ").append(codecErrors).toString());
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.mediaCodec = null;
        mediaCodecVideoDecoder.mediaCodecThread = null;
        runningInstance = null;
        if (MediaCodecVideoDecoder.useSurface()) {
            MediaCodecVideoDecoder mediaCodecVideoDecoder2 = this;
            mediaCodecVideoDecoder2.surface.release();
            mediaCodecVideoDecoder2.surface = null;
            mediaCodecVideoDecoder2.textureListener.release();
        }
        Logging.d(TAG, "Java releaseDecoder done");
    }

    @CalledByNativeUnchecked
    private int dequeueInputBuffer() {
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        try {
            return mediaCodecVideoDecoder.mediaCodec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    @CalledByNativeUnchecked
    private boolean queueInputBuffer(int n3, int n4, long l3, long l4, long l5) {
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        try {
            mediaCodecVideoDecoder.inputBuffers[n3].position(0);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "decode failed", illegalStateException);
            return false;
        }
        mediaCodecVideoDecoder.inputBuffers[n3].limit(n4);
        mediaCodecVideoDecoder.decodeStartTimeMs.add(new TimeStamps(SystemClock.elapsedRealtime(), l4, l5));
        mediaCodecVideoDecoder.mediaCodec.queueInputBuffer(n3, 0, n4, l3, 0);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CalledByNativeUnchecked
    @Nullable
    private DecodedOutputBuffer dequeueOutputBuffer(int n3) {
        MediaCodec.BufferInfo bufferInfo;
        MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
        mediaCodecVideoDecoder.checkOnMediaCodecThread();
        if (mediaCodecVideoDecoder.decodeStartTimeMs.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
        bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            int n4 = this.mediaCodec.dequeueOutputBuffer(bufferInfo2, TimeUnit.MILLISECONDS.toMicros(n3));
            switch (n4) {
                default: {
                    this.hasDecodedFirstFrame = true;
                    TimeStamps timeStamps = this.decodeStartTimeMs.remove();
                    long l3 = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
                    if (l3 <= 200L) return new DecodedOutputBuffer(n4, bufferInfo2.offset, bufferInfo2.size, TimeUnit.MICROSECONDS.toMillis(bufferInfo2.presentationTimeUs), timeStamps.timeStampMs, timeStamps.ntpTimeStampMs, l3, SystemClock.elapsedRealtime());
                    Logging.e(TAG, "Very high decode time: " + l3 + "ms. Q size: " + this.decodeStartTimeMs.size() + ". Might be caused by resuming H264 decoding after a pause.");
                    l3 = 200L;
                    return new DecodedOutputBuffer(n4, bufferInfo2.offset, bufferInfo2.size, TimeUnit.MICROSECONDS.toMillis(bufferInfo2.presentationTimeUs), timeStamps.timeStampMs, timeStamps.ntpTimeStampMs, l3, SystemClock.elapsedRealtime());
                }
                case -1: {
                    return null;
                }
                case -2: {
                    int n5;
                    int n6;
                    MediaFormat mediaFormat = this.mediaCodec.getOutputFormat();
                    Logging.d(TAG, a.a("Decoder format changed: ").append(mediaFormat.toString()).toString());
                    if (mediaFormat.containsKey(FORMAT_KEY_CROP_LEFT) && mediaFormat.containsKey(FORMAT_KEY_CROP_RIGHT) && mediaFormat.containsKey(FORMAT_KEY_CROP_BOTTOM) && mediaFormat.containsKey(FORMAT_KEY_CROP_TOP)) {
                        MediaFormat mediaFormat2 = mediaFormat;
                        n6 = mediaFormat2.getInteger(FORMAT_KEY_CROP_RIGHT) + 1 - mediaFormat.getInteger(FORMAT_KEY_CROP_LEFT);
                        n5 = mediaFormat2.getInteger(FORMAT_KEY_CROP_BOTTOM) + 1 - mediaFormat.getInteger(FORMAT_KEY_CROP_TOP);
                    } else {
                        MediaFormat mediaFormat3 = mediaFormat;
                        n6 = mediaFormat3.getInteger("width");
                        n5 = mediaFormat3.getInteger("height");
                    }
                    if (this.hasDecodedFirstFrame && (n6 != this.width || n5 != this.height)) {
                        throw new RuntimeException(a.a("Unexpected size change. Configured ").append(this.width).append("*").append(this.height).append(". New ").append(n6).append("*").append(n5).toString());
                    }
                    this.width = n6;
                    this.height = n5;
                    TextureListener textureListener = this.textureListener;
                    if (textureListener != null) {
                        textureListener.setSize(this.width, this.height);
                    }
                    if (!MediaCodecVideoDecoder.useSurface() && mediaFormat.containsKey("color-format")) {
                        this.colorFormat = mediaFormat.getInteger("color-format");
                        Logging.d(TAG, a.a("Color: 0x").append(Integer.toHexString(this.colorFormat)).toString());
                        if (!supportedColorList.contains(this.colorFormat)) {
                            throw new IllegalStateException(a.a("Non supported color format: ").append(this.colorFormat).toString());
                        }
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_STRIDE)) {
                        this.stride = mediaFormat.getInteger(FORMAT_KEY_STRIDE);
                    }
                    if (mediaFormat.containsKey(FORMAT_KEY_SLICE_HEIGHT)) {
                        this.sliceHeight = mediaFormat.getInteger(FORMAT_KEY_SLICE_HEIGHT);
                    }
                    MediaCodecVideoDecoder mediaCodecVideoDecoder2 = this;
                    Logging.d(TAG, a.a("Frame stride and slice height: ").append(this.stride).append(" x ").append(this.sliceHeight).toString());
                    mediaCodecVideoDecoder2.stride = Math.max(mediaCodecVideoDecoder2.width, this.stride);
                    mediaCodecVideoDecoder2.sliceHeight = Math.max(mediaCodecVideoDecoder2.height, this.sliceHeight);
                    continue block5;
                }
                case -3: {
                    MediaCodecVideoDecoder mediaCodecVideoDecoder3 = this;
                    mediaCodecVideoDecoder3.outputBuffers = mediaCodecVideoDecoder3.mediaCodec.getOutputBuffers();
                    Logging.d(TAG, a.a("Decoder output buffers changed: ").append(this.outputBuffers.length).toString());
                    if (mediaCodecVideoDecoder3.hasDecodedFirstFrame) throw new RuntimeException("Unexpected output buffer change event.");
                    continue block5;
                }
            }
            break;
        }
    }

    @CalledByNativeUnchecked
    @Nullable
    private DecodedTextureBuffer dequeueTextureBuffer(int n3) {
        this.checkOnMediaCodecThread();
        if (MediaCodecVideoDecoder.useSurface()) {
            Object object = this.dequeueOutputBuffer(n3);
            if (object != null) {
                this.dequeuedSurfaceOutputBuffers.add((DecodedOutputBuffer)object);
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder = this;
            mediaCodecVideoDecoder.MaybeRenderDecodedTextureBuffer();
            object = mediaCodecVideoDecoder.textureListener.dequeueTextureBuffer(n3);
            if (object != null) {
                this.MaybeRenderDecodedTextureBuffer();
                return object;
            }
            if (this.dequeuedSurfaceOutputBuffers.size() < Math.min(3, this.outputBuffers.length) && (n3 <= 0 || this.dequeuedSurfaceOutputBuffers.isEmpty())) {
                return null;
            }
            MediaCodecVideoDecoder mediaCodecVideoDecoder2 = this;
            ++mediaCodecVideoDecoder2.droppedFrames;
            DecodedOutputBuffer decodedOutputBuffer = mediaCodecVideoDecoder2.dequeuedSurfaceOutputBuffers.remove();
            if (n3 > 0) {
                Logging.w(TAG, a.a("Draining decoder. Dropping frame with TS: ").append(decodedOutputBuffer.presentationTimeStampMs).append(". Total number of dropped frames: ").append(this.droppedFrames).toString());
            } else {
                Logging.w(TAG, a.a("Too many output buffers ").append(this.dequeuedSurfaceOutputBuffers.size()).append(". Dropping frame with TS: ").append(decodedOutputBuffer.presentationTimeStampMs).append(". Total number of dropped frames: ").append(this.droppedFrames).toString());
            }
            this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, false);
            DecodedOutputBuffer decodedOutputBuffer2 = decodedOutputBuffer;
            long l3 = decodedOutputBuffer2.presentationTimeStampMs;
            long l4 = decodedOutputBuffer2.timeStampMs;
            long l5 = decodedOutputBuffer2.ntpTimeStampMs;
            long l6 = decodedOutputBuffer2.decodeTimeMs;
            long l7 = SystemClock.elapsedRealtime() - decodedOutputBuffer.endDecodeTimeMs;
            return new DecodedTextureBuffer(null, l3, l4, l5, l6, l7);
        }
        throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
    }

    private void MaybeRenderDecodedTextureBuffer() {
        if (!((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).dequeuedSurfaceOutputBuffers.isEmpty() && !((MediaCodecVideoDecoder)((Object)decodedOutputBuffer)).textureListener.isWaitingForTexture()) {
            MediaCodecVideoDecoder mediaCodecVideoDecoder = decodedOutputBuffer;
            DecodedOutputBuffer decodedOutputBuffer = mediaCodecVideoDecoder.dequeuedSurfaceOutputBuffers.remove();
            mediaCodecVideoDecoder.textureListener.addBufferToRender(decodedOutputBuffer);
            mediaCodecVideoDecoder.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, true);
            return;
        }
    }

    @CalledByNativeUnchecked
    private void returnDecodedOutputBuffer(int n3) {
        this.checkOnMediaCodecThread();
        if (!MediaCodecVideoDecoder.useSurface()) {
            this.mediaCodec.releaseOutputBuffer(n3, false);
            return;
        }
        throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
    }

    public static native long nativeCreateDecoder(String var0, boolean var1);

    static {
        hwDecoderDisabledTypes = new HashSet<String>();
        supportedVp9HwCodecPrefixes = new String[]{supportedQcomH264HighProfileHwCodecPrefix, supportedExynosH264HighProfileHwCodecPrefix};
        supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876);
    }

    @CalledByNative
    public ByteBuffer[] getInputBuffers() {
        return this.inputBuffers;
    }

    @CalledByNative
    public ByteBuffer[] getOutputBuffers() {
        return this.outputBuffers;
    }

    @CalledByNative
    public int getColorFormat() {
        return this.colorFormat;
    }

    @CalledByNative
    public int getWidth() {
        return this.width;
    }

    @CalledByNative
    public int getHeight() {
        return this.height;
    }

    @CalledByNative
    public int getStride() {
        return this.stride;
    }

    @CalledByNative
    public int getSliceHeight() {
        return this.sliceHeight;
    }

    public class TextureListener
    implements VideoSink {
        public final SurfaceTextureHelper surfaceTextureHelper;
        public final Object newFrameLock = new Object();
        @Nullable
        public DecodedOutputBuffer bufferToRender;
        @Nullable
        public DecodedTextureBuffer renderedBuffer;

        public TextureListener(SurfaceTextureHelper surfaceTextureHelper) {
            this.surfaceTextureHelper = surfaceTextureHelper;
            surfaceTextureHelper.startListening(this);
        }

        public void addBufferToRender(DecodedOutputBuffer decodedOutputBuffer) {
            if (this.bufferToRender == null) {
                this.bufferToRender = decodedOutputBuffer;
                return;
            }
            Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected addBufferToRender() called while waiting for a texture.");
            throw new IllegalStateException("Waiting for a texture.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWaitingForTexture() {
            TextureListener textureListener = object;
            Object object = textureListener.newFrameLock;
            synchronized (object) {
                boolean bl = textureListener.bufferToRender != null;
                return bl;
            }
        }

        public void setSize(int n3, int n4) {
            this.surfaceTextureHelper.setTextureSize(n3, n4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onFrame(VideoFrame refCounted) {
            TextureListener textureListener = this;
            Object object = textureListener.newFrameLock;
            synchronized (object) {
                if (textureListener.renderedBuffer == null) {
                    DecodedTextureBuffer decodedTextureBuffer;
                    TextureListener textureListener2 = this;
                    VideoFrame.Buffer buffer = ((VideoFrame)refCounted).getBuffer();
                    buffer.retain();
                    decodedTextureBuffer(buffer, this.bufferToRender.presentationTimeStampMs, this.bufferToRender.timeStampMs, this.bufferToRender.ntpTimeStampMs, this.bufferToRender.decodeTimeMs, SystemClock.elapsedRealtime() - this.bufferToRender.endDecodeTimeMs);
                    textureListener2.renderedBuffer = decodedTextureBuffer;
                    textureListener2.bufferToRender = null;
                    textureListener2.newFrameLock.notifyAll();
                    return;
                }
                Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected onFrame() called while already holding a texture.");
                throw new IllegalStateException("Already holding a texture.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public DecodedTextureBuffer dequeueTextureBuffer(int var1_1) {
            v0 = this;
            var2_2 = v0.newFrameLock;
            synchronized (var2_2) {
                if (v0.renderedBuffer != null || var1_1 <= 0) ** GOTO lbl18
                {
                    catch (Throwable v1) {
                        throw v1;
                    }
                }
                if (!this.isWaitingForTexture()) ** GOTO lbl18
                v2 = this.newFrameLock;
                try {
                    v2.wait(var1_1);
                    ** GOTO lbl18
                }
                catch (InterruptedException v3) {
                    Thread.currentThread().interrupt();
lbl18:
                    // 4 sources

                    this.renderedBuffer = null;
                    return this.renderedBuffer;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void release() {
            TextureListener textureListener = this;
            textureListener.surfaceTextureHelper.stopListening();
            Object object = textureListener.newFrameLock;
            synchronized (object) {
                if (textureListener.renderedBuffer != null) {
                    this.renderedBuffer.getVideoFrameBuffer().release();
                    this.renderedBuffer = null;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                this.surfaceTextureHelper.dispose();
                return;
            }
        }
    }

    public static class DecodedTextureBuffer {
        public final VideoFrame.Buffer videoFrameBuffer;
        public final long presentationTimeStampMs;
        public final long timeStampMs;
        public final long ntpTimeStampMs;
        public final long decodeTimeMs;
        public final long frameDelayMs;

        public DecodedTextureBuffer(VideoFrame.Buffer buffer, long l3, long l4, long l5, long l6, long l7) {
            this.videoFrameBuffer = buffer;
            this.presentationTimeStampMs = l3;
            this.timeStampMs = l4;
            this.ntpTimeStampMs = l5;
            this.decodeTimeMs = l6;
            this.frameDelayMs = l7;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        public VideoFrame.Buffer getVideoFrameBuffer() {
            return this.videoFrameBuffer;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        public long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        public long getTimeStampMs() {
            return this.timeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        public long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        public long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }

        @CalledByNative(value="DecodedTextureBuffer")
        public long getFrameDelayMs() {
            return this.frameDelayMs;
        }
    }

    public static class DecodedOutputBuffer {
        public final int index;
        public final int offset;
        public final int size;
        public final long presentationTimeStampMs;
        public final long timeStampMs;
        public final long ntpTimeStampMs;
        public final long decodeTimeMs;
        public final long endDecodeTimeMs;

        public DecodedOutputBuffer(int n3, int n4, int n5, long l3, long l4, long l5, long l6, long l7) {
            this.index = n3;
            this.offset = n4;
            this.size = n5;
            this.presentationTimeStampMs = l3;
            this.timeStampMs = l4;
            this.ntpTimeStampMs = l5;
            this.decodeTimeMs = l6;
            this.endDecodeTimeMs = l7;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        public int getIndex() {
            return this.index;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        public int getOffset() {
            return this.offset;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        public int getSize() {
            return this.size;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        public long getPresentationTimestampMs() {
            return this.presentationTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        public long getTimestampMs() {
            return this.timeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        public long getNtpTimestampMs() {
            return this.ntpTimeStampMs;
        }

        @CalledByNative(value="DecodedOutputBuffer")
        public long getDecodeTimeMs() {
            return this.decodeTimeMs;
        }
    }

    public static class TimeStamps {
        public final long decodeStartTimeMs;
        public final long timeStampMs;
        public final long ntpTimeStampMs;

        public TimeStamps(long l3, long l4, long l5) {
            this.decodeStartTimeMs = l3;
            this.timeStampMs = l4;
            this.ntpTimeStampMs = l5;
        }
    }

    public static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        public DecoderProperties(String string2, int n3) {
            this.codecName = string2;
            this.colorFormat = n3;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_UNKNOWN,
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;


        @CalledByNative(value="VideoCodecType")
        public static VideoCodecType fromNativeIndex(int n3) {
            return VideoCodecType.values()[n3];
        }
    }

    public static class HwDecoderFactory
    implements VideoDecoderFactory {
        public final VideoCodecInfo[] supportedHardwareCodecs = HwDecoderFactory.getSupportedHardwareCodecs();

        public static boolean isSameCodec(VideoCodecInfo videoCodecInfo, VideoCodecInfo videoCodecInfo2) {
            if (!videoCodecInfo.name.equalsIgnoreCase(videoCodecInfo2.name)) {
                return false;
            }
            return videoCodecInfo.name.equalsIgnoreCase("H264") ? H264Utils.isSameH264Profile(videoCodecInfo.params, videoCodecInfo2.params) : true;
        }

        public static boolean isCodecSupported(VideoCodecInfo[] videoCodecInfoArray, VideoCodecInfo videoCodecInfo) {
            int n3 = videoCodecInfoArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!HwDecoderFactory.isSameCodec(videoCodecInfoArray[i3], videoCodecInfo)) continue;
                return true;
            }
            return false;
        }

        public static VideoCodecInfo[] getSupportedHardwareCodecs() {
            HashMap<String, String> hashMap;
            ArrayList<VideoCodecInfo> arrayList;
            ArrayList<VideoCodecInfo> arrayList2 = arrayList;
            arrayList = new ArrayList<VideoCodecInfo>();
            if (MediaCodecVideoDecoder.isVp8HwSupported()) {
                HashMap<String, String> hashMap2;
                Logging.d(MediaCodecVideoDecoder.TAG, "VP8 HW Decoder supported.");
                hashMap = hashMap2;
                hashMap2 = new HashMap<String, String>();
                arrayList2.add(new VideoCodecInfo("VP8", hashMap));
            }
            if (MediaCodecVideoDecoder.isVp9HwSupported()) {
                HashMap<String, String> hashMap3;
                Logging.d(MediaCodecVideoDecoder.TAG, "VP9 HW Decoder supported.");
                hashMap = hashMap3;
                hashMap3 = new HashMap<String, String>();
                arrayList2.add(new VideoCodecInfo("VP9", hashMap));
            }
            if (MediaCodecVideoDecoder.isH264HighProfileHwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "H.264 High Profile HW Decoder supported.");
                arrayList2.add(H264Utils.DEFAULT_H264_HIGH_PROFILE_CODEC);
            }
            if (MediaCodecVideoDecoder.isH264HwSupported()) {
                Logging.d(MediaCodecVideoDecoder.TAG, "H.264 HW Decoder supported.");
                arrayList2.add(H264Utils.DEFAULT_H264_BASELINE_PROFILE_CODEC);
            }
            ArrayList<VideoCodecInfo> arrayList3 = arrayList2;
            return arrayList3.toArray(new VideoCodecInfo[arrayList3.size()]);
        }

        @Override
        public VideoCodecInfo[] getSupportedCodecs() {
            return this.supportedHardwareCodecs;
        }

        @Override
        @Nullable
        public VideoDecoder createDecoder(final VideoCodecInfo videoCodecInfo) {
            if (!HwDecoderFactory.isCodecSupported(this.supportedHardwareCodecs, videoCodecInfo)) {
                Logging.d(MediaCodecVideoDecoder.TAG, a.a("No HW video decoder for codec ").append(videoCodecInfo.name).toString());
                return null;
            }
            Logging.d(MediaCodecVideoDecoder.TAG, a.a("Create HW video decoder for ").append(videoCodecInfo.name).toString());
            return new WrappedNativeVideoDecoder(){

                @Override
                public long createNativeVideoDecoder() {
                    return MediaCodecVideoDecoder.nativeCreateDecoder(videoCodecInfo.name, MediaCodecVideoDecoder.useSurface());
                }
            };
        }
    }
}

