/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodecInfo;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.webrtc.H264Utils;
import org.webrtc.VideoCodecType;

public class MediaCodecUtils {
    public static final String TAG = "MediaCodecUtils";
    public static final String EXYNOS_PREFIX = "OMX.Exynos.";
    public static final String INTEL_PREFIX = "OMX.Intel.";
    public static final String NVIDIA_PREFIX = "OMX.Nvidia.";
    public static final String QCOM_PREFIX = "OMX.qcom.";
    public static final String[] SOFTWARE_IMPLEMENTATION_PREFIXES = new String[]{"OMX.google.", "OMX.SEC."};
    public static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    public static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    public static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    public static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    public static final int[] DECODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876};
    public static final int[] ENCODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391876};
    public static final int[] TEXTURE_COLOR_FORMATS = MediaCodecUtils.getTextureColorFormats();

    public static int[] getTextureColorFormats() {
        if (Build.VERSION.SDK_INT >= 18) {
            return new int[]{2130708361};
        }
        return new int[0];
    }

    @Nullable
    public static Integer selectColorFormat(int[] nArray, MediaCodecInfo.CodecCapabilities codecCapabilities) {
        for (int n3 : nArray) {
            int[] nArray2 = codecCapabilities.colorFormats;
            int n4 = codecCapabilities.colorFormats.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                int n5 = nArray2[i3];
                if (n5 != n3) continue;
                return n5;
            }
        }
        return null;
    }

    public static boolean codecSupportsType(MediaCodecInfo stringArray, VideoCodecType videoCodecType) {
        for (String string2 : stringArray.getSupportedTypes()) {
            if (!videoCodecType.mimeType().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> getCodecProperties(VideoCodecType videoCodecType, boolean bl) {
        int n3 = videoCodecType.ordinal();
        if (n3 != 0 && n3 != 1) {
            if (n3 == 2) {
                return H264Utils.getDefaultH264Params(bl);
            }
            throw new IllegalArgumentException("Unsupported codec: " + (Object)((Object)videoCodecType));
        }
        return new HashMap<String, String>();
    }
}

