/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.webrtc.Loggable;

public class Logging {
    public static final Logger fallbackLogger = Logging.createFallbackLogger();
    public static volatile boolean loggingEnabled;
    @Nullable
    public static Loggable loggable;
    public static Severity loggableSeverity;

    public static Logger createFallbackLogger() {
        Logger logger = Logger.getLogger("org.webrtc.Logging");
        logger.setLevel(Level.ALL);
        return logger;
    }

    public static void injectLoggable(Loggable loggable, Severity severity) {
        if (loggable != null) {
            Logging.loggable = loggable;
            loggableSeverity = severity;
        }
    }

    public static void deleteInjectedLoggable() {
        loggable = null;
    }

    public static void enableLogThreads() {
        Logging.nativeEnableLogThreads();
    }

    public static void enableLogTimeStamps() {
        Logging.nativeEnableLogTimeStamps();
    }

    @Deprecated
    public static void enableTracing(String string2, EnumSet<TraceLevel> enumSet) {
    }

    public static synchronized void enableLogToDebugOutput(Severity severity) {
        if (loggable == null) {
            Logging.nativeEnableLogToDebugOutput(severity.ordinal());
            loggingEnabled = true;
            return;
        }
        throw new IllegalStateException("Logging to native debug output not supported while Loggable is injected. Delete the Loggable before calling this method.");
    }

    public static void log(Severity severity, String string2, String string3) {
        if (string2 != null && string3 != null) {
            if (loggable != null) {
                if (severity.ordinal() < loggableSeverity.ordinal()) {
                    return;
                }
                loggable.onLogMessage(string3, severity, string2);
                return;
            }
            if (loggingEnabled) {
                Logging.nativeLog(severity.ordinal(), string2, string3);
                return;
            }
            int n3 = severity.ordinal();
            Level level = n3 != 1 ? (n3 != 2 ? (n3 != 3 ? Level.FINE : Level.SEVERE) : Level.WARNING) : Level.INFO;
            fallbackLogger.log(level, string2 + ": " + string3);
            return;
        }
        throw new IllegalArgumentException("Logging tag or message may not be null.");
    }

    public static void d(String string2, String string3) {
        Logging.log(Severity.LS_INFO, string2, string3);
    }

    public static void e(String string2, String string3) {
        Logging.log(Severity.LS_ERROR, string2, string3);
    }

    public static void w(String string2, String string3) {
        Logging.log(Severity.LS_WARNING, string2, string3);
    }

    public static void e(String string2, String string3, Throwable throwable) {
        Logging.log(Severity.LS_ERROR, string2, string3);
        Logging.log(Severity.LS_ERROR, string2, throwable.toString());
        Logging.log(Severity.LS_ERROR, string2, Logging.getStackTraceString(throwable));
    }

    public static void w(String string2, String string3, Throwable throwable) {
        Logging.log(Severity.LS_WARNING, string2, string3);
        Logging.log(Severity.LS_WARNING, string2, throwable.toString());
        Logging.log(Severity.LS_WARNING, string2, Logging.getStackTraceString(throwable));
    }

    public static void v(String string2, String string3) {
        Logging.log(Severity.LS_VERBOSE, string2, string3);
    }

    public static String getStackTraceString(Throwable object) {
        StringWriter stringWriter;
        if (object == null) {
            return "";
        }
        Throwable throwable = object;
        object = stringWriter;
        stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)object));
        return ((StringWriter)object).toString();
    }

    public static native void nativeEnableLogToDebugOutput(int var0);

    public static native void nativeEnableLogThreads();

    public static native void nativeEnableLogTimeStamps();

    public static native void nativeLog(int var0, String var1, String var2);

    public static enum Severity {
        LS_VERBOSE,
        LS_INFO,
        LS_WARNING,
        LS_ERROR,
        LS_NONE;

    }

    @Deprecated
    public static enum TraceLevel {
        TRACE_NONE(0),
        TRACE_STATEINFO(1),
        TRACE_WARNING(2),
        TRACE_ERROR(4),
        TRACE_CRITICAL(8),
        TRACE_APICALL(16),
        TRACE_DEFAULT(255),
        TRACE_MODULECALL(32),
        TRACE_MEMORY(256),
        TRACE_TIMER(512),
        TRACE_STREAM(1024),
        TRACE_DEBUG(2048),
        TRACE_INFO(4096),
        TRACE_TERSEINFO(8192),
        TRACE_ALL(65535);

        public final int level;

        public TraceLevel(int n4) {
            this.level = n4;
        }
    }
}

