/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.webrtc.JniCommon;
import org.webrtc.RefCountDelegate;
import org.webrtc.VideoFrame;

public class JavaI420Buffer
implements VideoFrame.I420Buffer {
    public final int width;
    public final int height;
    public final ByteBuffer dataY;
    public final ByteBuffer dataU;
    public final ByteBuffer dataV;
    public final int strideY;
    public final int strideU;
    public final int strideV;
    public final RefCountDelegate refCountDelegate;

    public JavaI420Buffer(int n3, int n4, ByteBuffer byteBuffer, int n5, ByteBuffer byteBuffer2, int n6, ByteBuffer byteBuffer3, int n7, @Nullable Runnable runnable) {
        JavaI420Buffer javaI420Buffer = this;
        this.width = n3;
        this.height = n4;
        this.dataY = byteBuffer;
        this.dataU = byteBuffer2;
        this.dataV = byteBuffer3;
        this.strideY = n5;
        this.strideU = n6;
        javaI420Buffer.strideV = n7;
        javaI420Buffer.refCountDelegate = new RefCountDelegate(runnable);
    }

    public static void checkCapacity(ByteBuffer byteBuffer, int n3, int n4, int n5) {
        n3 = (n4 - 1) * n5 + n3;
        if (byteBuffer.capacity() >= n3) {
            return;
        }
        throw new IllegalArgumentException("Buffer must be at least " + n3 + " bytes, but was " + byteBuffer.capacity());
    }

    public static JavaI420Buffer wrap(int n3, int n4, ByteBuffer byteBuffer, int n5, ByteBuffer byteBuffer2, int n6, ByteBuffer byteBuffer3, int n7, @Nullable Runnable runnable) {
        if (byteBuffer != null && byteBuffer2 != null && byteBuffer3 != null) {
            if (byteBuffer.isDirect() && byteBuffer2.isDirect() && byteBuffer3.isDirect()) {
                byteBuffer = byteBuffer.slice();
                byteBuffer2 = byteBuffer2.slice();
                byteBuffer3 = byteBuffer3.slice();
                int n8 = (n3 + 1) / 2;
                int n9 = (n4 + 1) / 2;
                JavaI420Buffer.checkCapacity(byteBuffer, n3, n4, n5);
                JavaI420Buffer.checkCapacity(byteBuffer2, n8, n9, n6);
                JavaI420Buffer.checkCapacity(byteBuffer3, n8, n9, n7);
                return new JavaI420Buffer(n3, n4, byteBuffer, n5, byteBuffer2, n6, byteBuffer3, n7, runnable);
            }
            throw new IllegalArgumentException("Data buffers must be direct byte buffers.");
        }
        throw new IllegalArgumentException("Data buffers cannot be null.");
    }

    public static JavaI420Buffer allocate(int n3, int n4) {
        ByteBuffer byteBuffer;
        int n5 = (n4 + 1) / 2;
        int n6 = (n3 + 1) / 2;
        int n7 = n3 * n4;
        int n8 = n7 + 0;
        int n9 = n6 * n5;
        int n10 = n8 + n9;
        ByteBuffer byteBuffer2 = byteBuffer = JniCommon.nativeAllocateByteBuffer(n6 * 2 * n5 + n7);
        ByteBuffer byteBuffer3 = byteBuffer;
        byteBuffer.position(0);
        byteBuffer3.limit(n8);
        ByteBuffer byteBuffer4 = byteBuffer3.slice();
        byteBuffer.position(n8);
        byteBuffer2.limit(n10);
        ByteBuffer byteBuffer5 = byteBuffer2.slice();
        byteBuffer.position(n10);
        byteBuffer.limit(n10 + n9);
        ByteBuffer byteBuffer6 = byteBuffer.slice();
        return new JavaI420Buffer(n3, n4, byteBuffer4, n3, byteBuffer5, n6, byteBuffer6, n6, () -> JniCommon.nativeFreeByteBuffer(byteBuffer));
    }

    public static VideoFrame.Buffer cropAndScaleI420(VideoFrame.I420Buffer i420Buffer, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n5 == n7 && n6 == n8) {
            VideoFrame.I420Buffer i420Buffer2 = i420Buffer;
            ByteBuffer byteBuffer = i420Buffer2.getDataY();
            ByteBuffer byteBuffer2 = i420Buffer2.getDataU();
            ByteBuffer byteBuffer3 = i420Buffer2.getDataV();
            byteBuffer.position(i420Buffer.getStrideY() * n4 + n3);
            byteBuffer2.position(i420Buffer.getStrideU() * (n4 /= 2) + (n3 /= 2));
            byteBuffer3.position(i420Buffer.getStrideV() * n4 + n3);
            i420Buffer2.retain();
            return JavaI420Buffer.wrap(n7, n8, byteBuffer.slice(), i420Buffer.getStrideY(), byteBuffer2.slice(), i420Buffer.getStrideU(), byteBuffer3.slice(), i420Buffer.getStrideV(), i420Buffer::release);
        }
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(n7, n8);
        JavaI420Buffer.nativeCropAndScaleI420(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), n3, n4, n5, n6, javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV(), n7, n8);
        return javaI420Buffer;
    }

    public static native void nativeCropAndScaleI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8, int var9, ByteBuffer var10, int var11, ByteBuffer var12, int var13, ByteBuffer var14, int var15, int var16, int var17);

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        JavaI420Buffer javaI420Buffer = this;
        javaI420Buffer.retain();
        return javaI420Buffer;
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n3, int n4, int n5, int n6, int n7, int n8) {
        return JavaI420Buffer.cropAndScaleI420(this, n3, n4, n5, n6, n7, n8);
    }
}

