/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.webrtc.BaseBitrateAdjuster;
import org.webrtc.BitrateAdjuster;
import org.webrtc.DynamicBitrateAdjuster;
import org.webrtc.EglBase;
import org.webrtc.EglBase14;
import org.webrtc.FramerateBitrateAdjuster;
import org.webrtc.H264Utils;
import org.webrtc.HardwareVideoEncoder;
import org.webrtc.Logging;
import org.webrtc.MediaCodecUtils;
import org.webrtc.MediaCodecWrapperFactoryImpl;
import org.webrtc.Predicate;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;

public class HardwareVideoEncoderFactory
implements VideoEncoderFactory {
    public static final String TAG = "HardwareVideoEncoderFactory";
    public static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    public static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    public static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    public static final List<String> H264_HW_EXCEPTION_MODELS = Arrays.asList("SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4");
    @Nullable
    public final EglBase14.Context sharedContext;
    public final boolean enableIntelVp8Encoder;
    public final boolean enableH264HighProfile;
    @Nullable
    public final Predicate<MediaCodecInfo> codecAllowedPredicate;

    public HardwareVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2) {
        this(context, bl, bl2, null);
    }

    public HardwareVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2, @Nullable Predicate<MediaCodecInfo> predicate) {
        if (context instanceof EglBase14.Context) {
            this.sharedContext = (EglBase14.Context)context;
        } else {
            Logging.w(TAG, "No shared EglBase.Context.  Encoders will not use texture mode.");
            this.sharedContext = null;
        }
        this.enableIntelVp8Encoder = bl;
        this.enableH264HighProfile = bl2;
        this.codecAllowedPredicate = predicate;
    }

    @Deprecated
    public HardwareVideoEncoderFactory(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecType videoCodecType) {
        for (int i3 = 0; i3 < MediaCodecList.getCodecCount(); ++i3) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder() || !this.isSupportedCodec(mediaCodecInfo, videoCodecType)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        if (!MediaCodecUtils.codecSupportsType(mediaCodecInfo, videoCodecType)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType(videoCodecType.mimeType())) == null) {
            return false;
        }
        return this.isHardwareSupportedInCurrentSdk(mediaCodecInfo, videoCodecType) && this.isMediaCodecAllowed(mediaCodecInfo);
    }

    private boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo mediaCodecInfo, VideoCodecType videoCodecType) {
        int n3 = videoCodecType.ordinal();
        if (n3 != 0) {
            if (n3 != 1) {
                return n3 == 2;
            }
            return this.isHardwareSupportedInCurrentSdkVp9(mediaCodecInfo);
        }
        return this.isHardwareSupportedInCurrentSdkVp8(mediaCodecInfo);
    }

    private boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo object) {
        return ((String)(object = object.getName())).startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || ((String)object).startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || ((String)object).startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21 && this.enableIntelVp8Encoder;
    }

    private boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo mediaCodecInfo) {
        String string2 = mediaCodecInfo.getName();
        return (string2.startsWith("OMX.qcom.") || string2.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
    }

    private boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo mediaCodecInfo) {
        if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
            return false;
        }
        String string2 = mediaCodecInfo.getName();
        return string2.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || string2.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 21;
    }

    private boolean isMediaCodecAllowed(MediaCodecInfo mediaCodecInfo) {
        return true;
    }

    private int getKeyFrameIntervalSec(VideoCodecType videoCodecType) {
        int n3 = videoCodecType.ordinal();
        if (n3 != 0 && n3 != 1) {
            if (n3 == 2) {
                return 20;
            }
            throw new IllegalArgumentException("Unsupported VideoCodecType " + (Object)((Object)videoCodecType));
        }
        return 100;
    }

    private int getForcedKeyFrameIntervalMs(VideoCodecType videoCodecType, String string2) {
        if (videoCodecType == VideoCodecType.VP8 && string2.startsWith("OMX.qcom.")) {
            int n3 = Build.VERSION.SDK_INT;
            if (n3 != 21 && n3 != 22) {
                if (n3 == 23) {
                    return 20000;
                }
                if (n3 > 23) {
                    return 15000;
                }
            } else {
                return 15000;
            }
        }
        return 0;
    }

    private BitrateAdjuster createBitrateAdjuster(VideoCodecType videoCodecType, String string2) {
        if (string2.startsWith("OMX.Exynos.")) {
            if (videoCodecType == VideoCodecType.VP8) {
                return new DynamicBitrateAdjuster();
            }
            return new FramerateBitrateAdjuster();
        }
        return new BaseBitrateAdjuster();
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo mediaCodecInfo) {
        return this.enableH264HighProfile && Build.VERSION.SDK_INT > 23 && mediaCodecInfo.getName().startsWith("OMX.Exynos.");
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo videoCodecInfo) {
        MediaCodecWrapperFactoryImpl mediaCodecWrapperFactoryImpl;
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        VideoCodecType videoCodecType = VideoCodecType.valueOf(videoCodecInfo.name);
        Object object = this.findCodecForType(videoCodecType);
        if (object == null) {
            return null;
        }
        VideoCodecType videoCodecType2 = videoCodecType;
        String string2 = object.getName();
        Object object2 = videoCodecType2.mimeType();
        Integer n3 = MediaCodecUtils.selectColorFormat(MediaCodecUtils.TEXTURE_COLOR_FORMATS, object.getCapabilitiesForType((String)object2));
        object2 = MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, object.getCapabilitiesForType((String)object2));
        if (videoCodecType2 == VideoCodecType.H264) {
            boolean bl = H264Utils.isSameH264Profile(videoCodecInfo.params, MediaCodecUtils.getCodecProperties(videoCodecType, true));
            boolean bl2 = H264Utils.isSameH264Profile(videoCodecInfo.params, MediaCodecUtils.getCodecProperties(videoCodecType, false));
            if (!bl && !bl2) {
                return null;
            }
            if (bl && !this.isH264HighProfileSupported((MediaCodecInfo)object)) {
                return null;
            }
        }
        object = mediaCodecWrapperFactoryImpl;
        object();
        return new HardwareVideoEncoder(mediaCodecWrapperFactoryImpl, string2, videoCodecType, n3, (Integer)object2, videoCodecInfo.params, this.getKeyFrameIntervalSec(videoCodecType), this.getForcedKeyFrameIntervalMs(videoCodecType, string2), this.createBitrateAdjuster(videoCodecType, string2), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> arrayList;
        if (Build.VERSION.SDK_INT < 19) {
            return new VideoCodecInfo[0];
        }
        ArrayList<VideoCodecInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<VideoCodecInfo>();
        VideoCodecType[] videoCodecTypeArray = new VideoCodecType[3];
        VideoCodecType[] videoCodecTypeArray2 = videoCodecTypeArray;
        videoCodecTypeArray[0] = VideoCodecType.VP8;
        videoCodecTypeArray[1] = VideoCodecType.VP9;
        videoCodecTypeArray[2] = VideoCodecType.H264;
        int n3 = videoCodecTypeArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            VideoCodecType videoCodecType = videoCodecTypeArray2[i3];
            MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
            if (mediaCodecInfo == null) continue;
            VideoCodecType videoCodecType2 = videoCodecType;
            String string2 = videoCodecType2.name();
            if (videoCodecType2 == VideoCodecType.H264 && this.isH264HighProfileSupported(mediaCodecInfo)) {
                arrayList2.add(new VideoCodecInfo(string2, MediaCodecUtils.getCodecProperties(videoCodecType, true)));
            }
            arrayList2.add(new VideoCodecInfo(string2, MediaCodecUtils.getCodecProperties(videoCodecType, false)));
        }
        ArrayList<VideoCodecInfo> arrayList3 = arrayList2;
        return arrayList3.toArray(new VideoCodecInfo[arrayList3.size()]);
    }
}

