/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.webrtc.BitrateAdjuster;
import org.webrtc.EglBase;
import org.webrtc.EglBase14;
import org.webrtc.EncodedImage;
import org.webrtc.GlRectDrawer;
import org.webrtc.Logging;
import org.webrtc.MediaCodecWrapper;
import org.webrtc.MediaCodecWrapperFactory;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoCodecType;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoFrame;
import org.webrtc.VideoFrameDrawer;
import org.webrtc.YuvHelper;

@TargetApi(value=19)
public class HardwareVideoEncoder
implements VideoEncoder {
    public static final String TAG = "HardwareVideoEncoder";
    public static final int VIDEO_ControlRateConstant = 2;
    public static final String KEY_BITRATE_MODE = "bitrate-mode";
    public static final int VIDEO_AVC_PROFILE_HIGH = 8;
    public static final int VIDEO_AVC_LEVEL_3 = 256;
    public static final int MAX_VIDEO_FRAMERATE = 30;
    public static final int MAX_ENCODER_Q_SIZE = 2;
    public static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    public static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    public final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    public final String codecName;
    public final VideoCodecType codecType;
    public final Integer surfaceColorFormat;
    public final Integer yuvColorFormat;
    public final YuvFormat yuvFormat;
    public final Map<String, String> params;
    public final int keyFrameIntervalSec;
    public final long forcedKeyFrameNs;
    public final BitrateAdjuster bitrateAdjuster;
    public final EglBase14.Context sharedContext;
    public final GlRectDrawer textureDrawer;
    public final VideoFrameDrawer videoFrameDrawer;
    public final BlockingDeque<EncodedImage.Builder> outputBuilders;
    public final ThreadUtils.ThreadChecker encodeThreadChecker;
    public final ThreadUtils.ThreadChecker outputThreadChecker;
    public VideoEncoder.Callback callback;
    public boolean automaticResizeOn;
    @Nullable
    public MediaCodecWrapper codec;
    @Nullable
    public ByteBuffer[] outputBuffers;
    @Nullable
    public Thread outputThread;
    @Nullable
    public EglBase14 textureEglBase;
    @Nullable
    public Surface textureInputSurface;
    public int width;
    public int height;
    public boolean useSurfaceMode;
    public long lastKeyFrameNs;
    @Nullable
    public ByteBuffer configBuffer;
    public int adjustedBitrate;
    public volatile boolean running;
    @Nullable
    public volatile Exception shutdownException;

    public HardwareVideoEncoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String string2, VideoCodecType videoCodecType, Integer n3, Integer n4, Map<String, String> map, int n5, int n6, BitrateAdjuster bitrateAdjuster, EglBase14.Context context) {
        HardwareVideoEncoder hardwareVideoEncoder = this;
        this.textureDrawer = new GlRectDrawer();
        this.videoFrameDrawer = new VideoFrameDrawer();
        this.outputBuilders = new LinkedBlockingDeque<EncodedImage.Builder>();
        this.encodeThreadChecker = new ThreadUtils.ThreadChecker();
        this.outputThreadChecker = new ThreadUtils.ThreadChecker();
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = string2;
        this.codecType = videoCodecType;
        this.surfaceColorFormat = n3;
        this.yuvColorFormat = n4;
        this.yuvFormat = YuvFormat.valueOf(n4);
        this.params = map;
        hardwareVideoEncoder.keyFrameIntervalSec = n5;
        hardwareVideoEncoder.forcedKeyFrameNs = TimeUnit.MILLISECONDS.toNanos(n6);
        this.bitrateAdjuster = bitrateAdjuster;
        this.sharedContext = context;
        this.encodeThreadChecker.detachThread();
    }

    /*
     * Unable to fully structure code
     */
    private VideoCodecStatus initEncodeInternal() {
        block19: {
            block16: {
                block18: {
                    block17: {
                        v0 = this;
                        v0.encodeThreadChecker.checkIsOnValidThread();
                        v0.lastKeyFrameNs = -1L;
                        v0.codec = v0.mediaCodecWrapperFactory.createByCodecName(this.codecName);
                        var1_1 = v0.useSurfaceMode != false ? this.surfaceColorFormat : this.yuvColorFormat;
                        try {
                            v1 = this;
                            v2 = v1;
                            var2_4 = MediaFormat.createVideoFormat((String)v1.codecType.mimeType(), (int)this.width, (int)this.height);
                        }
                        catch (IllegalStateException var1_3) {
                            Logging.e("HardwareVideoEncoder", "initEncodeInternal failed", var1_3);
                            this.release();
                            return VideoCodecStatus.FALLBACK_SOFTWARE;
                        }
                        var2_4.setInteger("bitrate", this.adjustedBitrate);
                        var2_4.setInteger("bitrate-mode", 2);
                        var2_4.setInteger("color-format", var1_1);
                        var2_4.setInteger("frame-rate", this.bitrateAdjuster.getCodecConfigFramerate());
                        var2_4.setInteger("i-frame-interval", this.keyFrameIntervalSec);
                        if (v2.codecType != VideoCodecType.H264) break block16;
                        var1_2 = this.params.get("profile-level-id");
                        if (var1_2 == null) {
                            var1_2 = "42e01f";
                        }
                        var3_5 = -1;
                        var4_6 = var1_2.hashCode();
                        if (var4_6 == 1537948542) break block17;
                        if (var4_6 != 1595523974) break block18;
                        if (!var1_2.equals("640c1f")) ** GOTO lbl42
                        var3_5 = 0;
                    }
                    if (!var1_2.equals("42e01f")) break block18;
                    var3_5 = 1;
                }
                if (var3_5 == 0) ** GOTO lbl48
                if (var3_5 == 1) break block16;
                Logging.w("HardwareVideoEncoder", "Unknown profile level id: " + var1_2);
                break block16;
lbl48:
                // 1 sources

                v3 = var2_4;
                v3.setInteger("profile", 8);
                v3.setInteger("level", 256);
            }
            v4 = this;
            Logging.d("HardwareVideoEncoder", "Format: " + var2_4);
            v4.codec.configure(var2_4, null, null, 1);
            if (!v4.useSurfaceMode) ** GOTO lbl63
            v5 = this;
            v5.textureEglBase = EglBase.createEgl14(v5.sharedContext, EglBase.CONFIG_RECORDABLE);
            v5.textureInputSurface = v5.codec.createInputSurface();
            v5.textureEglBase.createSurface(this.textureInputSurface);
            v5.textureEglBase.makeCurrent();
lbl63:
            // 2 sources

            v6 = this;
            v6.codec.start();
            v6.outputBuffers = v6.codec.getOutputBuffers();
            v6.running = true;
            v6.outputThreadChecker.detachThread();
            v6.outputThread = v6.createOutputThread();
            v6.outputThread.start();
            return VideoCodecStatus.OK;
            catch (IllegalArgumentException v7) {
                break block19;
            }
            catch (IOException v8) {}
        }
        Logging.e("HardwareVideoEncoder", a.a("Cannot create media encoder ").append(this.codecName).toString());
        return VideoCodecStatus.FALLBACK_SOFTWARE;
    }

    private VideoCodecStatus encodeTextureBuffer(VideoFrame videoFrame) {
        VideoFrame videoFrame2;
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.encodeThreadChecker.checkIsOnValidThread();
        try {
            GLES20.glClear((int)16384);
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "encodeTexture failed", runtimeException);
            return VideoCodecStatus.ERROR;
        }
        VideoFrame videoFrame3 = videoFrame2;
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        videoFrame2 = new VideoFrame(buffer, 0, videoFrame.getTimestampNs());
        hardwareVideoEncoder.videoFrameDrawer.drawFrame(videoFrame3, this.textureDrawer, null);
        hardwareVideoEncoder.textureEglBase.swapBuffers(videoFrame.getTimestampNs());
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus encodeByteBuffer(VideoFrame videoFrame, VideoFrame.Buffer buffer, int n3) {
        HardwareVideoEncoder hardwareVideoEncoder;
        int n4;
        long l3;
        block6: {
            this.encodeThreadChecker.checkIsOnValidThread();
            l3 = (videoFrame.getTimestampNs() + 500L) / 1000L;
            try {
                n4 = this.codec.dequeueInputBuffer(0L);
                if (n4 != -1) break block6;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "dequeueInputBuffer failed", illegalStateException);
                return VideoCodecStatus.ERROR;
            }
            Logging.d(TAG, "Dropped frame, no input buffers available");
            return VideoCodecStatus.NO_OUTPUT;
        }
        try {
            HardwareVideoEncoder hardwareVideoEncoder2 = this;
            hardwareVideoEncoder = hardwareVideoEncoder2;
            hardwareVideoEncoder2.fillInputBuffer(hardwareVideoEncoder2.codec.getInputBuffers()[n4], buffer);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "getInputBuffers failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        try {
            hardwareVideoEncoder.codec.queueInputBuffer(n4, 0, n3, l3, 0);
            return VideoCodecStatus.OK;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "queueInputBuffer failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
    }

    private VideoCodecStatus resetCodec(int n3, int n4, boolean bl) {
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.encodeThreadChecker.checkIsOnValidThread();
        VideoCodecStatus videoCodecStatus = hardwareVideoEncoder.release();
        if (videoCodecStatus != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        this.width = n3;
        this.height = n4;
        this.useSurfaceMode = bl;
        return this.initEncodeInternal();
    }

    private boolean shouldForceKeyFrame(long l3) {
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.encodeThreadChecker.checkIsOnValidThread();
        long l4 = hardwareVideoEncoder.forcedKeyFrameNs;
        return l4 > 0L && l3 > this.lastKeyFrameNs + l4;
    }

    private void requestKeyFrame(long l3) {
        Bundle bundle;
        HardwareVideoEncoder hardwareVideoEncoder = hardwareVideoEncoder3;
        HardwareVideoEncoder hardwareVideoEncoder2 = hardwareVideoEncoder3;
        hardwareVideoEncoder2.encodeThreadChecker.checkIsOnValidThread();
        HardwareVideoEncoder hardwareVideoEncoder3 = bundle;
        try {
            new Bundle().putInt("request-sync", 0);
            hardwareVideoEncoder2.codec.setParameters((Bundle)hardwareVideoEncoder3);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "requestKeyFrame failed", illegalStateException);
            return;
        }
        hardwareVideoEncoder.lastKeyFrameNs = l3;
    }

    private Thread createOutputThread() {
        return new Thread(){

            @Override
            public void run() {
                while (HardwareVideoEncoder.this.running) {
                    HardwareVideoEncoder.this.deliverEncodedImage();
                }
                HardwareVideoEncoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    private void releaseCodecOnOutputThread() {
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        try {
            hardwareVideoEncoder.codec.stop();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media encoder stop failed", exception);
        }
        try {
            this.codec.release();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media encoder release failed", exception);
            this.shutdownException = exception;
        }
        this.configBuffer = null;
        Logging.d(TAG, "Release on output thread done");
    }

    private VideoCodecStatus updateBitrate() {
        Bundle bundle;
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.outputThreadChecker.checkIsOnValidThread();
        hardwareVideoEncoder.adjustedBitrate = hardwareVideoEncoder.bitrateAdjuster.getAdjustedBitrateBps();
        Bundle bundle2 = bundle;
        try {
            bundle = new Bundle();
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "updateBitrate failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        bundle.putInt("video-bitrate", this.adjustedBitrate);
        hardwareVideoEncoder.codec.setParameters(bundle2);
        return VideoCodecStatus.OK;
    }

    private boolean canUseSurface() {
        return this.sharedContext != null && this.surfaceColorFormat != null;
    }

    @Override
    public VideoCodecStatus initEncode(VideoEncoder.Settings settings, VideoEncoder.Callback callback) {
        int n3;
        this.encodeThreadChecker.checkIsOnValidThread();
        this.callback = callback;
        this.automaticResizeOn = settings.automaticResizeOn;
        this.width = settings.width;
        this.height = settings.height;
        this.useSurfaceMode = this.canUseSurface();
        int n4 = settings.startBitrate;
        if (n4 != 0 && (n3 = settings.maxFramerate) != 0) {
            this.bitrateAdjuster.setTargets(n4 * 1000, n3);
        }
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.adjustedBitrate = hardwareVideoEncoder.bitrateAdjuster.getAdjustedBitrateBps();
        Logging.d(TAG, a.a("initEncode: ").append(this.width).append(" x ").append(this.height).append(". @ ").append(settings.startBitrate).append("kbps. Fps: ").append(settings.maxFramerate).append(" Use surface mode: ").append(this.useSurfaceMode).toString());
        return hardwareVideoEncoder.initEncodeInternal();
    }

    @Override
    public VideoCodecStatus release() {
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.encodeThreadChecker.checkIsOnValidThread();
        Object object = hardwareVideoEncoder.outputThread;
        if (object == null) {
            object = VideoCodecStatus.OK;
        } else {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(object, 5000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                object = VideoCodecStatus.TIMEOUT;
            } else if (this.shutdownException != null) {
                object = this.shutdownException;
                Logging.e(TAG, "Media encoder release exception", (Throwable)object);
                object = VideoCodecStatus.ERROR;
            } else {
                object = VideoCodecStatus.OK;
            }
        }
        HardwareVideoEncoder hardwareVideoEncoder2 = this;
        hardwareVideoEncoder2.textureDrawer.release();
        hardwareVideoEncoder2.videoFrameDrawer.release();
        EglBase14 eglBase14 = hardwareVideoEncoder2.textureEglBase;
        if (eglBase14 != null) {
            eglBase14.release();
            this.textureEglBase = null;
        }
        if ((eglBase14 = this.textureInputSurface) != null) {
            eglBase14.release();
            this.textureInputSurface = null;
        }
        HardwareVideoEncoder hardwareVideoEncoder3 = this;
        hardwareVideoEncoder3.outputBuilders.clear();
        hardwareVideoEncoder3.codec = null;
        hardwareVideoEncoder3.outputBuffers = null;
        hardwareVideoEncoder3.outputThread = null;
        hardwareVideoEncoder3.encodeThreadChecker.detachThread();
        return object;
    }

    @Override
    public VideoCodecStatus encode(VideoFrame object, VideoEncoder.EncodeInfo encodeInfo) {
        VideoCodecStatus videoCodecStatus;
        HardwareVideoEncoder hardwareVideoEncoder = this;
        hardwareVideoEncoder.encodeThreadChecker.checkIsOnValidThread();
        if (hardwareVideoEncoder.codec == null) {
            return VideoCodecStatus.UNINITIALIZED;
        }
        VideoFrame videoFrame = object;
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        boolean bl = buffer instanceof VideoFrame.TextureBuffer;
        int n3 = videoFrame.getBuffer().getWidth();
        int n4 = videoFrame.getBuffer().getHeight();
        bl = this.canUseSurface() && bl;
        if ((n3 != this.width || n4 != this.height || bl != this.useSurfaceMode) && (videoCodecStatus = this.resetCodec(n3, n4, bl)) != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        if (this.outputBuilders.size() > 2) {
            Logging.e(TAG, "Dropped frame, encoder queue full");
            return VideoCodecStatus.NO_OUTPUT;
        }
        int n5 = 0;
        Object object2 = encodeInfo.frameTypes;
        n3 = encodeInfo.frameTypes.length;
        for (n4 = 0; n4 < n3; ++n4) {
            if (object2[n4] != EncodedImage.FrameType.VideoFrameKey) continue;
            n5 = 1;
        }
        if (n5 != 0 || this.shouldForceKeyFrame(object.getTimestampNs())) {
            this.requestKeyFrame(object.getTimestampNs());
        }
        HardwareVideoEncoder hardwareVideoEncoder2 = this;
        VideoFrame.Buffer buffer2 = buffer;
        n5 = buffer2.getHeight();
        n5 = buffer2.getWidth() * n5 * 3 / 2;
        object2 = EncodedImage.builder().setCaptureTimeNs(object.getTimestampNs()).setCompleteFrame(true).setEncodedWidth(object.getBuffer().getWidth()).setEncodedHeight(object.getBuffer().getHeight()).setRotation(object.getRotation());
        hardwareVideoEncoder2.outputBuilders.offer((EncodedImage.Builder)object2);
        object = hardwareVideoEncoder2.useSurfaceMode ? this.encodeTextureBuffer((VideoFrame)object) : this.encodeByteBuffer((VideoFrame)object, buffer, n5);
        if (object != VideoCodecStatus.OK) {
            this.outputBuilders.pollLast();
        }
        return object;
    }

    @Override
    public VideoCodecStatus setRateAllocation(VideoEncoder.BitrateAllocation bitrateAllocation, int n3) {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (n3 > 30) {
            n3 = 30;
        }
        this.bitrateAdjuster.setTargets(bitrateAllocation.getSum(), n3);
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoEncoder.ScalingSettings getScalingSettings() {
        HardwareVideoEncoder hardwareVideoEncoder = object;
        hardwareVideoEncoder.encodeThreadChecker.checkIsOnValidThread();
        if (hardwareVideoEncoder.automaticResizeOn) {
            Object object = object.codecType;
            if (object == VideoCodecType.VP8) {
                return new VideoEncoder.ScalingSettings(29, 95);
            }
            if (object == VideoCodecType.H264) {
                return new VideoEncoder.ScalingSettings(24, 37);
            }
        }
        return VideoEncoder.ScalingSettings.OFF;
    }

    @Override
    public String getImplementationName() {
        return "HWEncoder";
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void deliverEncodedImage() {
        block32: {
            block30: {
                block29: {
                    block28: {
                        v0 = this;
                        v0.outputThreadChecker.checkIsOnValidThread();
                        var1_2 = v1;
                        v1 = new MediaCodec.BufferInfo();
                        var2_3 = v0.codec.dequeueOutputBuffer((MediaCodec.BufferInfo)var1_2, 100000L);
                        if (var2_3 >= 0) ** GOTO lbl12
                        if (var2_3 != -3) ** GOTO lbl11
                        this.outputBuffers = this.codec.getOutputBuffers();
lbl11:
                        // 2 sources

                        return;
lbl12:
                        // 1 sources

                        v2 = var1_2;
                        var3_4 /* !! */  = this.outputBuffers[var2_3];
                        v3 = var1_2;
                        var3_4 /* !! */ .position(var1_2.offset);
                        v4 = v3.offset + var1_2.size;
                        var3_4 /* !! */ .limit(v4);
                        if ((v2.flags & 2) == 0) break block28;
                        Logging.d("HardwareVideoEncoder", "Config frame generated. Offset: " + var1_2.offset + ". Size: " + var1_2.size);
                        this.configBuffer = ByteBuffer.allocateDirect(var1_2.size);
                        this.configBuffer.put(var3_4 /* !! */ );
                        ** GOTO lbl92
                    }
                    v5 = this;
                    v5.bitrateAdjuster.reportEncodedFrame(var1_2.size);
                    if (v5.adjustedBitrate == this.bitrateAdjuster.getAdjustedBitrateBps()) break block29;
                    this.updateBitrate();
                }
                var4_5 = (var1_2.flags & 1) != 0;
                if (!var4_5) break block30;
                Logging.d("HardwareVideoEncoder", "Sync frame generated");
            }
            if (var4_5) {
                if (this.codecType != VideoCodecType.H264) ** break block31
                Logging.d("HardwareVideoEncoder", "Prepending config frame of size " + this.configBuffer.capacity() + " to output buffer with offset " + var1_2.offset + ", size " + var1_2.size);
                v6 = var1_2.size + this.configBuffer.capacity();
                var1_2 = ByteBuffer.allocateDirect(v6);
                v7 /* !! */  = var3_4 /* !! */ ;
                v8 = var1_2;
                v9 = this;
                v10 = v9;
                v9.configBuffer.rewind();
                v8.put(v10.configBuffer);
                var1_2.put(v7 /* !! */ );
                var1_2.rewind();
            } else {
                var1_2 = var3_4 /* !! */ .slice();
            }
            if (!var4_5) break block32;
            v11 = EncodedImage.FrameType.VideoFrameKey;
lbl77:
            // 2 sources

            while (true) {
                var3_4 /* !! */  = v11;
                ** GOTO lbl84
                break;
            }
        }
        v11 = EncodedImage.FrameType.VideoFrameDelta;
        ** continue;
lbl84:
        // 1 sources

        v12 = this;
        v13 = v12;
        var4_6 = v12.outputBuilders.poll();
        var4_6.setBuffer((ByteBuffer)var1_2).setFrameType((EncodedImage.FrameType)var3_4 /* !! */ );
        try {
            v13.callback.onEncodedFrame(var4_6.createEncodedImage(), new VideoEncoder.CodecSpecificInfo());
lbl92:
            // 2 sources

            this.codec.releaseOutputBuffer(var2_3, false);
        }
        catch (IllegalStateException var0_1) {
            Logging.e("HardwareVideoEncoder", "deliverOutput failed", var0_1);
        }
    }

    public void fillInputBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer buffer) {
        this.yuvFormat.fillBuffer(byteBuffer, buffer);
    }

    public static enum YuvFormat {
        I420{

            @Override
            public void fillBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer buffer) {
                VideoFrame.I420Buffer i420Buffer = buffer.toI420();
                YuvHelper.I420Copy(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), byteBuffer, i420Buffer.getWidth(), i420Buffer.getHeight());
                i420Buffer.release();
            }
        }
        ,
        NV12{

            @Override
            public void fillBuffer(ByteBuffer byteBuffer, VideoFrame.Buffer buffer) {
                VideoFrame.I420Buffer i420Buffer = buffer.toI420();
                YuvHelper.I420ToNV12(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), byteBuffer, i420Buffer.getWidth(), i420Buffer.getHeight());
                i420Buffer.release();
            }
        };


        public YuvFormat() {
        }

        public static YuvFormat valueOf(int n3) {
            if (n3 != 19) {
                if (n3 != 21 && n3 != 2141391872 && n3 != 2141391876) {
                    throw new IllegalArgumentException("Unsupported colorFormat: " + n3);
                }
                return NV12;
            }
            return I420;
        }

        public /* synthetic */ YuvFormat(String string2, int n3, 1 var3_3) {
            this();
        }

        public abstract void fillBuffer(ByteBuffer var1, VideoFrame.Buffer var2);
    }
}

