/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.opengl.GLES20;
import org.webrtc.GlUtil;

public class GlTextureFrameBuffer {
    public final int pixelFormat;
    public int frameBufferId;
    public int textureId;
    public int width;
    public int height;

    public GlTextureFrameBuffer(int n3) {
        switch (n3) {
            default: {
                throw new IllegalArgumentException("Invalid pixel format: " + n3);
            }
            case 6407: 
            case 6408: 
            case 6409: 
        }
        GlTextureFrameBuffer glTextureFrameBuffer = this;
        glTextureFrameBuffer.pixelFormat = n3;
        glTextureFrameBuffer.width = 0;
        glTextureFrameBuffer.height = 0;
    }

    public void setSize(int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            if (n3 == this.width && n4 == this.height) {
                return;
            }
            this.width = n3;
            this.height = n4;
            if (this.textureId == 0) {
                this.textureId = GlUtil.generateTexture(3553);
            }
            if (this.frameBufferId == 0) {
                int[] nArray = new int[1];
                GLES20.glGenFramebuffers((int)1, (int[])nArray, (int)0);
                this.frameBufferId = nArray[0];
            }
            GlTextureFrameBuffer glTextureFrameBuffer = this;
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)glTextureFrameBuffer.textureId);
            int n5 = glTextureFrameBuffer.pixelFormat;
            GLES20.glTexImage2D((int)3553, (int)0, (int)n5, (int)n3, (int)n4, (int)0, (int)n5, (int)5121, null);
            GLES20.glBindTexture((int)3553, (int)0);
            GlUtil.checkNoGLES2Error("GlTextureFrameBuffer setSize");
            GLES20.glBindFramebuffer((int)36160, (int)glTextureFrameBuffer.frameBufferId);
            n5 = glTextureFrameBuffer.textureId;
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n5, (int)0);
            n5 = GLES20.glCheckFramebufferStatus((int)36160);
            if (n5 == 36053) {
                GLES20.glBindFramebuffer((int)36160, (int)0);
                return;
            }
            throw new IllegalStateException("Framebuffer not complete, status: " + n5);
        }
        throw new IllegalArgumentException("Invalid size: " + n3 + "x" + n4);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameBufferId() {
        return this.frameBufferId;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void release() {
        GlTextureFrameBuffer glTextureFrameBuffer = this;
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = this.textureId;
        GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
        glTextureFrameBuffer.textureId = 0;
        int[] nArray3 = new int[1];
        nArray2 = nArray3;
        nArray3[0] = this.frameBufferId;
        GLES20.glDeleteFramebuffers((int)1, (int[])nArray2, (int)0);
        glTextureFrameBuffer.frameBufferId = 0;
        glTextureFrameBuffer.width = 0;
        glTextureFrameBuffer.height = 0;
    }
}

