/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.webrtc.GlUtil;
import org.webrtc.Logging;

public class GlShader {
    public static final String TAG = "GlShader";
    public int program;

    public static int compileShader(int n3, String string2) {
        if ((n3 = GLES20.glCreateShader((int)n3)) != 0) {
            int n4 = n3;
            GLES20.glShaderSource((int)n4, (String)string2);
            GLES20.glCompileShader((int)n4);
            int[] nArray = new int[]{0};
            GLES20.glGetShaderiv((int)n3, (int)35713, (int[])nArray, (int)0);
            if (nArray[0] == 1) {
                GlUtil.checkNoGLES2Error("compileShader");
                return n3;
            }
            Logging.e(TAG, a.a("Compile error ").append(GLES20.glGetShaderInfoLog((int)n3)).append(" in shader:\n").append(string2).toString());
            throw new RuntimeException(GLES20.glGetShaderInfoLog((int)n3));
        }
        throw new RuntimeException(a.a("glCreateShader() failed. GLES20 error: ").append(GLES20.glGetError()).toString());
    }

    public GlShader(String string2, String string3) {
        int n3 = GlShader.compileShader(35633, string2);
        int n4 = GlShader.compileShader(35632, string3);
        int n5 = this.program = GLES20.glCreateProgram();
        if (n5 != 0) {
            GlShader glShader = this;
            GLES20.glAttachShader((int)n5, (int)n3);
            GLES20.glAttachShader((int)glShader.program, (int)n4);
            GLES20.glLinkProgram((int)glShader.program);
            int[] nArray = new int[]{0};
            GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])nArray, (int)0);
            if (nArray[0] == 1) {
                GLES20.glDeleteShader((int)n3);
                GLES20.glDeleteShader((int)n4);
                GlUtil.checkNoGLES2Error("Creating GlShader");
                return;
            }
            Logging.e(TAG, a.a("Could not link program: ").append(GLES20.glGetProgramInfoLog((int)this.program)).toString());
            throw new RuntimeException(GLES20.glGetProgramInfoLog((int)this.program));
        }
        throw new RuntimeException(a.a("glCreateProgram() failed. GLES20 error: ").append(GLES20.glGetError()).toString());
    }

    public int getAttribLocation(String string2) {
        int n3 = this.program;
        if (n3 != -1) {
            if ((n3 = GLES20.glGetAttribLocation((int)n3, (String)string2)) >= 0) {
                return n3;
            }
            throw new RuntimeException("Could not locate '" + string2 + "' in program");
        }
        throw new RuntimeException("The program has been released");
    }

    public void setVertexAttribArray(String string2, int n3, FloatBuffer floatBuffer) {
        this.setVertexAttribArray(string2, n3, 0, floatBuffer);
    }

    public void setVertexAttribArray(String string2, int n3, int n4, FloatBuffer floatBuffer) {
        if (this.program != -1) {
            int n5 = this.getAttribLocation(string2);
            GLES20.glEnableVertexAttribArray((int)n5);
            GLES20.glVertexAttribPointer((int)n5, (int)n3, (int)5126, (boolean)false, (int)n4, (Buffer)floatBuffer);
            GlUtil.checkNoGLES2Error("setVertexAttribArray");
            return;
        }
        throw new RuntimeException("The program has been released");
    }

    public int getUniformLocation(String string2) {
        int n3 = this.program;
        if (n3 != -1) {
            if ((n3 = GLES20.glGetUniformLocation((int)n3, (String)string2)) >= 0) {
                return n3;
            }
            throw new RuntimeException("Could not locate uniform '" + string2 + "' in program");
        }
        throw new RuntimeException("The program has been released");
    }

    public void useProgram() {
        int n3 = this.program;
        if (n3 != -1) {
            GLES20.glUseProgram((int)n3);
            GlUtil.checkNoGLES2Error("glUseProgram");
            return;
        }
        throw new RuntimeException("The program has been released");
    }

    public void release() {
        Logging.d(TAG, "Deleting shader.");
        int n3 = this.program;
        if (n3 != -1) {
            GLES20.glDeleteProgram((int)n3);
            this.program = -1;
        }
    }
}

