/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.opengl.GLES20;
import android.support.annotation.Nullable;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.webrtc.GlShader;
import org.webrtc.GlUtil;
import org.webrtc.RendererCommon;

public class GlGenericDrawer
implements RendererCommon.GlDrawer {
    public static final String INPUT_VERTEX_COORDINATE_NAME = "in_pos";
    public static final String INPUT_TEXTURE_COORDINATE_NAME = "in_tc";
    public static final String TEXTURE_MATRIX_NAME = "tex_mat";
    public static final String DEFAULT_VERTEX_SHADER_STRING = "varying vec2 tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\nuniform mat4 tex_mat;\nvoid main() {\n  gl_Position = in_pos;\n  tc = (tex_mat * in_tc).xy;\n}\n";
    public static final FloatBuffer FULL_RECTANGLE_BUFFER = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    public static final FloatBuffer FULL_RECTANGLE_TEXTURE_BUFFER = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    public final String genericFragmentSource;
    public final String vertexShader;
    public final ShaderCallbacks shaderCallbacks;
    @Nullable
    public ShaderType currentShaderType;
    @Nullable
    public GlShader currentShader;
    public int inPosLocation;
    public int inTcLocation;
    public int texMatrixLocation;

    public static String createFragmentShaderString(String string2, ShaderType object) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (object == ShaderType.OES) {
            stringBuilder2.append("#extension GL_OES_EGL_image_external : require\n");
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append("precision mediump float;\n");
        stringBuilder3.append("varying vec2 tc;\n");
        if (object == ShaderType.YUV) {
            StringBuilder stringBuilder4 = stringBuilder2;
            stringBuilder4.append("uniform sampler2D y_tex;\n");
            stringBuilder4.append("uniform sampler2D u_tex;\n");
            stringBuilder4.append("uniform sampler2D v_tex;\n");
            stringBuilder4.append("vec4 sample(vec2 p) {\n");
            stringBuilder4.append("  float y = texture2D(y_tex, p).r * 1.16438;\n");
            stringBuilder4.append("  float u = texture2D(u_tex, p).r;\n");
            stringBuilder4.append("  float v = texture2D(v_tex, p).r;\n");
            stringBuilder4.append("  return vec4(y + 1.59603 * v - 0.874202,\n");
            stringBuilder4.append("    y - 0.391762 * u - 0.812968 * v + 0.531668,\n");
            stringBuilder4.append("    y + 2.01723 * u - 1.08563, 1);\n");
            stringBuilder4.append("}\n");
            stringBuilder2.append(string2);
        } else {
            object = object == ShaderType.OES ? "samplerExternalOES" : "sampler2D";
            stringBuilder2.append("uniform ").append((String)object).append(" tex;\n");
            stringBuilder2.append(string2.replace("sample(", "texture2D(tex, "));
        }
        return stringBuilder2.toString();
    }

    public GlGenericDrawer(String string2, ShaderCallbacks shaderCallbacks) {
        this(DEFAULT_VERTEX_SHADER_STRING, string2, shaderCallbacks);
    }

    public GlGenericDrawer(String string2, String string3, ShaderCallbacks shaderCallbacks) {
        this.vertexShader = string2;
        this.genericFragmentSource = string3;
        this.shaderCallbacks = shaderCallbacks;
    }

    private void prepareShader(ShaderType object, float[] fArray, int n3, int n4, int n5, int n6) {
        if (((Enum)object).equals((Object)((GlGenericDrawer)object4).currentShaderType)) {
            object = ((GlGenericDrawer)object4).currentShader;
        } else {
            ((GlGenericDrawer)object4).currentShaderType = object;
            GlShader glShader = ((GlGenericDrawer)object4).currentShader;
            if (glShader != null) {
                glShader.release();
            }
            Object object2 = object;
            ((GlGenericDrawer)object4).currentShader = object = ((GlGenericDrawer)object4).createShader((ShaderType)((Object)object));
            ((GlShader)object).useProgram();
            if (object2 == ShaderType.YUV) {
                Object object3 = object;
                GLES20.glUniform1i((int)((GlShader)object3).getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)((GlShader)object3).getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)((GlShader)object3).getUniformLocation("v_tex"), (int)2);
            } else {
                GLES20.glUniform1i((int)((GlShader)object).getUniformLocation("tex"), (int)0);
            }
            GlUtil.checkNoGLES2Error("Create shader");
            ((GlGenericDrawer)object4).shaderCallbacks.onNewShader((GlShader)object);
            ((GlGenericDrawer)object4).texMatrixLocation = ((GlShader)object).getUniformLocation(TEXTURE_MATRIX_NAME);
            ((GlGenericDrawer)object4).inPosLocation = ((GlShader)object).getAttribLocation(INPUT_VERTEX_COORDINATE_NAME);
            ((GlGenericDrawer)object4).inTcLocation = ((GlShader)object).getAttribLocation(INPUT_TEXTURE_COORDINATE_NAME);
        }
        GlGenericDrawer glGenericDrawer = object4;
        ((GlShader)object).useProgram();
        GLES20.glEnableVertexAttribArray((int)glGenericDrawer.inPosLocation);
        Object object4 = FULL_RECTANGLE_BUFFER;
        GLES20.glVertexAttribPointer((int)glGenericDrawer.inPosLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)object4);
        GLES20.glEnableVertexAttribArray((int)glGenericDrawer.inTcLocation);
        object4 = FULL_RECTANGLE_TEXTURE_BUFFER;
        GLES20.glVertexAttribPointer((int)glGenericDrawer.inTcLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)object4);
        GLES20.glUniformMatrix4fv((int)glGenericDrawer.texMatrixLocation, (int)1, (boolean)false, (float[])fArray, (int)0);
        glGenericDrawer.shaderCallbacks.onPrepareShader((GlShader)object, fArray, n3, n4, n5, n6);
        GlUtil.checkNoGLES2Error("Prepare shader");
    }

    public GlShader createShader(ShaderType shaderType) {
        return new GlShader(this.vertexShader, GlGenericDrawer.createFragmentShaderString(this.genericFragmentSource, shaderType));
    }

    @Override
    public void drawOes(int n3, float[] fArray, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.prepareShader(ShaderType.OES, fArray, n4, n5, n8, n9);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)n3);
        GLES20.glViewport((int)n6, (int)n7, (int)n8, (int)n9);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    @Override
    public void drawRgb(int n3, float[] fArray, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.prepareShader(ShaderType.RGB, fArray, n4, n5, n8, n9);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n3);
        GLES20.glViewport((int)n6, (int)n7, (int)n8, (int)n9);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    public void drawYuv(int[] nArray, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.prepareShader(ShaderType.YUV, fArray, n3, n4, n7, n8);
        int n9 = 0;
        while (n9 < 3) {
            int n10 = n9++;
            GLES20.glActiveTexture((int)(n10 + 33984));
            GLES20.glBindTexture((int)3553, (int)nArray[n10]);
        }
        GLES20.glViewport((int)n5, (int)n6, (int)n7, (int)n8);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        for (n9 = 0; n9 < 3; ++n9) {
            GLES20.glActiveTexture((int)(n9 + 33984));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    @Override
    public void release() {
        GlShader glShader = this.currentShader;
        if (glShader != null) {
            GlGenericDrawer glGenericDrawer = this;
            glShader.release();
            glGenericDrawer.currentShader = null;
            glGenericDrawer.currentShaderType = null;
        }
    }

    public static interface ShaderCallbacks {
        public void onNewShader(GlShader var1);

        public void onPrepareShader(GlShader var1, float[] var2, int var3, int var4, int var5, int var6);
    }

    public static enum ShaderType {
        OES,
        RGB,
        YUV;

    }
}

