/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.os.SystemClock;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.webrtc.CapturerObserver;
import org.webrtc.JavaI420Buffer;
import org.webrtc.Logging;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;

public class FileVideoCapturer
implements VideoCapturer {
    public static final String TAG = "FileVideoCapturer";
    public final VideoReader videoReader;
    public CapturerObserver capturerObserver;
    public final Timer timer = new Timer();
    public final TimerTask tickTask = new TimerTask(){

        @Override
        public void run() {
            FileVideoCapturer.this.tick();
        }
    };

    public FileVideoCapturer(String string2) {
        try {
            this.videoReader = new VideoReaderY4M(string2);
            return;
        }
        catch (IOException iOException) {
            Logging.d(TAG, "Could not open video file: " + string2);
            throw iOException;
        }
    }

    public void tick() {
        VideoFrame videoFrame = this.videoReader.getNextFrame();
        this.capturerObserver.onFrameCaptured(videoFrame);
        videoFrame.release();
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, CapturerObserver capturerObserver) {
        this.capturerObserver = capturerObserver;
    }

    @Override
    public void startCapture(int n3, int n4, int n5) {
        long l3 = 1000 / n5;
        this.timer.schedule(this.tickTask, 0L, l3);
    }

    @Override
    public void stopCapture() {
        this.timer.cancel();
    }

    @Override
    public void changeCaptureFormat(int n3, int n4, int n5) {
    }

    @Override
    public void dispose() {
        this.videoReader.close();
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    public static class VideoReaderY4M
    implements VideoReader {
        public static final String TAG = "VideoReaderY4M";
        public static final String Y4M_FRAME_DELIMETER = "FRAME";
        public static final int FRAME_DELIMETER_LENGTH = 6;
        public final int frameWidth;
        public final int frameHeight;
        public final long videoStart;
        public final RandomAccessFile mediaFile;
        public final FileChannel mediaFileChannel;

        public VideoReaderY4M(String stringArray) {
            int n3;
            StringBuilder stringBuilder;
            VideoReaderY4M videoReaderY4M = this;
            videoReaderY4M.mediaFile = new RandomAccessFile((String)stringArray, "r");
            videoReaderY4M.mediaFileChannel = videoReaderY4M.mediaFile.getChannel();
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            while ((n3 = this.mediaFile.read()) != -1) {
                if (n3 == 10) {
                    this.videoStart = this.mediaFileChannel.position();
                    stringArray = stringBuilder2.toString().split("[ ]");
                    int n4 = 0;
                    n3 = 0;
                    String string2 = "";
                    for (String string3 : stringArray) {
                        char c3 = string3.charAt(0);
                        if (c3 != 'C') {
                            if (c3 != 'H') {
                                if (c3 != 'W') continue;
                                n4 = Integer.parseInt(string3.substring(1));
                                continue;
                            }
                            n3 = Integer.parseInt(string3.substring(1));
                            continue;
                        }
                        string2 = string3.substring(1);
                    }
                    Logging.d(TAG, "Color space: " + string2);
                    if (!string2.equals("420") && !string2.equals("420mpeg2")) {
                        throw new IllegalArgumentException("Does not support any other color space than I420 or I420mpeg2");
                    }
                    if (n4 % 2 != 1 && n3 % 2 != 1) {
                        this.frameWidth = n4;
                        this.frameHeight = n3;
                        Logging.d(TAG, "frame dim: (" + n4 + ", " + n3 + ")");
                        return;
                    }
                    throw new IllegalArgumentException("Does not support odd width or height");
                }
                stringBuilder2.append((char)n3);
            }
            throw new RuntimeException("Found end of file before end of header for file: " + (String)stringArray);
        }

        @Override
        public VideoFrame getNextFrame() {
            String string2;
            block12: {
                String string3;
                ByteBuffer byteBuffer;
                ByteBuffer byteBuffer2;
                ByteBuffer byteBuffer3;
                ByteBuffer byteBuffer4;
                JavaI420Buffer javaI420Buffer;
                long l3;
                block11: {
                    VideoReaderY4M videoReaderY4M = this;
                    l3 = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                    JavaI420Buffer javaI420Buffer2 = javaI420Buffer = JavaI420Buffer.allocate(videoReaderY4M.frameWidth, this.frameHeight);
                    byteBuffer4 = javaI420Buffer2.getDataY();
                    byteBuffer3 = javaI420Buffer2.getDataU();
                    byteBuffer2 = javaI420Buffer2.getDataV();
                    int cfr_ignored_0 = (this.frameHeight + 1) / 2;
                    javaI420Buffer.getStrideY();
                    javaI420Buffer.getStrideU();
                    javaI420Buffer.getStrideV();
                    try {
                        byteBuffer = ByteBuffer.allocate(FRAME_DELIMETER_LENGTH);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    if (videoReaderY4M.mediaFileChannel.read(byteBuffer) >= FRAME_DELIMETER_LENGTH) break block11;
                    VideoReaderY4M videoReaderY4M2 = this;
                    VideoReaderY4M videoReaderY4M3 = videoReaderY4M2;
                    videoReaderY4M2.mediaFileChannel.position(this.videoStart);
                    if (videoReaderY4M3.mediaFileChannel.read(byteBuffer) >= FRAME_DELIMETER_LENGTH) break block11;
                    throw new RuntimeException("Error looping video");
                }
                string2 = string3;
                if (!new String(byteBuffer.array(), Charset.forName("US-ASCII")).equals("FRAME\n")) break block12;
                VideoReaderY4M videoReaderY4M = this;
                VideoReaderY4M videoReaderY4M4 = videoReaderY4M;
                VideoReaderY4M videoReaderY4M5 = videoReaderY4M;
                videoReaderY4M.mediaFileChannel.read(byteBuffer4);
                videoReaderY4M5.mediaFileChannel.read(byteBuffer3);
                videoReaderY4M4.mediaFileChannel.read(byteBuffer2);
                return new VideoFrame(javaI420Buffer, 0, l3);
            }
            throw new RuntimeException("Frames should be delimited by FRAME plus newline, found delimter was: '" + string2 + "'");
        }

        @Override
        public void close() {
            try {
                this.mediaFile.close();
            }
            catch (IOException iOException) {
                Logging.e(TAG, "Problem closing file", iOException);
            }
        }
    }

    public static interface VideoReader {
        public VideoFrame getNextFrame();

        public void close();
    }
}

