/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.webrtc.CalledByNative;

public class EncodedImage {
    public final ByteBuffer buffer;
    public final int encodedWidth;
    public final int encodedHeight;
    public final long captureTimeMs;
    public final long captureTimeNs;
    public final FrameType frameType;
    public final int rotation;
    public final boolean completeFrame;
    @Nullable
    public final Integer qp;

    @CalledByNative
    public EncodedImage(ByteBuffer byteBuffer, int n3, int n4, long l3, FrameType frameType, int n5, boolean bl, @Nullable Integer n6) {
        EncodedImage encodedImage = this;
        this.buffer = byteBuffer;
        this.encodedWidth = n3;
        encodedImage.encodedHeight = n4;
        encodedImage.captureTimeMs = TimeUnit.NANOSECONDS.toMillis(l3);
        this.captureTimeNs = l3;
        this.frameType = frameType;
        this.rotation = n5;
        this.completeFrame = bl;
        this.qp = n6;
    }

    @CalledByNative
    private ByteBuffer getBuffer() {
        return this.buffer;
    }

    @CalledByNative
    private int getEncodedWidth() {
        return this.encodedWidth;
    }

    @CalledByNative
    private int getEncodedHeight() {
        return this.encodedHeight;
    }

    @CalledByNative
    private long getCaptureTimeNs() {
        return this.captureTimeNs;
    }

    @CalledByNative
    private int getFrameType() {
        return this.frameType.getNative();
    }

    @CalledByNative
    private int getRotation() {
        return this.rotation;
    }

    @CalledByNative
    private boolean getCompleteFrame() {
        return this.completeFrame;
    }

    @CalledByNative
    @Nullable
    private Integer getQp() {
        return this.qp;
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public /* synthetic */ EncodedImage(ByteBuffer byteBuffer, int n3, int n4, long l3, FrameType frameType, int n5, boolean bl, Integer n6, 1 var10_9) {
        this(byteBuffer, n3, n4, l3, frameType, n5, bl, n6);
    }

    public static class Builder {
        public ByteBuffer buffer;
        public int encodedWidth;
        public int encodedHeight;
        public long captureTimeNs;
        public FrameType frameType;
        public int rotation;
        public boolean completeFrame;
        @Nullable
        public Integer qp;

        public Builder() {
        }

        public /* synthetic */ Builder(1 var1_1) {
            this();
        }

        public Builder setBuffer(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
            return this;
        }

        public Builder setEncodedWidth(int n3) {
            this.encodedWidth = n3;
            return this;
        }

        public Builder setEncodedHeight(int n3) {
            this.encodedHeight = n3;
            return this;
        }

        @Deprecated
        public Builder setCaptureTimeMs(long l3) {
            this.captureTimeNs = TimeUnit.MILLISECONDS.toNanos(l3);
            return this;
        }

        public Builder setCaptureTimeNs(long l3) {
            this.captureTimeNs = l3;
            return this;
        }

        public Builder setFrameType(FrameType frameType) {
            this.frameType = frameType;
            return this;
        }

        public Builder setRotation(int n3) {
            this.rotation = n3;
            return this;
        }

        public Builder setCompleteFrame(boolean bl) {
            this.completeFrame = bl;
            return this;
        }

        public Builder setQp(@Nullable Integer n3) {
            this.qp = n3;
            return this;
        }

        public EncodedImage createEncodedImage() {
            return new EncodedImage(this.buffer, this.encodedWidth, this.encodedHeight, this.captureTimeNs, this.frameType, this.rotation, this.completeFrame, this.qp, null);
        }
    }

    public static enum FrameType {
        EmptyFrame(0),
        VideoFrameKey(3),
        VideoFrameDelta(4);

        public final int nativeIndex;

        public FrameType(int n4) {
            this.nativeIndex = n4;
        }

        @CalledByNative(value="FrameType")
        public static FrameType fromNativeIndex(int n3) {
            for (FrameType frameType : FrameType.values()) {
                if (frameType.getNative() != n3) continue;
                return frameType;
            }
            throw new IllegalArgumentException("Unknown native frame type: " + n3);
        }

        public int getNative() {
            return this.nativeIndex;
        }
    }
}

