/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.lang.invoke.LambdaMetafactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.webrtc.EglBase;
import org.webrtc.GlTextureFrameBuffer;
import org.webrtc.GlUtil;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoFrameDrawer;
import org.webrtc.VideoSink;

public class EglRenderer
implements VideoSink {
    public static final String TAG = "EglRenderer";
    public static final long LOG_INTERVAL_SEC = 4L;
    public final String name;
    public final Object handlerLock = new Object();
    @Nullable
    public Handler renderThreadHandler;
    public final ArrayList<FrameListenerAndParams> frameListeners = new ArrayList();
    public volatile ErrorCallback errorCallback;
    public final Object fpsReductionLock = new Object();
    public long nextFrameTimeNs;
    public long minRenderPeriodNs;
    @Nullable
    public EglBase eglBase;
    public final VideoFrameDrawer frameDrawer;
    @Nullable
    public RendererCommon.GlDrawer drawer;
    public boolean usePresentationTimeStamp;
    public final Matrix drawMatrix = new Matrix();
    public final Object frameLock = new Object();
    @Nullable
    public VideoFrame pendingFrame;
    public final Object layoutLock = new Object();
    public float layoutAspectRatio;
    public boolean mirrorHorizontally;
    public boolean mirrorVertically;
    public final Object statisticsLock = new Object();
    public int framesReceived;
    public int framesDropped;
    public int framesRendered;
    public long statisticsStartTimeNs;
    public long renderTimeNs;
    public long renderSwapBufferTimeNs;
    public final GlTextureFrameBuffer bitmapTextureFramebuffer = new GlTextureFrameBuffer(6408);
    public final Runnable logStatisticsRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            1 v02 = this;
            v02.EglRenderer.this.logStatistics();
            Object object = v02.EglRenderer.this.handlerLock;
            synchronized (object) {
                block5: {
                    if (v02.EglRenderer.this.renderThreadHandler == null) break block5;
                    1 v22 = this;
                    v22.EglRenderer.this.renderThreadHandler.removeCallbacks(EglRenderer.this.logStatisticsRunnable);
                    v22.EglRenderer.this.renderThreadHandler.postDelayed(EglRenderer.this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                }
                return;
            }
        }
    };
    public final EglSurfaceCreation eglSurfaceCreationRunnable = new EglSurfaceCreation(null);

    public EglRenderer(String string2) {
        this(string2, new VideoFrameDrawer());
    }

    public EglRenderer(String string2, VideoFrameDrawer videoFrameDrawer) {
        this.name = string2;
        this.frameDrawer = videoFrameDrawer;
    }

    private void createEglSurfaceInternal(Object object) {
        EglRenderer eglRenderer = this;
        eglRenderer.eglSurfaceCreationRunnable.setSurface(object);
        eglRenderer.postToRenderThread(eglRenderer.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatistics(long l3) {
        Object object = this.statisticsLock;
        EglRenderer eglRenderer = this;
        synchronized (object) {
            eglRenderer.statisticsStartTimeNs = l3;
            eglRenderer.framesReceived = 0;
            eglRenderer.framesDropped = 0;
            eglRenderer.framesRendered = 0;
            eglRenderer.renderTimeNs = 0L;
            eglRenderer.renderSwapBufferTimeNs = 0L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToRenderThread(Runnable runnable) {
        EglRenderer eglRenderer = this;
        Object object = eglRenderer.handlerLock;
        synchronized (object) {
            block5: {
                if (eglRenderer.renderThreadHandler == null) break block5;
                this.renderThreadHandler.post(runnable);
            }
            return;
        }
    }

    private void clearSurfaceOnRenderThread(float f3, float f4, float f5, float f6) {
        EglBase eglBase = this.eglBase;
        if (eglBase != null && eglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)f3, (float)f4, (float)f5, (float)f6);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void renderFrameOnRenderThread() {
        block31: {
            block32: {
                block29: {
                    v0 = this;
                    var1_1 = v0.frameLock;
                    // MONITORENTER : var1_1
                    if (v0.pendingFrame == null) {
                        // MONITOREXIT : var1_1
                        return;
                    }
                    var2_6 = this.pendingFrame;
                    this.pendingFrame = null;
                    // MONITOREXIT : var1_1
                    var1_1 = this.eglBase;
                    if (var1_1 == null || !var1_1.hasSurface()) ** GOTO lbl113
                    v1 = this;
                    var1_1 = v1.fpsReductionLock;
                    {
                        catch (Throwable v2) {
                            // MONITOREXIT : var1_1
                            throw v2;
                        }
                    }
                    // MONITORENTER : var1_1
                    if (v1.minRenderPeriodNs == 0x7FFFFFFFFFFFFFFFL) ** GOTO lbl25
                    if (this.minRenderPeriodNs <= 0L) ** GOTO lbl30
                    var3_7 = System.nanoTime();
                    if (var3_7 < this.nextFrameTimeNs) {
                        this.logD("Skipping frame rendering - fps reduction is active.");
lbl25:
                        // 2 sources

                        var3_8 = false;
                    } else {
                        v3 = this;
                        v3.nextFrameTimeNs += this.minRenderPeriodNs;
                        v3.nextFrameTimeNs = Math.max(v3.nextFrameTimeNs, var3_7);
lbl30:
                        // 2 sources

                        var3_8 = true;
                    }
                    v4 = this;
                    v5 = v4;
                    v6 = v4;
                    v7 = var2_6;
                    // MONITOREXIT : var1_1
                    {
                        catch (Throwable v8) {
                            // MONITOREXIT : var1_1
                            throw v8;
                        }
                    }
                    var4_9 = System.nanoTime();
                    var1_2 = (float)v7.getRotatedWidth() / (float)var2_6.getRotatedHeight();
                    var6_10 = v5.layoutLock;
                    // MONITORENTER : var6_10
                    var7_13 = v6.layoutAspectRatio != 0.0f ? this.layoutAspectRatio : var1_2;
                    // MONITOREXIT : var6_10
                    if (!(var1_2 > var7_13)) break block29;
                    {
                        catch (Throwable v9) {
                            // MONITOREXIT : var6_10
                            throw v9;
                        }
                    }
                    var1_2 = var7_13 / var1_2;
                    var6_11 = 1.0f;
                    break block32;
                }
                v10 = var1_2;
                var1_2 = 1.0f;
                var6_11 = v10 / var7_13;
            }
            v11 = this;
            v11.drawMatrix.reset();
            v11.drawMatrix.preTranslate(0.5f, 0.5f);
            var7_14 = v11.drawMatrix;
            var8_15 = v11.mirrorHorizontally != false ? -1.0f : 1.0f;
            var9_17 = this.mirrorVertically != false ? -1.0f : 1.0f;
            v12 = this;
            var7_14.preScale(var8_15, var9_17);
            v12.drawMatrix.preScale(var1_2, var6_11);
            v12.drawMatrix.preTranslate(-0.5f, -0.5f);
            if (!var3_8) ** GOTO lbl110
            v13 = this;
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            v13.frameDrawer.drawFrame(var2_6, this.drawer, this.drawMatrix, 0, 0, this.eglBase.surfaceWidth(), this.eglBase.surfaceHeight());
            var6_12 = System.nanoTime();
            if (v13.usePresentationTimeStamp) {
                this.eglBase.swapBuffers(var2_6.getTimestampNs());
            } else {
                this.eglBase.swapBuffers();
            }
            var8_16 = System.nanoTime();
            var1_3 = this.statisticsLock;
            v14 = this;
            v15 = var8_16;
            v16 = var6_12;
            v17 = this;
            v18 = v17;
            v19 = v17;
            v20 = var8_16;
            v21 = var4_9;
            v22 = this;
            v23 = v22;
            v24 = v22;
            v25 = v22;
            // MONITORENTER : var1_3
            try {
                v25.framesRendered = v24.framesRendered + 1;
                var4_9 = v23.renderTimeNs;
                v18.renderTimeNs = v20 - v21 + var4_9;
                var4_9 = v19.renderSwapBufferTimeNs;
                v14.renderSwapBufferTimeNs = v15 - v16 + var4_9;
                // MONITOREXIT : var1_3
                ** GOTO lbl110
            }
            catch (Throwable v26) {
                block30: {
                    // MONITOREXIT : var1_3
                    throw v26;
lbl110:
                    // 2 sources

                    v27 = var2_6;
                    this.notifyCallbacks(var2_6, var3_8);
                    break block30;
lbl113:
                    // 1 sources

                    this.logD("Dropping frame - No surface");
                    var2_6.release();
                    return;
                }
lbl117:
                // 2 sources

                while (true) {
                    v27.release();
                    return;
                }
                {
                    catch (Throwable v28) {
                        break block31;
                    }
                    catch (GlUtil.GlOutOfMemoryException var1_4) {}
                    {
                        v29 = this;
                        v29.logE("Error while drawing frame", var1_4);
                        var1_5 = v29.errorCallback;
                        if (var1_5 == null) ** GOTO lbl128
                    }
                    {
                        var1_5.onGlOutOfMemory();
lbl128:
                        // 2 sources

                        v27 = var2_6;
                        v30 = this;
                        v30.drawer.release();
                        v30.frameDrawer.release();
                        v30.bitmapTextureFramebuffer.release();
                        ** continue;
                    }
                }
            }
        }
        var2_6.release();
        throw v28;
    }

    private void notifyCallbacks(VideoFrame videoFrame, boolean bl) {
        if (this.frameListeners.isEmpty()) {
            return;
        }
        EglRenderer eglRenderer = this;
        eglRenderer.drawMatrix.reset();
        eglRenderer.drawMatrix.preTranslate(0.5f, 0.5f);
        Object object = eglRenderer.drawMatrix;
        float f3 = eglRenderer.mirrorHorizontally ? -1.0f : 1.0f;
        float f4 = this.mirrorVertically ? -1.0f : 1.0f;
        EglRenderer eglRenderer2 = this;
        object.preScale(f3, f4);
        eglRenderer2.drawMatrix.preScale(1.0f, -1.0f);
        eglRenderer2.drawMatrix.preTranslate(-0.5f, -0.5f);
        object = eglRenderer2.frameListeners.iterator();
        while (object.hasNext()) {
            Object object2 = (FrameListenerAndParams)object.next();
            if (!bl && ((FrameListenerAndParams)object2).applyFpsReduction) continue;
            object.remove();
            int n3 = (int)(((FrameListenerAndParams)object2).scale * (float)videoFrame.getRotatedWidth());
            int n4 = (int)(((FrameListenerAndParams)object2).scale * (float)videoFrame.getRotatedHeight());
            if (n3 != 0 && n4 != 0) {
                FrameListenerAndParams frameListenerAndParams = object2;
                EglRenderer eglRenderer3 = this;
                eglRenderer3.bitmapTextureFramebuffer.setSize(n3, n4);
                GLES20.glBindFramebuffer((int)36160, (int)eglRenderer3.bitmapTextureFramebuffer.getFrameBufferId());
                int n5 = eglRenderer3.bitmapTextureFramebuffer.getTextureId();
                GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n5, (int)0);
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GLES20.glClear((int)16384);
                eglRenderer3.frameDrawer.drawFrame(videoFrame, ((FrameListenerAndParams)object2).drawer, this.drawMatrix, 0, 0, n3, n4);
                object2 = ByteBuffer.allocateDirect(n3 * n4 * 4);
                GLES20.glViewport((int)0, (int)0, (int)n3, (int)n4);
                GLES20.glReadPixels((int)0, (int)0, (int)n3, (int)n4, (int)6408, (int)5121, (Buffer)object2);
                GLES20.glBindFramebuffer((int)36160, (int)0);
                GlUtil.checkNoGLES2Error("EglRenderer.notifyCallbacks");
                Bitmap bitmap = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap.copyPixelsFromBuffer((Buffer)object2);
                frameListenerAndParams.listener.onFrame(bitmap);
                continue;
            }
            ((FrameListenerAndParams)object2).listener.onFrame(null);
        }
    }

    private String averageTimeAsString(long l3, int n3) {
        return n3 <= 0 ? "NA" : TimeUnit.NANOSECONDS.toMicros(l3 / (long)n3) + " us";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logStatistics() {
        DecimalFormat decimalFormat;
        DecimalFormat decimalFormat2 = decimalFormat;
        decimalFormat = new DecimalFormat("#.0");
        long l3 = System.nanoTime();
        EglRenderer eglRenderer = this;
        Object object = eglRenderer.statisticsLock;
        synchronized (object) {
            long l4 = l3 - eglRenderer.statisticsStartTimeNs;
            if (l4 <= 0L) {
                return;
            }
            Object object2 = object;
            EglRenderer eglRenderer2 = this;
            long l5 = l3;
            EglRenderer eglRenderer3 = this;
            EglRenderer eglRenderer4 = eglRenderer3;
            float f3 = (float)((long)eglRenderer3.framesRendered * TimeUnit.SECONDS.toNanos(1L)) / (float)l4;
            StringBuilder stringBuilder = new StringBuilder().append("Duration: ").append(TimeUnit.NANOSECONDS.toMillis(l4)).append(" ms. Frames received: ").append(this.framesReceived).append(". Dropped: ").append(this.framesDropped).append(". Rendered: ").append(this.framesRendered).append(". Render fps: ");
            EglRenderer eglRenderer5 = this;
            EglRenderer eglRenderer6 = this;
            eglRenderer4.logD(stringBuilder.append(decimalFormat2.format(f3)).append(". Average render time: ").append(eglRenderer5.averageTimeAsString(eglRenderer5.renderTimeNs, this.framesRendered)).append(". Average swapBuffer time: ").append(eglRenderer6.averageTimeAsString(eglRenderer6.renderSwapBufferTimeNs, this.framesRendered)).append(".").toString());
            eglRenderer2.resetStatistics(l5);
            // ** MonitorExit[v2] (shouldn't be in output)
            return;
        }
    }

    private void logE(String string2, Throwable throwable) {
        Logging.e(TAG, this.name + string2, throwable);
    }

    private void logD(String string2) {
        Logging.d(TAG, this.name + string2);
    }

    private void logW(String string2) {
        Logging.w(TAG, this.name + string2);
    }

    private /* synthetic */ void a(Runnable runnable) {
        EglBase eglBase = this.eglBase;
        if (eglBase != null) {
            eglBase.detachCurrent();
            this.eglBase.releaseSurface();
        }
        runnable.run();
    }

    private /* synthetic */ void a(Looper looper) {
        this.logD("Quitting render thread.");
        looper.quit();
    }

    private /* synthetic */ void a(CountDownLatch countDownLatch) {
        GLES20.glUseProgram((int)0);
        RendererCommon.GlDrawer glDrawer = this.drawer;
        if (glDrawer != null) {
            glDrawer.release();
            this.drawer = null;
        }
        EglRenderer eglRenderer = this;
        eglRenderer.frameDrawer.release();
        eglRenderer.bitmapTextureFramebuffer.release();
        if (eglRenderer.eglBase != null) {
            EglRenderer eglRenderer2 = this;
            eglRenderer2.logD("eglBase detach and release.");
            eglRenderer2.eglBase.detachCurrent();
            eglRenderer2.eglBase.release();
            eglRenderer2.eglBase = null;
        }
        this.frameListeners.clear();
        countDownLatch.countDown();
    }

    private /* synthetic */ void a(EglBase.Context context, int[] nArray) {
        if (context == null) {
            this.logD("EglBase10.create context");
            this.eglBase = EglBase.createEgl10(nArray);
        } else {
            this.logD("EglBase.create shared context");
            this.eglBase = EglBase.create(context, nArray);
        }
    }

    public static /* synthetic */ Handler access$302(EglRenderer eglRenderer, Handler handler) {
        eglRenderer.renderThreadHandler = handler;
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void init(@Nullable EglBase.Context var1_1, int[] var2_2, RendererCommon.GlDrawer var3_3, boolean var4_4) {
        v0 = this;
        var5_5 = v0.handlerLock;
        synchronized (var5_5) {
            if (v0.renderThreadHandler != null) ** GOTO lbl33
            v2 = var5_5;
            v3 = this;
            v4 = v3;
            v5 = v3;
            v6 = v3;
            v7 = v3;
            v8 = v3;
            this.logD("Initializing EglRenderer");
            this.drawer = var3_3;
            v3.usePresentationTimeStamp = var4_4;
            var3_3 = v9;
            new HandlerThread(this.name + "EglRenderer").start();
            v6.renderThreadHandler = new HandlerWithExceptionCallback(var3_3.getLooper(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = EglRenderer.this.handlerLock;
                    synchronized (object) {
                        EglRenderer.access$302(EglRenderer.this, null);
                        return;
                    }
                }
            });
            ThreadUtils.invokeAtFrontUninterruptibly(v7.renderThreadHandler, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(org.webrtc.EglBase$Context int[] ), ()V)((EglRenderer)this, (EglBase.Context)var1_1, (int[])var2_2));
            v8.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
            v4.resetStatistics(System.nanoTime());
            v5.renderThreadHandler.postDelayed(this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
            // ** MonitorExit[v2] (shouldn't be in output)
            return;
lbl33:
            // 1 sources

            v10 = v11;
            v12 = v11;
            v10(this.name + "Already initialized");
            throw v12;
        }
    }

    public void init(@Nullable EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.init(context, nArray, glDrawer, false);
    }

    public void createEglSurface(Surface surface) {
        this.createEglSurfaceInternal(surface);
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.createEglSurfaceInternal(surfaceTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        CountDownLatch countDownLatch;
        EglRenderer eglRenderer = this;
        eglRenderer.logD("Releasing.");
        Object object = countDownLatch;
        countDownLatch = new CountDownLatch(1);
        Object object2 = eglRenderer.handlerLock;
        synchronized (object2) {
            if (eglRenderer.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            EglRenderer eglRenderer2 = this;
            EglRenderer eglRenderer3 = eglRenderer2;
            EglRenderer eglRenderer4 = eglRenderer2;
            CountDownLatch countDownLatch2 = object;
            Object object3 = object2;
            EglRenderer eglRenderer5 = this;
            EglRenderer eglRenderer6 = eglRenderer5;
            EglRenderer eglRenderer7 = eglRenderer5;
            EglRenderer eglRenderer8 = eglRenderer5;
            eglRenderer5.renderThreadHandler.removeCallbacks(this.logStatisticsRunnable);
            eglRenderer5.renderThreadHandler.postAtFrontOfQueue(() -> this.a((CountDownLatch)object));
            {
                object = eglRenderer7.renderThreadHandler.getLooper();
                eglRenderer8.renderThreadHandler.post(() -> this.a((Looper)object));
            }
            {
                eglRenderer6.renderThreadHandler = null;
                // ** MonitorExit[v6] (shouldn't be in output)
            }
            ThreadUtils.awaitUninterruptibly(countDownLatch2);
            object = eglRenderer3.frameLock;
            synchronized (object) {
                if (eglRenderer4.pendingFrame != null) {
                    this.pendingFrame.release();
                    this.pendingFrame = null;
                }
                // MONITOREXIT @DISABLED, blocks:[3, 4, 5] lbl39 : MonitorExitStatement: MONITOREXIT : var1_1
                this.logD("Releasing done.");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        EglRenderer eglRenderer = this;
        Object object = eglRenderer.handlerLock;
        synchronized (object) {
            block13: {
                StackTraceElement[] stackTraceElementArray;
                block12: {
                    block11: {
                        if (eglRenderer.renderThreadHandler != null) break block11;
                        stackTraceElementArray = null;
                        break block12;
                    }
                    stackTraceElementArray = this.renderThreadHandler.getLooper().getThread();
                }
                if (stackTraceElementArray != null) {
                    stackTraceElementArray = stackTraceElementArray.getStackTrace();
                    if (stackTraceElementArray.length <= 0) break block13;
                    this.logW("EglRenderer stack trace:");
                    int n3 = stackTraceElementArray.length;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        this.logW(stackTraceElementArray[i3].toString());
                        continue;
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean bl) {
        EglRenderer eglRenderer = this;
        eglRenderer.logD("setMirrorHorizontally: " + bl);
        Object object = eglRenderer.layoutLock;
        synchronized (object) {
            this.mirrorHorizontally = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirrorVertically(boolean bl) {
        EglRenderer eglRenderer = this;
        eglRenderer.logD("setMirrorVertically: " + bl);
        Object object = eglRenderer.layoutLock;
        synchronized (object) {
            this.mirrorVertically = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutAspectRatio(float f3) {
        EglRenderer eglRenderer = this;
        eglRenderer.logD("setLayoutAspectRatio: " + f3);
        Object object = eglRenderer.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = f3;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void setFpsReduction(float var1_1) {
        v0 = this;
        v0.logD("setFpsReduction: " + var1_1);
        var2_2 = v0.fpsReductionLock;
        synchronized (var2_2) {
            var3_3 = v0.minRenderPeriodNs;
            if (!(var1_1 <= 0.0f)) ** GOTO lbl13
            this.minRenderPeriodNs = 0x7FFFFFFFFFFFFFFFL;
            ** GOTO lbl17
lbl13:
            // 1 sources

            v2 = this;
            v3 = TimeUnit.SECONDS.toNanos(1L);
            v2.minRenderPeriodNs = (long)(v3 / var1_1);
lbl17:
            // 2 sources

            if (this.minRenderPeriodNs == var3_3) ** GOTO lbl20
            this.nextFrameTimeNs = System.nanoTime();
lbl20:
            // 2 sources

            return;
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    public void addFrameListener(FrameListener frameListener, float f3) {
        this.addFrameListener(frameListener, f3, null, false);
    }

    public void addFrameListener(FrameListener frameListener, float f3, RendererCommon.GlDrawer glDrawer) {
        this.addFrameListener(frameListener, f3, glDrawer, false);
    }

    public void addFrameListener(FrameListener frameListener, float f3, @Nullable RendererCommon.GlDrawer glDrawer, boolean bl) {
        EglRenderer eglRenderer = this;
        eglRenderer.postToRenderThread(() -> {
            if (glDrawer == null) {
                glDrawer = this.drawer;
            }
            this.frameListeners.add(new FrameListenerAndParams(frameListener, f3, glDrawer, bl));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFrameListener(FrameListener frameListener) {
        CountDownLatch countDownLatch;
        EglRenderer eglRenderer = this;
        CountDownLatch countDownLatch2 = countDownLatch;
        countDownLatch = new CountDownLatch(1);
        Object object = eglRenderer.handlerLock;
        synchronized (object) {
            if (eglRenderer.renderThreadHandler == null) {
                return;
            }
            if (Thread.currentThread() != this.renderThreadHandler.getLooper().getThread()) {
                EglRenderer eglRenderer2 = this;
                eglRenderer2.postToRenderThread(() -> {
                    countDownLatch2.countDown();
                    Iterator<FrameListenerAndParams> iterator = ((EglRenderer)((Object)iterator)).frameListeners.iterator();
                    while (iterator.hasNext()) {
                        if (((FrameListenerAndParams)iterator.next()).listener != frameListener) continue;
                        iterator.remove();
                    }
                });
                // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                ThreadUtils.awaitUninterruptibly(countDownLatch2);
                return;
            }
            throw new RuntimeException("removeFrameListener must not be called on the render thread.");
        }
    }

    public void setErrorCallback(ErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onFrame(VideoFrame object) {
        EglRenderer eglRenderer = this;
        Object object2 = eglRenderer.statisticsLock;
        // MONITORENTER : object2
        ++this.framesReceived;
        // MONITOREXIT : object2
        Object object3 = eglRenderer.handlerLock;
        // MONITORENTER : object3
        if (eglRenderer.renderThreadHandler == null) {
            this.logD("Dropping frame - Not initialized or already released.");
            // MONITOREXIT : object3
            return;
        }
        EglRenderer eglRenderer2 = this;
        EglRenderer eglRenderer3 = eglRenderer2;
        object2 = eglRenderer2.frameLock;
        {
            catch (Throwable throwable) {
                // MONITOREXIT : object3
                throw throwable;
            }
        }
        boolean bl = eglRenderer3.pendingFrame != null;
        if (bl) {
            this.pendingFrame.release();
        }
        boolean bl2 = bl;
        Object object4 = object3;
        Object object5 = object2;
        EglRenderer eglRenderer4 = this;
        eglRenderer4.pendingFrame = object;
        eglRenderer4.pendingFrame.retain();
        eglRenderer4.renderThreadHandler.post(this::renderFrameOnRenderThread);
        if (!bl2) return;
        object = this.statisticsLock;
        // MONITORENTER : object
        ++this.framesDropped;
        // MONITOREXIT : object
        return;
        catch (Throwable throwable) {
            // MONITOREXIT : object2
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void releaseEglSurface(Runnable var1_1) {
        v0 = this;
        v0.eglSurfaceCreationRunnable.setSurface(null);
        var2_2 = v0.handlerLock;
        synchronized (var2_2) {
            if (v0.renderThreadHandler == null) ** GOTO lbl18
            v2 = var2_2;
            v3 = this;
            v3.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
            v3.renderThreadHandler.postAtFrontOfQueue((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(java.lang.Runnable ), ()V)((EglRenderer)this, (Runnable)var1_1));
            // ** MonitorExit[v2] (shouldn't be in output)
            return;
lbl18:
            // 1 sources

            // MONITOREXIT @DISABLED, blocks:[2, 3] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
            var1_1.run();
            return;
        }
    }

    public void clearImage() {
        this.clearImage(0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearImage(float f3, float f4, float f5, float f6) {
        EglRenderer eglRenderer = this;
        Object object = eglRenderer.handlerLock;
        synchronized (object) {
            if (eglRenderer.renderThreadHandler == null) {
                return;
            }
            Object object2 = object;
            this.renderThreadHandler.postAtFrontOfQueue(() -> this.clearSurfaceOnRenderThread(f3, f4, f5, f6));
            {
                // ** MonitorExit[v1] (shouldn't be in output)
                return;
            }
        }
    }

    public static class HandlerWithExceptionCallback
    extends Handler {
        public final Runnable exceptionCallback;

        public HandlerWithExceptionCallback(Looper looper, Runnable runnable) {
            super(looper);
            this.exceptionCallback = runnable;
        }

        public void dispatchMessage(Message object) {
            try {
                super.dispatchMessage(object);
                return;
            }
            catch (Exception exception) {
                object = exception;
                Logging.e(EglRenderer.TAG, "Exception on EglRenderer thread", (Throwable)object);
                this.exceptionCallback.run();
                throw exception;
            }
        }
    }

    public class EglSurfaceCreation
    implements Runnable {
        public Object surface;

        public EglSurfaceCreation() {
        }

        public /* synthetic */ EglSurfaceCreation(1 var2_2) {
            this();
        }

        public synchronized void setSurface(Object object) {
            this.surface = object;
        }

        @Override
        public synchronized void run() {
            block4: {
                if (this.surface == null || EglRenderer.this.eglBase == null || EglRenderer.this.eglBase.hasSurface()) break block4;
                Object object = this.surface;
                if (object instanceof Surface) {
                    EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                } else {
                    if (!(object instanceof SurfaceTexture)) {
                        throw new IllegalStateException(a.a("Invalid surface: ").append(this.surface).toString());
                    }
                    EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                }
                EglRenderer.this.eglBase.makeCurrent();
                GLES20.glPixelStorei((int)3317, (int)1);
            }
        }
    }

    public static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final RendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;

        public FrameListenerAndParams(FrameListener frameListener, float f3, RendererCommon.GlDrawer glDrawer, boolean bl) {
            this.listener = frameListener;
            this.scale = f3;
            this.drawer = glDrawer;
            this.applyFpsReduction = bl;
        }
    }

    public static interface ErrorCallback {
        public void onGlOutOfMemory();
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }
}

