/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.Surface;
import org.webrtc.EglBase;
import org.webrtc.EglBase14;
import org.webrtc.Logging;

@TargetApi(value=18)
public class EglBase14Impl
implements EglBase14 {
    public static final String TAG = "EglBase14Impl";
    public static final int EGLExt_SDK_VERSION = 18;
    public static final int CURRENT_SDK_VERSION = Build.VERSION.SDK_INT;
    public EGLContext eglContext;
    @Nullable
    public EGLConfig eglConfig;
    public EGLDisplay eglDisplay;
    public EGLSurface eglSurface;

    public static boolean isEGL14Supported() {
        String string2 = TAG;
        StringBuilder stringBuilder = a.a("SDK version: ").append(CURRENT_SDK_VERSION).append(". isEGL14Supported: ");
        boolean bl = CURRENT_SDK_VERSION >= 18;
        Logging.d(string2, stringBuilder.append(bl).toString());
        return CURRENT_SDK_VERSION >= 18;
    }

    public EglBase14Impl(EGLContext eGLContext, int[] nArray) {
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.eglSurface = EGL14.EGL_NO_SURFACE;
        eglBase14Impl.eglDisplay = EglBase14Impl.getEglDisplay();
        eglBase14Impl.eglConfig = EglBase14Impl.getEglConfig(eglBase14Impl.eglDisplay, nArray);
        int n3 = EglBase.getOpenGlesVersionFromConfig(nArray);
        Logging.d(TAG, "Using OpenGL ES version " + n3);
        this.eglContext = EglBase14Impl.createEglContext(eGLContext, this.eglDisplay, this.eglConfig, n3);
    }

    private void createSurfaceInternal(Object object) {
        if (!(object instanceof Surface) && !(object instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a Surface or SurfaceTexture");
        }
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.checkIsNotReleased();
        if (eglBase14Impl.eglSurface == EGL14.EGL_NO_SURFACE) {
            EglBase14Impl eglBase14Impl2 = this;
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = 12344;
            eglBase14Impl2.eglSurface = EGL14.eglCreateWindowSurface((EGLDisplay)eglBase14Impl2.eglDisplay, (EGLConfig)this.eglConfig, (Object)object, (int[])nArray2, (int)0);
            if (eglBase14Impl2.eglSurface != EGL14.EGL_NO_SURFACE) {
                return;
            }
            throw new RuntimeException(a.a("Failed to create window surface: 0x").append(Integer.toHexString(EGL14.eglGetError())).toString());
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay != EGL14.EGL_NO_DISPLAY && this.eglContext != EGL14.EGL_NO_CONTEXT && this.eglConfig != null) {
            return;
        }
        throw new RuntimeException("This object has been released");
    }

    public static EGLDisplay getEglDisplay() {
        EGLDisplay eGLDisplay = EGL14.eglGetDisplay((int)0);
        if (eGLDisplay != EGL14.EGL_NO_DISPLAY) {
            int[] nArray = new int[2];
            if (EGL14.eglInitialize((EGLDisplay)eGLDisplay, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
                return eGLDisplay;
            }
            throw new RuntimeException(a.a("Unable to initialize EGL14: 0x").append(Integer.toHexString(EGL14.eglGetError())).toString());
        }
        throw new RuntimeException(a.a("Unable to get EGL14 display: 0x").append(Integer.toHexString(EGL14.eglGetError())).toString());
    }

    public static EGLConfig getEglConfig(EGLDisplay eGLConfig, int[] nArray) {
        int n3 = ((EGLConfig[])eGLConfig).length;
        if (EGL14.eglChooseConfig((EGLDisplay)eGLConfig, (int[])nArray, (int)0, (EGLConfig[])(eGLConfig = new EGLConfig[1]), (int)0, (int)n3, (int[])(nArray = new int[1]), (int)0)) {
            if (nArray[0] > 0) {
                if ((eGLConfig = eGLConfig[0]) != null) {
                    return eGLConfig;
                }
                throw new RuntimeException("eglChooseConfig returned null");
            }
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        throw new RuntimeException(a.a("eglChooseConfig failed: 0x").append(Integer.toHexString(EGL14.eglGetError())).toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EGLContext createEglContext(@Nullable EGLContext object, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n3) {
        if (object != null) {
            if (object == EGL14.EGL_NO_CONTEXT) throw new RuntimeException("Invalid sharedContext");
        }
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray[0] = 12440;
        nArray[1] = n3;
        nArray[2] = 12344;
        if (object == null) {
            object = EGL14.EGL_NO_CONTEXT;
        }
        EGLContext eGLContext = object;
        object = EglBase.lock;
        synchronized (object) {
            eGLDisplay = EGL14.eglCreateContext((EGLDisplay)eGLDisplay, (EGLConfig)eGLConfig, (EGLContext)eGLContext, (int[])nArray2, (int)0);
            {
                if (eGLDisplay == EGL14.EGL_NO_CONTEXT) throw new RuntimeException(a.a("Failed to create EGL context: 0x").append(Integer.toHexString(EGL14.eglGetError())).toString());
                return eGLDisplay;
            }
        }
    }

    @Override
    public void createSurface(Surface surface) {
        this.createSurfaceInternal(surface);
    }

    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        this.createSurfaceInternal(surfaceTexture);
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int n3, int n4) {
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.checkIsNotReleased();
        if (eglBase14Impl.eglSurface == EGL14.EGL_NO_SURFACE) {
            EglBase14Impl eglBase14Impl2 = this;
            int[] nArray = new int[5];
            int[] nArray2 = nArray;
            nArray[0] = 12375;
            nArray[1] = n3;
            nArray[2] = 12374;
            nArray[3] = n4;
            nArray[4] = 12344;
            eglBase14Impl2.eglSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)eglBase14Impl2.eglDisplay, (EGLConfig)this.eglConfig, (int[])nArray2, (int)0);
            if (eglBase14Impl2.eglSurface != EGL14.EGL_NO_SURFACE) {
                return;
            }
            throw new RuntimeException("Failed to create pixel buffer surface with size " + n3 + "x" + n4 + ": 0x" + Integer.toHexString(EGL14.eglGetError()));
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    @Override
    public Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        return this.eglSurface != EGL14.EGL_NO_SURFACE;
    }

    @Override
    public int surfaceWidth() {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12375, (int[])nArray, (int)0);
        return nArray[0];
    }

    @Override
    public int surfaceHeight() {
        int[] nArray = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12374, (int[])nArray, (int)0);
        return nArray[0];
    }

    @Override
    public void releaseSurface() {
        EGLSurface eGLSurface = this.eglSurface;
        if (eGLSurface != EGL14.EGL_NO_SURFACE) {
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)eGLSurface);
            this.eglSurface = EGL14.EGL_NO_SURFACE;
        }
    }

    @Override
    public void release() {
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.checkIsNotReleased();
        eglBase14Impl.releaseSurface();
        eglBase14Impl.detachCurrent();
        EGL14.eglDestroyContext((EGLDisplay)eglBase14Impl.eglDisplay, (EGLContext)this.eglContext);
        EGL14.eglReleaseThread();
        EGL14.eglTerminate((EGLDisplay)eglBase14Impl.eglDisplay);
        eglBase14Impl.eglContext = EGL14.EGL_NO_CONTEXT;
        eglBase14Impl.eglDisplay = EGL14.EGL_NO_DISPLAY;
        eglBase14Impl.eglConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void makeCurrent() {
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.checkIsNotReleased();
        if (eglBase14Impl.eglSurface == EGL14.EGL_NO_SURFACE) throw new RuntimeException("No EGLSurface - can't make current");
        Object object = EglBase.lock;
        synchronized (object) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) throw new RuntimeException("eglMakeCurrent failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void detachCurrent() {
        EglBase14Impl eglBase14Impl = object;
        Object object = EglBase.lock;
        synchronized (object) {
            if (!EGL14.eglMakeCurrent((EGLDisplay)eglBase14Impl.eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) throw new RuntimeException("eglDetachCurrent failed: 0x" + Integer.toHexString(EGL14.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.checkIsNotReleased();
        if (eglBase14Impl.eglSurface != EGL14.EGL_NO_SURFACE) {
            Object object = EglBase.lock;
            synchronized (object) {
                EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers(long l3) {
        EglBase14Impl eglBase14Impl = this;
        eglBase14Impl.checkIsNotReleased();
        if (eglBase14Impl.eglSurface != EGL14.EGL_NO_SURFACE) {
            Object object = EglBase.lock;
            EglBase14Impl eglBase14Impl2 = this;
            synchronized (object) {
                EGLExt.eglPresentationTimeANDROID((EGLDisplay)eglBase14Impl2.eglDisplay, (EGLSurface)this.eglSurface, (long)l3);
                EGL14.eglSwapBuffers((EGLDisplay)eglBase14Impl2.eglDisplay, (EGLSurface)this.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    public static class Context
    implements EglBase14.Context {
        public final EGLContext egl14Context;

        public Context(EGLContext eGLContext) {
            this.egl14Context = eGLContext;
        }

        @Override
        public EGLContext getRawContext() {
            return this.egl14Context;
        }

        @Override
        @TargetApi(value=21)
        public long getNativeEglContext() {
            return CURRENT_SDK_VERSION >= 21 ? this.egl14Context.getNativeHandle() : (long)this.egl14Context.getHandle();
        }
    }
}

