/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import a.a.a.a.a;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.support.annotation.Nullable;
import android.view.Surface;
import android.view.SurfaceHolder;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import org.webrtc.EglBase;
import org.webrtc.EglBase10;
import org.webrtc.Logging;

public class EglBase10Impl
implements EglBase10 {
    public static final String TAG = "EglBase10Impl";
    public static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    public final EGL10 egl;
    public EGLContext eglContext;
    @Nullable
    public EGLConfig eglConfig;
    public EGLDisplay eglDisplay;
    public EGLSurface eglSurface;

    public EglBase10Impl(EGLContext eGLContext, int[] nArray) {
        EglBase10Impl eglBase10Impl = this;
        eglBase10Impl.eglSurface = EGL10.EGL_NO_SURFACE;
        eglBase10Impl.egl = (EGL10)EGLContext.getEGL();
        eglBase10Impl.eglDisplay = eglBase10Impl.getEglDisplay();
        eglBase10Impl.eglConfig = eglBase10Impl.getEglConfig(eglBase10Impl.eglDisplay, nArray);
        int n3 = EglBase.getOpenGlesVersionFromConfig(nArray);
        Logging.d(TAG, "Using OpenGL ES version " + n3);
        this.eglContext = this.createEglContext(eGLContext, this.eglDisplay, this.eglConfig, n3);
    }

    private void createSurfaceInternal(Object object) {
        if (!(object instanceof SurfaceHolder) && !(object instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a SurfaceHolder or SurfaceTexture");
        }
        EglBase10Impl eglBase10Impl = this;
        eglBase10Impl.checkIsNotReleased();
        if (eglBase10Impl.eglSurface == EGL10.EGL_NO_SURFACE) {
            EglBase10Impl eglBase10Impl2 = this;
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = 12344;
            eglBase10Impl2.eglSurface = eglBase10Impl2.egl.eglCreateWindowSurface(this.eglDisplay, this.eglConfig, object, nArray2);
            if (eglBase10Impl2.eglSurface != EGL10.EGL_NO_SURFACE) {
                return;
            }
            throw new RuntimeException(a.a("Failed to create window surface: 0x").append(Integer.toHexString(this.egl.eglGetError())).toString());
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay != EGL10.EGL_NO_DISPLAY && this.eglContext != EGL10.EGL_NO_CONTEXT && this.eglConfig != null) {
            return;
        }
        throw new RuntimeException("This object has been released");
    }

    private EGLDisplay getEglDisplay() {
        EGLDisplay eGLDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (eGLDisplay != EGL10.EGL_NO_DISPLAY) {
            int[] nArray = new int[2];
            if (this.egl.eglInitialize(eGLDisplay, nArray)) {
                return eGLDisplay;
            }
            throw new RuntimeException(a.a("Unable to initialize EGL10: 0x").append(Integer.toHexString(this.egl.eglGetError())).toString());
        }
        throw new RuntimeException(a.a("Unable to get EGL10 display: 0x").append(Integer.toHexString(this.egl.eglGetError())).toString());
    }

    private EGLConfig getEglConfig(EGLDisplay eGLDisplay, int[] nArray) {
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[1];
        if (eglBase10Impl.egl.eglChooseConfig(eGLDisplay, nArray, eGLConfigArray, eGLConfigArray.length, nArray2)) {
            if (nArray2[0] > 0) {
                EglBase10Impl eglBase10Impl = eGLConfigArray[0];
                if (eglBase10Impl != null) {
                    return eglBase10Impl;
                }
                throw new RuntimeException("eglChooseConfig returned null");
            }
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        throw new RuntimeException(a.a("eglChooseConfig failed: 0x").append(Integer.toHexString(eglBase10Impl.egl.eglGetError())).toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EGLContext createEglContext(@Nullable EGLContext eGLContext, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n3) {
        if (eGLContext != null) {
            if (eGLContext == EGL10.EGL_NO_CONTEXT) throw new RuntimeException("Invalid sharedContext");
        }
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray[0] = 12440;
        nArray[1] = n3;
        nArray[2] = 12344;
        if (eGLContext == null) {
            eGLContext = EGL10.EGL_NO_CONTEXT;
        }
        Object object = EglBase.lock;
        synchronized (object) {
            eGLContext = this.egl.eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray2);
            {
                if (eGLContext == EGL10.EGL_NO_CONTEXT) throw new RuntimeException(a.a("Failed to create EGL context: 0x").append(Integer.toHexString(this.egl.eglGetError())).toString());
                return eGLContext;
            }
        }
    }

    @Override
    public void createSurface(Surface surface) {
        public class FakeSurfaceHolder
        implements SurfaceHolder {
            public final Surface surface;

            public FakeSurfaceHolder(Surface surface) {
                this.surface = surface;
            }

            public void addCallback(SurfaceHolder.Callback callback) {
            }

            public void removeCallback(SurfaceHolder.Callback callback) {
            }

            public boolean isCreating() {
                return false;
            }

            @Deprecated
            public void setType(int n3) {
            }

            public void setFixedSize(int n3, int n4) {
            }

            public void setSizeFromLayout() {
            }

            public void setFormat(int n3) {
            }

            public void setKeepScreenOn(boolean bl) {
            }

            @Nullable
            public Canvas lockCanvas() {
                return null;
            }

            @Nullable
            public Canvas lockCanvas(Rect rect) {
                return null;
            }

            public void unlockCanvasAndPost(Canvas canvas) {
            }

            @Nullable
            public Rect getSurfaceFrame() {
                return null;
            }

            public Surface getSurface() {
                return this.surface;
            }
        }
        this.createSurfaceInternal(new FakeSurfaceHolder(surface));
    }

    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        this.createSurfaceInternal(surfaceTexture);
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int n3, int n4) {
        EglBase10Impl eglBase10Impl = this;
        eglBase10Impl.checkIsNotReleased();
        if (eglBase10Impl.eglSurface == EGL10.EGL_NO_SURFACE) {
            EglBase10Impl eglBase10Impl2 = this;
            int[] nArray = new int[5];
            int[] nArray2 = nArray;
            nArray[0] = 12375;
            nArray[1] = n3;
            nArray[2] = 12374;
            nArray[3] = n4;
            nArray[4] = 12344;
            eglBase10Impl2.eglSurface = eglBase10Impl2.egl.eglCreatePbufferSurface(this.eglDisplay, this.eglConfig, nArray2);
            if (eglBase10Impl2.eglSurface != EGL10.EGL_NO_SURFACE) {
                return;
            }
            throw new RuntimeException("Failed to create pixel buffer surface with size " + n3 + "x" + n4 + ": 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        throw new RuntimeException("Already has an EGLSurface");
    }

    @Override
    public EglBase.Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        return this.eglSurface != EGL10.EGL_NO_SURFACE;
    }

    @Override
    public int surfaceWidth() {
        int[] nArray = new int[1];
        this.egl.eglQuerySurface(this.eglDisplay, this.eglSurface, 12375, nArray);
        return nArray[0];
    }

    @Override
    public int surfaceHeight() {
        int[] nArray = new int[1];
        this.egl.eglQuerySurface(this.eglDisplay, this.eglSurface, 12374, nArray);
        return nArray[0];
    }

    @Override
    public void releaseSurface() {
        EGLSurface eGLSurface = this.eglSurface;
        if (eGLSurface != EGL10.EGL_NO_SURFACE) {
            this.egl.eglDestroySurface(this.eglDisplay, eGLSurface);
            this.eglSurface = EGL10.EGL_NO_SURFACE;
        }
    }

    @Override
    public void release() {
        EglBase10Impl eglBase10Impl = this;
        eglBase10Impl.checkIsNotReleased();
        eglBase10Impl.releaseSurface();
        eglBase10Impl.detachCurrent();
        eglBase10Impl.egl.eglDestroyContext(this.eglDisplay, this.eglContext);
        eglBase10Impl.egl.eglTerminate(this.eglDisplay);
        eglBase10Impl.eglContext = EGL10.EGL_NO_CONTEXT;
        eglBase10Impl.eglDisplay = EGL10.EGL_NO_DISPLAY;
        eglBase10Impl.eglConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void makeCurrent() {
        EglBase10Impl eglBase10Impl = this;
        eglBase10Impl.checkIsNotReleased();
        if (eglBase10Impl.eglSurface == EGL10.EGL_NO_SURFACE) throw new RuntimeException("No EGLSurface - can't make current");
        Object object = EglBase.lock;
        synchronized (object) {
            if (!this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) throw new RuntimeException("eglMakeCurrent failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void detachCurrent() {
        Object object = EglBase.lock;
        synchronized (object) {
            if (!this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) throw new RuntimeException("eglDetachCurrent failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        EglBase10Impl eglBase10Impl = this;
        eglBase10Impl.checkIsNotReleased();
        if (eglBase10Impl.eglSurface != EGL10.EGL_NO_SURFACE) {
            Object object = EglBase.lock;
            synchronized (object) {
                this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface);
                return;
            }
        }
        throw new RuntimeException("No EGLSurface - can't swap buffers");
    }

    @Override
    public void swapBuffers(long l3) {
        this.swapBuffers();
    }

    public static class Context
    implements EglBase10.Context {
        public final EGLContext eglContext;

        public Context(EGLContext eGLContext) {
            this.eglContext = eGLContext;
        }

        @Override
        public EGLContext getRawContext() {
            return this.eglContext;
        }

        @Override
        public long getNativeEglContext() {
            return 0L;
        }
    }
}

