/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.SurfaceTexture;
import android.opengl.EGLContext;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.util.ArrayList;
import org.webrtc.EglBase10;
import org.webrtc.EglBase10Impl;
import org.webrtc.EglBase14;
import org.webrtc.EglBase14Impl;

public interface EglBase {
    public static final Object lock = new Object();
    public static final int EGL_OPENGL_ES2_BIT = 4;
    public static final int EGL_OPENGL_ES3_BIT = 64;
    public static final int EGL_RECORDABLE_ANDROID = 12610;
    public static final int[] CONFIG_PLAIN = EglBase.configBuilder().createConfigAttributes();
    public static final int[] CONFIG_RGBA = EglBase.configBuilder().setHasAlphaChannel(true).createConfigAttributes();
    public static final int[] CONFIG_PIXEL_BUFFER = EglBase.configBuilder().setSupportsPixelBuffer(true).createConfigAttributes();
    public static final int[] CONFIG_PIXEL_RGBA_BUFFER = EglBase.configBuilder().setHasAlphaChannel(true).setSupportsPixelBuffer(true).createConfigAttributes();
    public static final int[] CONFIG_RECORDABLE = EglBase.configBuilder().setIsRecordable(true).createConfigAttributes();

    public static ConfigBuilder configBuilder() {
        return new ConfigBuilder();
    }

    public static int getOpenGlesVersionFromConfig(int[] nArray) {
        for (int i3 = 0; i3 < nArray.length - 1; ++i3) {
            if (nArray[i3] != 12352) continue;
            int n3 = nArray[i3 + 1];
            if (n3 != 4) {
                if (n3 != 64) {
                    return 1;
                }
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public static EglBase create(@Nullable Context context, int[] nArray) {
        if (context == null) {
            return EglBase14Impl.isEGL14Supported() ? EglBase.createEgl14(nArray) : EglBase.createEgl10(nArray);
        }
        if (context instanceof EglBase14.Context) {
            return EglBase.createEgl14((EglBase14.Context)context, nArray);
        }
        if (context instanceof EglBase10.Context) {
            return EglBase.createEgl10((EglBase10.Context)context, nArray);
        }
        throw new IllegalArgumentException("Unrecognized Context");
    }

    public static EglBase create() {
        return EglBase.create(null, CONFIG_PLAIN);
    }

    public static EglBase create(Context context) {
        return EglBase.create(context, CONFIG_PLAIN);
    }

    public static EglBase10 createEgl10(int[] nArray) {
        return new EglBase10Impl(null, nArray);
    }

    public static EglBase10 createEgl10(EglBase10.Context context, int[] nArray) {
        EglBase10Impl eglBase10Impl;
        context = context == null ? null : context.getRawContext();
        EglBase10Impl eglBase10Impl2 = eglBase10Impl;
        eglBase10Impl2((javax.microedition.khronos.egl.EGLContext)context, nArray);
        return eglBase10Impl2;
    }

    public static EglBase10 createEgl10(javax.microedition.khronos.egl.EGLContext eGLContext, int[] nArray) {
        return new EglBase10Impl(eGLContext, nArray);
    }

    public static EglBase14 createEgl14(int[] nArray) {
        return new EglBase14Impl(null, nArray);
    }

    public static EglBase14 createEgl14(EglBase14.Context context, int[] nArray) {
        EglBase14Impl eglBase14Impl;
        context = context == null ? null : context.getRawContext();
        EglBase14Impl eglBase14Impl2 = eglBase14Impl;
        eglBase14Impl2((EGLContext)context, nArray);
        return eglBase14Impl2;
    }

    public static EglBase14 createEgl14(EGLContext eGLContext, int[] nArray) {
        return new EglBase14Impl(eGLContext, nArray);
    }

    public void createSurface(Surface var1);

    public void createSurface(SurfaceTexture var1);

    public void createDummyPbufferSurface();

    public void createPbufferSurface(int var1, int var2);

    public Context getEglBaseContext();

    public boolean hasSurface();

    public int surfaceWidth();

    public int surfaceHeight();

    public void releaseSurface();

    public void release();

    public void makeCurrent();

    public void detachCurrent();

    public void swapBuffers();

    public void swapBuffers(long var1);

    public static class ConfigBuilder {
        public int openGlesVersion = 2;
        public boolean hasAlphaChannel;
        public boolean supportsPixelBuffer;
        public boolean isRecordable;

        public ConfigBuilder setOpenGlesVersion(int n3) {
            if (n3 >= 1 && n3 <= 3) {
                this.openGlesVersion = n3;
                return this;
            }
            throw new IllegalArgumentException("OpenGL ES version " + n3 + " not supported");
        }

        public ConfigBuilder setHasAlphaChannel(boolean bl) {
            this.hasAlphaChannel = bl;
            return this;
        }

        public ConfigBuilder setSupportsPixelBuffer(boolean bl) {
            this.supportsPixelBuffer = bl;
            return this;
        }

        public ConfigBuilder setIsRecordable(boolean bl) {
            this.isRecordable = bl;
            return this;
        }

        public int[] createConfigAttributes() {
            int n3;
            ArrayList<Integer> arrayList;
            ArrayList<Integer> arrayList2 = arrayList;
            new ArrayList<Integer>().add(12324);
            arrayList2.add(8);
            arrayList2.add(12323);
            arrayList2.add(8);
            arrayList2.add(12322);
            arrayList2.add(8);
            if (((ConfigBuilder)object).hasAlphaChannel) {
                ArrayList<Integer> arrayList3 = arrayList2;
                arrayList3.add(12321);
                arrayList3.add(8);
            }
            if ((n3 = ((ConfigBuilder)object).openGlesVersion) == 2 || n3 == 3) {
                arrayList2.add(12352);
                arrayList2.add(((ConfigBuilder)object).openGlesVersion == 3 ? 64 : 4);
            }
            if (((ConfigBuilder)object).supportsPixelBuffer) {
                ArrayList<Integer> arrayList4 = arrayList2;
                arrayList4.add(12339);
                arrayList4.add(1);
            }
            if (((ConfigBuilder)object).isRecordable) {
                ArrayList<Integer> arrayList5 = arrayList2;
                arrayList5.add(12610);
                arrayList5.add(1);
            }
            ArrayList<Integer> arrayList6 = arrayList2;
            arrayList6.add(12344);
            Object object = new int[arrayList6.size()];
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                object[n3] = (Integer)arrayList2.get(n3);
            }
            return object;
        }
    }

    public static interface Context {
        public static final long NO_CONTEXT = 0L;

        public long getNativeEglContext();
    }
}

