/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.BaseBitrateAdjuster;

public class DynamicBitrateAdjuster
extends BaseBitrateAdjuster {
    public static final double BITRATE_ADJUSTMENT_SEC = 3.0;
    public static final double BITRATE_ADJUSTMENT_MAX_SCALE = 4.0;
    public static final int BITRATE_ADJUSTMENT_STEPS = 20;
    public static final double BITS_PER_BYTE = 8.0;
    public double deviationBytes;
    public double timeSinceLastAdjustmentMs;
    public int bitrateAdjustmentScaleExp;

    private double getBitrateAdjustmentScale() {
        double d3 = (double)this.bitrateAdjustmentScaleExp / 20.0;
        return Math.pow(4.0, d3);
    }

    @Override
    public void setTargets(int n3, int n4) {
        int n5 = this.targetBitrateBps;
        if (n5 > 0 && n3 < n5) {
            this.deviationBytes = this.deviationBytes * (double)n3 / (double)n5;
        }
        super.setTargets(n3, n4);
    }

    @Override
    public void reportEncodedFrame(int n3) {
        double d3;
        int n4 = this.targetFps;
        if (n4 == 0) {
            return;
        }
        DynamicBitrateAdjuster dynamicBitrateAdjuster = this;
        int n5 = n3;
        DynamicBitrateAdjuster dynamicBitrateAdjuster2 = this;
        n3 = dynamicBitrateAdjuster2.targetBitrateBps;
        double d4 = (double)n3 / 8.0 / (double)n4;
        double d5 = dynamicBitrateAdjuster2.deviationBytes;
        this.deviationBytes = (double)n5 - d4 + d5;
        d4 = this.timeSinceLastAdjustmentMs;
        d5 = n4;
        dynamicBitrateAdjuster.timeSinceLastAdjustmentMs = 1000.0 / d5 + d4;
        d4 = (double)n3 / 8.0;
        d5 = d4 * 3.0;
        dynamicBitrateAdjuster.deviationBytes = Math.min(dynamicBitrateAdjuster.deviationBytes, d5);
        dynamicBitrateAdjuster.deviationBytes = Math.max(dynamicBitrateAdjuster.deviationBytes, -d5);
        if (dynamicBitrateAdjuster.timeSinceLastAdjustmentMs <= 3000.0) {
            return;
        }
        d5 = this.deviationBytes;
        if (d3 > d4) {
            DynamicBitrateAdjuster dynamicBitrateAdjuster3 = this;
            n3 = (int)(d5 / d4 + 0.5);
            dynamicBitrateAdjuster3.bitrateAdjustmentScaleExp -= n3;
            dynamicBitrateAdjuster3.bitrateAdjustmentScaleExp = Math.max(dynamicBitrateAdjuster3.bitrateAdjustmentScaleExp, -20);
            this.deviationBytes = d4;
        } else {
            double d6;
            double d7 = -d4;
            if (d5 < d6) {
                DynamicBitrateAdjuster dynamicBitrateAdjuster4 = this;
                n3 = (int)(-d5 / d4 + 0.5);
                dynamicBitrateAdjuster4.bitrateAdjustmentScaleExp += n3;
                dynamicBitrateAdjuster4.bitrateAdjustmentScaleExp = Math.min(dynamicBitrateAdjuster4.bitrateAdjustmentScaleExp, 20);
                this.deviationBytes = d7;
            }
        }
        this.timeSinceLastAdjustmentMs = 0.0;
    }

    @Override
    public int getAdjustedBitrateBps() {
        return (int)((double)this.targetBitrateBps * this.getBitrateAdjustmentScale());
    }
}

