/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.webrtc.EglBase;
import org.webrtc.HardwareVideoEncoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoEncoderFallback;

public class DefaultVideoEncoderFactory
implements VideoEncoderFactory {
    public final VideoEncoderFactory hardwareVideoEncoderFactory;
    public final VideoEncoderFactory softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory();

    public DefaultVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2) {
        this.hardwareVideoEncoderFactory = new HardwareVideoEncoderFactory(context, bl, bl2);
    }

    public DefaultVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
        this.hardwareVideoEncoderFactory = videoEncoderFactory;
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo object) {
        DefaultVideoEncoderFactory defaultVideoEncoderFactory = videoEncoder;
        VideoEncoder videoEncoder = defaultVideoEncoderFactory.softwareVideoEncoderFactory.createEncoder((VideoCodecInfo)object);
        if ((object = defaultVideoEncoderFactory.hardwareVideoEncoderFactory.createEncoder((VideoCodecInfo)object)) != null && videoEncoder != null) {
            return new VideoEncoderFallback(videoEncoder, (VideoEncoder)object);
        }
        if (object == null) {
            object = videoEncoder;
        }
        return object;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> linkedHashSet;
        LinkedHashSet<VideoCodecInfo> linkedHashSet2 = linkedHashSet;
        linkedHashSet2();
        linkedHashSet2.addAll(Arrays.asList(this.softwareVideoEncoderFactory.getSupportedCodecs()));
        linkedHashSet.addAll(Arrays.asList(this.hardwareVideoEncoderFactory.getSupportedCodecs()));
        return linkedHashSet.toArray(new VideoCodecInfo[linkedHashSet.size()]);
    }
}

