/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.webrtc.EglBase;
import org.webrtc.HardwareVideoDecoderFactory;
import org.webrtc.PlatformSoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoDecoderFallback;

public class DefaultVideoDecoderFactory
implements VideoDecoderFactory {
    public final VideoDecoderFactory hardwareVideoDecoderFactory;
    public final VideoDecoderFactory softwareVideoDecoderFactory;
    @Nullable
    public final VideoDecoderFactory platformSoftwareVideoDecoderFactory;

    public DefaultVideoDecoderFactory(@Nullable EglBase.Context context) {
        this.softwareVideoDecoderFactory = new SoftwareVideoDecoderFactory();
        this.hardwareVideoDecoderFactory = new HardwareVideoDecoderFactory(context);
        this.platformSoftwareVideoDecoderFactory = new PlatformSoftwareVideoDecoderFactory(context);
    }

    public DefaultVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
        DefaultVideoDecoderFactory defaultVideoDecoderFactory = this;
        this.softwareVideoDecoderFactory = new SoftwareVideoDecoderFactory();
        defaultVideoDecoderFactory.hardwareVideoDecoderFactory = videoDecoderFactory;
        defaultVideoDecoderFactory.platformSoftwareVideoDecoderFactory = null;
    }

    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo videoCodecInfo) {
        VideoDecoder videoDecoder = ((DefaultVideoDecoderFactory)this).softwareVideoDecoderFactory.createDecoder(videoCodecInfo);
        VideoDecoder videoDecoder2 = ((DefaultVideoDecoderFactory)this).hardwareVideoDecoderFactory.createDecoder(videoCodecInfo);
        if (videoDecoder == null && (this = ((DefaultVideoDecoderFactory)this).platformSoftwareVideoDecoderFactory) != null) {
            videoDecoder = this.createDecoder(videoCodecInfo);
        }
        if (videoDecoder2 != null && videoDecoder != null) {
            return new VideoDecoderFallback(videoDecoder, videoDecoder2);
        }
        if (videoDecoder2 != null) {
            videoDecoder = videoDecoder2;
        }
        return videoDecoder;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> linkedHashSet;
        LinkedHashSet<VideoCodecInfo> linkedHashSet2 = linkedHashSet;
        linkedHashSet2();
        linkedHashSet2.addAll(Arrays.asList(((DefaultVideoDecoderFactory)videoDecoderFactory).softwareVideoDecoderFactory.getSupportedCodecs()));
        linkedHashSet.addAll(Arrays.asList(((DefaultVideoDecoderFactory)videoDecoderFactory).hardwareVideoDecoderFactory.getSupportedCodecs()));
        VideoDecoderFactory videoDecoderFactory = ((DefaultVideoDecoderFactory)videoDecoderFactory).platformSoftwareVideoDecoderFactory;
        if (videoDecoderFactory != null) {
            linkedHashSet2.addAll(Arrays.asList(videoDecoderFactory.getSupportedCodecs()));
        }
        LinkedHashSet<VideoCodecInfo> linkedHashSet3 = linkedHashSet2;
        return linkedHashSet3.toArray(new VideoCodecInfo[linkedHashSet3.size()]);
    }
}

