/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;

public class DataChannel {
    public long nativeDataChannel;
    public long nativeObserver;

    @CalledByNative
    public DataChannel(long l3) {
        this.nativeDataChannel = l3;
    }

    private void checkDataChannelExists() {
        if (this.nativeDataChannel != 0L) {
            return;
        }
        throw new IllegalStateException("DataChannel has been disposed.");
    }

    private native long nativeRegisterObserver(Observer var1);

    private native void nativeUnregisterObserver(long var1);

    private native String nativeLabel();

    private native int nativeId();

    private native State nativeState();

    private native long nativeBufferedAmount();

    private native void nativeClose();

    private native boolean nativeSend(byte[] var1, boolean var2);

    public void registerObserver(Observer observer) {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        long l3 = dataChannel.nativeObserver;
        if (l3 != 0L) {
            this.nativeUnregisterObserver(l3);
        }
        this.nativeObserver = this.nativeRegisterObserver(observer);
    }

    public void unregisterObserver() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        dataChannel.nativeUnregisterObserver(dataChannel.nativeObserver);
    }

    public String label() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        return dataChannel.nativeLabel();
    }

    public int id() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        return dataChannel.nativeId();
    }

    public State state() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        return dataChannel.nativeState();
    }

    public long bufferedAmount() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        return dataChannel.nativeBufferedAmount();
    }

    public void close() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        dataChannel.nativeClose();
    }

    public boolean send(Buffer buffer) {
        DataChannel dataChannel = object;
        ((DataChannel)object).checkDataChannelExists();
        byte[] byArray = new byte[buffer.data.remaining()];
        Object object = byArray;
        Buffer buffer2 = buffer;
        buffer2.data.get((byte[])object);
        return dataChannel.nativeSend(byArray, buffer2.binary);
    }

    public void dispose() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        JniCommon.nativeReleaseRef(dataChannel.nativeDataChannel);
        dataChannel.nativeDataChannel = 0L;
    }

    @CalledByNative
    public long getNativeDataChannel() {
        return this.nativeDataChannel;
    }

    public static enum State {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;


        @CalledByNative(value="State")
        public static State fromNativeIndex(int n3) {
            return State.values()[n3];
        }
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onBufferedAmountChange(long var1);

        @CalledByNative(value="Observer")
        public void onStateChange();

        @CalledByNative(value="Observer")
        public void onMessage(Buffer var1);
    }

    public static class Buffer {
        public final ByteBuffer data;
        public final boolean binary;

        @CalledByNative(value="Buffer")
        public Buffer(ByteBuffer byteBuffer, boolean bl) {
            this.data = byteBuffer;
            this.binary = bl;
        }
    }

    public static class Init {
        public boolean ordered = true;
        public int maxRetransmitTimeMs = -1;
        public int maxRetransmits = -1;
        public String protocol = "";
        public boolean negotiated;
        public int id = -1;

        @CalledByNative(value="Init")
        public boolean getOrdered() {
            return this.ordered;
        }

        @CalledByNative(value="Init")
        public int getMaxRetransmitTimeMs() {
            return this.maxRetransmitTimeMs;
        }

        @CalledByNative(value="Init")
        public int getMaxRetransmits() {
            return this.maxRetransmits;
        }

        @CalledByNative(value="Init")
        public String getProtocol() {
            return this.protocol;
        }

        @CalledByNative(value="Init")
        public boolean getNegotiated() {
            return this.negotiated;
        }

        @CalledByNative(value="Init")
        public int getId() {
            return this.id;
        }
    }
}

